/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.balance.dto.SpecialCardDTO;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardLogInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardService
extends BaseService<PrepayCardEntity, String>
implements PrepayCardInterface {
    @Resource
    PrepayCardMapper prepayCardMapper;
    @Autowired
    PrepayCardLogInterface cardLogInterface;
    @Autowired
    MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    AccountBalanceInterface balanceInterface;
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;

    @Override
    @Async
    public void setCardStatus(String cardId) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId), 0L);
        if (prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue() || prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
            PrepayCardDetailEntity query = new PrepayCardDetailEntity();
            query.setCardId(cardId);
            List list = this.prepayCardPlanDetailService.getList(query, 0L);
            if (list.size() > 0) {
                if (!list.stream().anyMatch(p -> p.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue() || p.getStatus().intValue() == PrepayCardPlanStatusEnum.SUSPEND.getValue() || p.getStatus().intValue() == PrepayCardPlanStatusEnum.DELIVERY.getValue()) && prepayCardEntity.getRemainCount() == 0) {
                    boolean isFinnish = list.stream().anyMatch(p -> p.getStatus().intValue() == PrepayCardPlanStatusEnum.FINISH.getValue());
                    PrepayCardEntity update = new PrepayCardEntity();
                    update.setCardId(cardId);
                    if (isFinnish && prepayCardEntity.getRemainCount() == 0) {
                        update.setStatus(PrepayCardStatusEnum.FINISH.getValue());
                    } else {
                        update.setStatus(PrepayCardStatusEnum.NOEFFECT.getValue());
                    }
                    this.updateByPrimaryKeySelective(update);
                    this.cardLogInterface.saveCardPlanLog(cardId, prepayCardEntity.getStatus(), update.getStatus(), "\u6240\u6709\u8ba1\u5212\u9000\u6b3e\u65f6\u89e6\u53d1\u6216\u8005\u6536\u8d27\u65f6\u89e6\u53d1");
                }
            } else {
                PrepayCardEntity update = new PrepayCardEntity();
                update.setCardId(cardId);
                this.updateByPrimaryKeySelective(update);
                update.setStatus(PrepayCardStatusEnum.NOEFFECT.getValue());
                this.cardLogInterface.saveCardPlanLog(cardId, prepayCardEntity.getStatus(), update.getStatus(), "\u9000\u8ba2\u6240\u6709\u914d\u9001\u8ba1\u5212");
            }
        }
    }

    @Override
    public BaseJsonVo orderConfirmGoodsUpdateCardStatus(String cardId) {
        PrepayCardEntity entity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId));
        if (entity != null && entity.getStatus() == 2) {
            Integer _old = entity.getStatus();
            Integer _new = 6;
            entity.setStatus(_new);
            this.updateByPrimaryKeySelective(entity);
            this.setCardStatus(cardId);
            this.cardLogInterface.saveCardPlanLog(cardId, _old, _new, "\u786e\u8ba4\u6536\u8d27\u66f4\u65b0\u72b6\u6001");
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderRefundUpdateCardPlanStatus(String cardId) {
        Integer _old;
        PrepayCardEntity entity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId));
        if (entity != null && (_old = entity.getStatus()) != 5) {
            Integer _new = 5;
            entity.setStatus(_new);
            this.updateByPrimaryKeySelective(entity);
            this.cardLogInterface.saveCardPlanLog(cardId, _old, _new, "\u9000\u6b3e\u66f4\u65b0\u72b6\u6001");
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderAllRefundUpdateCardPlanStatus(String cardOrderMainNo) {
        PrepayCardEntity entity = new PrepayCardEntity();
        entity.setOrderMainNo(cardOrderMainNo);
        entity = (PrepayCardEntity)this.getSingle(entity);
        if (entity != null) {
            Integer _old = entity.getStatus();
            Integer _new = 5;
            entity.setStatus(_new);
            this.updateByPrimaryKeySelective(entity);
            this.cardLogInterface.saveCardPlanLog(entity.getCardId(), _old, _new, "\u9000\u6b3e\u66f4\u65b0\u72b6\u6001");
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Override
    public BaseJsonVo orderPaySuccessUpdateCardPlanCount(String cardId, String updateTimeStamp) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardId));
        if (prepayCardEntity != null && this.prepayCardMapper.reduceCardCount(cardId, updateTimeStamp) > 0) {
            this.remoteCache((Serializable)((Object)cardId));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u6263\u51cf\u5931\u8d25");
    }

    @Override
    public int updateCardCount(PrepayCardEntity prepayCardEntity) {
        this.remoteCache((Serializable)((Object)prepayCardEntity.getCardId()));
        return this.prepayCardMapper.updateCardCount(prepayCardEntity);
    }

    @Override
    public BaseJsonVo orderPaySuccessCreateCard(String orderMainNo) {
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        List<MallOrderProductEntity> products = this.mallOrderProductInterface.getOrderProductInfoByOrderMianNo(orderMainNo);
        if (products == null || products.size() == 0) {
            return BaseJsonVo.error((String)"\u751f\u6210\u8ba2\u5355\u5546\u54c1\u9519\u8bef");
        }
        PrepayCardBatchEntity param = new PrepayCardBatchEntity();
        this.logger.info("<><><><>" + JsonUtils.toJson(products, (boolean)true));
        param.setCardPromotionId(products.get(0).getPromotionId());
        List batches = this.prepayCardBatchInterface.getList(param);
        if (batches == null || batches.size() == 0) {
            return BaseJsonVo.error((String)("[\u751f\u6210prepay\u5361][" + orderMainNo + "]\u67e5\u8be2\u5361\u6279\u6b21\u9519\u8bef"));
        }
        PrepayCardBatchEntity batch = (PrepayCardBatchEntity)batches.get(0);
        PrepayCardEntity entity = new PrepayCardEntity();
        entity.setCardId(IDGenerate.getUniqueIdStr().toUpperCase());
        entity.setCardPassword("LEPUR");
        entity.setBuyerCustomerId(mallOrderMainEntity.getCustomerId());
        entity.setBelongCustomerId(entity.getBuyerCustomerId());
        entity.setBatchId(batch.getBatchId());
        entity.setOrderMainNo(orderMainNo);
        entity.setTotalCount(batch.getDeliverCount());
        entity.setRemainCount(entity.getTotalCount());
        entity.setStatus(1);
        entity.setCreateTime(DateUtils.now());
        BaseJsonVo<SpecialCardDTO> vo = this.balanceInterface.charge(entity.getBuyerCustomerId(), orderMainNo, batch.getCardPrice());
        if (!vo.isSuccess()) {
            return vo;
        }
        entity.setRelateCardNo(((SpecialCardDTO)vo.getValue()).getCardNo());
        this.insert(entity);
        return BaseJsonVo.success((Object)"");
    }
}

