/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallFullcutMapper;
import cc.lechun.mall.entity.sales.MallFullCutNumberVo;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntity;
import cc.lechun.mall.entity.sales.MallFullcutVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.sales.MallFullcutDetailService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFullcutService
extends BaseService
implements MallFullcutInterface {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallFullcutMapper fullcutMapper;
    @Autowired
    private MallFullcutDetailService mallFullcutDetailService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private MallGroupInterface groupInterface;

    public MallFullcutEntity getFullcutEntity(String fullcutId) {
        return (MallFullcutEntity)this.fullcutMapper.selectByPrimaryKey((Serializable)((Object)fullcutId));
    }

    @Override
    public BaseJsonVo getEnableFullcut(List<MallShoppingcartVO> carts) {
        if (carts.size() == 0) {
            return BaseJsonVo.error((String)"\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728");
        }
        return this.getEnableFullcut(carts.get(0).getBindCode());
    }

    @Override
    public BaseJsonVo getEnableFullcut(String bindCode) {
        if (bindCode == null || bindCode.isEmpty()) {
            return BaseJsonVo.paramError((String)"\u7ed1\u5b9a\u7801\u4e0d\u5b58\u5728");
        }
        String activeNo = this.activeInterface.getActiveNoByBindCode(bindCode);
        if (!this.activeInterface.checkActiveEnable(activeNo).isSuccess()) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u5df2\u8fc7\u671f");
        }
        MallFullcutVo fullcutVo = this.fullcutMapper.getSingleEntityByTime(activeNo, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
        if (fullcutVo == null && (fullcutVo = this.fullcutMapper.getSingleEntityByTime(bindCode, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"))) == null) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\uff1a\u5c1a\u672a\u5f00\u59cb\u6216\u5df2\u8fc7\u671f");
        }
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)fullcutVo.getEndTime());
        fullcutVo.setSeconds(seconds);
        fullcutVo.setSecond(seconds / 3600L);
        fullcutVo.setMinute(seconds % 3600L / 60L);
        fullcutVo.setHour(seconds % 3600L % 60L);
        return BaseJsonVo.success((Object)fullcutVo);
    }

    @Override
    public boolean checkFullcut(MallFullcutVo fullcutVo, List<MallFullcutDetailEntity> detailEntities, List<MallShoppingcartVO> shoppingcartVOS) {
        BigDecimal[] count = new BigDecimal[]{BigDecimal.valueOf(0L)};
        for (MallShoppingcartVO shoppingcartVO : shoppingcartVOS) {
            List<Object> productVOs = new ArrayList();
            List<Object> groups = new ArrayList();
            if (fullcutVo.getFullClass() == 1) {
                productVOs = shoppingcartVO.getProductsPool();
            } else {
                productVOs = shoppingcartVO.getProducts();
                groups = shoppingcartVO.getGroups();
            }
            for (MallProductVO mallProductVO : productVOs) {
                if (detailEntities.stream().filter(c -> c.getGroupType() == 4 && c.getProductId().equals(productVO.getProId())).count() <= 0L) continue;
                mallProductVO.setFullCutId(fullcutVo.getFullCutId());
                mallProductVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                if (fullcutVo.getType() == 1) {
                    count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)BigDecimal.valueOf(mallProductVO.getCount().intValue()));
                    continue;
                }
                count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)mallProductVO.getShareAmount());
            }
            for (MallGroupVO mallGroupVO : groups) {
                if (detailEntities.stream().filter(c -> c.getGroupType() == 2 && c.getGroupId().equals(groupVO.getGroupId())).count() <= 0L) continue;
                mallGroupVO.setFullCutId(fullcutVo.getFullCutId());
                mallGroupVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                if (fullcutVo.getType() == 1) {
                    count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)BigDecimal.valueOf(mallGroupVO.getCount().intValue()));
                    continue;
                }
                count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)mallGroupVO.getShareAmount());
            }
        }
        MallFullCutNumberVo cutNumberVo = this.calculateFullCutAmount(fullcutVo, count[0], count[0].intValue());
        return cutNumberVo.getFullNumber().compareTo(BigDecimal.ZERO) > 0 && cutNumberVo.getCutNumber() > 0;
    }

    @Override
    public BaseJsonVo getEnableFullcutDetail(String bindCode) {
        MallFullcutVo vo;
        List<MallFullcutDetailEntity> ls;
        BaseJsonVo rs = this.getEnableFullcut(bindCode);
        if (rs.isSuccess() && (ls = this.mallFullcutDetailService.getFullcutDetails((vo = (MallFullcutVo)rs.getValue()).getFullCutId())) != null && ls.size() > 0) {
            ArrayList<MallProductVO> productVOs = new ArrayList<MallProductVO>();
            List<Object> groupVOS = new ArrayList();
            for (MallFullcutDetailEntity mallFullcutDetailEntity : ls) {
                BaseJsonVo sr;
                if (mallFullcutDetailEntity.getGroupType() == 4 && (sr = this.productService.buildProductVO(mallFullcutDetailEntity.getProductId(), 1, null, null, null, null, true, true, null, null)).isSuccess()) {
                    productVOs.add((MallProductVO)sr.getValue());
                }
                if (mallFullcutDetailEntity.getGroupType() != 2 || !(sr = this.groupInterface.buildGroupVO(mallFullcutDetailEntity.getGroupId(), 1, null, null)).isSuccess()) continue;
                groupVOS.add((MallGroupVO)sr.getValue());
            }
            groupVOS = groupVOS.stream().filter(c -> c.getValid() == true).collect(Collectors.toList());
            if (productVOs.size() == 0 && groupVOS.size() == 0) {
                rs = BaseJsonVo.error((String)"\u6ca1\u6709\u6dfb\u52a0\u4ea7\u54c1\u6216\u5957\u88c5");
            } else {
                vo.setProducts(productVOs);
                vo.setGroups(groupVOS);
            }
        }
        return rs;
    }

    @Override
    public BaseJsonVo saveOrUpdateFullCutList(MallFullcutEntity mallFullcutEntity) {
        if (mallFullcutEntity.getBeginTime() == null || mallFullcutEntity.getEndTime() == null) {
            return BaseJsonVo.paramError((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFullcutEntity.getBeginTime().after(mallFullcutEntity.getEndTime())) {
            return BaseJsonVo.paramError((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (StringUtils.isEmpty((String)mallFullcutEntity.getCutRuleName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFullcutEntity.getType() == 2 && mallFullcutEntity.getCutRule() == 4) {
            return BaseJsonVo.paramError((String)"\u6ee1\u51cf\u7c7b\u578b\u4e3a\u91d1\u989d\u65f6\uff0c\u6ee1\u51cf\u89c4\u5219\u4e0d\u652f\u6301\u6309\u5546\u54c1\u51cf");
        }
        if (StringUtils.isEmpty((String)mallFullcutEntity.getFullCutId())) {
            mallFullcutEntity.setFullCutId(IDGenerate.getUniqueID() + "");
            mallFullcutEntity.setCreateTime(DateUtils.now());
            this.fullcutMapper.insertSelective(mallFullcutEntity);
        } else {
            this.fullcutMapper.updateByPrimaryKeySelective(mallFullcutEntity);
        }
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    @Override
    public PageInfo getFullCutList(int pageNum, int pageSize, int platformGroupId, String fullCutName) {
        MallFullcutEntity mallFullcutEntity = new MallFullcutEntity();
        mallFullcutEntity.setPlatformGroupId(platformGroupId);
        if (!StringUtils.isEmpty((String)fullCutName)) {
            mallFullcutEntity.setFullCutName(fullCutName);
        }
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.fullcutMapper.getList(mallFullcutEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public BaseJsonVo checkShoppingcatIsEnableFullCut(MallShoppingcartVO coldChainCart, MallShoppingcartVO nomalTempCart, MallShoppingcartVO quickShoppingCart) {
        List<MallFullcutEntity> fullcutEntities;
        ArrayList<MallProductVO> coldProductVOS = new ArrayList<MallProductVO>();
        ArrayList<MallProductVO> normalProductVOS = new ArrayList<MallProductVO>();
        ArrayList quickProductVOS = new ArrayList();
        BigDecimal coldFullCutAmount = BigDecimal.ZERO;
        BigDecimal normalFullCutAmount = BigDecimal.ZERO;
        BigDecimal quickFullCutAmount = BigDecimal.ZERO;
        if (coldChainCart.getOrderSource() != 0) {
            return BaseJsonVo.error((String)"\u975e\u8d2d\u7269\u8f66\u8d2d\u4e70\uff0c\u4e0d\u53c2\u4e0e\u5168\u5c40\u6ee1\u51cf");
        }
        if (coldChainCart.getProductsPool() != null && coldChainCart.getProductsPool().size() > 0) {
            coldProductVOS.addAll(coldChainCart.getProductsPool().stream().filter(c -> c.getShareAmount().doubleValue() > 0.0).collect(Collectors.toList()));
        }
        if (nomalTempCart.getProductsPool() != null && nomalTempCart.getProductsPool().size() > 0) {
            normalProductVOS.addAll(nomalTempCart.getProductsPool().stream().filter(c -> c.getShareAmount().doubleValue() > 0.0).collect(Collectors.toList()));
        }
        if (quickShoppingCart.getProductsPool() != null && quickShoppingCart.getProductsPool().size() > 0) {
            quickProductVOS.addAll(quickShoppingCart.getProductsPool().stream().filter(c -> c.getShareAmount().doubleValue() > 0.0).collect(Collectors.toList()));
        }
        if ((fullcutEntities = this.getShoppingcatEnableFullcut()).size() > 0) {
            MallFullCutNumberVo cutNumberVo = new MallFullCutNumberVo();
            cutNumberVo.setCutNumber(0);
            cutNumberVo.setFullNumber(BigDecimal.ZERO);
            for (MallFullcutEntity fullcut : fullcutEntities) {
                List<MallFullcutDetailEntity> fullcutDetails = this.mallFullcutDetailService.getFullcutDetails(fullcut.getFullCutId());
                if (coldFullCutAmount.compareTo(BigDecimal.ZERO) == 0 && StringUtils.isEmpty((String)coldChainCart.getBindCode()) && fullcut.getType() == 2) {
                    cutNumberVo = this.calculateFullCutAmount(fullcut, fullcutDetails, coldProductVOS);
                    coldFullCutAmount = cutNumberVo.getFullNumber();
                    coldChainCart.setBindCode(cutNumberVo.getBindCode());
                    if (coldFullCutAmount.compareTo(BigDecimal.ZERO) > 0) {
                        coldChainCart.setFullCutNotice("\u4e0b\u5355\u514d\u90ae\u8d39\uff0c\u518d\u4e70" + cutNumberVo.getFullNumber() + "\u5143\u53ef\u51cf" + cutNumberVo.getCutNumber() + "\u5143");
                        continue;
                    }
                }
                if (normalFullCutAmount.compareTo(BigDecimal.ZERO) != 0 || !StringUtils.isEmpty((String)nomalTempCart.getBindCode()) || fullcut.getType() != 2) continue;
                cutNumberVo = this.calculateFullCutAmount(fullcut, fullcutDetails, normalProductVOS);
                normalFullCutAmount = cutNumberVo.getFullNumber();
                nomalTempCart.setBindCode(cutNumberVo.getBindCode());
                if (normalFullCutAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                nomalTempCart.setFullCutNotice("\u4e0b\u5355\u514d\u90ae\u8d39\uff0c\u518d\u4e70" + cutNumberVo.getFullNumber() + "\u5143\u53ef\u51cf" + cutNumberVo.getCutNumber() + "\u5143");
            }
        } else {
            return BaseJsonVo.error((String)"\u5f53\u524d\u6ee1\u51cf\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)"");
    }

    private MallFullCutNumberVo calculateFullCutAmount(MallFullcutEntity fullcut, List<MallFullcutDetailEntity> fullcutDetails, List<MallProductVO> productVOS) {
        List fullCutNumberVos;
        BigDecimal fullCutAmount = BigDecimal.ZERO;
        if (fullcut.getDoublePromotion() == 0) {
            productVOS = productVOS.stream().filter(c -> StringUtils.isEmpty((String)c.getPromotionId())).collect(Collectors.toList());
        }
        for (MallProductVO productVO : productVOS) {
            if (fullcutDetails.stream().filter(c -> c.getGroupType() == 4 && c.getProductId().equals(productVO.getProId())).count() <= 0L) continue;
            fullCutAmount = fullCutAmount.add(productVO.getShareAmount());
        }
        BigDecimal fullCutAmountTmp = fullCutAmount;
        String bindCode = "";
        if (fullCutAmount.doubleValue() > 0.0 && StringUtils.isNotEmpty((String)fullcut.getFullCutNumbers()) && (fullCutNumberVos = JsonUtils.getListByArray(MallFullCutNumberVo.class, (String)fullcut.getFullCutNumbers())).size() > 0) {
            fullCutNumberVos = fullCutNumberVos.stream().sorted(Comparator.comparing(MallFullCutNumberVo::getFullNumber)).collect(Collectors.toList());
            Optional<MallFullCutNumberVo> bal = fullCutNumberVos.stream().filter(c -> c.getFullNumber().compareTo(fullCutAmountTmp) > 0).findFirst();
            Optional<MallFullCutNumberVo> curbal = fullCutNumberVos.stream().filter(c -> c.getFullNumber().compareTo(fullCutAmountTmp) <= 0).findFirst();
            if (curbal.isPresent()) {
                bindCode = fullcut.getActiveNo();
            }
            if (bal.isPresent()) {
                bal.get().setFullNumber(PriceUtils.format((BigDecimal)bal.get().getFullNumber().subtract(fullCutAmount)));
                bal.get().setBindCode(bindCode);
                return bal.get();
            }
        }
        MallFullCutNumberVo cutNumberVo = new MallFullCutNumberVo();
        cutNumberVo.setCutNumber(0);
        cutNumberVo.setFullNumber(BigDecimal.ZERO);
        cutNumberVo.setBindCode(bindCode);
        return cutNumberVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="cc.lechun.mall.service.sales.MallFullcutService.getShoppingcatEnableFullcut", expiration=300)
    public List<MallFullcutEntity> getShoppingcatEnableFullcut() {
        List<MallFullcutEntity> fullcuts = this.fullcutMapper.getGlobalSingleEntityByTime(DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
        if (fullcuts.size() == 0) {
            return new ArrayList<MallFullcutEntity>();
        }
        ArrayList<MallFullcutEntity> removeList = new ArrayList<MallFullcutEntity>();
        for (MallFullcutEntity fullcut : fullcuts) {
            String activeNo = this.activeInterface.getActiveNoByBindCode(fullcut.getActiveNo());
            if (this.activeInterface.checkActiveEnable(activeNo).isSuccess()) continue;
            removeList.add(fullcut);
        }
        if (removeList.size() > 0) {
            fullcuts.removeAll(removeList);
        }
        return fullcuts;
    }

    @Override
    public MallFullCutNumberVo calculateFullCutAmount(MallFullcutVo fullcut, BigDecimal amount, Integer quantity) {
        Optional<MallFullCutNumberVo> curbal;
        List fullCutNumberVos;
        BigDecimal fullCutAmountTmp;
        BigDecimal fullCutAmount = BigDecimal.ZERO;
        BigDecimal bigDecimal = fullCutAmountTmp = fullcut.getType() == 1 ? BigDecimal.valueOf(quantity.intValue()) : amount;
        if (StringUtils.isNotEmpty((String)fullcut.getFullCutNumbers()) && (fullCutNumberVos = JsonUtils.getListByArray(MallFullCutNumberVo.class, (String)fullcut.getFullCutNumbers())).size() > 0 && (curbal = (fullCutNumberVos = fullCutNumberVos.stream().sorted(Comparator.comparing(MallFullCutNumberVo::getFullNumber).reversed()).collect(Collectors.toList())).stream().filter(c -> c.getFullNumber().compareTo(fullCutAmountTmp) <= 0).findFirst()).isPresent()) {
            return curbal.get();
        }
        MallFullCutNumberVo cutNumberVo = new MallFullCutNumberVo();
        cutNumberVo.setCutNumber(0);
        cutNumberVo.setFullNumber(BigDecimal.ZERO);
        return cutNumberVo;
    }
}

