/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.MallSplitOrderInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallSplitOrderService
extends BaseService
implements MallSplitOrderInterface {
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;

    @Override
    public List<MallOrderVo> splitOrder(MallOrderVo orderVo) {
        List pp2;
        List pp1;
        MallOrderVo orderVo1 = new MallOrderVo();
        MallOrderVo orderVo2 = new MallOrderVo();
        List<MallProductVO> p1 = orderVo.getProducts().stream().filter(c -> c.getSelfMadeType() == 1).collect(Collectors.toList());
        List<MallProductVO> p2 = orderVo.getProducts().stream().filter(c -> c.getSelfMadeType() == 2).collect(Collectors.toList());
        List<MallGroupVO> g1 = orderVo.getGroups().stream().filter(c -> c.getSelfModeType() == 1).collect(Collectors.toList());
        List<MallGroupVO> g2 = orderVo.getGroups().stream().filter(c -> c.getSelfModeType() == 2).collect(Collectors.toList());
        List<MallPromotionVO> promotionVOs1 = orderVo.getPromotions().stream().filter(c -> c.getSelfModeType() == 1).collect(Collectors.toList());
        List<MallPromotionVO> promotionVOs2 = orderVo.getPromotions().stream().filter(c -> c.getSelfModeType() == 2).collect(Collectors.toList());
        if (g1 != null && g1.size() > 0) {
            for (MallGroupVO c2 : g1) {
                pp1 = c2.getProductList().stream().filter(c1 -> c1.getSelfMadeType() == 1).collect(Collectors.toList());
                pp2 = c2.getProductList().stream().filter(c1 -> c1.getSelfMadeType() == 2).collect(Collectors.toList());
                if (pp1.size() <= 0 || pp2.size() <= 0) continue;
                p1.addAll(pp1);
                p2.addAll(pp2);
                g1 = new ArrayList<MallGroupVO>();
            }
        }
        if (promotionVOs1 != null && promotionVOs1.size() > 0) {
            for (MallPromotionVO p : promotionVOs1) {
                if (p.getGroup() == null) continue;
                pp1 = p.getGroup().getProductList().stream().filter(c1 -> c1.getSelfMadeType() == 1).collect(Collectors.toList());
                pp2 = p.getGroup().getProductList().stream().filter(c1 -> c1.getSelfMadeType() == 2).collect(Collectors.toList());
                if (pp1.size() <= 0 || pp2.size() <= 0) continue;
                p1.addAll(pp1);
                p2.addAll(pp2);
                promotionVOs1 = new ArrayList<MallPromotionVO>();
            }
        }
        ArrayList<MallOrderVo> orderVos = new ArrayList<MallOrderVo>();
        if (p1 != null && p1.size() > 0 || g1 != null && g1.size() > 0 || promotionVOs1 != null && promotionVOs1.size() > 0) {
            BeanUtils.copyProperties((Object)orderVo, (Object)orderVo1);
            orderVo1.setProducts(p1);
            orderVo1.setGroups(g1);
            orderVo1.setPromotions(promotionVOs1);
            orderVo1.setTransportType(this.productInterface.getTransportType(orderVo1));
            orderVo1.setSelfMadeType(this.productInterface.getSelfMode(orderVo1));
            this.shoppingcartInterface.collectProducts(orderVo1);
            orderVo1.setQuantity(orderVo1.getProductsPool().stream().mapToInt(e -> e.getCount()).sum());
            orderVos.add(orderVo1);
        }
        if (p2 != null && p2.size() > 0 || g2 != null && g2.size() > 0 || promotionVOs2 != null && promotionVOs2.size() > 0) {
            BeanUtils.copyProperties((Object)orderVo, (Object)orderVo2);
            orderVo2.setProducts(p2);
            orderVo2.setGroups(g2);
            orderVo2.setPromotions(promotionVOs2);
            orderVo2.setTransportType(this.productInterface.getTransportType(orderVo2));
            orderVo2.setSelfMadeType(this.productInterface.getSelfMode(orderVo2));
            this.shoppingcartInterface.collectProducts(orderVo2);
            orderVo2.setQuantity(orderVo2.getProductsPool().stream().mapToInt(e -> e.getCount()).sum());
            orderVos.add(orderVo2);
        }
        this.priceCalcInterface.totalOrderPrice(orderVos);
        return orderVos;
    }
}

