/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.RefundSourceEnum;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.trade.ApplyRefundPayDetailVo;
import cc.lechun.mall.entity.trade.CheckRefundPayDetailVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.entity.trade.MallRefundPayDetailEntity;
import cc.lechun.mall.entity.trade.MallRefundRecordEntity;
import cc.lechun.mall.entity.trade.OrderRefundApplyVo;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallRefundDetailInterface;
import cc.lechun.mall.iservice.trade.MallRefundInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.iservice.trade.MallRefundRecordInterface;
import cc.lechun.mall.iservice.trade.OrderRefundInterface;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import weixin.popular.util.JsonUtil;

@Service
public class OrderRefundService
extends BaseService
implements OrderRefundInterface {
    @Autowired
    private MallRefundInterface refundInterface;
    @Autowired
    private MallRefundDetailInterface refundDetailInterface;
    @Autowired
    private MallRefundPayDetailInterface refundPayDetailInterface;
    @Autowired
    private MallRefundRecordInterface refundRecordInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Value(value="${erp.reduceInventory.url}")
    private String reduceInventory;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    private MallOrderSyncInfoInterface syncInfoInterface;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo createRefundBill(OrderRefundApplyVo refundApplyVo) {
        this.logger.info("\u5f00\u59cb\u68c0\u67e5\u9000\u6b3e\u4fe1\u606f..." + JsonUtils.toJson((Object)refundApplyVo, (boolean)false));
        BaseJsonVo jsonVo = this.validateRefundVo(refundApplyVo);
        this.logger.info("\u5f00\u59cb\u9000\u6b3e\u4fe1\u606f\u68c0\u67e5\u7ed3\u679c...,result:" + jsonVo.isSuccess() + ",message:" + jsonVo.getMessage());
        try {
            if (jsonVo.isSuccess()) {
                MallRefundEntity refundEntity = this.refundInterface.createRefund(refundApplyVo);
                this.logger.info("\u521b\u5efa\u9000\u6b3e\u5355\u5b8c\u6210..." + JsonUtils.toJson((Object)refundApplyVo, (boolean)false));
                this.refundDetailInterface.createRefundDetail(refundEntity);
                this.logger.info("\u521b\u5efa\u9000\u6b3e\u5b50\u5355\u5b8c\u6210,orderMainNo:" + refundApplyVo.getOrderMainNo() + ",orderNo:" + refundApplyVo.getOrderNo());
                this.refundPayDetailInterface.createRefundPay(refundApplyVo, refundEntity);
                this.logger.info("\u521b\u5efa\u9000\u6b3e\u660e\u7ec6\u5b8c\u6210,orderMainNo:" + refundApplyVo.getOrderMainNo() + ",orderNo:" + refundApplyVo.getOrderNo());
                if (refundApplyVo.getRefundOrderType() == 1) {
                    jsonVo = this.updateOrderStatusRefund(refundApplyVo.getOrderMainNo(), refundApplyVo.getOrderNo(), OrderStatusEnum.REFUND_APPLY.getName(), refundApplyVo.getCustomerId());
                    if (!jsonVo.isSuccess()) {
                        throw new Exception(jsonVo.getMessage());
                    }
                    List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(refundApplyVo.getOrderMainNo());
                    for (MallOrderEntity o : orderEntities) {
                        this.refundInventory(o.getOrderNo());
                    }
                } else {
                    this.logger.info("\u9000\u6b3e\u4e0d\u9000\u5355\uff0c\u65e0\u9700\u4fee\u6539\u8ba2\u5355\u72b6\u6001,orderMainNo:" + refundApplyVo.getOrderMainNo() + ",orderNo:" + refundApplyVo.getOrderNo());
                }
                jsonVo.setValue((Object)refundEntity);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u521b\u5efa\u9000\u6b3e\u5355\u5931\u8d25,param:" + JsonUtil.toJSONString((Object)refundApplyVo) + ",result:" + e.getMessage());
            return BaseJsonVo.error((String)"\u521b\u5efa\u9000\u6b3e\u5355\u5931\u8d25");
        }
        return jsonVo;
    }

    public BaseJsonVo updateOrderStatusRefund(String orderMainNo, String orderNo, String statusName, String customerId) {
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        boolean updateOrderIsSuccess = this.orderMainInterface.updateOrderMainStatus(orderMainNo, statusName, customerId, orderMainEntity.getStatus());
        this.logger.info("\u4fee\u6539\u4e3b\u8ba2\u5355\u72b6\u6001\u5b8c\u6210\uff0corderMainNo:" + orderMainNo + "\uff0cresult:" + updateOrderIsSuccess);
        if (!updateOrderIsSuccess) {
            return BaseJsonVo.error((String)"\u66f4\u65b0\u4e3b\u8ba2\u5355\u5931\u8d25");
        }
        if (orderNo != null && !orderNo.isEmpty()) {
            MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
            if (orderEntity == null) {
                return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            updateOrderIsSuccess = this.orderInterface.updateOrderStatus(orderNo, statusName, customerId, orderEntity.getStatus());
            this.logger.info("\u4fee\u6539\u5b50\u8ba2\u5355\u72b6\u6001\u5b8c\u6210\uff0cresult:" + updateOrderIsSuccess);
            if (!updateOrderIsSuccess) {
                return BaseJsonVo.error((String)"\u66f4\u65b0\u5b50\u8ba2\u5355\u5931\u8d25");
            }
        } else {
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
            for (MallOrderEntity o : orderEntities) {
                updateOrderIsSuccess = this.orderInterface.updateOrderStatus(o.getOrderNo(), statusName, customerId, o.getStatus());
                this.logger.info("\u4fee\u6539\u5b50\u8ba2\u5355\u72b6\u6001\u5b8c\u62101\uff0cresult:" + updateOrderIsSuccess);
                if (updateOrderIsSuccess) continue;
                return BaseJsonVo.error((String)"\u66f4\u65b0\u5b50\u8ba2\u5355\u5931\u8d251");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo refundInventory(String orderNo) {
        ArrayList<String> orderNoList = new ArrayList<String>();
        orderNoList.add(orderNo);
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.reduceInventory, (String)JsonUtils.toJson(orderNoList, (boolean)false));
        this.logger.info("*************************refundApply********************\u8c03\u7528ERP3.0\u589e\u52a0\u5e93\u5b58\u8bf7\u6c42\u548c\u8fd4\u56de\u7684\u6570\u636e*************orderNoList={},result={}", (Object)JSON.toJSONString(orderNoList), (Object)JSON.toJSONString((Object)(StringUtils.isNotEmpty((String)result) ? result : "")));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo passOrderRefund(String refundId, String checker, List<CheckRefundPayDetailVo> payDetailVo) {
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"");
        try {
            MallRefundEntity refundEntity = this.refundInterface.selectByPrimaryKey(refundId);
            if (refundEntity == null) {
                throw new Exception("\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
            }
            if (refundEntity.getStatus() != 1) {
                throw new Exception("\u9000\u6b3e\u5355\u72b6\u6001\u4e0d\u80fd\u5ba1\u6838\u901a\u8fc7");
            }
            BigDecimal factRefudnAmount = null;
            if (payDetailVo != null && payDetailVo.size() != 0 && (factRefudnAmount = PriceUtils.format((BigDecimal)new BigDecimal(payDetailVo.stream().mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum()))).doubleValue() > PriceUtils.format((BigDecimal)refundEntity.getReturnAmount()).doubleValue()) {
                throw new Exception("\u5b9e\u9645\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d");
            }
            this.refundPayDetailInterface.PassOrderRefund(refundId, payDetailVo);
            this.refundInterface.PassOrderRefund(refundId, factRefudnAmount, checker);
            this.refundDetailInterface.PassOrderRefund(refundId, factRefudnAmount);
            if (refundEntity.getRefundOrderType() == 1 && !(jsonVo = this.updateOrderStatusRefund(refundEntity.getOrderMainNo(), refundEntity.getOrderNo(), OrderStatusEnum.REFUND_PROCESS.getName(), refundEntity.getCustomerId())).isSuccess()) {
                throw new Exception(jsonVo.getMessage());
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u9000\u6b3e\u5ba1\u6838\u5931\u8d25,param:refundId:" + refundId + ",result:" + e.getMessage());
            return BaseJsonVo.error((String)("\u9000\u6b3e\u5ba1\u6838\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return jsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo failOrderRefund(String refundId, String reason) {
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"");
        try {
            MallRefundEntity refundEntity = this.refundInterface.selectByPrimaryKey(refundId);
            if (refundEntity == null) {
                throw new Exception("\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
            }
            if (refundEntity.getStatus() != 1) {
                throw new Exception("\u9000\u6b3e\u5355\u5df2\u7ecf\u4e0d\u80fd\u9a73\u56de");
            }
            this.refundInterface.FailOrderRefund(refundId, reason);
            this.refundDetailInterface.FailOrderRefund(refundId);
            this.refundPayDetailInterface.FailOrderRefund(refundId);
            if (refundEntity.getRefundOrderType() == 1 && !(jsonVo = this.updateOrderStatusRefund(refundEntity.getOrderMainNo(), refundEntity.getOrderNo(), OrderStatusEnum.getName(refundEntity.getOrderStatus()), refundEntity.getCustomerId())).isSuccess()) {
                throw new Exception(jsonVo.getMessage());
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u9000\u6b3e\u9a73\u56de\u5931\u8d25,param:refundId:" + refundId + ",result:" + e.getMessage());
            return BaseJsonVo.error((String)("\u9000\u6b3e\u9a73\u56de\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return jsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo successOrderRefund(String refundId, int payTypeId, String tradeNo) {
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"");
        try {
            MallRefundEntity refundEntity = this.refundInterface.selectByPrimaryKey(refundId);
            if (refundEntity == null) {
                throw new Exception("\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
            }
            this.refundPayDetailInterface.SuccessOrderRefund(refundId, payTypeId);
            this.refundRecordInterface.updateSuccess(tradeNo);
            if (this.refundPayDetailInterface.isAllSuccess(refundId)) {
                this.refundInterface.SuccessOrderRefund(refundId);
                this.refundDetailInterface.SuccessOrderRefund(refundId);
                if (refundEntity.getRefundOrderType() == 1 && !(jsonVo = this.updateOrderStatusRefund(refundEntity.getOrderMainNo(), refundEntity.getOrderNo(), OrderStatusEnum.REFUNDED.getName(), refundEntity.getCustomerId())).isSuccess()) {
                    throw new Exception(jsonVo.getMessage());
                }
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u9000\u6b3e\u5b8c\u6210\u5931\u8d25,param:refundId:" + refundId + ",result:" + e.getMessage());
            return BaseJsonVo.error((String)("\u9000\u6b3e\u5b8c\u6210\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return jsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo cancelOrderRefund(String refundId, String reason) {
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"");
        try {
            MallRefundEntity refundEntity = this.refundInterface.selectByPrimaryKey(refundId);
            if (refundEntity == null) {
                throw new Exception("\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
            }
            if (refundEntity.getStatus() != 1) {
                throw new Exception("\u9000\u6b3e\u5355\u5df2\u7ecf\u4e0d\u80fd\u53d6\u6d88");
            }
            this.refundInterface.CancelOrderRefund(refundId, reason);
            this.refundDetailInterface.CancelOrderRefund(refundId);
            this.refundPayDetailInterface.CancelOrderRefund(refundId);
            if (refundEntity.getRefundOrderType() == 1 && !(jsonVo = this.updateOrderStatusRefund(refundEntity.getOrderMainNo(), refundEntity.getOrderNo(), OrderStatusEnum.getName(refundEntity.getOrderStatus()), refundEntity.getCustomerId())).isSuccess()) {
                throw new Exception(jsonVo.getMessage());
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error("\u9000\u6b3e\u53d6\u6d88\u5931\u8d25,param:refundId:" + refundId + ",result:" + e.getMessage());
            return BaseJsonVo.error((String)("\u9000\u6b3e\u53d6\u6d88\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return jsonVo;
    }

    @Override
    public BaseJsonVo buildRefundRecord(String refundPayId) {
        MallRefundPayDetailEntity refundPayDetailEntity = this.refundPayDetailInterface.getSingle(refundPayId);
        if (refundPayDetailEntity == null) {
            return BaseJsonVo.error((String)("\u9000\u6b3e\u660e\u7ec6\u4e0d\u5b58\u5728refundPayId:" + refundPayId));
        }
        if (refundPayDetailEntity.getPaytypeId() == 2) {
            MallRefundRecordEntity refundRecordEntity = new MallRefundRecordEntity();
            refundRecordEntity.setRefundPayId(refundPayDetailEntity.getRefundPayId());
            refundRecordEntity.setIssuccess(0);
            refundRecordEntity = this.refundRecordInterface.queryRefundRecordByParam(refundRecordEntity);
            if (refundRecordEntity == null) {
                return this.buildRefundRecord(refundPayDetailEntity, refundPayId);
            }
            return BaseJsonVo.success((Object)refundRecordEntity.getRefundRecordId());
        }
        return this.buildRefundRecord(refundPayDetailEntity, refundPayId);
    }

    private BaseJsonVo buildRefundRecord(MallRefundPayDetailEntity refundPayDetailEntity, String refundPayId) {
        MallOrderPayEntity orderPayEntity = this.orderPayInterface.getOrderPayInfoByOrderMainNoPayType(refundPayDetailEntity.getPaytypeId(), refundPayDetailEntity.getOrderMainNo());
        String recordId = IDGenerate.getUniqueIdStr();
        MallRefundRecordEntity refundRecordEntity = new MallRefundRecordEntity();
        refundRecordEntity.setRefundRecordId(recordId);
        refundRecordEntity.setWechatFactAmount(refundPayDetailEntity.getFactReturnAmount().multiply(new BigDecimal(100)).longValue());
        refundRecordEntity.setWechatApplyAmount(refundPayDetailEntity.getReturnAmount().multiply(new BigDecimal(100)).longValue());
        refundRecordEntity.setOrderAmount(orderPayEntity != null ? orderPayEntity.getPayamount().multiply(new BigDecimal(100)).longValue() : 0L);
        refundRecordEntity.setIssuccess(0);
        refundRecordEntity.setCreateTime(new Date());
        refundRecordEntity.setRefundBillNo(refundPayDetailEntity.getRefundId());
        refundRecordEntity.setTradeBillNo(recordId);
        refundRecordEntity.setRefundAmount(refundPayDetailEntity.getFactReturnAmount().multiply(new BigDecimal(100)).longValue());
        refundRecordEntity.setRefundPayId(refundPayId);
        if (!this.refundRecordInterface.insertEntity(refundRecordEntity)) {
            return BaseJsonVo.error((String)("\u521b\u5efa\u9000\u6b3e\u8bb0\u5f55\u5931\u8d25refundPayId:" + refundPayId));
        }
        return BaseJsonVo.success((Object)recordId);
    }

    @Override
    public BaseJsonVo returnUpdateRecord(String tradeNo, String thirdTradeNo, long refundAmount, String sendData, String receive_data) {
        try {
            MallRefundRecordEntity refundRecordEntity = this.refundRecordInterface.selectEntity(tradeNo);
            if (sendData.length() > 4000) {
                sendData = sendData.substring(0, 3999);
            }
            if (receive_data.length() > 4000) {
                receive_data = receive_data.substring(0, 3999);
            }
            refundRecordEntity.setWechatTradeId(thirdTradeNo);
            refundRecordEntity.setWechatFactAmount(refundAmount);
            refundRecordEntity.setSendData(sendData);
            refundRecordEntity.setReceiveData(receive_data);
            if (this.refundRecordInterface.updateEntity(refundRecordEntity)) {
                return BaseJsonVo.success((Object)"");
            }
        }
        catch (Exception e) {
            this.logger.error("\u9000\u6b3e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25,tradeNo:" + tradeNo + ",err:" + e.getMessage());
        }
        return BaseJsonVo.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    private BaseJsonVo validateRefundVo(OrderRefundApplyVo refundApplyVo) {
        PayInputEntity p;
        List<MallOrderPayEntity> orderPayEntities;
        BigDecimal refundAmount;
        List<MallRefundEntity> mallRefundEntityList;
        BaseJsonVo jsonVo = BaseJsonVo.success((Object)"");
        int orderStatus = 0;
        if (refundApplyVo == null) {
            return BaseJsonVo.error((String)"\u9000\u5355\u5bf9\u8c61\u4e3a\u7a7a");
        }
        List<ApplyRefundPayDetailVo> payDetailVos = refundApplyVo.getPayDetailVos();
        if (payDetailVos != null && payDetailVos.size() > 0) {
            BigDecimal cash = new BigDecimal(0);
            BigDecimal balance = new BigDecimal(0);
            for (ApplyRefundPayDetailVo payDetailVo : payDetailVos) {
                MallPayTypeEntity payTypeEntity = this.payTypeInterface.getPayType(payDetailVo.getPayTypeId());
                if (payTypeEntity == null) {
                    return BaseJsonVo.error((String)("\u652f\u4ed8\u65b9\u5f0f[" + payDetailVo.getPayTypeId() + "]\u4e0d\u5b58\u5728"));
                }
                if (payTypeEntity.getCashType() == 1) {
                    cash = cash.add(payDetailVo.getAmount());
                }
                if (payDetailVo.getPayTypeId() == 8) {
                    balance = balance.add(payDetailVo.getAmount());
                }
                if (payDetailVo.getPayTypeId() != 3) continue;
                refundApplyVo.setReturnAmount(refundApplyVo.getReturnAmount().subtract(payDetailVo.getAmount()));
            }
            refundApplyVo.setCashAmount(cash);
            refundApplyVo.setBalanceAmount(balance);
        }
        if ((refundApplyVo.getOrderMainNo() == null || refundApplyVo.getOrderMainNo().isEmpty()) && (refundApplyVo.getOrderNo() == null || refundApplyVo.getOrderNo().isEmpty())) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u53f7\u548c\u5b50\u8ba2\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (refundApplyVo.getSourceEnum() != RefundSourceEnum.edb && this.syncInfoInterface.isSuccessSyncEdb(refundApplyVo.getOrderMainNo(), refundApplyVo.getOrderNo()).booleanValue()) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u540c\u6b65EDB\uff0c\u8bf7\u5728EDB\u9000\u6b3e");
        }
        if (refundApplyVo.getBalanceAmount() == null || refundApplyVo.getBalanceAmount().doubleValue() < 0.0) {
            return BaseJsonVo.error((String)"\u4f59\u989d\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e\u96f6");
        }
        if (refundApplyVo.getCashAmount() == null || refundApplyVo.getCashAmount().doubleValue() < 0.0) {
            return BaseJsonVo.error((String)"\u94f6\u884c\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e\u96f6");
        }
        if (refundApplyVo.getIsRefundCoupon() != 0 && refundApplyVo.getIsRefundCoupon() != 1 && refundApplyVo.getIsRefundCoupon() != 2) {
            refundApplyVo.setIsRefundCoupon(2);
        }
        if (refundApplyVo.getReason() != null && refundApplyVo.getReason().length() > 500) {
            return BaseJsonVo.error((String)"\u9000\u6b3e\u539f\u56e0\u4e0d\u80fd\u5927\u4e8e500\u4e2a\u5b57\u7b26");
        }
        if (refundApplyVo.getRefundOrderType() != 1 && refundApplyVo.getRefundOrderType() != 2) {
            return BaseJsonVo.error((String)"\u9000\u6b3e\u7c7b\u578b\u8bf7\u9009\u62e91\u9000\u6b3e\u9000\u5355\u62162\u9000\u6b3e\u4e0d\u9000\u5355");
        }
        MallOrderMainEntity orderMainEntity = null;
        MallOrderEntity orderEntity = null;
        if (refundApplyVo.getOrderMainNo() != null && !refundApplyVo.getOrderMainNo().isEmpty() && (refundApplyVo.getOrderNo() == null || refundApplyVo.getOrderNo().isEmpty())) {
            orderMainEntity = this.orderMainInterface.selectByPrimaryKey(refundApplyVo.getOrderMainNo());
            if (orderMainEntity == null) {
                return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (orderMainEntity.getStatus() <= 1) {
                return BaseJsonVo.error((String)"\u8be5\u4e3b\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e");
            }
            if (orderMainEntity.getStatus() >= 20) {
                return BaseJsonVo.error((String)"\u8be5\u4e3b\u8ba2\u5355\u5df2\u7ecf\u53d1\u8d77\u9000\u6b3e\u4e0d\u80fd\u518d\u6b21\u9000\u6b3e");
            }
            refundApplyVo.setOrderTotalAmount(orderMainEntity.getTotalAmount());
            refundApplyVo.setCustomerId(orderMainEntity.getCustomerId());
            orderStatus = orderMainEntity.getStatus();
            mallRefundEntityList = this.refundInterface.getRefundListByOrderMainNo(refundApplyVo.getOrderMainNo());
            if (mallRefundEntityList != null && mallRefundEntityList.size() > 0 && PriceUtils.add((BigDecimal)(refundAmount = new BigDecimal(mallRefundEntityList.stream().filter(c -> c.getStatus() != 4 && c.getStatus() != 5).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum())), (BigDecimal)refundApplyVo.getReturnAmount()).compareTo(PriceUtils.format((BigDecimal)orderMainEntity.getTotalAmount())) > 0) {
                return BaseJsonVo.error((String)"\u9000\u6b3e\u91d1\u989d\u5df2\u7ecf\u8d85\u8fc7\u4e3b\u8ba2\u5355\u91d1\u989d");
            }
        }
        if (refundApplyVo.getOrderNo() != null && !refundApplyVo.getOrderNo().isEmpty()) {
            orderEntity = this.orderInterface.getmallOrder(refundApplyVo.getOrderNo());
            if (orderEntity == null) {
                return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (orderEntity.getStatus() <= 1 || orderEntity.getStatus() >= 20) {
                return BaseJsonVo.error((String)"\u8be5\u5b50\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e");
            }
            refundApplyVo.setOrderMainNo(orderEntity.getOrderMainNo());
            refundApplyVo.setOrderTotalAmount(orderEntity.getTotalAmount());
            orderMainEntity = this.orderMainInterface.selectByPrimaryKey(refundApplyVo.getOrderMainNo());
            if (orderMainEntity == null) {
                return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u7684\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            refundApplyVo.setCustomerId(orderMainEntity.getCustomerId());
            orderStatus = orderEntity.getStatus();
            mallRefundEntityList = this.refundInterface.getRefundListByOrderMainNo(refundApplyVo.getOrderMainNo());
            if (mallRefundEntityList != null && mallRefundEntityList.size() > 0 ? PriceUtils.add((BigDecimal)(refundAmount = new BigDecimal(mallRefundEntityList.stream().filter(c -> c.getStatus() != 4 && c.getStatus() != 5).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum())), (BigDecimal)refundApplyVo.getReturnAmount()).compareTo(PriceUtils.format((BigDecimal)orderMainEntity.getTotalAmount())) > 0 : PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()).compareTo(PriceUtils.format((BigDecimal)orderMainEntity.getTotalAmount())) > 0) {
                return BaseJsonVo.error((String)"\u9000\u6b3e\u91d1\u989d\u5df2\u7ecf\u8d85\u8fc7\u4e3b\u8ba2\u5355\u91d1\u989d");
            }
            mallRefundEntityList = this.refundInterface.getRefundListByOrderNo(refundApplyVo.getOrderNo());
            if (mallRefundEntityList != null && mallRefundEntityList.size() > 0) {
                refundAmount = new BigDecimal(mallRefundEntityList.stream().filter(c -> c.getStatus() != 4 && c.getStatus() != 5).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum());
                if (PriceUtils.add((BigDecimal)refundAmount, (BigDecimal)refundApplyVo.getReturnAmount()).compareTo(PriceUtils.format((BigDecimal)orderEntity.getTotalAmount())) > 0) {
                    return BaseJsonVo.error((String)("\u603b\u9000\u6b3e\u91d1\u989d[" + PriceUtils.add((BigDecimal)refundAmount, (BigDecimal)refundApplyVo.getReturnAmount()) + "]\u5df2\u7ecf\u8d85\u8fc7\u5b50\u8ba2\u5355\u91d1\u989d[" + orderEntity.getTotalAmount() + "]"));
                }
            } else if (PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()).compareTo(PriceUtils.format((BigDecimal)orderEntity.getTotalAmount())) > 0) {
                return BaseJsonVo.error((String)("\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()) + "]\u5df2\u7ecf\u8d85\u8fc7\u5b50\u8ba2\u5355\u91d1\u989d[" + orderEntity.getTotalAmount() + "]"));
            }
        }
        if (PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()).compareTo(new BigDecimal(0)) < 0) {
            return BaseJsonVo.error((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e0e\u96f6");
        }
        if (PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()).doubleValue() != 0.0 && PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()).doubleValue() != 0.0 && PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount().add(refundApplyVo.getBalanceAmount())).compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount())) != 0) {
            return BaseJsonVo.error((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        if (PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()).doubleValue() > 0.0 && PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()).doubleValue() == 0.0) {
            refundApplyVo.setBalanceAmount(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount().subtract(refundApplyVo.getCashAmount())));
        }
        if (PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()).doubleValue() == 0.0 && PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()).doubleValue() > 0.0) {
            refundApplyVo.setCashAmount(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount().subtract(refundApplyVo.getBalanceAmount())));
        }
        if ((orderPayEntities = this.orderPayInterface.getList(refundApplyVo.getOrderMainNo())) == null || orderPayEntities.size() == 0) {
            return BaseJsonVo.error((String)"\u652f\u4ed8\u660e\u7ec6\u4e0d\u5b58\u5728\u65e0\u6cd5\u9000\u6b3e");
        }
        ArrayList<PayInputEntity> payInputEntities = new ArrayList<PayInputEntity>();
        List<MallRefundPayDetailEntity> refundPayDetailList = this.refundPayDetailInterface.getRefundPayDetailList(refundApplyVo.getOrderMainNo());
        refundPayDetailList = refundPayDetailList.stream().filter(c -> c.getRefundStatus() >= 0).collect(Collectors.toList());
        Optional<MallOrderPayEntity> optional = orderPayEntities.stream().filter(c -> c.getCashType() == 1).findFirst();
        MallOrderPayEntity orderPayEntity = optional.isPresent() ? optional.get() : null;
        List orderPayEntitiesBalance = orderPayEntities.stream().filter(c -> c.getPaytypeId() == 8).collect(Collectors.toList());
        jsonVo = this.getPayBalanceList(refundApplyVo.getOrderNo(), orderMainEntity, orderEntity, orderPayEntities, refundPayDetailList);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        List maps = (List)jsonVo.getValue();
        Optional<Map> optionalMap = maps.stream().filter(c -> c.get("CASH").toString().equals("1")).findFirst();
        BigDecimal cashBalance = new BigDecimal(optionalMap.isPresent() ? optionalMap.get().get("REFUND_AMOUNT").toString() : "0");
        BigDecimal cashBalanceAll = new BigDecimal(optionalMap.isPresent() ? optionalMap.get().get("All_REFUND_AMOUNT").toString() : "0");
        List lsts = maps.stream().filter(c -> c.get("PAYTYPE_ID").toString().equals("8")).collect(Collectors.toList());
        BigDecimal yueBalance = BigDecimal.ZERO;
        BigDecimal yueBalanceAll = BigDecimal.ZERO;
        for (Map m : lsts) {
            yueBalance = yueBalance.add(new BigDecimal(m.get("REFUND_AMOUNT").toString()));
            yueBalanceAll = yueBalanceAll.add(new BigDecimal(m.get("All_REFUND_AMOUNT").toString()));
        }
        List orderPayEntitiesCoupon = orderPayEntities.stream().filter(c -> c.getPaytypeId() == 3).collect(Collectors.toList());
        if (refundApplyVo.getIsRefundCoupon() == 1 || refundApplyVo.getIsRefundCoupon() == 2) {
            if (orderPayEntitiesCoupon.size() == 0) {
                refundApplyVo.setIsRefundCoupon(0);
            } else if (!this.isRefundCoupon(orderMainEntity, refundPayDetailList, refundApplyVo.getOrderNo(), refundApplyVo.getRefundOrderType())) {
                refundApplyVo.setIsRefundCoupon(0);
            }
        }
        if (refundApplyVo.getSourceEnum() == RefundSourceEnum.edb) {
            if (PriceUtils.format((BigDecimal)yueBalance.add(cashBalance)).compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount())) < 0) {
                refundApplyVo.setReturnAmount(PriceUtils.format((BigDecimal)yueBalance.add(cashBalance)));
                refundApplyVo.setCashAmount(BigDecimal.ZERO);
                refundApplyVo.setBalanceAmount(BigDecimal.ZERO);
            }
        } else if (PriceUtils.format((BigDecimal)yueBalance.add(cashBalance)).compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount())) < 0) {
            return BaseJsonVo.error((String)("\u53ef\u9000\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u5269\u4f59\u53ef\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)yueBalance.add(cashBalance)) + "]\uff0c\u65e0\u6cd5\u9000\u6b3e" + PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()) + "\u5143"));
        }
        if (PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()).doubleValue() == 0.0 && PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()).doubleValue() == 0.0) {
            if (orderPayEntity != null) {
                if (cashBalance.doubleValue() >= PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()).doubleValue()) {
                    refundApplyVo.setCashAmount(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()));
                    refundApplyVo.setBalanceAmount(new BigDecimal(0));
                } else {
                    refundApplyVo.setCashAmount(cashBalance);
                    refundApplyVo.setBalanceAmount(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount().subtract(cashBalance)));
                }
            } else {
                refundApplyVo.setBalanceAmount(PriceUtils.format((BigDecimal)refundApplyVo.getReturnAmount()));
            }
        }
        if (refundApplyVo.getIsRefundCoupon() == 0 && (refundApplyVo.getReturnAmount() == null || refundApplyVo.getReturnAmount().doubleValue() <= 0.0)) {
            return BaseJsonVo.error((String)"\u9000\u6b3e\u603b\u989d\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()).doubleValue() > 0.0) {
            if (cashBalanceAll.compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount())) < 0) {
                return BaseJsonVo.error((String)("\u73b0\u91d1\u652f\u4ed8\u7684\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()) + "]\u5927\u4e8e\u53ef\u9000\u73b0\u91d1\u652f\u4ed8\u603b\u91d1\u989d[" + cashBalanceAll + "]"));
            }
            if (orderPayEntity == null) {
                return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u6ca1\u6709\u73b0\u91d1\u652f\u4ed8\uff0c\u4e0d\u80fd\u9000\u73b0\u91d1\u652f\u4ed8");
            }
            if (orderMainEntity != null && orderEntity != null && cashBalance.compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount())) < 0) {
                return BaseJsonVo.error((String)("\u5b50\u5355\u73b0\u91d1\u652f\u4ed8\u7684\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()) + "]\u5927\u4e8e\u53ef\u9000\u73b0\u91d1\u652f\u4ed8\u5206\u644a\u7684\u91d1\u989d[" + cashBalance + "]"));
            }
            if (cashBalance.compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount())) < 0) {
                return BaseJsonVo.error((String)("\u73b0\u91d1\u652f\u4ed8\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)refundApplyVo.getCashAmount()) + "]\u5927\u4e8e\u53ef\u9000\u73b0\u91d1\u652f\u4ed8\u91d1\u989d[" + cashBalance + "]"));
            }
        }
        if (PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()).doubleValue() > 0.0) {
            if (yueBalanceAll.compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount())) < 0) {
                return BaseJsonVo.error((String)("\u4f59\u989d\u652f\u4ed8\u7684\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()) + "]\u5927\u4e8e\u53ef\u9000\u4f59\u989d\u652f\u4ed8\u603b\u91d1\u989d[" + yueBalanceAll + "]"));
            }
            if (orderPayEntitiesBalance.size() == 0) {
                return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u6ca1\u6709\u4f59\u989d\u652f\u4ed8\uff0c\u4e0d\u80fd\u9000\u4f59\u989d");
            }
            if (orderMainEntity != null && orderEntity != null && yueBalance.compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount())) < 0) {
                return BaseJsonVo.error((String)("\u5b50\u5355\u4f59\u989d\u652f\u4ed8\u7684\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()) + "]\u5927\u4e8e\u53ef\u9000\u4f59\u989d\u652f\u4ed8\u5206\u644a\u7684\u91d1\u989d[" + yueBalance + "]"));
            }
            if (yueBalance.compareTo(PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount())) < 0) {
                return BaseJsonVo.error((String)("\u73b0\u91d1\u652f\u4ed8\u9000\u6b3e\u91d1\u989d[" + PriceUtils.format((BigDecimal)refundApplyVo.getBalanceAmount()) + "]\u5927\u4e8e\u53ef\u9000\u73b0\u91d1\u652f\u4ed8\u91d1\u989d[" + yueBalance + "]"));
            }
        }
        if (refundApplyVo.getCashAmount().doubleValue() > 0.0) {
            p = new PayInputEntity();
            p.setPayType(orderPayEntity.getPaytypeId());
            p.setPaySubType(orderPayEntity.getPaySubtypeId());
            p.setCashType(orderPayEntity.getCashType());
            p.setPayAmount(refundApplyVo.getCashAmount());
            p.setTradeNo(orderPayEntity.getTradeNo());
            payInputEntities.add(p);
        }
        if (refundApplyVo.getBalanceAmount().doubleValue() > 0.0) {
            p = new PayInputEntity();
            p.setPayType(((MallOrderPayEntity)orderPayEntitiesBalance.get(0)).getPaytypeId());
            p.setPaySubType(0);
            p.setCashType(((MallOrderPayEntity)orderPayEntitiesBalance.get(0)).getCashType());
            p.setTradeNo(((MallOrderPayEntity)orderPayEntitiesBalance.get(0)).getTradeNo());
            p.setPayAmount(refundApplyVo.getBalanceAmount());
            payInputEntities.add(p);
        }
        if (refundApplyVo.getIsRefundCoupon() == 1 || refundApplyVo.getIsRefundCoupon() == 2) {
            p = new PayInputEntity();
            p.setPayType(((MallOrderPayEntity)orderPayEntitiesCoupon.get(0)).getPaytypeId());
            p.setPaySubType(((MallOrderPayEntity)orderPayEntitiesCoupon.get(0)).getPaySubtypeId());
            p.setCashType(((MallOrderPayEntity)orderPayEntitiesCoupon.get(0)).getCashType());
            p.setPayAmount(new BigDecimal(0));
            p.setTradeNo(((MallOrderPayEntity)orderPayEntitiesCoupon.get(0)).getTradeNo());
            payInputEntities.add(p);
        }
        refundApplyVo.setPayInputEntities(payInputEntities);
        refundApplyVo.setOrderStatus(orderStatus);
        return jsonVo;
    }

    @Override
    public BaseJsonVo getPayBalanceList(String orderMainNo, String orderNo) {
        List<MallOrderPayEntity> orderPayEntities = this.orderPayInterface.getList(orderMainNo);
        MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderPayEntities == null || orderPayEntities.size() == 0) {
            return BaseJsonVo.error((String)"\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (orderNo != null && !orderNo.isEmpty() && orderEntity == null) {
            return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Optional<MallOrderPayEntity> couponPayEntity = orderPayEntities.stream().filter(c -> c.getPaytypeId() == 3).findFirst();
        List<MallRefundPayDetailEntity> refundPayDetailEntities = this.refundPayDetailInterface.getRefundPayDetailList(orderMainNo);
        refundPayDetailEntities = refundPayDetailEntities.stream().filter(c -> c.getRefundStatus() >= 0).collect(Collectors.toList());
        return this.getPayBalanceList(orderNo, orderMainEntity, orderEntity, orderPayEntities, refundPayDetailEntities);
    }

    private BaseJsonVo getPayBalanceList(String orderNo, MallOrderMainEntity orderMainEntity, MallOrderEntity orderEntity, List<MallOrderPayEntity> orderPayEntities, List<MallRefundPayDetailEntity> refundPayDetailEntities) {
        Optional<MallOrderPayEntity> couponPayEntity = orderPayEntities.stream().filter(c -> c.getPaytypeId() == 3).findFirst();
        if (!this.isRefundCoupon(orderMainEntity, refundPayDetailEntities, orderNo, null) && couponPayEntity.isPresent()) {
            orderPayEntities.remove(couponPayEntity.get());
        }
        BigDecimal rate = new BigDecimal(1);
        if (orderEntity != null) {
            rate = PriceUtils.divide((BigDecimal)orderEntity.getTotalAmount(), (BigDecimal)orderMainEntity.getTotalAmount(), (int)8, (Integer)4);
        }
        ArrayList<HashedMap> maps = new ArrayList<HashedMap>();
        HashedMap map = null;
        BigDecimal refundedAmount = BigDecimal.ZERO;
        BigDecimal refundedAmountAll = BigDecimal.ZERO;
        for (MallOrderPayEntity orderPayEntity : orderPayEntities) {
            map = new HashedMap();
            refundedAmountAll = PriceUtils.format((Double)refundPayDetailEntities.stream().filter(c -> c.getPaytypeId().intValue() == orderPayEntity.getPaytypeId().intValue()).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum());
            if (orderEntity != null) {
                Double mainCash = refundPayDetailEntities.stream().filter(c -> (c.getOrderNo() == null || c.getOrderNo().isEmpty()) && c.getPaytypeId().intValue() == orderPayEntity.getPaytypeId().intValue()).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum();
                refundedAmount = rate.multiply(new BigDecimal(mainCash));
                refundedAmount = PriceUtils.format((BigDecimal)refundedAmount.add(new BigDecimal(refundPayDetailEntities.stream().filter(c -> c.getOrderNo().equals(orderNo) && c.getPaytypeId().intValue() == orderPayEntity.getPaytypeId().intValue()).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum())));
            } else {
                refundedAmount = PriceUtils.format((Double)refundPayDetailEntities.stream().filter(c -> c.getPaytypeId().intValue() == orderPayEntity.getPaytypeId().intValue()).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum());
            }
            BigDecimal balanceRefund = PriceUtils.format((BigDecimal)orderPayEntity.getPayamount().multiply(rate)).subtract(refundedAmount);
            BigDecimal balanceRefundAll = PriceUtils.format((BigDecimal)orderPayEntity.getPayamount()).subtract(refundedAmountAll);
            BigDecimal bigDecimal = balanceRefund = balanceRefund.compareTo(balanceRefundAll) > 0 ? balanceRefundAll : balanceRefund;
            if (balanceRefund.doubleValue() <= 0.0) continue;
            map.put("PAYTYPE_ID", orderPayEntity.getPaytypeId());
            map.put("PAYTYPE_NAME", orderPayEntity.getPaytypeName());
            map.put("AlreadyRefund", refundedAmount);
            map.put("CASH", orderPayEntity.getCashType());
            map.put("PAYAMOUNT", orderPayEntity.getPayamount());
            map.put("SUB_PAYAMOUNT", PriceUtils.format((BigDecimal)orderPayEntity.getPayamount().multiply(rate)));
            if (orderPayEntity.getPaytypeId() != 3) {
                if (balanceRefund.doubleValue() < 0.0) {
                    balanceRefund = BigDecimal.ZERO;
                }
                if (balanceRefundAll.doubleValue() < 0.0) {
                    balanceRefundAll = BigDecimal.ZERO;
                }
                map.put("REFUND_AMOUNT", balanceRefund);
                map.put("All_REFUND_AMOUNT", balanceRefundAll);
            } else {
                map.put("REFUND_AMOUNT", orderPayEntity.getPayamount());
                map.put("All_REFUND_AMOUNT", orderPayEntity.getPayamount());
            }
            maps.add(map);
        }
        if (maps.size() == 0) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u53ef\u9000\u91d1\u989d");
        }
        return BaseJsonVo.success(maps);
    }

    private boolean isRefundCoupon(MallOrderMainEntity orderMainEntity, List<MallRefundPayDetailEntity> refundPayDetailEntities, String orderNo, Integer refundType) {
        if (refundType != null && refundType == 2) {
            return false;
        }
        if ((refundPayDetailEntities = refundPayDetailEntities.stream().filter(c -> c.getRefundStatus() != -1).collect(Collectors.toList())) != null && refundPayDetailEntities.size() > 0 && refundPayDetailEntities.stream().filter(c -> c.getPaytypeId() == 3).findFirst().isPresent()) {
            return false;
        }
        if (orderMainEntity.getStatus() >= 9 && (orderNo == null || orderNo.isEmpty())) {
            return false;
        }
        List<MallRefundEntity> refundEntities = this.refundInterface.getRefundListByOrderMainNo(orderMainEntity.getOrderMainNo());
        if ((refundEntities = refundEntities.stream().filter(c -> c.getStatus() != 4 && c.getStatus() != 5).collect(Collectors.toList())).stream().filter(c -> c.getRefundOrderType() == 2).count() > 0L) {
            return false;
        }
        if (refundEntities.stream().filter(c -> c.getOrderStatus() >= 9).count() > 0L) {
            return false;
        }
        if (orderNo != null && !orderNo.isEmpty()) {
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
            if (orderEntities.stream().filter(c -> !c.getOrderNo().equals(orderNo) && c.getStatus() <= 20).count() > 0L) {
                return false;
            }
            Optional<MallOrderEntity> orderEntity = orderEntities.stream().filter(c -> c.getOrderNo().equals(orderNo)).findFirst();
            if (!orderEntity.isPresent()) {
                return false;
            }
            if (orderEntity.get().getStatus() >= 10) {
                return false;
            }
        }
        return true;
    }
}

