/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.defineFieldHandle;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.iservice.active.GiftInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.sales.MallPromotionBuyEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntitiesVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageQueueInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.service.thirdparty.OldApiUtil;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DefineFiledHandleService
extends BaseService
implements DefineFiledHandleInterface {
    @Autowired
    private GiftInterface giftInterface;
    @Autowired
    private MallOrderMessageQueueInterface messageQueueService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderPayInterface payService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private DeliverInterface deliverInterface;
    @Autowired
    private OldApiUtil oldApiUtil;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    @Lazy
    private ActiveInterface activeInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private ActiveSaleContext activeContext;
    @Autowired
    private MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    private MallPromotionBuyInterface mallPromotionBuyInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallPromotionTimeInterface promotionTimeService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private AccountBalanceInterface balanceService;
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    private PrepayCardInterface prepayCardInterface;

    @Override
    public BaseJsonVo setCache(int platFormId, String customerId, String cacheId, MallOrderCacheInVo cacheInVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo toPayPage(MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderBefore(MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderBefore(MallOrderEntitiesVo orderEntitiesVo, MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo createOrderBefore(String customerId, Integer orderSource, String bindCode) {
        try {
            ActiveEntity activeEntity;
            if (orderSource != null && StringUtils.isNotEmpty((String)bindCode) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) != null) {
                BaseJsonVo baseJsonVo = this.activeContext.checkCanJoin(activeEntity.getActiveType(), customerId, bindCode);
                return baseJsonVo;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo createOrderBefore(String customerId, Integer orderSource, String bindCode, MallMainOrderVo mainOrderVo) {
        try {
            ActiveEntity activeEntity;
            if (orderSource != null && StringUtils.isNotEmpty((String)bindCode) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode)) != null) {
                BaseJsonVo baseJsonVo = this.activeContext.checkCanJoin(activeEntity.getActiveType(), customerId, bindCode, mainOrderVo);
                return baseJsonVo;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderBeforeWithTransaction(MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo createOrderAfterWithTransaction(MallMainOrderVo mainOrderVo, boolean createSuccess) {
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo createOrderAfter(MallMainOrderVo mainOrderVo, MallOrderCacheVo orderCacheVo, boolean createSuccess) {
        this.messageQueueService.sendCommitOrderQueue(mainOrderVo);
        try {
            ActiveEntity activeEntity;
            if (StringUtils.isNotEmpty((String)orderCacheVo.getBindCode()) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(orderCacheVo.getBindCode())) != null) {
                BaseJsonVo baseJsonVo = this.activeContext.afterCreateOrder(activeEntity.getActiveType(), orderCacheVo, mainOrderVo);
                return baseJsonVo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo orderPayBefore(String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo orderPayAfter(String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo orderPaySuccessAfter(String orderMainNo) {
        this.logger.info("\u652f\u4ed8\u6210\u529f\u7684\u4e8b\u4ef6\u5f00\u59cb:" + orderMainNo);
        try {
            Integer activeType = 0;
            MallOrderMainEntity mallOrderEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            if (StringUtils.isNotEmpty((String)mallOrderEntity.getBindCode())) {
                this.redisService.sadd(mallOrderEntity.getBindCode() + ":customer", mallOrderEntity.getCustomerId());
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(mallOrderEntity.getBindCode());
                activeType = activeEntity.getActiveType();
            }
            this.logger.info("\u652f\u4ed8\u6210\u529f\u540c\u6b65EDB\u5b8c\u6210");
            this.logger.info("<><><><><><><><><><>" + mallOrderEntity.getOrderClass());
            if (mallOrderEntity.getOrderClass().intValue() == OrderClassEnum.CHARGE_ORDER.getValue()) {
                List<MallOrderProductEntity> products = this.mallOrderProductInterface.getOrderProductInfoByOrderMianNo(orderMainNo);
                this.balanceService.charge(mallOrderEntity.getCustomerId(), orderMainNo, products.get(0).getProductId());
            }
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u652f\u4ed8\u6210\u529f\u6d88\u606f\u961f\u5217,\u8ba2\u5355\u53f7:{},\u6d3b\u52a8\u7c7b\u578b:{}", (Object)orderMainNo, (Object)activeType);
            BaseJsonVo createCardResult = BaseJsonVo.error();
            if (mallOrderEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue()) {
                createCardResult = this.prepayCardInterface.orderPaySuccessCreateCard(orderMainNo);
                this.logger.info("<><><><>\u751f\u6210prepay\u5361\u7ed3\u679c:" + createCardResult.isSuccess() + "|" + createCardResult.getError_msg());
            }
            this.logger.info("<><><><>" + (mallOrderEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue()));
            this.logger.info("<><><><>" + createCardResult.isSuccess());
            if (mallOrderEntity.getOrderClass().intValue() == OrderClassEnum.CHARGE_ORDER.getValue() || mallOrderEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY.getValue() && createCardResult.isSuccess()) {
                Boolean success = this.orderMainInterface.updateOrderMainStatus(orderMainNo, OrderStatusEnum.COMPLETION.getName(), mallOrderEntity.getCustomerId(), mallOrderEntity.getStatus());
                List<MallOrderEntity> orderEntities = this.mallOrderInterface.getOrderList(mallOrderEntity.getOrderMainNo());
                if (orderEntities != null) {
                    for (MallOrderEntity o : orderEntities) {
                        if (this.mallOrderInterface.updateOrderStatus(o.getOrderNo(), OrderStatusEnum.COMPLETION.getName(), mallOrderEntity.getCustomerId(), OrderStatusEnum.PAYCONFIRM.getValue())) continue;
                        this.logger.error("\u66f4\u65b0\u5b50\u8ba2\u5355\u5931\u8d25,\u8ba2\u5355\u53f7={}", (Object)mallOrderEntity.getOrderMainNo());
                    }
                }
                this.logger.info("\u50a8\u503c\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u76f4\u63a5\u53d8\u66f4\u6210\u5df2\u5b8c\u6210[" + mallOrderEntity.getOrderMainNo() + "] : " + success);
            }
            if (mallOrderEntity.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue()) {
                this.planDetailInterface.orderPaySuccessUpdateCardPlanStatus(orderMainNo);
            }
            this.messageQueueService.sendPaySuccessOrderQueue(mallOrderEntity, activeType);
        }
        catch (Exception e) {
            this.logger.error("\u652f\u4ed8\u540e\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        this.logger.info("\u652f\u4ed8\u6210\u529f\u7684\u4e8b\u4ef6\u7ed3\u675f:" + orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo cancelOrderBefore(String customerId, String orderMainNo, int cancelSource) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo cancelOrderAfter(String customerId, String orderMainNo, int cancelSource) {
        List<MallOrderProductEntity> mallOrderProductEntityList = this.mallOrderProductInterface.getOrderProductInfoByOrderMianNoPromotion(orderMainNo);
        if (mallOrderProductEntityList.size() > 0) {
            int i;
            ArrayList<String> promotionIdList = new ArrayList<String>();
            ArrayList<MallPromotionBuyEntity> mallPromotionBuyEntityList = new ArrayList<MallPromotionBuyEntity>();
            for (MallOrderProductEntity mallOrderProductEntity : mallOrderProductEntityList) {
                MallPromotionBuyEntity promotionBuyEntity = new MallPromotionBuyEntity();
                promotionBuyEntity.setPromotionId(mallOrderProductEntity.getPromotionId());
                promotionBuyEntity.setBuyCount(-mallOrderProductEntity.getQuantity().intValue());
                promotionBuyEntity.setCreateTime(DateUtils.now());
                mallPromotionBuyEntityList.add(promotionBuyEntity);
                promotionIdList.add(mallOrderProductEntity.getPromotionId());
            }
            if (mallPromotionBuyEntityList != null && mallPromotionBuyEntityList.size() > 0 && (i = this.mallPromotionBuyInterface.insertPromotionBuyBatch(mallPromotionBuyEntityList)) > 0 && promotionIdList.size() > 0 && promotionIdList != null) {
                for (String promotionId : promotionIdList) {
                    MallPromotionEntity promotionEntity = this.promotionService.getPromotion(promotionId);
                    MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionId, DateUtils.date());
                    if (promotionTimeEntity != null && promotionEntity != null) {
                        Date beginTime = promotionTimeEntity.getBeginTime();
                        Date endTime = promotionTimeEntity.getEndTime();
                        if (promotionEntity.getPromotionType() == 2) {
                            beginTime = DateUtils.currentDate();
                            endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
                        }
                        this.mallPromotionBuyInterface.clearPromotionBuyCache(promotionId, beginTime, endTime);
                    }
                    this.memcachedService.delete("promotionEntity", promotionId);
                }
            }
        }
        this.messageQueueService.sendCancelOrderQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteOrderBefore(String customerId, String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteOrderAfter(String customerId, String orderMainNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo confirmGoodsBefore(String customerId, String orderMainNo, String orderNo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo confirmGoodsAfter(String customerId, String orderMainNo, String orderNo) {
        MallOrderMainEntity mallOrderEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        return this.confirmGoodsAfter(mallOrderEntity, orderNo);
    }

    @Override
    public BaseJsonVo confirmGoodsAfter(MallOrderMainEntity orderMainEntity, String orderNo) {
        try {
            this.messageQueueService.sendConfirmGoodsQueue(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo(), orderNo);
            return BaseJsonVo.success((Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u786e\u8ba4\u6536\u8d27\u51fa\u9519,\u8ba2\u5355\u53f7:{},\u7528\u6237customerId={}", new Object[]{orderMainEntity.getOrderMainNo(), orderMainEntity.getCustomerId(), e});
            throw new RuntimeException(e);
        }
    }

    @Override
    public BaseJsonVo TakeGoodAfter(String orderMainNo) {
        this.messageQueueService.sendDeliverGoodsQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo RefundApplyAfter(String orderMainNo) {
        this.messageQueueService.sendRefundApplyQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo RefundAfter(String orderMainNo) {
        this.messageQueueService.sendRefundQueue(orderMainNo);
        return BaseJsonVo.success((Object)"");
    }
}

