/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="42_balance")
public class balanceHandle
implements OrderHandleInterface {
    @Autowired
    private AccountBalanceInterface balanceInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        this.priceCalcInterface.totalMainOrderPrice(mallMainOrderVo);
        if (mallMainOrderVo.getOrderCacheVo().getUseAccountBalance() == 0) {
            return BaseJsonVo.success((Object)"");
        }
        CustomerEntity customerEntity = this.customerInterface.getCustomer(mallMainOrderVo.getCustomerId());
        if (customerEntity == null) {
            return BaseJsonVo.error((String)("\u7528\u6237\u4e0d\u5b58\u5728customer:" + mallMainOrderVo.getCustomerId()));
        }
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal useBalanceAmount = PriceUtils.subtract((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getCouponAmount());
        balance = mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.CARDPLAN.getValue() ? useBalanceAmount : this.balanceInterface.getGiftBalanceById(customerEntity.getCustomerId());
        mallMainOrderVo.setTotalBalanceAmount(balance);
        if (useBalanceAmount.doubleValue() > balance.doubleValue()) {
            useBalanceAmount = balance;
        }
        if (useBalanceAmount.doubleValue() > 0.0) {
            BigDecimal[] remainder = new BigDecimal[]{new BigDecimal(0)};
            BigDecimal[] finalUseBalanceAmount = new BigDecimal[]{useBalanceAmount};
            mallMainOrderVo.getMallOrderVos().forEach(c -> {
                BigDecimal mianOrderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)mallMainOrderVo.getTotalAmount(), (BigDecimal)mallMainOrderVo.getCouponAmount());
                BigDecimal orderMoneyAmount = PriceUtils.subtractToSix((BigDecimal)c.getTotalAmount(), (BigDecimal)c.getCouponAmount());
                BigDecimal orderDivideMainMoneyAmount = orderMoneyAmount.divide(mianOrderMoneyAmount, 6, 4);
                BigDecimal subBalanceAmount = PriceUtils.multiply((BigDecimal)orderDivideMainMoneyAmount, (BigDecimal)finalUseBalanceAmount[0]);
                c.setBalanceAmount(subBalanceAmount);
                remainder[0] = PriceUtils.addNoUp((BigDecimal)remainder[0], (BigDecimal)subBalanceAmount);
            });
            remainder[0] = PriceUtils.subtractToSix((BigDecimal)useBalanceAmount, (BigDecimal)remainder[0]);
            if (remainder[0].doubleValue() != 0.0) {
                mallMainOrderVo.getMallOrderVos().get(0).setBalanceAmount(PriceUtils.add((BigDecimal)mallMainOrderVo.getMallOrderVos().get(0).getBalanceAmount(), (BigDecimal)remainder[0]));
            }
        }
        mallMainOrderVo.setBalanceAmount(useBalanceAmount);
        return BaseJsonVo.success((Object)"");
    }
}

