/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.mall.service.weixin.reply.MenuMessageHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component
public class MenuMessageContext {
    private Map<String, MenuMessageHandle> messageHandle = new ConcurrentHashMap<String, MenuMessageHandle>();

    @Autowired
    public MenuMessageContext(Map<String, MenuMessageHandle> messageHandle) {
        this.messageHandle.clear();
        messageHandle.forEach((k, v) -> this.messageHandle.put((String)k, (MenuMessageHandle)v));
    }

    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        MenuMessageHandle menuMessageHandle = this.messageHandle.get(eventMessage.getEventKey().toLowerCase());
        if (menuMessageHandle != null) {
            return menuMessageHandle.receiveMessage(eventMessage, platformId);
        }
        return null;
    }
}

