/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.tempCode.CustomerQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.active.service.tempqrcode.TempQrcodeContext;
import cc.lechun.active.vo.CustomerQrcodeVo;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.version.VersionDetailEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.weixin.WeiXinMessage;
import cc.lechun.mall.service.weixin.reply.ReplyMessageHandle;
import cc.lechun.mall.service.weixin.reply.ScanInfoMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component(value="scanMessage")
public class ScanMessageHandle
extends WeiXinMessage
implements ReplyMessageHandle {
    @Autowired
    private DictionaryInterface dictionaryService;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeService;
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private TempQrcodeContext tempQrcodeContext;
    @Autowired
    private ScanInfoMessage scanMessage;

    @Override
    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        return this.scanMessage.receiveMessage(eventMessage, platformId);
    }

    private XMLMessage receivePicScan(CustomerQrcodeEntity tempCustomerQrcode, EventMessage eventMessage, int platformId) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetailByOpenid(eventMessage.getFromUserName(), platformId);
        tempCustomerQrcode.setCustomerId(customerDetailVo.getCustomerId());
        CustomerQrcodeEntity customerQrcodeEntity = this.customerQrcodeService.getCustomerQrcode(tempCustomerQrcode);
        if (customerQrcodeEntity != null) {
            this.logger.info("\u7528\u6237\u4e8c\u7ef4\u7801\u5b9e\u4f53:{}", (Object)customerQrcodeEntity.toString());
            VersionDetailEntity versionDetail = new VersionDetailEntity();
            ActiveQrcodeEntity tempActiveQrcode = new ActiveQrcodeEntity();
            tempActiveQrcode.setActiveType(1);
            tempActiveQrcode.setActiveNo(customerQrcodeEntity.getActiveNo());
            ActiveQrcodeEntity qrcodeEntity = this.activeQrcodeService.getActiveQrcode(tempActiveQrcode);
            this.logger.info("\u6d3b\u52a8\u4e8c\u7ef4\u7801\u5b9e\u4f53:{}", (Object)customerQrcodeEntity.toString());
            CustomerEntity customerEntity = this.customerService.getCustomer(customerQrcodeEntity.getCustomerId());
            this.logger.info("\u67e5\u8be2\u4e8c\u7ef4\u7801\u7528\u6237:{}", (Object)customerQrcodeEntity.toString());
            CustomerQrcodeVo customerQrcodeVo = new CustomerQrcodeVo();
            customerQrcodeVo.setCustomerEntity(customerEntity);
            customerQrcodeVo.setVersionDetailEntity(versionDetail);
            customerQrcodeVo.setCustomerQrcodeEntity(customerQrcodeEntity);
            this.logger.info("\u63a8\u9001\u626b\u7801\u4e8c\u7ef4\u7801\u8bb0\u5f55:{}", (Object)customerQrcodeVo.toString());
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.picScanCode, MessageParam.messageParam((String)customerEntity.getCustomerId(), (Object)customerQrcodeVo));
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(customerQrcodeEntity.getActiveNo());
            if (activeEntity != null && activeEntity.getEndTime().after(DateUtils.now()) && activeEntity.getStatus() == 1) {
                this.logger.info("\u67e5\u8be2\u6d3b\u52a8\u5b9e\u4f53:{}", (Object)activeEntity.toString());
                if (Integer.valueOf(4).equals(activeEntity.getActiveType())) {
                    String ountContent = this.customerQrcodeService.getBuyLinkMessage(customerQrcodeEntity, versionDetail, qrcodeEntity, customerEntity);
                    return this.pushTextMessage(eventMessage, ountContent);
                }
                return this.pushMessage(eventMessage, qrcodeEntity.getKeywordId(), platformId);
            }
            this.logger.info("\u6d3b\u52a8\u5df2\u8fc7\u671f\u6216\u672a\u542f\u7528\uff0cactiveNo={}", (Object)customerQrcodeEntity.getActiveNo());
        } else {
            this.logger.info("\u7528\u6237\u4e8c\u7ef4\u7801\u5b9e\u4f53\u4e3a\u7a7a:{}", (Object)tempCustomerQrcode.toString());
        }
        return null;
    }
}

