/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin.reply;

import cc.lechun.mall.service.weixin.reply.ReplyMessageHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;

@Component
public class WeiXinMessageContext {
    private Map<String, ReplyMessageHandle> messageHandle = new ConcurrentHashMap<String, ReplyMessageHandle>();

    @Autowired
    public WeiXinMessageContext(Map<String, ReplyMessageHandle> messageHandle) {
        this.messageHandle.clear();
        messageHandle.forEach((k, v) -> this.messageHandle.put((String)k, (ReplyMessageHandle)v));
    }

    public XMLMessage receiveMessage(EventMessage eventMessage, int platformId) {
        ReplyMessageHandle replyMessageHandle;
        if (eventMessage.getMsgType().equals("event") && (replyMessageHandle = this.messageHandle.get(eventMessage.getEvent().toLowerCase() + "Message")) != null) {
            return replyMessageHandle.receiveMessage(eventMessage, platformId);
        }
        if (eventMessage.getMsgType().equals("text")) {
            return this.messageHandle.get("keywordMessage").receiveMessage(eventMessage, platformId);
        }
        return null;
    }
}

