/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.reserve;

import cc.lechun.active.dao.active.ActiveReserveMapper;
import cc.lechun.active.entity.active.ActiveReserveEntity;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ReserveService
extends ActiveBaseService
implements ReserveInterface {
    @Autowired
    private ActiveReserveMapper reserveMapper;
    @Autowired
    @Lazy
    private MessageInterface messageService;

    @Override
    public BaseJsonVo reserve(String customerId, String activeNo, String reserveType) {
        BaseJsonVo getReserve = this.getReserve(customerId, activeNo);
        if (getReserve.isSuccess() && "0".equals(((HashMap)getReserve.getValue()).get("code"))) {
            ActiveReserveEntity reserve = new ActiveReserveEntity();
            reserve.setCustomerId(customerId);
            reserve.setProId(activeNo);
            reserve.setProType(StringUtils.isEmpty((String)reserveType) ? "5" : reserveType);
            reserve.setIsSend("0");
            reserve.setCreateTime(DateUtils.now());
            this.reserveMapper.insert(reserve);
        }
        return BaseJsonVo.success((Object)"\u9884\u7ea6\u6210\u529f");
    }

    @Override
    public BaseJsonVo getReserve(String customerId, String activeNo) {
        ActiveReserveEntity reserve = new ActiveReserveEntity();
        reserve.setProId(activeNo);
        reserve.setCustomerId(customerId);
        reserve.setIsSend("0");
        List reserves = this.reserveMapper.getList(reserve);
        if (reserves != null && reserves.size() > 0) {
            return BaseJsonVo.success((Object)new HashMap<String, String>(){
                {
                    this.put("code", "1");
                    this.put("message", "\u60a8\u5df2\u9884\u7ea6");
                }
            });
        }
        return BaseJsonVo.success((Object)new HashMap<String, String>(){
            {
                this.put("code", "0");
                this.put("message", "\u60a8\u8fd8\u672a\u9884\u7ea6");
            }
        });
    }

    @Override
    public BaseJsonVo getActiveReserve(String activeNo) {
        ActiveReserveEntity reserve = new ActiveReserveEntity();
        reserve.setProId(activeNo);
        reserve.setIsSend("0");
        List reserves = this.reserveMapper.getList(reserve);
        return BaseJsonVo.success((Object)(reserves == null ? 0 : reserves.size()));
    }

    @Override
    public PageInfo reserveList(int pageNum, int pageSize, String activeNo, String nickName) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        List<ActiveReserveEntity> list = this.reserveMapper.getReserveList();
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    @Override
    public BaseJsonVo sendReserveMessage(String activeNo) {
        List<Map<String, Object>> customers = this.reserveMapper.findUnsend(activeNo);
        this.logger.info("\u8981\u53d1\u9001\u9884\u7ea6\u63d0\u9192\u4e86 : " + customers.size());
        ExecutorService pool = Executors.newCachedThreadPool();
        customers.forEach(customer -> pool.execute(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nickName", (String)customer.get("NICK_NAME"));
            map.put("proName", (String)customer.get("PRO_NAME"));
            map.put("createTime", customer.get("CREATE_TIME") == null ? DateUtils.date() : DateUtils.formatDate((Date)((Date)customer.get("CREATE_TIME")), (String)"yyyy-MM-dd"));
            BaseJsonVo result = this.messageService.sendWechatMessage(1, "\u9884\u7ea6\u63d0\u9192\u6a21\u677f", (String)customer.get("CHANNEL_CUSTOMER_ID"), map);
            this.logger.info("\u63a8\u9001\u9884\u7ea6\u63d0\u9192\uff1a[" + customer.get("CHANNEL_CUSTOMER_ID") + "]\u7ed3\u679c \uff1a " + (result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25[" + result.getError_msg() + "]"));
        }));
        pool.shutdown();
        this.reserveMapper.updateSendStatus(activeNo);
        return BaseJsonVo.success((Object)"\u53d1\u9001\u5b8c\u6210");
    }
}

