/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveWhiteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ActiveSaleBase
extends ActiveBaseService {
    @Autowired
    private ActiveWhiteInterface activeWhiteInterface;
    @Autowired
    protected MallOrderMainInterface orderMainInterface;
    @Autowired
    protected ActiveCashticketInterface activeCashticketService;
    @Autowired
    protected MallOrderInterface mallOrderInterface;
    @Autowired
    protected MessageQueueService messageQueueService;

    public BaseJsonVo confirmOrder(MallOrderMainEntity orderMain) {
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo canJoin(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            this.logger.info("\u65e0\u6548\u7684\u6d3b\u52a8, bindCode={}", (Object)bindCode);
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (baseJsonVo.isSuccess()) {
            baseJsonVo.setValue((Object)activeEntity);
        }
        return baseJsonVo;
    }

    public boolean checkIsWhite(String customerId) {
        Boolean isWhile = this.activeWhiteInterface.existsWhiteList(customerId, 1);
        return isWhile != null && isWhile != false;
    }

    public void sendCoupon(String customerId, String bindCode, Integer platFormId) {
        this.activeCashticketService.sendTicket4Base(customerId, bindCode, "", platFormId, true);
    }

    public void collectionActiveOrderData(MallOrderMainEntity orderMain) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(orderMain.getActiveNo());
        if (activeEntity != null) {
            HashMap<String, Object> messageBody = new HashMap<String, Object>();
            messageBody.put("userId", orderMain.getCustomerId());
            messageBody.put("dataFrom", activeEntity.getActiveName());
            messageBody.put("bindCode", orderMain.getBindCode());
            messageBody.put("activeNo", orderMain.getActiveNo());
            messageBody.put("versionName", "\u6d3b\u52a8\u8ba2\u5355\u7edf\u8ba1");
            messageBody.put("createTime", DateUtils.now());
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, MessageParam.messageParam((String)orderMain.getOrderMainNo(), messageBody));
        }
    }

    public void updateOrderComplete(MallOrderMainEntity mallOrderEntity, String orderStatusName) {
        try {
            boolean orderStatus = this.orderMainInterface.updateOrderMainStatus(mallOrderEntity.getOrderMainNo(), orderStatusName, mallOrderEntity.getCustomerId(), OrderStatusEnum.PAYCONFIRM.getValue());
            List<MallOrderEntity> orderEntities = this.mallOrderInterface.getOrderList(mallOrderEntity.getOrderMainNo());
            if (orderEntities != null) {
                for (MallOrderEntity o : orderEntities) {
                    if (this.mallOrderInterface.updateOrderStatus(o.getOrderNo(), orderStatusName, mallOrderEntity.getCustomerId(), OrderStatusEnum.PAYCONFIRM.getValue())) continue;
                    this.logger.error("\u66f4\u65b0\u5b50\u8ba2\u5355\u5931\u8d25,\u8ba2\u5355\u53f7={}", (Object)mallOrderEntity.getOrderMainNo());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BaseJsonVo updateActiveJoinStatus(MallOrderMainEntity orderMain) {
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo refund(MallOrderMainEntity orderMain) {
        return BaseJsonVo.success((Object)"");
    }
}

