/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.accountBalance;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.SpecialCardDTO;
import cc.lechun.balance.dto.StorageCardDTO;
import cc.lechun.balance.dto.UserBalanceDTO;
import cc.lechun.balance.dto.UserBalanceDetailDTO;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import com.github.pagehelper.util.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AccountBalanceService
extends BaseService
implements AccountBalanceInterface {
    @Value(value="${lechun.oldwealth.domain:}")
    private String balanceHost;
    @Value(value="${lechun.oldwealth.domain1:}")
    private String balanceHost1;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveQrcodeInterface qrcodeService;
    @Autowired
    private BalanceAccountInvoke balanceApi;
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private RedisCacheUtil redisService;
    @Autowired
    private PrepayCardPlanDetailInterface prepayCardPlanDetailInterface;
    @Autowired
    private PrepayCardInterface cardInterface;

    @Override
    public BigDecimal getGiftBalanceById(String customerId) {
        BaseJsonVo<UserBalanceDTO> userBalance = this.balanceApi.getUserBalance(customerId);
        this.logger.info(JsonUtils.toJson(userBalance, (boolean)true));
        this.customerInterface.removeCache(customerId);
        if (userBalance != null && userBalance.isSuccess()) {
            return ((UserBalanceDTO)userBalance.getValue()).getUsableTotalBalance();
        }
        this.logger.error("\u83b7\u53d6\u7528\u6237\u4f59\u989d\u5931\u8d25\uff0c\u8fd4\u56de0[" + customerId + "]:" + userBalance.getMessage());
        return new BigDecimal(0);
    }

    @Override
    public BigDecimal getGiftBalanceBySign(String sign) {
        CustomerEntity customer = this.customerInterface.getCustomerBySign(sign);
        return this.getGiftBalanceById(customer.getCustomerId());
    }

    @Override
    public BaseJsonVo useGiftBalance(String customerId, String orderMainNo, BigDecimal amount, Integer subPayTypeId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        try {
            BaseJsonVo<BalanceChangeDTO> balanceChange;
            if (subPayTypeId.intValue() != PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue() && this.getGiftBalanceById(customerId).doubleValue() < amount.doubleValue()) {
                result.setError("\u4f59\u989d\u5c0f\u4e8e\u652f\u4ed8\u91d1\u989d\uff0c\u65e0\u6cd5\u652f\u4ed8");
                return result;
            }
            this.logger.info("\u8981\u6263\u51cf\u4f59\u989d\u4e86" + orderMainNo);
            if (subPayTypeId.intValue() == PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue()) {
                PrepayCardEntity cardEntity;
                String cardNo = "";
                PrepayCardDetailEntity detailEntity = new PrepayCardDetailEntity();
                detailEntity.setOrderMainNo(orderMainNo);
                detailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailInterface.getSingle(detailEntity);
                if (detailEntity != null && (cardEntity = (PrepayCardEntity)this.cardInterface.selectByPrimaryKey((Serializable)((Object)detailEntity.getCardId()))) != null) {
                    cardNo = cardEntity.getRelateCardNo();
                }
                if (StringUtil.isEmpty((String)cardNo)) {
                    return BaseJsonVo.error((String)"\u4f59\u989d\u5361\u53f7\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a");
                }
                balanceChange = this.balanceApi.payOrderWithSpecialCard(customerId, orderMainNo, cardNo, amount);
            } else {
                balanceChange = this.balanceApi.payOrder(customerId, orderMainNo, amount);
            }
            this.logger.info("\u6263\u51cf\u4f59\u989d\u5b8c\u4e86" + orderMainNo);
            this.logger.info("\u6263\u51cf\u4f59\u989d\u5b8c\u4e86" + orderMainNo + "|" + JsonUtils.toJson(balanceChange, (boolean)true));
            this.customerInterface.removeCache(customerId);
            if (!balanceChange.isSuccess()) {
                return BaseJsonVo.error((String)balanceChange.getMessage());
            }
            HashMap<String, Object> wealth = new HashMap<String, Object>();
            wealth.put("wealth", ((BalanceChangeDTO)balanceChange.getValue()).getUserBalanceDetail().getUserBalance().getUsableTotalBalance().multiply(new BigDecimal(100)).intValue());
            wealth.put("store", ((BalanceChangeDTO)balanceChange.getValue()).getStoreBalanceChange().multiply(new BigDecimal(100)).intValue());
            wealth.put("present", ((BalanceChangeDTO)balanceChange.getValue()).getFreeBalanceChange().multiply(new BigDecimal(100)).intValue());
            wealth.put("card", ((BalanceChangeDTO)balanceChange.getValue()).getGiftBalanceChange().multiply(new BigDecimal(100)).intValue());
            wealth.put("cardPlan", ((BalanceChangeDTO)balanceChange.getValue()).getSpecialCardBalanceChange().multiply(new BigDecimal(100)).intValue());
            wealth.put("thirdTradeNo", ((BalanceChangeDTO)balanceChange.getValue()).getDetailId());
            result.setValue(wealth);
            return result;
        }
        catch (Exception e) {
            return BaseJsonVo.error((String)"\u4f59\u989d\u652f\u4ed8\u5f02\u5e38");
        }
    }

    @Override
    public BaseJsonVo cancelGiftBalance(String customerId, String tradeNo, BigDecimal amount) {
        this.logger.info("[\u53d6\u6d88\u8ba2\u5355\u9000\u4f59\u989d][" + tradeNo + "][" + amount);
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.cancleOrder(customerId, tradeNo);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo cancleOrderRefundGift(PayInputEntity inputEntity, String opName) {
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.refundOrder(inputEntity.getCustomerId(), inputEntity.getOrderMainNo(), inputEntity.getRefundAmount(), opName);
        this.customerInterface.removeCache(inputEntity.getCustomerId());
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo recharge(String customerId, int amount, String changeType, String remark, boolean isSendMsg) {
        return null;
    }

    @Override
    public BaseJsonVo rechargeByEvaluate(String customerId, String orderMainNo, Integer changeWealth) throws IOException {
        return ((AccountBalanceService)SpringContextUtil.getBean(this.getClass())).activeCharge(customerId, new BigDecimal(changeWealth).divide(new BigDecimal(100)), "\u8bc4\u4ef7\u8d60\u9001", true, "\u8bc4\u4ef7\u6210\u529f\uff0c\u8d60\u9001", orderMainNo);
    }

    @Override
    public BaseJsonVo mergeAccount(String sourceId, String targetId) throws IOException {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        result.setError("\u5408\u5e76\u5931\u8d25");
        return result;
    }

    @Override
    public BaseJsonVo activeCharge(String customerId, String bindCode) {
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        sr.setError("\u65b9\u6cd5\u4e3a\u5b9e\u73b0");
        return sr;
    }

    @Override
    public BaseJsonVo activeCharge(String customerId, String bindCode, int amountOfFen) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        return ((AccountBalanceService)SpringContextUtil.getBean(this.getClass())).activeCharge(customerId, new BigDecimal(amountOfFen).divide(new BigDecimal(100)), activeEntity != null ? activeEntity.getActiveName() : "", activeEntity != null, activeEntity != null ? activeEntity.getActiveName() + "\u8d60\u9001" : "", bindCode);
    }

    @Override
    public BaseJsonVo activeCharge(String customerId, BigDecimal increaseAmount, String detailSubTypeDesc, Boolean notice, String noticeText, String remark) {
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.activeCharge(customerId, increaseAmount, detailSubTypeDesc, true, noticeText, remark);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo charge(String customerId, String orderMainNo, String productId) {
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.charge(customerId, orderMainNo, productId);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo<SpecialCardDTO> charge(String customerId, String orderMainNo, BigDecimal chargeAmount) {
        BaseJsonVo<SpecialCardDTO> balanceChange = this.balanceApi.purchaseSpecialCard(customerId, orderMainNo, chargeAmount);
        return balanceChange;
    }

    @Override
    public BaseJsonVo<List<StorageCardDTO>> findStorageCards() {
        return this.balanceApi.findStorageCards();
    }

    @Override
    public BaseJsonVo<BalanceChangeDTO> cardCharge(String customerId, String cardNo) {
        if (this.redisService.exists("CardChargeError_" + customerId) && (Integer)this.redisService.get("CardChargeError_" + customerId) > 2) {
            return BaseJsonVo.error((String)"\u9519\u8bef\u6b21\u6570\u592a\u591a\uff0c\u8bf7\u660e\u5929\u518d\u8bd5");
        }
        BaseJsonVo<BalanceChangeDTO> chargeResult = this.balanceApi.cardCharge(customerId, cardNo);
        if (chargeResult.isSuccess()) {
            this.redisService.remove("CardChargeError_" + customerId);
        } else if ("\u5361\u53f7\u4e0d\u5b58\u5728".equals(chargeResult.getError_msg())) {
            if (this.redisService.exists("CardChargeError_" + customerId)) {
                this.redisService.increment("CardChargeError_" + customerId, 1);
            } else {
                this.redisService.set("CardChargeError_" + customerId, (Object)1, Long.valueOf((DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1).getTime() - DateUtils.now().getTime()) / 1000L));
            }
        }
        return chargeResult;
    }

    @Override
    public BaseJsonVo<UserBalanceDetailDTO> getBalanceDetail(String customerId) {
        return this.balanceApi.getUserBalanceDetail(customerId);
    }

    @Override
    public BaseJsonVo<BalanceChangeDTO> cardRefund(String cardNo, String orderMainNo, BigDecimal refundAmount, String operator) {
        return this.balanceApi.refundSpecialCardOrder(cardNo, orderMainNo, refundAmount, operator);
    }
}

