/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.active.form.cash.CashticketBatchQuaryForm;
import cc.lechun.common.enums.cashticket.CashBathStatusEnum;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashPeriodTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketUserInfoEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.service.cashticket.CashticketClassService;
import cc.lechun.mall.service.cashticket.CashticketService;
import cc.lechun.mall.service.cashticket.CashticketUserInfoService;
import cc.lechun.mall.service.user.SysUserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketBatchService
extends BaseService
implements CashticketBatchInterface {
    @Autowired
    private CashticketBatchMapper cashticketBatchMapper;
    @Autowired
    private CashticketUserInfoService cashticketUserInfoService;
    @Autowired
    private CashticketService cashticketService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private CashticketClassService cashticketClassService;
    @Autowired
    private SysUserService sysUserService;

    @Override
    public CashticketBatchEntity getCashticketBatchByTicketNo(String ticketNo) {
        CashticketBatchEntity temp = new CashticketBatchEntity();
        temp.setTicketNo(ticketNo);
        return (CashticketBatchEntity)this.cashticketBatchMapper.getSingle(temp);
    }

    @Override
    public CashticketBatchEntity getCashticketBatch(@ParameterValueKeyProvider String ticketBatchId) {
        return (CashticketBatchEntity)this.cashticketBatchMapper.selectByPrimaryKey((Serializable)((Object)ticketBatchId));
    }

    @Override
    @Transactional
    public BaseJsonVo addCashticketBatch(CashticketBatchEntity cashticketBatchEntity) {
        BaseJsonVo vo = this.validateCash(cashticketBatchEntity);
        if (!vo.isSuccess()) {
            return vo;
        }
        cashticketBatchEntity.setTicketBatchId(IDGenerate.getUniqueID() + "");
        cashticketBatchEntity.setCreateTime(DateUtils.now());
        this.cashticketBatchMapper.insertSelective(cashticketBatchEntity);
        if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
            this.cashticketService.addCashTicketNos(cashticketBatchEntity.getTicketBatchId());
        }
        return BaseJsonVo.success((Object)cashticketBatchEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo updateCashticketBatch(CashticketBatchEntity cashticketBatchEntity) {
        BaseJsonVo vo = this.validateCash(cashticketBatchEntity);
        if (!vo.isSuccess()) {
            return vo;
        }
        this.cashticketBatchMapper.updateByPrimaryKeySelective(cashticketBatchEntity);
        this.removeCache(cashticketBatchEntity.getTicketBatchId());
        if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
            this.cashticketService.addCashTicketNos(cashticketBatchEntity.getTicketBatchId());
        }
        return BaseJsonVo.success((Object)cashticketBatchEntity);
    }

    @Override
    public BaseJsonVo deleteCashticketBatch(String ticketBatchId) {
        CashticketBatchEntity cashticketBatchEntity = this.getCashticketBatch(ticketBatchId);
        if (cashticketBatchEntity == null) {
            BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21");
        }
        cashticketBatchEntity.setStatus(CashBathStatusEnum.jinyong.getValue());
        this.cashticketBatchMapper.updateByPrimaryKeySelective(cashticketBatchEntity);
        this.removeCache(ticketBatchId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public boolean updateCashticketBatchAlreadyQuantity(String ticketBatchId, int already_quantity) {
        boolean flag;
        boolean bl = flag = this.cashticketBatchMapper.updateCashticketBatchAlreadyQuantity(ticketBatchId, already_quantity) > 0;
        if (flag) {
            this.removeCache(ticketBatchId);
        }
        return flag;
    }

    @Override
    public PageInfo getCashticketBatchList(PageForm pageForm, CashticketBatchQuaryForm cashticketBatchQuaryForm, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.cashticketBatchMapper.getCashticketBatchList(cashticketBatchQuaryForm, platformGroupId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(o -> {
                o.setCreateTypeName(CashCreateTypeEnum.getName(o.getCreateType().shortValue()));
                o.setDiscountModeName(CashDiscountModeEnum.getName(o.getDiscountMode().shortValue()));
                o.setTicetClassName(o.getTicetClass() == null ? "" : this.cashticketClassService.getCashticketClassName(o.getPlatformGroupId(), (int)o.getTicetClass()));
                o.setDiscountOrAmount(o.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() ? o.getAmount() + "" : o.getDiscountAmount() + "");
                o.setUserName(this.sysUserService.getMallUserNickName(o.getCreateUserid()));
            });
        }
        return pg;
    }

    private BaseJsonVo validateCash(CashticketBatchEntity cashticketBatchEntity) {
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u53c2\u6570");
        }
        if (StringUtils.isEmpty((String)cashticketBatchEntity.getTicketBatchName())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u4f18\u60e0\u52b5\u540d\u79f0");
        }
        CashticketUserInfoEntity cashticketUserInfo = this.cashticketUserInfoService.getCashticketUserInfo(cashticketBatchEntity.getCreateUserid());
        if (cashticketUserInfo == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7528\u6237\uff0c\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        if (cashticketUserInfo.getMaxValue() > 0 && cashticketBatchEntity.getAmount().intValue() > cashticketUserInfo.getMaxValue()) {
            return BaseJsonVo.paramError((String)"\u8d85\u8fc7\u6700\u5927\u521b\u5efa\u91d1\u989d");
        }
        int count = cashticketBatchEntity.getQuantity();
        if (cashticketBatchEntity.getCreateType().shortValue() == CashCreateTypeEnum.ma.getValue()) {
            count = cashticketBatchEntity.getQuantity() * cashticketBatchEntity.getTicketNoNum();
        }
        System.out.println("count\u662f" + count + "\uff0cMaxNu\u662f" + cashticketUserInfo.getMaxNum());
        if (cashticketUserInfo.getMaxNum() > 0 && count > cashticketUserInfo.getMaxNum()) {
            return BaseJsonVo.paramError((String)"\u8d85\u8fc7\u6700\u5927\u521b\u5efa\u6570\u91cf");
        }
        if (cashticketBatchEntity.getTicetClass() == null || cashticketBatchEntity.getTicetClass() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5206\u7c7b");
        }
        if (cashticketBatchEntity.getPeriodType().intValue() == CashPeriodTypeEnum.riqi.getValue()) {
            if (cashticketBatchEntity.getBeginTime() == null || cashticketBatchEntity.getEndTime() == null) {
                return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u65e5\u671f");
            }
            cashticketBatchEntity.setEndTime(DateUtils.StrToDate((String)(DateUtils.formatDate((Date)cashticketBatchEntity.getEndTime(), (String)"yyyy-MM-dd") + " 23:59:59"), (String)""));
        }
        if (cashticketBatchEntity.getCreateType().shortValue() == CashCreateTypeEnum.ma.getValue()) {
            CashticketBatchEntity temp;
            if (StringUtils.isEmpty((String)cashticketBatchEntity.getTicketNo())) {
                return BaseJsonVo.paramError((String)"\u9519\u8bef\u7684\u4f18\u60e0\u7801");
            }
            if (StringUtils.isEmpty((String)cashticketBatchEntity.getTicketBatchId()) ? (temp = this.getCashticketBatchByTicketNo(cashticketBatchEntity.getTicketNo())) != null : (temp = this.getCashticketBatchByTicketNo(cashticketBatchEntity.getTicketNo())) != null && !temp.getTicketBatchId().equals(cashticketBatchEntity.getTicketBatchId())) {
                return BaseJsonVo.paramError((String)"\u4f18\u60e0\u7801\u91cd\u590d");
            }
        }
        return BaseJsonVo.success(null);
    }

    private void removeCache(String ticketBatchId) {
        this.memcachedService.delete("getCashticketBatch", ticketBatchId);
    }

    @Override
    public List<CashticketBatchEntity> getCashticketBatchForOption() {
        CashticketBatchEntity entity = new CashticketBatchEntity();
        entity.setStatus(1);
        List cashticketBatchEntities = this.cashticketBatchMapper.getList(entity);
        cashticketBatchEntities.sort((c1, c2) -> c1.getTicketBatchName().compareTo(c2.getTicketBatchName()));
        return cashticketBatchEntities;
    }

    @Override
    public PageInfo getCashticketBatchForOption(PageForm pageForm, Integer platFormGroupId, String ticketBatchName) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.cashticketBatchMapper.getEnableCashticketList(platFormGroupId, ticketBatchName);
        PageInfo pg = page.toPageInfo();
        if (pg != null) {
            pg.setList(pg.getList().stream().sorted((c1, c2) -> c1.getTicketBatchName().compareTo(c2.getTicketBatchName())).collect(Collectors.toList()));
        }
        return pg;
    }
}

