/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerOnlineMapper;
import cc.lechun.mall.entity.customer.CustomerOnlineEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerOnlineInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerOnlineService
extends BaseService
implements CustomerOnlineInterface {
    @Autowired
    private CustomerOnlineMapper customerOnlineMapper;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public BaseJsonVo saveCustomerOnline(CustomerOnlineEntity customerOnlineEntity) {
        CustomerOnlineEntity temp = new CustomerOnlineEntity();
        temp.setOpenId(customerOnlineEntity.getOpenId());
        Boolean result = false;
        this.removeCache(customerOnlineEntity);
        result = this.customerOnlineMapper.existsByEntity(temp) >= 1 ? Boolean.valueOf(this.customerOnlineMapper.updateByPrimaryKeySelective(customerOnlineEntity) > 0) : Boolean.valueOf(this.customerOnlineMapper.insert(customerOnlineEntity) > 0);
        return result != false ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5728\u7ebf\u5ba2\u670d\u5931\u8d25");
    }

    @Override
    @ReadThroughSingleCache(namespace="CustomerOnlineService.checkIsExistOnline")
    public boolean checkIsExistOnline(@ParameterValueKeyProvider String openId) {
        boolean flag = false;
        CustomerOnlineEntity temp = new CustomerOnlineEntity();
        temp.setOpenId(openId);
        CustomerOnlineEntity single = (CustomerOnlineEntity)this.customerOnlineMapper.getSingle(temp);
        if (single == null) {
            return flag;
        }
        flag = DateUtils.getDateDiff((Date)single.getCreateTime(), (Date)DateUtils.now()) <= 0L;
        return flag;
    }

    private void removeCache(CustomerOnlineEntity customerOnlineEntity) {
        if (customerOnlineEntity != null) {
            this.memcachedService.delete("CustomerOnlineService.checkIsExistOnline", customerOnlineEntity.getOpenId());
        }
    }
}

