/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.MallDeliverEntity;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.mall.iservice.deliver.DeliverRouteInterface;
import cc.lechun.mall.iservice.trade.MallOrderExpressInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.service.trade.MallOrderService;
import cc.lechun.utils.PinYinHelper;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliverRouteService
implements DeliverRouteInterface {
    private static final Logger log = LoggerFactory.getLogger(DeliverRouteService.class);
    @Autowired
    private DeliverKuaidiInterface kuaidiInterface;
    @Autowired
    private MallOrderExpressInterface expressInterface;
    @Autowired
    private MallOrderService orderService;
    @Autowired
    private DeliverInterface deliverInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;

    @Override
    public BaseJsonVo getRouteInfo(String orderNo) {
        MallOrderExpressEntity expressEntity1;
        boolean isSubscribe = false;
        BaseJsonVo jsonVo = this.getDeliverParam(orderNo);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        DeliverParam param = (DeliverParam)jsonVo.getValue();
        MallOrderExpressEntity expressEntity = this.expressInterface.getExpressEntity(param.getDeliverCode(), param.wayBillNo);
        if (expressEntity != null) {
            boolean bl = isSubscribe = expressEntity.getIsSubscribe() == 1;
            if (expressEntity.getStatus() == 3 && !expressEntity.getData().isEmpty()) {
                isSubscribe = true;
                return BaseJsonVo.success((Object)expressEntity);
            }
        }
        if ((expressEntity1 = this.kuaidiInterface.getRouteInfo(param.deliverCode, param.wayBillNo, param.phone)) != null) {
            expressEntity = expressEntity1;
            if (expressEntity != null) {
                expressEntity.setIsSubscribe(isSubscribe ? 1 : 0);
                expressEntity.setOrderNo(orderNo);
                expressEntity.setLastTime(new Date());
                this.expressInterface.saveExpress(expressEntity);
                this.expressToConfirmGoods(expressEntity);
            }
            if (!isSubscribe) {
                this.pullRouteInfo(orderNo);
            }
        }
        return BaseJsonVo.success((Object)expressEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="DeliverRouteService.getRouteInfoForWexin", expiration=300)
    public List<OrderDeliverRecordVo> getRouteInfoForWexin(@ParameterValueKeyProvider String orderNo) {
        BaseJsonVo jsonVo = this.getRouteInfo(orderNo);
        if (!jsonVo.isSuccess()) {
            return new ArrayList<OrderDeliverRecordVo>();
        }
        MallOrderExpressEntity expressEntity = (MallOrderExpressEntity)jsonVo.getValue();
        if (expressEntity != null) {
            String data = expressEntity.getData();
            if (data == null || data.isEmpty()) {
                return new ArrayList<OrderDeliverRecordVo>();
            }
            try {
                JSONArray jsonArray = new JSONArray(data);
                ArrayList<OrderDeliverRecordVo> vos = new ArrayList<OrderDeliverRecordVo>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    OrderDeliverRecordVo vo = new OrderDeliverRecordVo();
                    vo.setContent(jsonObject.getString("context"));
                    vo.setCreateTime(DateUtils.getDateFromString((String)jsonObject.getString("time")));
                    vo.setPushTime(DateUtils.getDateFromString((String)jsonObject.getString("ftime")));
                    vos.add(vo);
                }
                return vos;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<OrderDeliverRecordVo>();
    }

    @Override
    public BaseJsonVo pullRouteInfo(String orderNo) {
        BaseJsonVo jsonVo = this.getDeliverParam(orderNo);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        DeliverParam param = (DeliverParam)jsonVo.getValue();
        MallOrderExpressEntity expressEntity = this.kuaidiInterface.pullRouteInfo(param.deliverCode, param.wayBillNo, param.phone);
        if (expressEntity != null) {
            expressEntity.setOrderNo(orderNo);
            return this.expressInterface.saveExpress(expressEntity);
        }
        return BaseJsonVo.error((String)("\u63d0\u4ea4\u8ba2\u9605\u4fe1\u606f\u5f02\u5e38,\u8ba2\u5355\u53f7\uff1a" + orderNo));
    }

    @Override
    public BaseJsonVo expressCallBack(String thirdExpressNo, String param) {
        MallOrderExpressEntity expressEntity = this.kuaidiInterface.expressCallBack(thirdExpressNo, param);
        if (expressEntity == null) {
            return BaseJsonVo.error((String)"\u4e0d\u80fd\u83b7\u53d6\u7269\u6d41\u4fe1\u606f");
        }
        MallOrderExpressEntity search = this.expressInterface.getExpressEntity(expressEntity.getDeliverNo(), expressEntity.getExpressNo());
        log.info("expressCallBack_search:" + (search == null ? 0 : 1));
        if (search == null) {
            MallOrderEntity orderEntity = new MallOrderEntity();
            MallDeliverEntity deliverEntity = new MallDeliverEntity();
            deliverEntity.setRemark(expressEntity.getDeliverNo());
            deliverEntity = this.deliverInterface.getDeliverSigle(deliverEntity);
            orderEntity.setWaybillNo(expressEntity.getExpressNo());
            orderEntity = this.orderService.getmallOrder(orderEntity);
            if (orderEntity == null) {
                return BaseJsonVo.error((String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u7269\u6d41\u5355\u53f7\uff1a" + expressEntity.getExpressNo()));
            }
            search = new MallOrderExpressEntity();
            search.setCreateTime(new Date());
            search.setOrderNo(orderEntity.getOrderNo());
            search.setExpressNo(expressEntity.getExpressNo());
            search.setDeliverNo(expressEntity.getDeliverNo());
        }
        search.setStatus(expressEntity.getStatus());
        search.setIsSubscribe(1);
        search.setSubscribeCode("200");
        search.setLastTime(new Date());
        search.setData(expressEntity.getData());
        BaseJsonVo baseJsonVo = this.expressInterface.saveExpress(search);
        this.expressToConfirmGoods(search);
        log.info("expressCallBack_\u4fdd\u5b58:" + baseJsonVo.isSuccess() + ",\u7269\u6d41\u5355\u53f7\uff1a" + search.getExpressNo());
        return baseJsonVo;
    }

    private BaseJsonVo getDeliverParam(String orderNo) {
        MallOrderEntity orderEntity = this.orderService.getmallOrder(orderNo);
        if (orderEntity == null) {
            return BaseJsonVo.error((String)("\u8ba2\u5355\u53f7:" + orderNo + "\u7684\u8ba2\u5355\u4e0d\u5b58\u5728"));
        }
        MallDeliverEntity deliverEntity = new MallDeliverEntity();
        deliverEntity.setEdbName(orderEntity.getDeliverName());
        deliverEntity = this.deliverInterface.getDeliverSigle(deliverEntity);
        if (deliverEntity == null) {
            deliverEntity = new MallDeliverEntity();
            deliverEntity.setDeliverName(orderEntity.getDeliverName());
            deliverEntity = this.deliverInterface.getDeliverSigle(deliverEntity);
            if (deliverEntity == null) {
                deliverEntity = new MallDeliverEntity();
                deliverEntity.setEdbId(orderEntity.getDeliverId());
                deliverEntity.setEdbName(orderEntity.getDeliverName());
                deliverEntity.setDeliverName(orderEntity.getDeliverName());
                deliverEntity.setRemark(PinYinHelper.getPinYin(orderEntity.getDeliverName()));
                this.deliverInterface.insertDeliver(deliverEntity);
            } else {
                deliverEntity.setEdbId(orderEntity.getDeliverId());
                deliverEntity.setEdbName(orderEntity.getDeliverName());
                deliverEntity.setRemark(PinYinHelper.getPinYin(orderEntity.getDeliverName()));
                this.deliverInterface.updateDeliver(deliverEntity);
            }
        }
        if (deliverEntity == null) {
            return BaseJsonVo.error((String)("\u7269\u6d41\u516c\u53f8ID:" + orderEntity.getDeliverId() + "\u7684\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728"));
        }
        if (deliverEntity.getRemark() == null || deliverEntity.getRemark().isEmpty()) {
            return BaseJsonVo.error((String)"\u8bf7\u8bbe\u7f6e\u7269\u6d41\u516c\u53f8\u5907\u6ce8\u5b57\u6bb5\u4e3a\u7269\u6d41\u516c\u53f8\u7684\u7f16\u53f7");
        }
        String deliverCode = deliverEntity.getRemark();
        String wayBillNo = orderEntity.getWaybillNo();
        String phone = orderEntity.getConsigneePhone();
        if (wayBillNo == null || wayBillNo.isEmpty()) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u7269\u6d41\u5355\u53f7\uff0c\u65e0\u6cd5\u8ba2\u9605\u548c\u67e5\u8be2");
        }
        DeliverParam param = new DeliverParam();
        param.setDeliverCode(deliverCode);
        param.setPhone(phone);
        param.setWayBillNo(wayBillNo);
        return BaseJsonVo.success((Object)param);
    }

    private void expressToConfirmGoods(MallOrderExpressEntity expressEntity) {
        MallOrderMainEntity orderMainEntity;
        MallOrderEntity orderEntity;
        if (expressEntity.getStatus() != null && expressEntity.getStatus() == 3 && (orderEntity = this.orderService.getmallOrder(expressEntity.getOrderNo())) != null && (orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo())) != null) {
            this.tradeInterface.confirmGoods(orderMainEntity.getCustomerId(), orderEntity.getOrderMainNo(), expressEntity.getOrderNo());
        }
    }

    public class DeliverParam {
        private String deliverCode;
        private String wayBillNo;
        private String phone;

        public String getDeliverCode() {
            return this.deliverCode;
        }

        public void setDeliverCode(String deliverCode) {
            this.deliverCode = deliverCode;
        }

        public String getWayBillNo() {
            return this.wayBillNo;
        }

        public void setWayBillNo(String wayBillNo) {
            this.wayBillNo = wayBillNo;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }
    }
}

