/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay;

import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.pay.WechatNotifyEntity;
import cc.lechun.mall.entity.pay.WechatRefundNotifyEntity;
import cc.lechun.mall.iservice.pay.PayInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.service.pay.PayStrategyInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayService
implements PayInterface {
    private static final Logger log = LoggerFactory.getLogger(PayService.class);
    private final Map<String, PayStrategyInterface> payStrategyInterfaceMap = new ConcurrentHashMap<String, PayStrategyInterface>();
    @Autowired
    private PayOrderInterface payOrderInterface;

    @Autowired
    public PayService(Map<String, PayStrategyInterface> payStrategyInterfaceMap) {
        this.payStrategyInterfaceMap.clear();
        payStrategyInterfaceMap.forEach((k, v) -> this.payStrategyInterfaceMap.put((String)k, (PayStrategyInterface)v));
    }

    @Override
    public BaseJsonVo pay(List<PayInputEntity> inputEntitis) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (inputEntitis == null || inputEntitis.size() == 0) {
            result.setError("\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
            return result;
        }
        ArrayList<PayOutputEntity> payOutputEntities = new ArrayList<PayOutputEntity>();
        for (PayInputEntity inputEntity : inputEntitis) {
            PayStrategyInterface payStrategyInterface;
            if (inputEntity.isSuccess()) continue;
            String payKey = PayTypeEnum.getName((int)inputEntity.getPayType());
            if (inputEntity.getPaySubType() != 0 && inputEntity.getPayType() != PayTypeEnum.BALANCE_PAY.getValue()) {
                payKey = payKey + "." + PaySubTypeEnum.getName((int)inputEntity.getPaySubType());
            }
            if ((payStrategyInterface = this.payStrategyInterfaceMap.get(payKey)) != null) {
                result = payStrategyInterface.pay(inputEntity);
                if (result.isSuccess()) {
                    PayOutputEntity p = (PayOutputEntity)result.getValue();
                    if (p == null) {
                        result.setError("\u652f\u4ed8\u65b9\u5f0f" + payKey + "\u652f\u4ed8\u5f02\u5e38");
                        log.error("\u652f\u4ed8\u65b9\u5f0f" + payKey + "\u652f\u4ed8\u5f02\u5e38[\u5bf9\u8c61PayOutputEntity->NULL]", inputEntitis);
                    }
                    payOutputEntities.add(p);
                } else {
                    log.error("\u652f\u4ed8\u65b9\u5f0f" + payKey + "\u652f\u4ed8\u5f02\u5e38\uff0c" + result.getError_msg(), inputEntitis);
                    result.setError("\u652f\u4ed8\u65b9\u5f0f" + payKey + "\u652f\u4ed8\u5f02\u5e38");
                }
            } else {
                result.setError("\u652f\u4ed8\u65b9\u5f0f" + payKey + "\u6ca1\u6709\u5b9e\u73b0");
            }
            if (result.isSuccess()) continue;
            break;
        }
        result.setValue(payOutputEntities);
        return result;
    }

    @Override
    public BaseJsonVo aliPayWapNotify(PayInputEntity notifyEntity) {
        String payName = PayTypeEnum.ALIPAY_PAY.getName() + "." + PaySubTypeEnum.ALIPAYSUB_WAP_PAY.getName();
        return this.payStrategyInterfaceMap.get(payName).payNotify(notifyEntity);
    }

    @Override
    public BaseJsonVo wechatPayNotify(WechatNotifyEntity notifyEntity) {
        String payName = PayTypeEnum.WECHAT_PAY.getName() + "." + PaySubTypeEnum.WECHAT_SUB_PAY.getName();
        return this.payStrategyInterfaceMap.get(payName).payNotify(notifyEntity);
    }

    @Override
    public BaseJsonVo cmbPayNotify(Map<String, Object> map) {
        String payName = PayTypeEnum.BANK_PAY.getName() + "." + PaySubTypeEnum.BANK_SUB_CMB_PAY.getName();
        return this.payStrategyInterfaceMap.get(payName).payNotify(map);
    }

    @Override
    public BaseJsonVo paySearch(PayInputEntity payInputEntity) {
        String payName = PayTypeEnum.getName((int)payInputEntity.getPayType()) + "." + PaySubTypeEnum.getName((int)payInputEntity.getPaySubType());
        return this.payStrategyInterfaceMap.get(payName).paySearch(payInputEntity);
    }

    @Override
    public BaseJsonVo payClose(PayInputEntity inputEntity) {
        String payName = PayTypeEnum.getName((int)inputEntity.getPayType()) + "." + PaySubTypeEnum.getName((int)inputEntity.getPaySubType());
        return this.payStrategyInterfaceMap.get(payName).payClose(inputEntity);
    }

    @Override
    public BaseJsonVo payRefund(PayInputEntity inputEntity) {
        String payName = PayTypeEnum.getName((int)inputEntity.getPayType());
        if (inputEntity.getPaySubType() != 0 && inputEntity.getPayType() != PayTypeEnum.BALANCE_PAY.getValue()) {
            payName = payName + "." + PaySubTypeEnum.getName((int)inputEntity.getPaySubType());
        }
        return this.payStrategyInterfaceMap.get(payName).payRefund(inputEntity);
    }

    @Override
    public BaseJsonVo wechatRefundNotify(WechatRefundNotifyEntity notifyEntity) {
        String payName = PayTypeEnum.WECHAT_PAY.getName() + "." + PaySubTypeEnum.WECHAT_SUB_PAY.getName();
        return this.payStrategyInterfaceMap.get(payName).refundNotify(notifyEntity);
    }
}

