/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.FreeRuleTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallFreeMapper;
import cc.lechun.mall.dao.sales.MallFreeProductMapper;
import cc.lechun.mall.dao.sales.MallFreeRuleMapper;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeEntityVo;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.sales.MallFreeRuleEntity;
import cc.lechun.mall.entity.sales.MallFreeRuleEntityVo;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.service.deliver.MallCityService;
import cc.lechun.mall.service.sales.MallGroupService;
import cc.lechun.mall.service.sales.MallPromotionService;
import cc.lechun.mall.service.vip.MallVipService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFreeService
extends BaseService
implements MallFreeInterface {
    private static final Logger log = LoggerFactory.getLogger(MallFreeService.class);
    @Autowired
    MallFreeMapper freeMapper;
    @Autowired
    MallFreeProductMapper freeProductMapper;
    @Autowired
    MallFreeRuleMapper freeRuleMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    private MallPromotionService mallPromotionService;
    @Autowired
    private MallGroupService mallGroupService;
    @Autowired
    MallPromotionBuyInterface promotionBuyInterface;
    @Autowired
    private MallCityService mallCityService;
    @Autowired
    private MallVipService mallVipService;

    @Override
    public BaseJsonVo buildFreeVOFromCart(MallMainOrderVo mallMainOrderVo) {
        List<MallOrderVo> orderVoList = mallMainOrderVo.getMallOrderVos();
        boolean coldProductBoolean = false;
        boolean nomalProductBoolean = false;
        if (orderVoList != null && orderVoList.size() > 0) {
            ArrayList freeProductList = new ArrayList();
            ArrayList<MallShoppingcartVO> mallShoppingcartVOList = new ArrayList<MallShoppingcartVO>();
            int i = 0;
            for (MallOrderVo o : orderVoList) {
                if (o.getDeliverType() != 1) {
                    if (i == 0) {
                        mallShoppingcartVOList.add(o);
                    }
                } else {
                    if (o.getTransportType() == 1) {
                        coldProductBoolean = true;
                    }
                    if (o.getTransportType() == 2) {
                        nomalProductBoolean = true;
                    }
                    mallShoppingcartVOList.add(o);
                }
                ++i;
            }
            freeProductList.addAll((List)this.newBuildFree4Cart(mallShoppingcartVOList).getValue());
            if (nomalProductBoolean) {
                orderVoList.stream().forEach(orderVo -> {
                    if (orderVo.getTransportType() == 2) {
                        orderVo.setFrees(freeProductList);
                    }
                    if (orderVo.getTransportType() == 1) {
                        orderVo.setFrees(null);
                    }
                });
            } else if (coldProductBoolean) {
                orderVoList.stream().forEach(orderVo -> {
                    if (orderVo.getTransportType() == 1) {
                        orderVo.setFrees(freeProductList);
                    }
                    if (orderVo.getTransportType() == 2) {
                        orderVo.setFrees(null);
                    }
                });
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo buildFreeVOFromCart(MallShoppingcartVO coldChainCart, MallShoppingcartVO nomalCart, MallShoppingcartVO quickShoppingCart) {
        ArrayList<MallShoppingcartVO> cartProductList = new ArrayList<MallShoppingcartVO>();
        cartProductList.add(coldChainCart);
        cartProductList.add(nomalCart);
        cartProductList.add(quickShoppingCart);
        if (nomalCart != null) {
            if (nomalCart.getProducts() != null && nomalCart.getProducts().size() >= 1 || nomalCart.getGroups() != null && nomalCart.getGroups().size() >= 1 || nomalCart.getPromotions() != null && nomalCart.getPromotions().size() >= 1) {
                List<MallFreeVO> productFrees = new ArrayList<MallFreeVO>();
                if (cartProductList != null && cartProductList.size() > 0) {
                    productFrees = (List)this.newBuildFree4Cart(cartProductList).getValue();
                }
                nomalCart.setFrees(productFrees);
            } else {
                nomalCart.setFrees(new ArrayList<MallFreeVO>());
                if (coldChainCart != null) {
                    coldChainCart.setFrees(new ArrayList<MallFreeVO>());
                    if (coldChainCart.getProducts() != null && coldChainCart.getProducts().size() >= 1 || coldChainCart.getGroups() != null && coldChainCart.getGroups().size() >= 1 || coldChainCart.getPromotions() != null && coldChainCart.getPromotions().size() >= 1) {
                        List productFreesList = (List)this.newBuildFree4Cart(cartProductList).getValue();
                        coldChainCart.setFrees(productFreesList);
                    } else {
                        coldChainCart.setFrees(new ArrayList<MallFreeVO>());
                    }
                }
            }
        }
        ArrayList<MallFreeVO> c_ls = new ArrayList<MallFreeVO>();
        quickShoppingCart.setFrees(c_ls);
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo newBuildFree4Cart(List<MallShoppingcartVO> cartProductList) {
        BigDecimal[] factPriceSum = new BigDecimal[]{new BigDecimal("0")};
        ArrayList<MallProductVO> productList = new ArrayList<MallProductVO>();
        ArrayList<MallGroupVO> groupList = new ArrayList<MallGroupVO>();
        ArrayList<MallPromotionVO> promotionList = new ArrayList<MallPromotionVO>();
        for (MallShoppingcartVO mallShoppingcartVO : cartProductList) {
            factPriceSum[0] = PriceUtils.add((BigDecimal)mallShoppingcartVO.getFactPrice(), (BigDecimal)factPriceSum[0]);
            productList.addAll(mallShoppingcartVO.getProducts());
            groupList.addAll(mallShoppingcartVO.getGroups());
            promotionList.addAll(mallShoppingcartVO.getPromotions());
        }
        ArrayList rs = new ArrayList();
        List<MallFreeEntity> frees = this.freeMapper.getEnnableFrees(cartProductList.get(0).getPlatFormGroupId());
        if (frees != null && frees.size() > 0) {
            frees.forEach(free -> {
                int size = 0;
                boolean hasFree = true;
                if (free.getFreePrice() == 0L) {
                    List<MallFreeProductEntity> products;
                    MallFreeVO vo2;
                    List<MallFreeRuleEntity> rules = this.getMallFreeRule(free.getFreeId());
                    if (rules != null || rules.size() > 0) {
                        for (MallFreeRuleEntity mallFreeRuleEntity : rules) {
                            if (mallFreeRuleEntity.getFreeRuleType() == 1) {
                                if (factPriceSum[0].doubleValue() < Double.parseDouble(mallFreeRuleEntity.getFreeRuleData())) {
                                    hasFree = false;
                                    break;
                                }
                                size = 1;
                                continue;
                            }
                            if (mallFreeRuleEntity.getFreeRuleType() == 2) {
                                List size_ls;
                                if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) {
                                    if (productList == null || productList.size() == 0) {
                                        hasFree = false;
                                        break;
                                    }
                                    size_ls = productList.stream().filter(mallProductVO -> mallProductVO.getProId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                    if (size_ls != null && size_ls.size() > 0) {
                                        size = size == 0 ? ((MallProductVO)size_ls.get(0)).getCount() : (((MallProductVO)size_ls.get(0)).getCount() <= size ? ((MallProductVO)size_ls.get(0)).getCount() : size);
                                        continue;
                                    }
                                    hasFree = false;
                                    break;
                                }
                                if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) {
                                    if (groupList == null || groupList.size() == 0) {
                                        hasFree = false;
                                        break;
                                    }
                                    size_ls = groupList.stream().filter(mallGroupVO -> mallGroupVO.getGroupId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                    if (size_ls != null && size_ls.size() > 0) {
                                        size = size == 0 ? ((MallGroupVO)size_ls.get(0)).getCount() : (((MallGroupVO)size_ls.get(0)).getCount() <= size ? ((MallGroupVO)size_ls.get(0)).getCount() : size);
                                        continue;
                                    }
                                    hasFree = false;
                                    break;
                                }
                                if (!String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) continue;
                                if (promotionList == null || promotionList.size() == 0) {
                                    hasFree = false;
                                    break;
                                }
                                size_ls = promotionList.stream().filter(vo -> vo.getPromotionId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                if (size_ls != null && size_ls.size() > 0) {
                                    size = size == 0 ? ((MallPromotionVO)size_ls.get(0)).getCount() : (((MallPromotionVO)size_ls.get(0)).getCount() <= size ? ((MallPromotionVO)size_ls.get(0)).getCount() : size);
                                    continue;
                                }
                                hasFree = false;
                                break;
                            }
                            if (mallFreeRuleEntity.getFreeRuleType() == 3 || mallFreeRuleEntity.getFreeRuleType() != 4) continue;
                            log.info("\u6ee1\u8d60\u5f00\u59cb\u6267\u884c....\u901a\u8fc7\u6307\u5b9a\u4f1a\u5458\u6743\u76ca\u6ee1\u8d60...");
                            if (!this.mallVipService.getCustomerRight(((MallShoppingcartVO)cartProductList.get(0)).getCustomerId(), mallFreeRuleEntity.getFreeRuleData()).isSuccess()) {
                                hasFree = false;
                                break;
                            }
                            size = 1;
                        }
                    }
                    if (hasFree && (vo2 = this.buildFreeVO((MallFreeEntity)free, rules, products = this.getMallFreeProduct(free.getFreeId()), size)) != null) {
                        rs.add(vo2);
                    }
                }
            });
        }
        return BaseJsonVo.success(rs);
    }

    private BaseJsonVo buildFree4Cart(MallShoppingcartVO cart) {
        ArrayList rs = new ArrayList();
        List<MallFreeEntity> frees = this.freeMapper.getEnnableFrees(cart.getPlatFormGroupId());
        if (frees != null && frees.size() > 0) {
            frees.forEach(free -> {
                int size = 0;
                boolean hasFree = true;
                if (free.getFreePrice() == 0L) {
                    List<MallFreeProductEntity> products;
                    MallFreeVO vo2;
                    List<MallFreeRuleEntity> rules = this.getMallFreeRule(free.getFreeId());
                    if (rules != null || rules.size() > 0) {
                        for (MallFreeRuleEntity mallFreeRuleEntity : rules) {
                            if (mallFreeRuleEntity.getFreeRuleType() == 1) {
                                if (cart.getFactPrice().doubleValue() < Double.parseDouble(mallFreeRuleEntity.getFreeRuleData())) {
                                    hasFree = false;
                                    break;
                                }
                                size = 1;
                                continue;
                            }
                            if (mallFreeRuleEntity.getFreeRuleType() == 2) {
                                List size_ls;
                                if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) {
                                    if (cart.getProducts() == null || cart.getProducts().size() == 0) {
                                        hasFree = false;
                                        break;
                                    }
                                    size_ls = cart.getProducts().stream().filter(mallProductVO -> mallProductVO.getProId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                    if (size_ls != null && size_ls.size() > 0) {
                                        size = size == 0 ? ((MallProductVO)size_ls.get(0)).getCount() : (((MallProductVO)size_ls.get(0)).getCount() <= size ? ((MallProductVO)size_ls.get(0)).getCount() : size);
                                        continue;
                                    }
                                    hasFree = false;
                                    break;
                                }
                                if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) {
                                    if (cart.getGroups() == null || cart.getGroups().size() == 0) {
                                        hasFree = false;
                                        break;
                                    }
                                    size_ls = cart.getGroups().stream().filter(mallGroupVO -> mallGroupVO.getGroupId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                    if (size_ls != null && size_ls.size() > 0) {
                                        size = size == 0 ? ((MallGroupVO)size_ls.get(0)).getCount() : (((MallGroupVO)size_ls.get(0)).getCount() <= size ? ((MallGroupVO)size_ls.get(0)).getCount() : size);
                                        continue;
                                    }
                                    hasFree = false;
                                    break;
                                }
                                if (!String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) continue;
                                if (cart.getPromotions() == null || cart.getPromotions().size() == 0) {
                                    hasFree = false;
                                    break;
                                }
                                size_ls = cart.getPromotions().stream().filter(vo -> vo.getPromotionId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                if (size_ls != null && size_ls.size() > 0) {
                                    size = size == 0 ? ((MallPromotionVO)size_ls.get(0)).getCount() : (((MallPromotionVO)size_ls.get(0)).getCount() <= size ? ((MallPromotionVO)size_ls.get(0)).getCount() : size);
                                    continue;
                                }
                                hasFree = false;
                                break;
                            }
                            if (mallFreeRuleEntity.getFreeRuleType() == 3 || mallFreeRuleEntity.getFreeRuleType() != 4) continue;
                            log.info("\u6ee1\u8d60\u5f00\u59cb\u6267\u884c....\u901a\u8fc7\u6307\u5b9a\u4f1a\u5458\u6743\u76ca\u6ee1\u8d60...");
                            if (!this.mallVipService.getCustomerRight(cart.getCustomerId(), mallFreeRuleEntity.getFreeRuleData()).isSuccess()) {
                                hasFree = false;
                                break;
                            }
                            size = 1;
                        }
                    }
                    if (hasFree && (vo2 = this.buildFreeVO((MallFreeEntity)free, rules, products = this.getMallFreeProduct(free.getFreeId()), size)) != null) {
                        rs.add(vo2);
                    }
                }
            });
        }
        return BaseJsonVo.success(rs);
    }

    private List<MallFreeRuleEntity> getMallFreeRule(String freeId) {
        MallFreeRuleEntity searchParam = new MallFreeRuleEntity();
        searchParam.setFreeId(freeId);
        return this.freeRuleMapper.getList(searchParam);
    }

    private List<MallFreeProductEntity> getMallFreeProduct(String freeId) {
        MallFreeProductEntity searchParam0 = new MallFreeProductEntity();
        searchParam0.setFreeId(freeId);
        return this.freeProductMapper.getList(searchParam0);
    }

    private MallFreeVO buildFreeVO(MallFreeEntity free, List<MallFreeRuleEntity> rules, List<MallFreeProductEntity> freeProducts, int size) {
        if (size == 0) {
            return null;
        }
        if (freeProducts == null || freeProducts.size() == 0) {
            return null;
        }
        MallFreeVO freeVO = new MallFreeVO();
        freeVO.setFreeId(free.getFreeId());
        freeVO.setFreeName(free.getFreeName());
        freeVO.setFreePrice(free.getFreePrice());
        freeVO.setStatus(free.getStatus());
        freeVO.setBeginTime(free.getBeginTime());
        freeVO.setEndTime(free.getEndTime());
        freeVO.setCreateTime(free.getCreateTime());
        freeVO.setPlatformGroupId(free.getPlatformGroupId());
        freeVO.setRuleOperator(free.getRuleOperator());
        ArrayList<MallProductVO> productVOList = new ArrayList<MallProductVO>();
        freeProducts.forEach(freeProduct -> {
            BaseJsonVo sr = this.productService.buildProductVO(freeProduct.getProductId(), freeProduct.getProductCount() * size, null, null, null, freeProduct.getFreeId(), false, true, null, null);
            if (sr.isSuccess() && ((MallProductVO)sr.getValue()).getValid().booleanValue()) {
                MallProductVO productVO = (MallProductVO)sr.getValue();
                productVO.setFactPrice(new BigDecimal(free.getFreePrice()));
                productVOList.add(productVO);
            }
        });
        if (productVOList.size() == 0) {
            return null;
        }
        freeVO.setProductList(productVOList);
        freeVO.setRuleType(0);
        if (rules != null && rules.size() > 0) {
            rules.forEach(mallFreeRuleEntity -> {
                if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
                    freeVO.setRuleType(mallFreeRuleEntity.getFreeRuleType());
                    freeVO.setSalesType(Integer.parseInt(mallFreeRuleEntity.getFreeRuleData()));
                    freeVO.setRuleData(mallFreeRuleEntity.getFreeRuleDataExtend());
                }
            });
        }
        return freeVO;
    }

    @Override
    public PageInfo<MallFreeEntityVo> getFreeList(int pageNum, int pageSize, String freeName, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.freeMapper.getFreeList(freeName, platformGroupId);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public PageInfo<MallFreeProductEntity> getFreeProductList(int pageNum, int pageSize, String freeId) {
        MallFreeProductEntity mallFreeProductEntity = new MallFreeProductEntity();
        mallFreeProductEntity.setFreeId(freeId);
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.freeProductMapper.getList(mallFreeProductEntity);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public PageInfo<MallFreeRuleEntityVo> getFreeRuletList(int pageNum, int pageSize, String freeId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.freeRuleMapper.getFreeRuletList(freeId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null) {
            pg.getList().forEach(mallFreeRuleEntityVo -> {
                mallFreeRuleEntityVo.setFreeRuleTypeName(FreeRuleTypeEnum.getName(mallFreeRuleEntityVo.getFreeRuleType()));
                if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.amount_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(mallFreeRuleEntityVo.getFreeRuleData());
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(SalesTypeEnum.getName(Integer.parseInt(mallFreeRuleEntityVo.getFreeRuleData())));
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                    if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(mallFreeRuleEntityVo.getFreeRuleData())) {
                        MallProductEntity mallproduct = this.productService.getProduct(mallFreeRuleEntityVo.getFreeRuleDataExtend());
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(mallproduct == null ? "" : mallproduct.getProName());
                    } else if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(mallFreeRuleEntityVo.getFreeRuleData())) {
                        MallProductGroupEntity MallProductGroupEntity2 = this.mallGroupService.getGroup(mallFreeRuleEntityVo.getFreeRuleDataExtend());
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(MallProductGroupEntity2 == null ? "" : MallProductGroupEntity2.getGroupName());
                    } else if (String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()).equals(mallFreeRuleEntityVo.getFreeRuleData())) {
                        MallPromotionEntity mallPromotionEntity = this.mallPromotionService.getPromotion(mallFreeRuleEntityVo.getFreeRuleDataExtend());
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(mallPromotionEntity == null ? "" : mallPromotionEntity.getPromotionName());
                    }
                } else if (mallFreeRuleEntityVo.getFreeRuleType() == 3) {
                    mallFreeRuleEntityVo.setFreeRuleDataName("");
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                    if (!StringUtils.isEmpty((String)mallFreeRuleEntityVo.getFreeRuleDataExtend())) {
                        String cityNames = "";
                        for (String s : mallFreeRuleEntityVo.getFreeRuleDataExtend().split(",")) {
                            MallCityEntity city = this.mallCityService.getCity(Integer.parseInt(s));
                            cityNames = cityNames + (city == null ? "" : city.getCityName()) + ",";
                        }
                        mallFreeRuleEntityVo.setFreeRuleDataExtendName(cityNames);
                    }
                } else if (mallFreeRuleEntityVo.getFreeRuleType().intValue() == FreeRuleTypeEnum.vip_type.getValue()) {
                    mallFreeRuleEntityVo.setFreeRuleDataName(this.mallVipService.getRight(mallFreeRuleEntityVo.getFreeRuleData()).getRightName());
                    mallFreeRuleEntityVo.setFreeRuleDataExtendName("");
                }
            });
        }
        return pg;
    }

    @Override
    public BaseJsonVo saveOrUpdateFree(MallFreeEntity mallFreeEntity) {
        if (StringUtils.isEmpty((String)mallFreeEntity.getFreeName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallFreeEntity.getBeginTime() == null || mallFreeEntity.getEndTime() == null) {
            return BaseJsonVo.paramError((String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallFreeEntity.getFreeId())) {
            mallFreeEntity.setFreeId(IDGenerate.getUniqueID() + "");
            mallFreeEntity.setCreateTime(DateUtils.now());
            this.freeMapper.insertSelective(mallFreeEntity);
        } else {
            this.freeMapper.updateByPrimaryKeySelective(mallFreeEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveOrUpdateFreeProduct(MallFreeProductEntity mallFreeProductEntity) {
        if (StringUtils.isEmpty((String)mallFreeProductEntity.getProductId())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u5546\u54c1");
        }
        if (mallFreeProductEntity.getProductCount() == null) {
            return BaseJsonVo.paramError((String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MallProductEntity productEntity = this.productService.getProduct(mallFreeProductEntity.getProductId());
        if (productEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5546\u54c1");
        }
        MallFreeProductEntity temp = new MallFreeProductEntity();
        temp.setProductId(mallFreeProductEntity.getProductId());
        temp.setFreeId(mallFreeProductEntity.getFreeId());
        if (this.freeProductMapper.existsByEntity(temp) >= 1) {
            return BaseJsonVo.paramError((String)"\u8d60\u54c1\u91cd\u590d\u914d\u7f6e");
        }
        mallFreeProductEntity.setProductName(productEntity.getProName());
        if (StringUtils.isEmpty((String)mallFreeProductEntity.getFreeProductId())) {
            mallFreeProductEntity.setFreeProductId(IDGenerate.getUniqueID() + "");
            this.freeProductMapper.insertSelective(mallFreeProductEntity);
        } else {
            this.freeProductMapper.updateByPrimaryKeySelective(mallFreeProductEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteFreeProduct(String freeProductId) {
        this.freeProductMapper.deleteByPrimaryKey((Serializable)((Object)freeProductId));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveOrUpdateFreeRule(MallFreeRuleEntity mallFreeRuleEntity) {
        MallFreeRuleEntity temp = new MallFreeRuleEntity();
        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
            temp.setFreeRuleDataExtend(mallFreeRuleEntity.getFreeRuleDataExtend());
        } else if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.amount_type.getValue() || mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.vip_type.getValue()) {
            temp.setFreeRuleData(mallFreeRuleEntity.getFreeRuleData());
        }
        temp.setFreeId(mallFreeRuleEntity.getFreeId());
        temp.setFreeRuleType(mallFreeRuleEntity.getFreeRuleType());
        if (this.freeRuleMapper.existsByEntity(temp) >= 1) {
            return BaseJsonVo.paramError((String)"\u8d60\u54c1\u89c4\u5219\u91cd\u590d\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((String)mallFreeRuleEntity.getFreeRuleId())) {
            mallFreeRuleEntity.setFreeRuleId(IDGenerate.getUniqueID() + "");
            this.freeRuleMapper.insertSelective(mallFreeRuleEntity);
        } else {
            this.freeRuleMapper.updateByPrimaryKeySelective(mallFreeRuleEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo deleteFreeRule(String freeRuleId) {
        this.freeRuleMapper.deleteByPrimaryKey((Serializable)((Object)freeRuleId));
        return BaseJsonVo.success((Object)"");
    }
}

