/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallProductLineMapper;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.dao.sales.MallProductSalesMapper;
import cc.lechun.mall.dao.sales.MallSaleRecommendMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductLineEntity;
import cc.lechun.mall.entity.sales.MallProductSalesEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallSaleRecommendEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.service.sales.MallProductSalesService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallProductService
extends BaseService
implements MallProductInterface {
    @Value(value="${lechun.oldapi.domain:}")
    private String oldApiHost;
    @Autowired
    private MallProductMapper productMapper;
    @Autowired
    private MallProductLineMapper productLineMapper;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    MallSaleRecommendMapper saleRecommendMapper;
    @Autowired
    MallPriceCalcInterface priceCalcInterface;
    @Autowired
    DeliverInterface deliverService;
    @Autowired
    private CustomerAddressInterface addressService;
    @Autowired
    private MallProductSalesMapper mallProductSalesMapper;
    @Autowired
    private MallProductSalesService mallProductSalesService;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public MallProductEntity getProduct(String productId) {
        if (StringUtils.isNotEmpty((String)productId)) {
            return this.productInterface.getProductById(productId);
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallProductService.getProduct", expiration=60)
    public MallProductEntity getProductById(@ParameterValueKeyProvider String productId) {
        if (StringUtils.isNotEmpty((String)productId)) {
            return (MallProductEntity)this.productMapper.selectByPrimaryKey((Serializable)((Object)productId));
        }
        return null;
    }

    @Override
    public List<MallProductEntity> getAllProductList(Integer platformGroupId) {
        MallProductEntity searchParam = new MallProductEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setProState(1);
        return this.productMapper.getList(searchParam);
    }

    @Override
    public List<MallProductEntity> getOnProductList(Integer platformGroupId) {
        return this.productMapper.getOnProductList(platformGroupId);
    }

    @Override
    public List<MallProductEntity> getOnAndShowProductList(Integer platformGroupId) {
        MallProductEntity searchParam = new MallProductEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setProState(1);
        searchParam.setShowState(1);
        return this.productMapper.getList(searchParam);
    }

    @Override
    public List<MallProductEntity> getOnAndShowProductList(Integer platformGroupId, boolean containPic) {
        List<MallProductEntity> list = this.getOnAndShowProductList(platformGroupId);
        if (containPic) {
            for (MallProductEntity pro : list) {
                List<String> pics = this.picService.getProductPicUrl(pro.getProId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
                if (pics == null || pics.size() <= 0) continue;
                pro.setListTemplateFile(pics.get(0));
            }
        }
        return list;
    }

    @Override
    public PageInfo getProductList(int pageNum, int pageSize, MallProductEntity mallProductEntity) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        String proName = mallProductEntity.getProName();
        Integer proState = mallProductEntity.getProState();
        String proType = mallProductEntity.getProType();
        Integer platformGroupId = mallProductEntity.getPlatformGroupId();
        List<MallProductEntity> pros = this.productMapper.getCmsList(proName, proState, proType, platformGroupId, true);
        for (MallProductEntity pro : pros) {
            List<String> pics = this.picService.getProductPicUrl(pro.getProId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
            if (pics == null || pics.size() <= 0) continue;
            pro.setListTemplateFile(pics.get(0));
        }
        PageInfo pg = page.toPageInfo();
        pg.setList(pros);
        return pg;
    }

    @Override
    public BaseJsonVo findProductByToken(String token, Integer limitCount) {
        BaseJsonVo serviceResult = BaseJsonVo.success((Object)"");
        List<MallProductEntity> list = this.productMapper.findProductByToken(token, limitCount);
        if (list != null && list.size() > 0) {
            serviceResult.setValue(list);
        } else {
            serviceResult.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return serviceResult;
    }

    @Override
    public BaseJsonVo buildProductVOFromProIDs(List<String> proIDs) {
        return null;
    }

    @Override
    public BaseJsonVo buildProductVO(String productId, Integer quantity, String groupId, String promotionId, String fullCutId, String freeId, Boolean isRegular, Boolean checked, String speedUp, String customerId) {
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        MallProductVO vo = new MallProductVO();
        MallProductEntity entity = this.productInterface.getProduct(productId);
        if (entity == null) {
            sr.setError("\u4e0d\u5b58\u5728\u7684\u5546\u54c1ID");
            return sr;
        }
        try {
            ObjectConvert.fatherConvertToChild((Object)entity, (Object)vo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            sr.setError("\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
            return sr;
        }
        vo.setProductPic(this.picService.getProductPicUrlMap(entity.getProId(), SalesTypeEnum.SALES_PRODUCT.getValue()));
        vo.setVipPrice(PriceUtils.format((String)entity.getProPrice()));
        vo.setFactPrice(PriceUtils.format((String)entity.getProPrice()));
        vo.setCount(quantity);
        vo.setShort(false);
        vo.setSoldOut(false);
        vo.setGroupId(groupId);
        vo.setPromotionId(promotionId);
        vo.setFullCutId(fullCutId);
        vo.setFreeId(freeId);
        vo.setRegular(isRegular);
        vo.setShoppingcartCheck(checked);
        vo.setUseCoupon(1);
        vo.setSpeedUp(speedUp);
        vo.setStockCount(0);
        BaseJsonVo checkResult = this.checkProduct(vo, vo.getPromotionId(), vo.getGroupId(), vo.getCount());
        if (checkResult.isSuccess()) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            vo.setShoppingcartCheck(false);
            vo.setInvalidReason(checkResult.getError_msg());
        }
        if ("1".equals(speedUp)) {
            vo.setStockCount(this.deliverService.getProductStock(customerId, productId));
        }
        sr.setValue((Object)vo);
        return sr;
    }

    @Override
    public int getTransportType(MallShoppingcartVO shoppingcartVO) {
        if (shoppingcartVO == null) {
            return TransportTypeEnum.COLD_CHAIN.getValue();
        }
        if (shoppingcartVO.getCustomerId() == null) {
            return TransportTypeEnum.COLD_CHAIN.getValue();
        }
        int[] transportType = new int[]{2};
        if (shoppingcartVO != null && shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() > 0) {
            for (MallProductVO mallProductVO : shoppingcartVO.getProducts()) {
                if (mallProductVO.getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                    return TransportTypeEnum.COLD_CHAIN.getValue();
                }
                transportType[0] = mallProductVO.getTransportType();
            }
        }
        if (shoppingcartVO != null && shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() > 0) {
            for (MallGroupVO mallGroupVO : shoppingcartVO.getGroups()) {
                for (MallProductVO d : mallGroupVO.getProductList()) {
                    if (d.getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                        return TransportTypeEnum.COLD_CHAIN.getValue();
                    }
                    transportType[0] = d.getTransportType();
                }
            }
        }
        if (shoppingcartVO != null && shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() > 0) {
            for (MallPromotionVO mallPromotionVO : shoppingcartVO.getPromotions()) {
                if (mallPromotionVO.getProduct() != null) {
                    if (mallPromotionVO.getProduct().getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                        return TransportTypeEnum.COLD_CHAIN.getValue();
                    }
                    transportType[0] = mallPromotionVO.getProduct().getTransportType();
                }
                if (mallPromotionVO.getGroup() == null) continue;
                for (MallProductVO d : mallPromotionVO.getGroup().getProductList()) {
                    if (d.getTransportType().intValue() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                        return TransportTypeEnum.COLD_CHAIN.getValue();
                    }
                    transportType[0] = d.getTransportType();
                }
            }
        }
        return transportType[0];
    }

    @Override
    public MallShoppingcartVO getTransportType(List<MallShoppingcartVO> shoppingcartVOS, TransportTypeEnum transportTypeEnum) {
        if (shoppingcartVOS.size() == 0) {
            return null;
        }
        for (MallShoppingcartVO shoppingcartVO : shoppingcartVOS) {
            if (shoppingcartVO != null && shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() > 0) {
                for (MallProductVO mallProductVO : shoppingcartVO.getProducts()) {
                    if (mallProductVO.getTransportType().intValue() != transportTypeEnum.getValue()) continue;
                    return shoppingcartVO;
                }
            }
            if (shoppingcartVO != null && shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() > 0) {
                for (MallGroupVO mallGroupVO : shoppingcartVO.getGroups()) {
                    for (MallProductVO d : mallGroupVO.getProductList()) {
                        if (d.getTransportType().intValue() != transportTypeEnum.getValue()) continue;
                        return shoppingcartVO;
                    }
                }
            }
            if (shoppingcartVO == null || shoppingcartVO.getPromotions() == null || shoppingcartVO.getPromotions().size() <= 0) continue;
            for (MallPromotionVO mallPromotionVO : shoppingcartVO.getPromotions()) {
                if (mallPromotionVO.getProduct() != null && mallPromotionVO.getProduct().getTransportType().intValue() == transportTypeEnum.getValue()) {
                    return shoppingcartVO;
                }
                if (mallPromotionVO.getGroup() == null) continue;
                for (MallProductVO d : mallPromotionVO.getGroup().getProductList()) {
                    if (d.getTransportType().intValue() != transportTypeEnum.getValue()) continue;
                    return shoppingcartVO;
                }
            }
        }
        return null;
    }

    @Override
    public BaseJsonVo checkProduct(MallProductEntity productVO, String promotionId, String groupId, int count) {
        if (productVO == null) {
            return BaseJsonVo.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if ((promotionId == null || promotionId.isEmpty()) && (groupId == null || groupId.isEmpty()) && count > productVO.getLimitBuyCount() && productVO.getLimitBuyCount() != 0) {
            return BaseJsonVo.error((String)String.format("\u5546\u54c1%s,\u8d2d\u4e70\u6570%d\uff0c\u8d85\u8fc7\u9650\u8d2d\u6570%d", productVO.getProNameSx(), count, productVO.getLimitBuyCount()));
        }
        if (productVO.getDeleteTime() != null) {
            return BaseJsonVo.error((String)String.format("\u5546\u54c1%s,\u5df2\u5220\u9664", productVO.getProNameSx()).toString());
        }
        if (productVO.getProState() != 1) {
            return BaseJsonVo.error((String)String.format("\u5546\u54c1%s,\u5df2\u4e0b\u67b6", productVO.getProNameSx()).toString());
        }
        if (count <= 0) {
            return BaseJsonVo.error((String)String.format("\u5546\u54c1%s\u6570\u91cf\u4e0d\u6b63\u786e", productVO.getProName()));
        }
        List<DictionaryEntity> dictionaryEntities = this.dictionaryInterface.getValidDictionaryList(productVO.getPlatformGroupId(), 16);
        if (dictionaryEntities != null && dictionaryEntities.size() > 0 && dictionaryEntities.get(0).getDictionaryName().contains(productVO.getProId()) && count % Integer.parseInt(dictionaryEntities.get(0).getDictionaryKey()) != 0) {
            return BaseJsonVo.error((String)String.format("\u5546\u54c1%s,\u5fc5\u987b\u8d2d\u4e70%s\u4e2a\u53ca\u5176\u500d\u6570", productVO.getProNameSx(), dictionaryEntities.get(0).getDictionaryKey()).toString());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public int getSelfMode(MallShoppingcartVO shoppingcartVO) {
        if (shoppingcartVO == null) {
            return 1;
        }
        int selfMode = 2;
        selfMode = this.getProductSelfMode(shoppingcartVO.getProducts());
        if (selfMode == 2) {
            selfMode = this.getGroupSelfMode(shoppingcartVO.getGroups());
        }
        if (selfMode == 2) {
            selfMode = this.getPromotionSelfMode(shoppingcartVO.getPromotions());
        }
        return selfMode;
    }

    @Override
    public int getProductSelfMode(List<MallProductVO> productVos) {
        if (productVos == null) {
            return 1;
        }
        int[] selfMode = new int[]{2};
        productVos.stream().forEach(c -> {
            if (c.getSelfMadeType() == 1) {
                selfMode[0] = 1;
            }
        });
        return selfMode[0];
    }

    @Override
    public int getGroupSelfMode(List<MallGroupVO> groupVos) {
        if (groupVos == null) {
            return 1;
        }
        int[] selfMode = new int[]{2};
        groupVos.stream().forEach(c -> c.getProductList().stream().forEach(d -> {
            if (d.getSelfMadeType() == 1) {
                selfMode[0] = 1;
            }
        }));
        return selfMode[0];
    }

    @Override
    public int getPromotionSelfMode(List<MallPromotionVO> promotinVos) {
        if (promotinVos == null) {
            return 1;
        }
        int[] selfMode = new int[]{2};
        promotinVos.stream().forEach(c -> {
            if (c.getProduct() != null && c.getProduct().getSelfMadeType() == 1) {
                selfMode[0] = 1;
            }
            if (c.getGroup() != null) {
                c.getGroup().getProductList().stream().forEach(d -> {
                    if (d.getSelfMadeType() == 1) {
                        selfMode[0] = 1;
                    }
                });
            }
        });
        return selfMode[0];
    }

    @Override
    public List<Map> findRecommendProducts(Integer platformGroupId) {
        ArrayList<Map> rtnList = new ArrayList<Map>();
        MallSaleRecommendEntity searchParam = new MallSaleRecommendEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        searchParam.setSaleType(SalesTypeEnum.SALES_PRODUCT.getValue());
        List sales = this.saleRecommendMapper.getList(searchParam);
        sales.forEach(entity -> {
            BaseJsonVo result = this.buildProductVO(entity.getSaleId(), 1, null, null, null, null, false, false, null, null);
            if (result.isSuccess() && ((MallProductVO)result.getValue()).getValid().booleanValue()) {
                Map pro = ObjectConvert.objectWithSuperConvertToObjectMap((Object)result.getValue());
                pro.put("recommendReason", entity.getRecommendReason());
                rtnList.add(pro);
            }
        });
        return rtnList;
    }

    @Override
    public BaseJsonVo buildIndexProductVo(String productId, String customerId) {
        MallProductEntity productEntity = this.productInterface.getProduct(productId);
        BaseJsonVo baseJsonVo = this.checkProduct(productEntity, "", "", 1);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallIndexProductVo productVo = new MallIndexProductVo();
        productVo.setSalePrice(new BigDecimal(productEntity.getProPrice()));
        productVo.setPrice(new BigDecimal(productEntity.getProPrice()));
        productVo.setLimitBuyCount(productEntity.getLimitBuyCount());
        productVo.setPicMap(this.picService.getProductPicUrlMap(productId, SalesTypeEnum.SALES_PRODUCT.getValue()));
        productVo.setProductAliasName(productEntity.getProNameSx());
        productVo.setProductId(productId);
        productVo.setProductName(productEntity.getProName());
        productVo.setProductTagName(productEntity.getProOtherName());
        productVo.setProductType(productEntity.getProType());
        productVo.setProductUnit(productEntity.getProDw());
        productVo.setProSummary(productEntity.getProSummary());
        productVo.setProTitle(productEntity.getProTitle());
        productVo.setProSpec(productEntity.getProSpec());
        productVo.setPeriod(productEntity.getPeriod());
        productVo.setChucang(productEntity.getMemoChucang());
        productVo.setMemo(productEntity.getMemo());
        productVo.setPeiliao(productEntity.getMemoPeiliao());
        MallPriceVO priceVO = this.priceCalcInterface.getPrice(OrderSourceEnum.CART, SalesTypeEnum.SALES_PRODUCT, productVo.getProductId(), customerId, 0);
        if (priceVO != null && priceVO.getFactPrice() != null) {
            productVo.setSalePrice(priceVO.getFactPrice());
            productVo.setPrice(priceVO.getOriginPrice());
        }
        productVo.setItemType(SalesTypeEnum.SALES_PRODUCT.getValue());
        return BaseJsonVo.success((Object)productVo);
    }

    @Override
    @Transactional
    public BaseJsonVo delProduct(MallProductEntity mallProductEntity) {
        if (mallProductEntity != null && StringUtils.isNotEmpty((String)mallProductEntity.getProId())) {
            mallProductEntity.setDeleteTime(DateUtils.now());
            this.productMapper.updateByPrimaryKeySelective(mallProductEntity);
            MallProductSalesEntity mallProductSalesEntity = new MallProductSalesEntity();
            mallProductSalesEntity.setProId(mallProductEntity.getProId());
            this.mallProductSalesMapper.deleteProductSalesByProId(mallProductSalesEntity);
            return BaseJsonVo.success((Object)"");
        }
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        sr.setError("\u5185\u90e8\u9519\u8bef");
        return sr;
    }

    @Override
    @Transactional
    public BaseJsonVo addProduct(MallProductEntity mallProductEntity) {
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        if (mallProductEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        if (StringUtils.isNotEmpty((String)mallProductEntity.getDownDate())) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date formatDate = format.parse(mallProductEntity.getDownDate());
                int i = formatDate.compareTo(format.parse(format.format(new Date())));
                if (i < 0) {
                    sr.setError("\u4e0b\u67b6\u65e5\u671f\u8bf7\u9009\u62e9\u4eca\u5929\u53ca\u4ee5\u540e\u7684\u65e5\u671f");
                    return sr;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((String)mallProductEntity.getBarCode()) && mallProductEntity.getBarCode().length() > 21) {
            sr.setError("\u6761\u5f62\u7801\u8fc7\u957f");
            return sr;
        }
        if (StringUtils.isEmpty((String)mallProductEntity.getProId())) {
            String id = IDGenerate.getUniqueIdStr();
            mallProductEntity.setProId(id);
            mallProductEntity.setProTypeId((int)mallProductEntity.getProTypeId());
            mallProductEntity.setProType(((MallProductLineEntity)this.productLineMapper.selectByPrimaryKey(mallProductEntity.getProTypeId())).getProType());
            mallProductEntity.setCreateTime(DateUtils.now());
            mallProductEntity.setLastUpdateTime(mallProductEntity.getCreateTime());
            mallProductEntity.setSort(99);
            mallProductEntity.setOnlineFlag(1);
            mallProductEntity.setOfflineFlag(1);
            mallProductEntity.setErpFlag(1);
            mallProductEntity.setErpSort(999);
            mallProductEntity.setErpShow(1);
            this.productMapper.insertSelective(mallProductEntity);
            this.mallProductSalesService.addProduct(id);
        } else {
            this.productMapper.updateByPrimaryKeySelective(mallProductEntity);
        }
        return sr;
    }

    @Override
    public List<MallSelectDataVo> getOptionProductList(Integer platformGroupId) {
        return this.productMapper.getOptionProductList(platformGroupId);
    }

    @Override
    public List<MallProductLineEntity> getProductTypeList(Integer platFormGroupId) {
        MallProductLineEntity param = new MallProductLineEntity();
        param.setPlatformGroupId(platFormGroupId);
        return this.productLineMapper.getList(param);
    }

    @Override
    public int getTransportType(List<MallOrderGroupProductEntity> orderGroupProductEntities) {
        if (orderGroupProductEntities == null || orderGroupProductEntities.size() == 0) {
            return TransportTypeEnum.COLD_CHAIN.getValue();
        }
        int[] transportType = new int[]{1};
        orderGroupProductEntities.stream().forEach(c -> {
            MallProductEntity productEntity = this.productInterface.getProduct(c.getProductId());
            if (productEntity.getTransportType().intValue() == TransportTypeEnum.NORMAL_CHAIN.getValue()) {
                transportType[0] = TransportTypeEnum.NORMAL_CHAIN.getValue();
            }
        });
        return transportType[0];
    }

    @Override
    @ReadThroughSingleCache(namespace="MallProductService.getProductListByGroupId", expiration=300)
    public List<MallProductEntity> getProductListByGroupId(@ParameterValueKeyProvider String groupId) {
        return this.productMapper.getProductListByGroupId(groupId);
    }

    @Override
    public void autoProductStateByDownDate() {
        List<MallProductEntity> mallProductEntityList = this.productMapper.getProductInfoByDownProduct();
        if (mallProductEntityList != null & mallProductEntityList.size() > 0) {
            ArrayList<MallProductEntity> updateProductList = new ArrayList<MallProductEntity>();
            for (MallProductEntity mallProductEntity : mallProductEntityList) {
                boolean isDownPro;
                String downDate = mallProductEntity.getDownDate();
                boolean bl = isDownPro = DateUtils.getDateDiffSecond((String)DateUtils.now((String)""), (String)downDate) < 0L;
                if (!isDownPro) continue;
                mallProductEntity.setProState(9);
                mallProductEntity.setShowState(0);
                updateProductList.add(mallProductEntity);
                this.memcachedService.delete("MallProductService.getProduct", mallProductEntity.getProId());
            }
            if (updateProductList != null && updateProductList.size() > 0) {
                this.productMapper.updateProductInfoByProId(updateProductList);
            }
        }
    }
}

