/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.scrollpic;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.scrollpic.MallScrollPicDetailMapper;
import cc.lechun.mall.entity.scrollpic.MallScrollPicDetailEntity;
import cc.lechun.mall.entity.scrollpic.MallScrollPicEntity;
import cc.lechun.mall.iservice.scrollpic.MallScrollPicDetailInterface;
import cc.lechun.mall.service.scrollpic.MallScrollPicService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallScrollPicDetailService
extends BaseService
implements MallScrollPicDetailInterface {
    @Autowired
    private MallScrollPicDetailMapper mallScrollPicDetailMapper;
    @Autowired
    private MallScrollPicService mallScrollPicService;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private OssService ossService;

    @Override
    public BaseJsonVo saveMallScrollPicDetail(MallScrollPicDetailEntity mallScrollPicDetailEntity) {
        BaseJsonVo rs = this.valid(mallScrollPicDetailEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        mallScrollPicDetailEntity.setCreateTime(DateUtils.now());
        this.mallScrollPicDetailMapper.insertSelective(mallScrollPicDetailEntity);
        this.removeCache(mallScrollPicDetailEntity.getScrollId());
        return rs;
    }

    @Override
    public BaseJsonVo updateMallScrollPicDetail(MallScrollPicDetailEntity mallScrollPicDetailEntity) {
        BaseJsonVo rs = this.valid(mallScrollPicDetailEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        this.removeCache(mallScrollPicDetailEntity.getScrollId());
        this.mallScrollPicDetailMapper.updateByPrimaryKeySelective(mallScrollPicDetailEntity);
        return rs;
    }

    @Override
    public MallScrollPicDetailEntity getMallScrollPicDetail(int scrollDetailid) {
        return (MallScrollPicDetailEntity)this.mallScrollPicDetailMapper.selectByPrimaryKey(Integer.valueOf(scrollDetailid));
    }

    @Override
    public PageInfo getMallScrollPicDetailList(int pageNum, int pageSize, int scrollId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallScrollPicDetailMapper.getMallScrollPicDetailList(scrollId);
        PageInfo pg = page.toPageInfo();
        pg.getList().forEach(mallScrollPicDetailEntity1 -> mallScrollPicDetailEntity1.setAllpicurl(this.ossService.getImageResoure(mallScrollPicDetailEntity1.getPicurl())));
        return pg;
    }

    @Override
    @ReadThroughSingleCache(namespace="getVailMallScrollPicDetailList", expiration=600)
    public List<MallScrollPicDetailEntity> getVailMallScrollPicDetailList(@ParameterValueKeyProvider(order=0) int platformId, @ParameterValueKeyProvider(order=1) int picType) {
        List<MallScrollPicDetailEntity> ls = this.mallScrollPicDetailMapper.getVailMallScrollPicDetail(platformId, picType);
        ls.forEach(mallScrollPicDetailEntity -> mallScrollPicDetailEntity.setPicurl(this.ossService.getImageResoure(mallScrollPicDetailEntity.getPicurl())));
        return ls;
    }

    private BaseJsonVo valid(MallScrollPicDetailEntity mallScrollPicEntity) {
        if (StringUtils.isEmpty((String)mallScrollPicEntity.getName())) {
            return BaseJsonVo.paramError((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallScrollPicEntity.getBeginTime() == null) {
            return BaseJsonVo.paramError((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallScrollPicEntity.getEndTime() == null) {
            return BaseJsonVo.paramError((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private void removeCache(int scrollId) {
        MallScrollPicEntity mallScrollPicEntity = this.mallScrollPicService.getMallScrollPic(scrollId);
        this.memcachedService.delete("getVailMallScrollPicDetailList", new String[]{mallScrollPicEntity.getPlatformId() + "", mallScrollPicEntity.getPicType() + ""});
    }
}

