/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCashticketMapper;
import cc.lechun.active.entity.Cash.CustomerCashVo;
import cc.lechun.active.entity.active.ActiveCashticketEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.redpackage.RedpackageConfigDetailVo;
import cc.lechun.active.form.cash.CustomerCashticketQuaryForm;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.active.vo.ActiveCashticketMessageVo;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.messagePush.PaySuccessMessageInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ActiveCashticketService
extends ActiveBaseService
implements ActiveCashticketInterface {
    @Autowired
    private ActiveCashticketMapper activeCashticketMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private AccountBalanceInterface balanceService;
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleService;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private PaySuccessMessageInterface paySuccessMessageInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    DistributionInviteInterface distributionInviteInterface;
    private CustomerEntity customerEntity;

    @Override
    public boolean updateCashticketStatus(int ticketId, String customerId, CashStatusEnum cashStatusEnum) {
        return this.cashticketCustomerService.updateCashticketStatus(ticketId, customerId, cashStatusEnum);
    }

    @Override
    public BaseJsonVo sendCashticketByTicketBatchId(String customerId, String ticketBatchId, Integer platFormId) {
        return this.cashticketInterface.convertByTicketBatchId(customerId, platFormId == null ? 1 : platFormId, ticketBatchId);
    }

    @Override
    public List<Integer> getCashticketTicketId(String bindCode, String customerId) {
        try {
            return this.cashticketCustomerService.getCashticketTicketId(bindCode, customerId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Integer>();
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=300)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType) {
        return this.activeCashticketMapper.getRedpackageConfigVoList(activeNo, activeType);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getRedpackageConfigVoList", expiration=600)
    public List<RedpackageConfigDetailVo> getRedpackageConfigVoList(@ParameterValueKeyProvider(order=0) String activeNo, @ParameterValueKeyProvider(order=1) Integer activeType, @ParameterValueKeyProvider(order=2) Integer shareCount) {
        List<RedpackageConfigDetailVo> list = this.getRedpackageConfigVoList(activeNo, activeType);
        if (list != null) {
            return list.stream().filter(c -> c.getUserType().intValue() == shareCount.intValue()).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getCashticketByBindCode", expiration=300)
    public ActiveCashticketVo getCashticketByBindCode(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getCashticketByBindCode(bindCode);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getCashticketListByBindCode", expiration=600)
    public BaseJsonVo getCashticketListByBindCode(@ParameterValueKeyProvider String bindCode) {
        return BaseJsonVo.success(this.activeCashticketMapper.getCashticketListByBindCode(bindCode));
    }

    @Override
    public BaseJsonVo sendTicket4CustomerType(String customerId, String bindCode, String versionDetailId, Integer platFormId, Integer platformGroupId, boolean isSendMessage) {
        return this.sendTicket4CustomerType(customerId, bindCode, versionDetailId, platFormId, platformGroupId, isSendMessage, 0);
    }

    @Override
    @Transactional
    public BaseJsonVo sendTicket4CustomerType(String customerId, String bindCode, String versionDetailId, Integer platFormId, Integer platformGroupId, boolean isSendMessage, Integer newUserStatus) {
        List<ActiveQrcodeEntity> qrcodeList;
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        if (activeEntity.getActiveType() != 15 && activeEntity.getActiveType() != 41) {
            return BaseJsonVo.error((String)"\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u65e0\u6548\u7684\u6d3b\u52a8\u7c7b\u578b");
        }
        if (newUserStatus != null && newUserStatus > 0 && bindCode.length() < 32 && (qrcodeList = this.activeQrcodeService.getQrcodeListByActiveNo(activeEntity.getActiveNo())).size() > 1) {
            Optional<ActiveQrcodeEntity> tempOptional;
            CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
            if (customerEntity.getIsNew() == 1) {
                tempOptional = qrcodeList.stream().filter(activeQrcodeEntity -> activeQrcodeEntity.getActiveType() == 1).findFirst();
                if (tempOptional.isPresent()) {
                    bindCode = tempOptional.get().getBindCode();
                }
            } else {
                tempOptional = qrcodeList.stream().filter(activeQrcodeEntity -> activeQrcodeEntity.getActiveType() == 2).findFirst();
                if (tempOptional.isPresent()) {
                    bindCode = tempOptional.get().getBindCode();
                }
            }
        }
        BaseJsonVo vo = this.activeCashticketService.sendTicket4Base(customerId, bindCode, versionDetailId, platFormId, isSendMessage);
        PageForm pageForm = new PageForm();
        int size = 100;
        BaseJsonVo baseJsonVo = this.activeCashticketService.getCashticketListByBindCode(bindCode);
        if (baseJsonVo.isSuccess()) {
            List cashticketVoList = (List)baseJsonVo.getValue();
            size = cashticketVoList.size();
        }
        pageForm.setPageSize(size);
        pageForm.setCurrentPage(1);
        CustomerCashticketQuaryForm customerCashticketQuaryForm = new CustomerCashticketQuaryForm();
        customerCashticketQuaryForm.setBindCode(bindCode);
        customerCashticketQuaryForm.setCustomerId(customerId);
        List<CashticketVo> cashticketVos = this.cashticketCustomerService.getTakedCashticketList(pageForm, platformGroupId, customerId, bindCode);
        CustomerCashVo customerCashVo = new CustomerCashVo();
        customerCashVo.setCashDetailVos(cashticketVos);
        customerCashVo.setTicketAmount(new BigDecimal(0));
        cashticketVos.forEach(c -> {
            if (c.getDiscountMode() == 0) {
                customerCashVo.setTicketAmount(customerCashVo.getTicketAmount().add(c.getTicketAmount()));
            }
        });
        vo.setValue((Object)customerCashVo);
        if (bindCode.equals("ba5a156234284999956a4fa98413abab")) {
            this.activeCashticketMapper.updateCustomerDomain(customerId);
        }
        return vo;
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        return this.activeCashticketService.sendTicket4Base(customerId, bindCode, 0.0, versionDetailId, platFormId, isSendMessage, isSendMessage);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        return this.sendTicket4Base(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, true);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog) {
        return this.activeCashticketService.sendTicket4Base(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo sendTicket4Base(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog, boolean checkActive) {
        BaseJsonVo baseJsonVo;
        Optional<ActiveEntity> activeEntityOpt = Optional.ofNullable(this.activeService.getActiveEntityByQrcode(bindCode));
        if (!activeEntityOpt.isPresent()) {
            if (bindCode.length() >= 32) return BaseJsonVo.error((String)"\u7121\u6548\u7684\u512a\u60e0\u5238\u6d3b\u52d5");
            activeEntityOpt = Optional.ofNullable(this.activeService.getActiveEntityByActiveNo(bindCode));
            if (!activeEntityOpt.isPresent()) return BaseJsonVo.error((String)"\u7121\u6548\u7684\u512a\u60e0\u5238\u6d3b\u52d5");
            bindCode = activeEntityOpt.get().getBindCode();
        }
        if (checkActive && !(baseJsonVo = this.activeService.checkActiveEnable((ActiveEntity)activeEntityOpt.orElse(null))).isSuccess()) {
            return baseJsonVo;
        }
        List<ActiveCashticketEntity> list = this.activeCashticketService.getBindCodeActiveCashticketList(bindCode);
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u6ca1\u6709\u7ed1\u5b9a\u4f18\u60e0\u5238\u6279\u6b21,bindcode={},customerId={},versionDetailId={}", new Object[]{bindCode, customerId, versionDetailId});
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6307\u5b9a\u53d1\u653e\u4f18\u60e0\u5238\u6279\u6b21");
        }
        String message = "\u4f18\u60e0\u5238\u53d1\u653e\u5931\u8d25";
        BaseJsonVo baseJsonVo2 = BaseJsonVo.error((String)"");
        String ticketBatchId = "";
        Integer count = 0;
        try {
            for (ActiveCashticketEntity c : list) {
                ticketBatchId = c.getTicketBatchId();
                count = c.getCount();
                baseJsonVo2 = this.cashticketCustomerService.sendTicket4Base(customerId, c.getTicketBatchId(), c.getCount(), "", c.getBindCode(), amount, versionDetailId, platFormId, isSendMessage);
                String string = message = !baseJsonVo2.isSuccess() ? baseJsonVo2.getMessage() : "";
                if (baseJsonVo2.isSuccess()) {
                    BaseJsonVo chargeResult;
                    if (c.getBalance() == null || c.getBalance() <= 0 || (chargeResult = this.balanceService.activeChargeAsync(customerId, bindCode, activeEntityOpt.get(), c.getBalance())).isSuccess()) continue;
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    baseJsonVo2 = BaseJsonVo.error((String)chargeResult.getError_msg());
                    continue;
                }
                if (message.contains("\u4e0d\u53ef\u4ee5\u91cd\u590d\u9886\u53d6") && activeEntityOpt.isPresent() && activeEntityOpt.get().getActiveType() == 15) {
                    baseJsonVo2.setMessage(activeEntityOpt.get().getActiveName() + "\u4f18\u60e0\u5238\u5df2\u9886\u53d6\uff0c\u4e0d\u53ef\u91cd\u590d\u9886\u53d6\u5662~~");
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return baseJsonVo2;
            }
            return baseJsonVo2;
        }
        catch (Exception e) {
            if (writeLog) {
                HashMap<String, Object> messageBody = new HashMap<String, Object>();
                messageBody.put("customerId", customerId);
                messageBody.put("bindCode", bindCode);
                messageBody.put("versionDetailId", "");
                messageBody.put("ticketBatchId", ticketBatchId);
                messageBody.put("status", 0);
                messageBody.put("message", e.getMessage());
                messageBody.put("count", count);
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendCashLog, MessageParam.messageParam((String)customerId, messageBody));
                baseJsonVo2 = BaseJsonVo.error((String)e.getMessage());
            }
            this.logger.error("\u53d1\u653e\u6d3b\u52a8\u4f18\u60e0\u5238\u5f02\u5e38\uff0c\u53c2\u6570:customerId=[{}],bindCode=[{}],versionDetailId=[{}],platFormId=[{}],\u6d88\u606f:[{}]", new Object[]{customerId, bindCode, versionDetailId, platFormId, e.getMessage()});
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return baseJsonVo2;
        }
    }

    @Override
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage) {
        this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, bindCode, versionDetailId, platFormId, isSendMessage, true);
    }

    @Override
    public void sendTicket4BaseAsynchronous(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean checkActive) {
        ActiveCashticketMessageVo activeCashticketMessageVo = new ActiveCashticketMessageVo();
        activeCashticketMessageVo.setBindCode(bindCode);
        activeCashticketMessageVo.setOpenId("");
        activeCashticketMessageVo.setUserId(customerId);
        activeCashticketMessageVo.setVersionDetailId("");
        activeCashticketMessageVo.setSendMessage(isSendMessage);
        activeCashticketMessageVo.setPlatFormId(platFormId);
        activeCashticketMessageVo.setCheckActive(checkActive);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendActiveCashTicket, MessageParam.messageParam((String)customerId, (Object)activeCashticketMessageVo));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveCashticketService.getBindCodeActiveCashticketList", expiration=600)
    public List<ActiveCashticketEntity> getBindCodeActiveCashticketList(@ParameterValueKeyProvider String bindCode) {
        return this.activeCashticketMapper.getBindCodeActiveCashticketList(bindCode);
    }

    @Override
    public BaseJsonVo deleteCouponConfig(Integer id) {
        ActiveCashticketEntity activeCashticketEntity = (ActiveCashticketEntity)this.activeCashticketMapper.selectByPrimaryKey(id);
        this.removeCache(activeCashticketEntity.getBindCode());
        int k = this.activeCashticketMapper.deleteByPrimaryKey(id);
        return k >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    private void removeCache(String bindCode) {
        this.memcachedService.delete("ActiveCashticketService.getBindCodeActiveCashticketList", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketByBindCode", bindCode);
        this.memcachedService.delete("ActiveCashticketService.getCashticketListByBindCode", bindCode);
    }

    @Override
    public BaseJsonVo sendCashticket(HttpServletRequest httpServletRequest, Integer platformGroupId, Integer platformId, Integer subscribe, String bindCode, String customerId, boolean isSendMessage) {
        if (platformId == 1 && subscribe == 0) {
            CustomerCashVo customerCashVo = new CustomerCashVo();
            customerCashVo.setSubscribe(subscribe);
            if (StringUtils.isEmpty((String)bindCode)) {
                return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
            }
            ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
            customerCashVo.setQrcodeUrl(activeQrcodeEntity != null ? this.ossService.getImageResoure(activeQrcodeEntity.getQrcodeImageUrl()) : "");
            return BaseJsonVo.success((Object)customerCashVo);
        }
        BaseJsonVo jsonVo = this.sendTicket4CustomerType(customerId, bindCode, "", platformId, platformGroupId, isSendMessage, 0);
        if (jsonVo.isSuccess()) {
            CustomerCashVo customerCashVo = (CustomerCashVo)jsonVo.getValue();
            customerCashVo.setSubscribe(1);
            if (customerCashVo != null) {
                this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a" + JsonUtils.toJson((Object)customerCashVo, (boolean)true));
                List<CashticketVo> cashticketVos = customerCashVo.getCashDetailVos();
                if (cashticketVos != null && cashticketVos.size() > 0) {
                    for (CashticketVo v : cashticketVos) {
                        this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a\u5faa\u73af:" + v.getTicketBatchName());
                        String distributorRelationCode = httpServletRequest.getParameter("ncp_bat");
                        if (StringUtils.isEmpty((String)distributorRelationCode)) {
                            distributorRelationCode = httpServletRequest.getParameter("ncpBat");
                        }
                        if (!StringUtils.isNotEmpty((String)distributorRelationCode)) continue;
                        this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a:\u9080\u8bf7\u7801\uff1a" + distributorRelationCode);
                        Boolean bl = this.distributionInviteInterface.invite(distributorRelationCode, customerId, v.getTicketCustomerId().toString(), 2);
                    }
                }
            }
        }
        return jsonVo;
    }
}

