/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCustomerMapper;
import cc.lechun.active.entity.active.ActiveCustomerEntity;
import cc.lechun.active.entity.active.ActiveCustomerVo;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.cache.RedisService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveCustomerService
extends ActiveBaseService
implements ActiveCustomerInterface {
    @Autowired
    private ActiveCustomerMapper activeCustomerMapper;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public BaseJsonVo saveActiveCustomerRecord(ActiveCustomerVo activeCustomerVo) {
        try {
            ActiveCustomerEntity activeCustomerEntity = activeCustomerVo.getActiveCustomerEntity();
            ActiveCustomerEntity temp = new ActiveCustomerEntity();
            temp.setCustomerId(activeCustomerEntity.getCustomerId());
            temp.setBindCode(activeCustomerEntity.getBindCode());
            ActiveCustomerEntity temp2 = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(temp);
            this.logger.info("\u5f00\u59cb\u5199\u5165\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55:{}", (Object)activeCustomerEntity.toString());
            if (temp2 == null) {
                this.logger.info("\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55\u4e3a\u7a7a...");
                Integer level = 1;
                if (StringUtils.isNotEmpty((String)activeCustomerVo.getSourceUserId())) {
                    ActiveInviteEntity queryEntity = new ActiveInviteEntity();
                    queryEntity.setCustomerId(activeCustomerVo.getSourceUserId());
                    queryEntity.setBindCode(activeCustomerVo.getActiveCustomerEntity().getBindCode());
                    ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity(queryEntity);
                    if (activeCustomerEntity != null && activeInviteEntity != null) {
                        temp.setCustomerId(activeInviteEntity.getCustomerId());
                        temp.setBindCode(activeCustomerEntity.getBindCode());
                        temp2 = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(temp);
                        if (temp2 != null) {
                            level = temp2.getLevel() + 1;
                        }
                    } else {
                        this.logger.info("\u6d3b\u52a8\u9080\u8bf7inviteId\u51fa\u9519,\u9080\u8bf7\u4ebacustomerId={}", (Object)activeCustomerVo.getSourceUserId());
                    }
                }
                activeCustomerEntity.setLevel(level);
                activeCustomerEntity.setStatus(0);
                activeCustomerEntity.setUpdateTime(DateUtils.now());
                this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeCustomerEntity.toString());
                int k = this.activeCustomerMapper.insert(activeCustomerEntity);
                if (k >= 1) {
                    this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeCustomerEntity.toString());
                } else {
                    this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u5931\u8d25:{}", (Object)activeCustomerEntity.toString());
                }
            } else if (temp2.getStatus() == 0) {
                ActiveCustomerEntity updateActiveCustomerEntity = new ActiveCustomerEntity();
                updateActiveCustomerEntity.setOrderMainNo(activeCustomerEntity.getOrderMainNo());
                updateActiveCustomerEntity.setUpdateTime(DateUtils.now());
                updateActiveCustomerEntity.setActiveNo(activeCustomerEntity.getActiveNo());
                updateActiveCustomerEntity.setActiveType(activeCustomerEntity.getActiveType());
                updateActiveCustomerEntity.setId(temp2.getId());
                this.activeCustomerMapper.updateByPrimaryKeySelective(updateActiveCustomerEntity);
            } else {
                this.logger.info("\u7528\u6237\u53c2\u4e0e\u6d3b\u52a8\u72b6\u6001\u4e3a:{}", (Object)temp2.getStatus());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveActiveCustomerRecord(ActiveEntity activeEntity, String customerId, String source, Integer status) {
        ActiveCustomerEntity temp = new ActiveCustomerEntity();
        temp.setCustomerId(customerId);
        if (StringUtils.isNotEmpty((String)source)) {
            temp.setSourceCustomerId(source);
        }
        temp.setBindCode(activeEntity.getBindCode());
        ActiveCustomerEntity activeCustomerEntity = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(temp);
        if (activeCustomerEntity == null || activeCustomerEntity.getId() == null) {
            temp.setActiveNo(activeEntity.getActiveNo());
            temp.setActiveType(activeEntity.getActiveType());
            temp.setCreateTime(DateUtils.now());
            temp.setGiveShareCount(0);
            temp.setInviteNum(activeEntity.getInviteNum());
            temp.setLevel(0);
            temp.setStatus(status);
            temp.setIsFirstOrder(0);
            temp.setSign("");
            temp.setRechangeUser("");
            temp.setRechangeCode(this.getTicketNo(8));
            this.redisService.sadd("ative_ticketNo", temp.getRechangeCode());
            return this.activeCustomerMapper.insertSelective(temp) >= 1 ? BaseJsonVo.success((Object)temp.getRechangeCode()) : BaseJsonVo.error((String)"");
        }
        if (activeCustomerEntity.getStatus() < status) {
            activeCustomerEntity.setStatus(status);
            this.activeCustomerMapper.updateByPrimaryKeySelective(activeCustomerEntity);
        }
        return BaseJsonVo.success((Object)activeCustomerEntity.getRechangeCode());
    }

    private String getTicketNo(int ticketPosition) {
        String randNo = RandomUtils.generateRandomNumberString((int)ticketPosition);
        if (this.redisService.sIsMember("ative_ticketNo", randNo)) {
            return this.getTicketNo(ticketPosition);
        }
        return randNo;
    }

    @Override
    public BaseJsonVo<ActiveCustomerEntity> getRechangeCode(String customerId, String bindCode) {
        ActiveCustomerEntity temp = new ActiveCustomerEntity();
        temp.setBindCode(bindCode);
        temp.setCustomerId(customerId);
        List list = this.activeCustomerMapper.getList(temp);
        Optional<ActiveCustomerEntity> activeCustomerEntityOptional = list.stream().filter(activeCustomerEntity -> StringUtils.isNotEmpty((String)activeCustomerEntity.getRechangeCode())).findFirst();
        if (activeCustomerEntityOptional.isPresent()) {
            return BaseJsonVo.success((Object)activeCustomerEntityOptional.get());
        }
        return BaseJsonVo.error((String)"\u672a\u53c2\u4e0e\u6d3b\u52a8!");
    }

    @Override
    public BaseJsonVo<List<ActiveCustomerEntity>> getRechangeCodeList(String customerId, String bindCode) {
        ActiveCustomerEntity temp = new ActiveCustomerEntity();
        temp.setBindCode(bindCode);
        temp.setCustomerId(customerId);
        List list = this.activeCustomerMapper.getList(temp);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BaseJsonVo.error((String)"\u9080\u8bf73\u4f4d\u670b\u53cb\u53c2\u4e0e\u6d3b\u52a8\u5c31\u53ef\u514d\u8d39\u9886\u53d6\u54e6\uff5e");
        }
        return BaseJsonVo.success(list.stream().filter(activeCustomerEntity -> StringUtils.isNotEmpty((String)activeCustomerEntity.getRechangeCode())).collect(Collectors.toList()));
    }

    @Override
    public BaseJsonVo<ActiveCustomerEntity> getGiftRechangeStatus(String rechangeCode, String bindCode) {
        ActiveCustomerEntity temp = new ActiveCustomerEntity();
        if (StringUtils.isNotEmpty((String)bindCode)) {
            temp.setBindCode(bindCode);
        }
        temp.setRechangeCode(rechangeCode.trim());
        List list = this.activeCustomerMapper.getList(temp);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BaseJsonVo.error((String)"\u5151\u6362\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success(list.get(0));
    }

    @Override
    public BaseJsonVo updateActiveCustomerRecord(ActiveCustomerEntity activeCustomerEntity) {
        this.activeCustomerMapper.updateByPrimaryKeySelective(activeCustomerEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateActiveCustomerRecord(MallOrderMainEntity orderMainEntity) {
        ActiveCustomerEntity queryActiveCustomer = new ActiveCustomerEntity();
        queryActiveCustomer.setCustomerId(orderMainEntity.getCustomerId());
        queryActiveCustomer.setBindCode(orderMainEntity.getBindCode());
        queryActiveCustomer.setStatus(0);
        ActiveCustomerEntity activeCustomerEntity = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(queryActiveCustomer);
        if (activeCustomerEntity != null) {
            ActiveCustomerEntity updateActiveCustomerEntity = new ActiveCustomerEntity();
            updateActiveCustomerEntity.setId(activeCustomerEntity.getId());
            updateActiveCustomerEntity.setStatus(1);
            this.activeCustomerMapper.updateByPrimaryKeySelective(updateActiveCustomerEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Transactional
    public BaseJsonVo saveActiveCustomerRecord(MallOrderMainEntity orderMain, String source, ActiveEntity activeEntity) {
        ActiveCustomerEntity temp2;
        ActiveCustomerEntity temp = new ActiveCustomerEntity();
        temp.setCustomerId(orderMain.getCustomerId());
        temp.setBindCode(orderMain.getBindCode());
        temp.setOrderMainNo(orderMain.getOrderMainNo());
        if (StringUtils.isNotEmpty((String)source)) {
            temp.setSourceCustomerId(source);
        }
        if (activeEntity == null) {
            activeEntity = this.activeService.getActiveEntityByQrcode(orderMain.getBindCode());
        }
        if ((temp2 = (ActiveCustomerEntity)this.activeCustomerMapper.getSingle(temp)) == null) {
            this.logger.info("\u7528\u6237{}\u53c2\u4e0e\u6d3b\u52a8:{}\u8bb0\u5f55\u4e3a\u7a7a...", (Object)orderMain.getCustomerId(), (Object)activeEntity.getActiveName());
            Integer level = 1;
            ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
            BeanUtils.copyProperties((Object)orderMain, (Object)activeCustomerEntity);
            activeCustomerEntity.setActiveType(activeEntity.getActiveType());
            activeCustomerEntity.setCityName("");
            activeCustomerEntity.setName("");
            activeCustomerEntity.setActiveNo(activeEntity.getActiveNo());
            activeCustomerEntity.setInviteNum(activeEntity.getInviteNum());
            activeCustomerEntity.setGiveShareCount(0);
            activeCustomerEntity.setIpCityId(0);
            activeCustomerEntity.setCreateTime(DateUtils.now());
            activeCustomerEntity.setThirdOpenId("");
            activeCustomerEntity.setIsFirstOrder(0);
            activeCustomerEntity.setQrcodeId(0);
            activeCustomerEntity.setSourceCustomerId(source == null ? "" : source);
            activeCustomerEntity.setReleaseSystemId("");
            activeCustomerEntity.setVersionDetailId("");
            if (StringUtils.isNotEmpty((String)source)) {
                ActiveCustomerEntity inviteCutomer = new ActiveCustomerEntity();
                inviteCutomer.setCustomerId(source);
                inviteCutomer.setActiveType(activeEntity.getActiveType());
                List<ActiveCustomerEntity> list = this.getActiveCustomerEntityList(inviteCutomer);
                if (list != null && list.size() >= 1) {
                    inviteCutomer = list.stream().filter(c -> c.getStatus() >= 1).findFirst().get();
                    if (inviteCutomer != null) {
                        level = inviteCutomer.getLevel() + 1;
                    }
                } else {
                    this.logger.info("\u67e5\u8be2\u6d3b\u52a8\u9080\u8bf7\u4ebalevel\u51fa\u9519,\u9080\u8bf7\u4ebacustomerId={}", (Object)source);
                }
            }
            activeCustomerEntity.setLevel(level);
            activeCustomerEntity.setStatus(0);
            activeCustomerEntity.setUpdateTime(DateUtils.now());
            int k = this.activeCustomerMapper.insert(activeCustomerEntity);
            if (k >= 1) {
                this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeCustomerEntity.toString());
                return BaseJsonVo.success((Object)"");
            }
            this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u5931\u8d25:{}", (Object)activeCustomerEntity.toString());
            return BaseJsonVo.error((String)"\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55\u5199\u5165\u5931\u8d25");
        }
        if (temp2.getStatus() != 0) {
            this.logger.info("\u7528\u6237\u53c2\u4e0e\u6d3b\u52a8\u72b6\u6001\u4e3a:{}", (Object)temp2.getStatus());
            return BaseJsonVo.success((Object)"");
        }
        ActiveCustomerEntity updateActiveCustomerEntity = new ActiveCustomerEntity();
        updateActiveCustomerEntity.setOrderMainNo(orderMain.getOrderMainNo());
        updateActiveCustomerEntity.setUpdateTime(DateUtils.now());
        updateActiveCustomerEntity.setActiveNo(orderMain.getActiveNo());
        updateActiveCustomerEntity.setSourceCustomerId(StringUtils.isNotEmpty((String)source) ? source : "");
        updateActiveCustomerEntity.setActiveType(activeEntity.getActiveType());
        updateActiveCustomerEntity.setId(temp2.getId());
        if (this.activeCustomerMapper.updateByPrimaryKeySelective(updateActiveCustomerEntity) >= 1) {
            this.logger.info("\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55\u66f4\u65b0\u6210\u529f.{}", (Object)updateActiveCustomerEntity.toString());
            return BaseJsonVo.success((Object)"");
        }
        this.logger.info("\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25.{}", (Object)updateActiveCustomerEntity.toString());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveActiveCustomerRecord(MallOrderMainEntity orderMainEntity) {
        return this.saveActiveCustomerRecord(orderMainEntity, "", null);
    }

    @Override
    public List<ActiveCustomerEntity> getActiveCustomerEntityList(ActiveCustomerEntity activeCustomerEntity) {
        return this.activeCustomerMapper.getList(activeCustomerEntity);
    }

    @Override
    public int getInviteNum(ActiveCustomerEntity activeCustomerEntity) {
        List<ActiveCustomerEntity> list = this.getActiveCustomerEntityList(activeCustomerEntity);
        if (CollectionUtils.isNotEmpty(list)) {
            Optional<ActiveCustomerEntity> temp = list.stream().filter(c -> c.getStatus() >= 1).findFirst();
            if (temp.isPresent()) {
                return temp.get().getInviteNum() == null ? 0 : temp.get().getInviteNum();
            }
            return 0;
        }
        return 0;
    }

    @Override
    public BaseJsonVo updateCustomerActiveRecordByOrderNo(ActiveCustomerEntity activeCustomerEntity) {
        return this.activeCustomerMapper.updateCustomerActiveRecord(activeCustomerEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public Integer getJoinActiveStatus(String customerId, Integer activeType) {
        Optional<ActiveCustomerEntity> optional;
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setActiveType(activeType);
        List list = this.activeCustomerMapper.getList(activeCustomerEntity);
        if (CollectionUtils.isNotEmpty((Collection)list) && (optional = list.stream().max(Comparator.comparing(ActiveCustomerEntity::getStatus))).isPresent()) {
            return optional.get().getStatus();
        }
        return 0;
    }

    @Override
    public Integer getJoinActiveStatus(String customerId, String bindCode) {
        Optional<ActiveCustomerEntity> optional;
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setBindCode(bindCode);
        List list = this.activeCustomerMapper.getList(activeCustomerEntity);
        if (list != null && list.size() >= 1 && (optional = list.stream().max(Comparator.comparing(ActiveCustomerEntity::getStatus))).isPresent()) {
            return optional.get().getStatus();
        }
        return 0;
    }

    @Override
    public BaseJsonVo prizeActive(String customerId, String bindCode) {
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setBindCode(bindCode);
        activeCustomerEntity.setCustomerId(customerId);
        activeCustomerEntity.setUpdateTime(DateUtils.now());
        activeCustomerEntity.setStatus(2);
        return this.activeCustomerMapper.setPrizeByBindCode(activeCustomerEntity) >= 1 ? BaseJsonVo.success((Object)"\u5151\u5956\u6210\u529f") : BaseJsonVo.error((String)"\u5151\u5956\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5!");
    }
}

