/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActivePropertyMapper;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.PicLinkVo;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivePropertyService
extends BaseService<ActivePropertyEntity, Integer>
implements ActivePropertyInterface {
    @Resource
    private ActivePropertyMapper activePropertyMapper;
    @Autowired
    MallProductPicInterface picInterface;
    @Autowired
    OssService ossService;

    @Override
    @ReadThroughSingleCache(namespace="ActivePropertyService.getPicPropertyList", expiration=240)
    public Map<String, List<PicLinkVo>> getPicPropertyList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) String activeNo) {
        HashMap<String, List<PicLinkVo>> result = new HashMap<String, List<PicLinkVo>>();
        Map<String, List<String>> list = this.picInterface.getProductPicUrlMap(activeNo, SalesTypeEnum.SALES_ACTIVE.getValue());
        if (list.size() > 0) {
            list.forEach((key, value) -> {
                ArrayList picLinkVoList = new ArrayList();
                ActivePropertyEntity activePropertyEntity = new ActivePropertyEntity();
                activePropertyEntity.setBindCode(bindCode);
                activePropertyEntity.setPropertyName((String)key);
                List propertyList = this.getList(activePropertyEntity, 0L);
                value.forEach(item -> {
                    Optional<ActivePropertyEntity> picUrlOption;
                    PicLinkVo picLinkVo = new PicLinkVo();
                    picLinkVo.setPicUrl((String)item);
                    if (propertyList.size() > 0 && (picUrlOption = propertyList.stream().filter(p -> this.ossService.removeUrlDomain((String)item).equals(p.getPropertyKey())).findFirst()).isPresent()) {
                        picLinkVo.setLinkUrl(picUrlOption.get().getPropertyValue());
                    }
                    picLinkVoList.add(picLinkVo);
                });
                if (picLinkVoList.size() > 0) {
                    result.put((String)key, picLinkVoList);
                }
            });
        }
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActivePropertyService.getActivePropertyList", expiration=120)
    public List<ActivePropertyEntity> getActivePropertyList(@ParameterValueKeyProvider String bindCode) {
        ActivePropertyEntity activePropertyEntity = new ActivePropertyEntity();
        activePropertyEntity.setBindCode(bindCode);
        activePropertyEntity.setStatus(1);
        return this.activePropertyMapper.getList(activePropertyEntity);
    }

    @Override
    public ActivePropertyEntity getActiveProperty(String propertyName, String propertyKey) {
        ActivePropertyEntity query = new ActivePropertyEntity();
        if (StringUtils.isNotEmpty((String)propertyName)) {
            query.setPropertyName(propertyName);
        }
        if (StringUtils.isNotEmpty((String)propertyKey)) {
            query.setPropertyKey(propertyKey);
        }
        return (ActivePropertyEntity)this.activePropertyMapper.getSingle(query);
    }
}

