/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.active;

import cc.lechun.active.dao.active.ActiveCheckinMapper;
import cc.lechun.active.dao.active.ActiveMapper;
import cc.lechun.active.entity.active.ActiveCheckinEntity;
import cc.lechun.active.entity.active.ActiveCheckinRemindEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveIndexEntity;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.entity.active.ActivePageVo;
import cc.lechun.active.entity.active.ActivePicLinkVo;
import cc.lechun.active.entity.active.ActivePicPropertyEnum;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.active.ActiveQueryVo;
import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCheckinRemindInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePageInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.apiinvoke.bi.CustomerProductInvoke;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.ActiveGiftPropertyInfoVo;
import cc.lechun.mall.entity.page.PageLinkEntity;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorGrowthActiveInterface;
import cc.lechun.mall.iservice.page.PageLinkInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.CustomerProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ActiveService
extends BaseService
implements ActiveInterface {
    @Autowired
    private ActiveMapper activeMapper;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeInterface;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActivePageInterface activePageInterface;
    @Autowired
    private ActiveCheckinMapper checkinMapper;
    @Autowired
    @Lazy
    private MessageInterface messageService;
    @Autowired
    @Lazy
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceService;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    ActiveCheckinRemindInterface activeCheckinRemindInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    private CustomerProductCategoryInterface customerProductCategoryInterface;
    @Autowired
    DistributorGrowthActiveInterface distributorGrowthActiveInterface;
    @Autowired
    CustomerProductInvoke customerProductInvoke;
    @Autowired
    MallOrderProductInterface orderProductInterface;
    @Autowired
    private OssService ossInterface;
    @Autowired
    private PageLinkInterface pageLinkInterface;

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getPicLinkList", expiration=120)
    public BaseJsonVo getPicLinkList(@ParameterValueKeyProvider(order=0) String pageUrl, @ParameterValueKeyProvider(order=1) String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        String path = "proImgStorage/";
        ArrayList list = new ArrayList();
        PageLinkEntity query = new PageLinkEntity();
        query.setPageLink(pageUrl);
        query.setActiveType(activeEntity.getActiveType());
        PageLinkEntity pageLinkEntity = (PageLinkEntity)this.pageLinkInterface.getSingle(query, 0L);
        List<Object> tempList = new ArrayList();
        tempList = pageLinkEntity != null && pageLinkEntity.getLinkId() != null ? this.picInterface.getProductPics(String.valueOf(pageLinkEntity.getLinkId()), ProductPicTypeEnum.ACT_HEAD.getValue()) : this.picInterface.getPicList(activeEntity.getActiveNo());
        List<Object> picEntities = tempList;
        if (CollectionUtils.isNotEmpty(picEntities)) {
            String url = "";
            ArrayList<ActivePicLinkVo> picUrlList = new ArrayList<ActivePicLinkVo>();
            if (CollectionUtils.isNotEmpty(picEntities)) {
                for (MallProductPicEntity mallProductPicEntity : picEntities) {
                    ActivePicLinkVo activePicLinkVo = new ActivePicLinkVo();
                    url = mallProductPicEntity.getFullRelativeUrl();
                    if (url == null || url.isEmpty()) {
                        mallProductPicEntity.setFullRelativeUrl(path + mallProductPicEntity.getPicAddr() + "_O." + mallProductPicEntity.getExpName());
                    }
                    activePicLinkVo.setPicUrl(mallProductPicEntity.getFullRelativeUrl());
                    this.logger.info("\u67e5\u8be2\u53c2\u6570:{},{}", (Object)mallProductPicEntity.getPicId(), (Object)"picLink");
                    ActivePropertyEntity activePropertyEntity = this.activePropertyInterface.getActiveProperty(mallProductPicEntity.getPicId(), "picLink");
                    if (activePropertyEntity != null) {
                        activePicLinkVo.setPicLink(activePropertyEntity.getPropertyValue());
                        activePicLinkVo.setType(ActivePicPropertyEnum.getValue(activePropertyEntity.getPropertyRemark()));
                        activePicLinkVo.setTypeName(activePropertyEntity.getPropertyRemark());
                        activePicLinkVo.setPicLink(activePropertyEntity.getPropertyValue());
                    } else {
                        activePicLinkVo.setType(0);
                        activePicLinkVo.setTypeName("\u65e0");
                    }
                    activePicLinkVo.setRemark("");
                    picUrlList.add(activePicLinkVo);
                }
            }
            return BaseJsonVo.success(picUrlList);
        }
        return BaseJsonVo.success(list);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActivePageVo", expiration=240)
    public BaseJsonVo<ActivePageVo> getActivePageVo(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        ActivePageVo activePageVo = new ActivePageVo();
        BeanUtils.copyProperties((Object)activeEntity, (Object)activePageVo);
        ActiveIndexEntity query = new ActiveIndexEntity();
        query.setActiveNo(activeEntity.getActiveNo());
        ActivePageEntity activePageEntity = this.activePageInterface.getActivePageEntityByActiveNo(activeEntity.getActiveNo());
        if (activePageEntity != null) {
            activePageVo.setActiveUrl(activePageEntity.getActiveUrl());
        }
        return BaseJsonVo.success((Object)activePageVo);
    }

    @Override
    public Integer getPrepayType(String activeNo) {
        return this.activeMapper.getPrepayType(activeNo);
    }

    @Override
    public int getOrderSourceByActiveType(Integer activeType) {
        int orderSource = 0;
        switch (activeType) {
            case 11: {
                orderSource = 7;
                break;
            }
            case 23: {
                orderSource = 14;
                break;
            }
            case 22: {
                orderSource = 22;
                break;
            }
            case 6: {
                orderSource = 6;
                break;
            }
            case 19: {
                orderSource = 21;
                break;
            }
            case 20: {
                orderSource = 20;
                break;
            }
            case 21: {
                orderSource = 19;
                break;
            }
            case 18: {
                orderSource = 23;
                break;
            }
            case 24: {
                orderSource = 24;
                break;
            }
            case 27: {
                orderSource = 27;
                break;
            }
            case 33: {
                orderSource = 35;
                break;
            }
            case 34: {
                orderSource = 27;
                break;
            }
            case 35: {
                orderSource = 27;
                break;
            }
            case 36: {
                orderSource = 27;
                break;
            }
            case 43: {
                orderSource = 41;
                break;
            }
            case 45: {
                orderSource = 44;
                break;
            }
            default: {
                orderSource = 0;
            }
        }
        return orderSource;
    }

    @Override
    public BaseJsonVo saveActive(ActiveEntity active) {
        BaseJsonVo result = this.checkSaveActive(active);
        if (result.isSuccess()) {
            this.removeCache(active);
            if (StringUtils.isEmpty((String)active.getActiveNo())) {
                boolean temp;
                active.setActiveNo(IDGenerate.getUniqueIdStr());
                active.setCreateTime(DateUtils.now());
                if (active.getKeywordId() == null) {
                    active.setKeywordId(0);
                }
                if (active.getPayKeywordId() == null) {
                    active.setPayKeywordId(0);
                }
                if (active.getPayamount() == null) {
                    active.setPayamount(new BigDecimal(0));
                }
                if (StringUtils.isEmpty((String)active.getVipRightType())) {
                    active.setVipRightType("0");
                }
                active.setBindCode(IDGenerate.getUniqueIdStr());
                active.setPlatformGroupId(this.platFormService.getPlatFormGroupId(active.getPlatformId()));
                boolean bl = temp = this.activeMapper.insert(active) >= 1;
                if (!temp) {
                    result.setError_msg("\u6d3b\u52a8\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    return result;
                }
                result.setValue((Object)active);
            } else {
                return this.activeMapper.updateByPrimaryKeySelective(active) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            }
        }
        return result;
    }

    private BaseJsonVo checkSaveActive(ActiveEntity active) {
        if (StringUtils.isEmpty((String)active.getActiveName())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u4e3a\u7a7a");
        }
        if (active.getBeginTime() == null) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (active.getEndTime() == null) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (active.getEndTime().before(active.getBeginTime())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        ActiveEntity tempActiveNo = new ActiveEntity();
        tempActiveNo.setActiveNo(active.getActiveNo());
        tempActiveNo.setActiveName(active.getActiveName());
        if (StringUtils.isEmpty((String)active.getActiveNo())) {
            if (this.activeMapper.existsActiveName(tempActiveNo) >= 1) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u5df2\u5b58\u5728");
            }
            if (active.getActiveType() == -1) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
            }
            if (active.getPlatformId() <= 0) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5e73\u53f0");
            }
        } else if (this.activeMapper.existsActiveNameByActiveNo(tempActiveNo) >= 1) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u540d\u5df2\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.checkActiveEnable", expiration=300)
    public BaseJsonVo checkActiveEnable(@ParameterValueKeyProvider String activeNo) {
        ActiveEntity activeEntity = this.getActiveEntityByActiveNo(activeNo);
        return this.checkActiveEnable(activeEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.checkActiveEnableByBindCode", expiration=300)
    public BaseJsonVo checkActiveEnableByBindCode(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity = this.getActiveEntityByQrcode(bindCode);
        return this.checkActiveEnable(activeEntity);
    }

    @Override
    public BaseJsonVo checkActiveEnable(ActiveEntity activeEntity) {
        if (activeEntity == null) {
            this.logger.error("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return BaseJsonVo.error((String)"\u672a\u77e5\u6d3b\u52a8");
        }
        if (activeEntity.getBeginTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u672a\u5f00\u59cb."));
        }
        if (activeEntity.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u5df2\u7ed3\u675f."));
        }
        if (activeEntity.getStatus() != 1) {
            return BaseJsonVo.error((String)("\u6d3b\u52a8:" + activeEntity.getActiveName() + "\u672a\u542f\u7528"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveNoByBindCode")
    public String getActiveNoByBindCode(@ParameterValueKeyProvider String bindCode) {
        if (StringUtils.isNotEmpty((String)bindCode)) {
            ActiveEntity activeEntity = this.getActiveEntityByQrcode(bindCode);
            if (activeEntity == null) {
                this.logger.error("\u65e0\u5339\u914d\u8bb0\u5f55,bindcode={}", (Object)bindCode);
                return "";
            }
            return activeEntity.getActiveNo();
        }
        this.logger.info("\u53c2\u6570,bindcode\u4e3a\u7a7a");
        return "";
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveEntityByQrcode", expiration=600)
    public ActiveEntity getActiveEntityByQrcode(@ParameterValueKeyProvider String bindCode) {
        if (StringUtils.isEmpty((String)bindCode)) {
            this.logger.info("\u67e5\u8be2bindcode\u4e3a\u7a7a");
            return null;
        }
        this.logger.info("bindCode={}", (Object)bindCode);
        if (bindCode.length() >= 32) {
            ActiveQrcodeEntity qrcode = this.activeQrcodeInterface.getActiveQrcode(bindCode);
            if (qrcode != null) {
                return (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)qrcode.getActiveNo()));
            }
            return null;
        }
        ActiveEntity activeEntity = new ActiveEntity();
        activeEntity.setBindCode(bindCode);
        return (ActiveEntity)this.activeMapper.getSingle(activeEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveListByQrcode", expiration=300)
    public List<ActiveEntity> getActiveListByQrcode(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity query = new ActiveEntity();
        query.setParentBindCode(bindCode);
        return this.activeMapper.getList(query);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveEntityByActiveNo")
    public ActiveEntity getActiveEntityByActiveNo(@ParameterValueKeyProvider String activeNo) {
        return (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveCouponByKeyWordId", expiration=300)
    public String getActiveCouponByKeyWordId(@ParameterValueKeyProvider Integer keyWordId) {
        return this.activeMapper.getActiveCouponByKeyWordId(keyWordId);
    }

    @Override
    public BaseJsonVo<Map<String, Object>> getActiveByKeyWordId(Integer keyWordId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (keyWordId == null || keyWordId == 0) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5173\u952e\u5b57");
        }
        ActiveEntity query = new ActiveEntity();
        query.setKeywordId(keyWordId);
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.getSingle(query);
        List<ActiveQrcodeEntity> list = this.activeQrcodeInterface.getQrcodeListByActiveNo(activeEntity.getActiveNo());
        if (list.size() == 0) {
            this.logger.error("\u6d3b\u52a8" + activeEntity.getActiveName() + "\u4e8c\u7ef4\u7801\u6ca1\u6709\u914d\u7f6e");
            return BaseJsonVo.error((String)("\u6d3b\u52a8" + activeEntity.getActiveName() + "\u4e8c\u7ef4\u7801\u6ca1\u6709\u914d\u7f6e"));
        }
        map.put("active", activeEntity);
        map.put("bindCode", list.get(0).getBindCode());
        return BaseJsonVo.success(map);
    }

    @Override
    public boolean deleteActive(String activeNo) {
        ActiveEntity activeEntity = (ActiveEntity)this.activeMapper.selectByPrimaryKey((Serializable)((Object)activeNo));
        this.removeCache(activeEntity);
        return this.activeMapper.deleteByPrimaryKey((Serializable)((Object)activeNo)) >= 1;
    }

    @Override
    @ReadThroughAssignCache(assignedKey="ActiveService.getEnableActiveForOption", namespace="ActiveService", expiration=300)
    public List<ActiveEntity> getEnableActiveForOption() {
        return this.getActiveForOptionByStatus(1, 1000);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveForOptionByStatus", expiration=300)
    public List<ActiveEntity> getActiveForOptionByStatus(@ParameterValueKeyProvider(order=0) Integer status, @ParameterValueKeyProvider(order=1) Integer platformGroupId) {
        return this.activeMapper.getActiveForOptionByStatus(status, platformGroupId);
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveService.getActiveForOption", expiration=300)
    public List<ActiveEntity> getActiveForOption(@ParameterValueKeyProvider Integer platformGroupId) {
        return this.activeMapper.getActiveForOption(platformGroupId);
    }

    @Override
    public PageInfo getActiveList(ActiveQueryVo activeQueryVo) {
        Page page = PageHelper.startPage((int)activeQueryVo.getCurrentPage(), (int)activeQueryVo.getPageSize());
        List<ActiveEntity> list = this.activeMapper.getActiveList(activeQueryVo);
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    @Override
    public boolean updateActive(ActiveEntity activeEntity) {
        this.removeCache(activeEntity);
        return this.activeMapper.updateByPrimaryKeySelective(activeEntity) >= 1;
    }

    public BaseJsonVo buildIndexActiveVo(String activeId, String customerId) {
        BaseJsonVo<IndexActiveVo> baseJsonVo = this.activeInterface.buildIndexActiveVo(activeId);
        if (baseJsonVo.isSuccess()) {
            IndexActiveVo indexActiveVo = (IndexActiveVo)baseJsonVo.getValue();
            ActivePageEntity activePageEntity = this.activePageInterface.getActivePageEntityByActiveNo(activeId);
            if (activePageEntity != null && indexActiveVo.getIsVip() == 1 && !this.vipInterface.checkVipRightByType(customerId, activePageEntity.getVipRightType())) {
                indexActiveVo.setIsShow(0);
            }
        }
        return baseJsonVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="activeInterface.buildIndexActiveVo", expiration=120)
    public BaseJsonVo<IndexActiveVo> buildIndexActiveVo(@ParameterValueKeyProvider String activeId) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(activeId);
        BaseJsonVo baseJsonVo = this.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        IndexActiveVo indexActiveVo = new IndexActiveVo();
        indexActiveVo.setActiveName(activeEntity.getActiveName());
        indexActiveVo.setActiveNo(activeEntity.getActiveNo());
        indexActiveVo.setBeginTime(activeEntity.getBeginTime());
        indexActiveVo.setEndTime(activeEntity.getEndTime());
        indexActiveVo.setIsShow(1);
        indexActiveVo.setBindCode(activeEntity.getBindCode());
        ActivePageEntity activePageEntity = this.activePageInterface.getActivePageEntityByActiveNo(activeId);
        if (activePageEntity != null) {
            indexActiveVo.setUrl(activePageEntity.getActiveUrl());
            indexActiveVo.setVipRightType(Integer.parseInt(activePageEntity.getVipRightType()));
            indexActiveVo.setIsVip(activePageEntity.getIsvip());
        }
        indexActiveVo.setIsvipday(this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        indexActiveVo.setPicMap(this.picInterface.getProductPicUrlMap(activeId, SalesTypeEnum.SALES_ACTIVE.getValue()));
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)activeEntity.getEndTime());
        indexActiveVo.setHour((int)(seconds / 3600L));
        indexActiveVo.setMinute((int)(seconds % 3600L / 60L));
        indexActiveVo.setSecond((int)(seconds % 3600L % 60L));
        indexActiveVo.setSeconds(seconds);
        indexActiveVo.setItemType(SalesTypeEnum.SALES_ACTIVE.getValue());
        return BaseJsonVo.success((Object)indexActiveVo);
    }

    private BaseJsonVo<IndexActiveVo> setShowStatus(IndexActiveVo indexActiveVo, String customerId, ActivePageEntity activePageEntity) {
        return BaseJsonVo.success((Object)indexActiveVo);
    }

    @Override
    public BaseJsonVo buildIndexActiveVoByBindCode(String bindCode, String customerId) {
        BaseJsonVo baseJsonVo;
        ActiveEntity activeEntity = this.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            activeEntity = this.getActiveEntityByActiveNo(bindCode);
        }
        if (!(baseJsonVo = this.checkActiveEnable(activeEntity)).isSuccess()) {
            return baseJsonVo;
        }
        IndexActiveVo indexActiveVo = new IndexActiveVo();
        indexActiveVo.setActiveName(activeEntity.getActiveName());
        indexActiveVo.setActiveNo(activeEntity.getActiveNo());
        indexActiveVo.setBeginTime(activeEntity.getBeginTime());
        indexActiveVo.setEndTime(activeEntity.getEndTime());
        indexActiveVo.setIsShow(1);
        indexActiveVo.setBindCode(activeEntity.getBindCode());
        ActivePageEntity activePageEntity = this.activePageInterface.getActivePageEntityByActiveNo(activeEntity.getActiveNo());
        if (activePageEntity != null) {
            if (activePageEntity.getIsvip() == 1 && !this.vipInterface.checkVipRightByType(customerId, activePageEntity.getVipRightType())) {
                indexActiveVo.setIsShow(0);
            }
            indexActiveVo.setUrl(activePageEntity.getActiveUrl());
            indexActiveVo.setVipRightType(Integer.parseInt(activePageEntity.getVipRightType()));
            indexActiveVo.setIsVip(activePageEntity.getIsvip());
        }
        indexActiveVo.setIsvipday(this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        indexActiveVo.setPicMap(this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)activeEntity.getEndTime());
        indexActiveVo.setHour((int)(seconds / 3600L));
        indexActiveVo.setMinute((int)(seconds % 3600L / 60L));
        indexActiveVo.setSecond((int)(seconds % 3600L % 60L));
        indexActiveVo.setSeconds(seconds);
        indexActiveVo.setItemType(SalesTypeEnum.SALES_ACTIVE.getValue());
        return BaseJsonVo.success((Object)indexActiveVo);
    }

    @Override
    public List<MallSelectDataVo> getOptionActiveList(Integer platformGroupId) {
        return this.activeMapper.getOptionActiveList(platformGroupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionActiveList(Integer platformGroupId, Integer[] activeTypes) {
        return this.activeMapper.getOptionActiveListByActiveTypes(platformGroupId, activeTypes);
    }

    @Override
    public List<ActiveEntity> getActiveList4ActiveType(int platformGroupId, int activeType) {
        ActiveEntity activeEntity = new ActiveEntity();
        activeEntity.setPlatformGroupId(platformGroupId);
        activeEntity.setActiveType(activeType);
        return this.activeMapper.getList(activeEntity);
    }

    @Override
    public List<ActiveEntity> getPrepayActiveList() {
        return this.activeMapper.getPrepayActiveList();
    }

    @Override
    public List<ActiveEntity> getPrepayActiveList(int activeType) {
        return this.activeMapper.getPrepayActiveListByActiveType(activeType);
    }

    @Override
    public BaseJsonVo getUserDailyCheckInCount(String bindCode, String customerId) {
        ActiveCheckinEntity checkinEntity = new ActiveCheckinEntity();
        checkinEntity.setBindCode(bindCode);
        checkinEntity.setCustomerId(customerId);
        List checkinEntities = this.checkinMapper.getList(checkinEntity);
        return BaseJsonVo.success((Object)(checkinEntities == null ? 0 : checkinEntities.size()));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BaseJsonVo dailyCheckIn(String bindCode, String customerId, int checkedCount) {
        if (!this.hasChecked(bindCode, customerId).isSuccess()) {
            ActiveCheckinEntity checkinEntity = new ActiveCheckinEntity();
            checkinEntity.setBindCode(bindCode);
            checkinEntity.setCustomerId(customerId);
            checkinEntity.setSn(++checkedCount);
            int insertResult = this.checkinMapper.insert(checkinEntity);
            BaseJsonVo chargeResult = this.accountBalanceService.activeCharge(customerId, bindCode, 10);
            if (!chargeResult.isSuccess()) {
                this.logger.error("\u7528\u6237\u6253\u5361\u53d1\u4f59\u989d\u5931\u8d25[customerId : " + customerId + "][bindCode : " + bindCode + "] : " + chargeResult.getError_msg());
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)chargeResult.getError_msg());
            }
            final CustomerEntity customer = this.customerService.getCustomer(customerId);
            BaseJsonVo result = this.messageService.sendWechatMessage("CHECKIN_AFTER", customerId, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("nickName", customer.getNickName());
                }
            });
            this.logger.info("\u7528\u6237\u6253\u5361\u53d1\u4f59\u989d\u6210\u529f[customerId : " + customerId + "][bindCode : " + bindCode + "]");
        }
        return BaseJsonVo.success((Object)checkedCount);
    }

    @Override
    public BaseJsonVo hasChecked(String bindCode, String customerId) {
        List<ActiveCheckinEntity> checkinEntities = this.checkinMapper.getTodayCheckList(bindCode, customerId);
        return checkinEntities == null || checkinEntities.size() == 0 ? BaseJsonVo.error() : BaseJsonVo.success((Object)checkinEntities.size());
    }

    @Override
    public BaseJsonVo canParticipate(String bindCode, String customerId) {
        ActiveQrcodeEntity qrcode = this.activeQrcodeInterface.getQrcode(bindCode);
        ActiveEntity active = this.getActiveEntityByActiveNo(qrcode.getActiveNo());
        if (active.getStatus() == 0) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u5173\u95ed");
        }
        if (active.getBeginTime().after(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5c1a\u672a\u5f00\u59cb");
        }
        if (active.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        BaseJsonVo result = this.canParticipateWithCondition(bindCode, customerId);
        return result;
    }

    @Override
    public BaseJsonVo canParticipateWithCondition(String bindCode, String customerId) {
        Integer checkInCount;
        int MAX_CHECKIN_COUNT = this.activeCheckinRemindInterface.getActiveCheckInMaxCount(bindCode);
        BaseJsonVo countResult = this.getUserDailyCheckInCount(bindCode, customerId);
        if (countResult.isSuccess() && (checkInCount = (Integer)countResult.getValue()) >= MAX_CHECKIN_COUNT) {
            return BaseJsonVo.success((Object)"\u6253\u5361\u5b8c\u6210");
        }
        BaseJsonVo hasCheckedTodayResult = this.hasChecked(bindCode, customerId);
        if (hasCheckedTodayResult.isSuccess()) {
            return BaseJsonVo.success((Object)"\u67e5\u770b\u6253\u5361");
        }
        return BaseJsonVo.success((Object)"\u7acb\u5373\u6253\u5361");
    }

    @Override
    public void checkinRemind() {
        List<String> customerIds = this.checkinMapper.findRemindUsers();
        ExecutorService pool = Executors.newCachedThreadPool();
        customerIds.forEach(customerId -> pool.execute(new Runnable((String)customerId){
            final /* synthetic */ String val$customerId;
            {
                this.val$customerId = string;
            }

            @Override
            public void run() {
                BaseJsonVo result = ActiveService.this.messageService.sendWechatMessage("CHECKIN_TEXT_MESSAGE", this.val$customerId, null);
                ActiveService.this.logger.info("\u65e0\u7cd6\u6253\u5361\u63d0\u9192\u7ed3\u679c[" + this.val$customerId + "] : " + JsonUtils.toJson((Object)result, (boolean)true));
            }
        }));
    }

    @Override
    public BaseJsonVo participate(String bindCode, String customerId, Integer remind) {
        ActiveCheckinRemindEntity param = new ActiveCheckinRemindEntity();
        param.setBindCode(bindCode);
        param.setCustomerId(customerId);
        List list = this.activeCheckinRemindInterface.getList(param);
        if (list != null && list.size() > 0 && ((ActiveCheckinRemindEntity)list.get(0)).getRemind().intValue() != remind.intValue()) {
            ActiveCheckinRemindEntity vo = (ActiveCheckinRemindEntity)list.get(0);
            vo.setRemind(remind);
            this.activeCheckinRemindInterface.updateByPrimaryKey(vo);
        } else if (list == null || list.size() == 0) {
            param.setRemind(remind);
            this.activeCheckinRemindInterface.insert(param);
        }
        if (this.mallRedisLock.lock("CHECK_IN_" + customerId, "", 60L, TimeUnit.SECONDS)) {
            BaseJsonVo checkResult = this.canParticipate(bindCode, customerId);
            BaseJsonVo countResult = this.getUserDailyCheckInCount(bindCode, customerId);
            if (!checkResult.isSuccess() || checkResult.isSuccess() && "\u6253\u5361\u5b8c\u6210".equals(checkResult.getValue())) {
                String picUrl = this.activeQrcodeInterface.getDailyCheckInPic(bindCode, (Integer)countResult.getValue());
                this.mallRedisLock.unlock("CHECK_IN_" + customerId);
                checkResult.setValue((Object)picUrl);
                return checkResult;
            }
            BaseJsonVo checkInResult = this.dailyCheckIn(bindCode, customerId, countResult.isSuccess() ? (Integer)countResult.getValue() : 0);
            String picUrl = this.activeQrcodeInterface.getDailyCheckInPic(bindCode, (Integer)checkInResult.getValue());
            this.mallRedisLock.unlock("CHECK_IN_" + customerId);
            return BaseJsonVo.success((Object)picUrl);
        }
        BaseJsonVo countResult = this.getUserDailyCheckInCount(bindCode, customerId);
        String picUrl = this.activeQrcodeInterface.getDailyCheckInPic(bindCode, countResult.isSuccess() ? (Integer)countResult.getValue() + 1 : 1);
        return BaseJsonVo.success((Object)picUrl);
    }

    private void removeCache(ActiveEntity activeEntity) {
        if (activeEntity != null) {
            List<ActiveQrcodeEntity> list;
            this.memcachedService.delete("ActiveService.getActiveEntityByActiveNo", activeEntity.getActiveNo());
            this.memcachedService.delete("ActiveService.getActiveEntityByQrcode", activeEntity.getBindCode());
            this.memcachedService.delete("ActiveService.getActiveNoByBindCode", activeEntity.getBindCode());
            this.memcachedService.delete("ActiveService.checkActiveEnable", activeEntity.getActiveNo());
            if (activeEntity.getKeywordId() != null && activeEntity.getKeywordId() > 0) {
                this.memcachedService.delete("ActiveService.getActiveCouponByKeyWordId", String.valueOf(activeEntity.getKeywordId()));
            }
            if ((list = this.activeQrcodeInterface.getQrcodeListByActiveNo(activeEntity.getActiveNo())) != null && list.size() >= 1) {
                list.forEach(q -> this.memcachedService.delete("ActiveService.getActiveEntityByQrcode", q.getBindCode()));
            }
        }
    }

    @Override
    public BaseJsonVo validateActive(String customerId, String bindCode, String phone, String person, String province, String city, String area, String address) {
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        if (Integer.valueOf(1).equals(activeGiftPropertyInfoVo.getCloseOrderBuy())) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0c\u5173\u95ed\u4e86\u4e0b\u5355\u5165\u53e3\uff1a" + activeGiftPropertyInfoVo.getCloseOrderBuy());
            return BaseJsonVo.error((String)"\u4eca\u65e5\u5df2\u9886\u5b8c");
        }
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        if (this.memcachedService.isExceedCount("validateActive", ip, activeGiftPropertyInfoVo.getIpLimitCount().intValue(), 31536000)) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0cIP\u9a8c\u8bc1\u8d85\u9650\uff1a\u9650\u5236\u6b21\u6570\uff1a" + activeGiftPropertyInfoVo.getIpLimitCount());
            return BaseJsonVo.error((String)"\u4eca\u65e5\u5df2\u9886\u5b8c~");
        }
        int count = this.orderProductInterface.getUserCategoryBuyCount(customerId, Integer.parseInt(activeGiftPropertyInfoVo.getProductCategoryId()));
        if (count > activeGiftPropertyInfoVo.getMiniBuyMilkLimitCount()) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0c\u5fae\u4fe1\u4e0b\u8fc7\u725b\u5976\u8ba2\u5355\u9a8c\u8bc1\u8d85\u9650\uff1a\u9650\u5236\u6b21\u6570\uff1a" + activeGiftPropertyInfoVo.getMiniBuyMilkLimitCount());
            return BaseJsonVo.error((String)"\u4f60\u5df2\u7ecf\u662f\u725b\u5976\u7528\u6237\uff0c\u65e0\u6cd5\u53c2\u4e0e\u6d3b\u52a8");
        }
        count = this.orderProductInterface.getAddressCategoryBuyCount(person, phone, province, city, area, address, Integer.parseInt(activeGiftPropertyInfoVo.getProductCategoryId()));
        if (count > activeGiftPropertyInfoVo.getAddressLimitCount()) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0c\u6536\u8d27\u5730\u5740\u4e0b\u8fc7\u725b\u5976\u8ba2\u5355\u9a8c\u8bc1\u8d85\u9650\uff1a\u9650\u5236\u6b21\u6570\uff1a" + activeGiftPropertyInfoVo.getAddressLimitCount());
            return BaseJsonVo.error((String)"\u4eca\u65e5\u5df2\u9886\u5b8c~~~");
        }
        BaseJsonVo<Integer> baseJsonVo = this.customerProductInvoke.getCustomerProductOrderNum(phone, "\u5e38\u6e29\u4e73\u54c1");
        if (baseJsonVo.isSuccess() && (Integer)baseJsonVo.getValue() > activeGiftPropertyInfoVo.getAllBuyMilkLimitCount()) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0c\u5168\u6e20\u9053\u4e0b\u8fc7\u725b\u5976\u8ba2\u5355\u9a8c\u8bc1\u8d85\u9650\uff1a\u9650\u5236\u6b21\u6570\uff1a" + activeGiftPropertyInfoVo.getAllBuyMilkLimitCount());
            return BaseJsonVo.error((String)"\u4f60\u5df2\u7ecf\u662f\u725b\u5976\u7528\u6237\uff0c\u65e0\u6cd5\u53c2\u4e0e\u6d3b\u52a8");
        }
        return BaseJsonVo.success((Object)"\u9a8c\u8bc1\u6210\u529f");
    }

    @Override
    public BaseJsonVo validateActive(String customerId, String bindCode, String phone, ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo) {
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        if (Integer.valueOf(1).equals(activeGiftPropertyInfoVo.getCloseOrderBuy())) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0c\u5173\u95ed\u4e86\u4e0b\u5355\u5165\u53e3\uff1a" + activeGiftPropertyInfoVo.getCloseOrderBuy());
            return BaseJsonVo.error((String)"\u4eca\u65e5\u5df2\u9886\u5b8c");
        }
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        if (this.memcachedService.isExceedCount("validateActive", ip, activeGiftPropertyInfoVo.getIpLimitCount().intValue(), 31536000)) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0cIP\u9a8c\u8bc1\u8d85\u9650\uff1a\u9650\u5236\u6b21\u6570\uff1a" + activeGiftPropertyInfoVo.getIpLimitCount());
            return BaseJsonVo.error((String)"\u4eca\u65e5\u5df2\u9886\u5b8c~");
        }
        int count = this.orderProductInterface.getUserCategoryBuyCount(customerId, Integer.parseInt(activeGiftPropertyInfoVo.getProductCategoryId()));
        if (count > activeGiftPropertyInfoVo.getMiniBuyMilkLimitCount()) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0c\u5fae\u4fe1\u4e0b\u8fc7\u725b\u5976\u8ba2\u5355\u9a8c\u8bc1\u8d85\u9650\uff1a\u9650\u5236\u6b21\u6570\uff1a" + activeGiftPropertyInfoVo.getMiniBuyMilkLimitCount());
            return BaseJsonVo.error((String)"\u53c2\u4e0e\u5931\u8d25,\u4ec5\u9650\u65b0\u7528\u6237\u53c2\u4e0e\u5662~~");
        }
        BaseJsonVo<Integer> baseJsonVo = this.customerProductInvoke.getCustomerProductOrderNum(phone, "\u4f4e\u6e29\u4e73\u54c1");
        if (baseJsonVo.isSuccess() && (Integer)baseJsonVo.getValue() > activeGiftPropertyInfoVo.getAllBuyMilkLimitCount()) {
            this.logger.info("\u7528\u6237" + customerId + "\uff0c\u5168\u6e20\u9053\u4e0b\u8fc7\u725b\u5976\u8ba2\u5355\u9a8c\u8bc1\u8d85\u9650\uff1a\u9650\u5236\u6b21\u6570\uff1a" + activeGiftPropertyInfoVo.getAllBuyMilkLimitCount());
            return BaseJsonVo.error((String)"\u53c2\u4e0e\u5931\u8d25,\u4ec5\u9650\u65b0\u7528\u6237\u53c2\u4e0e\u5662~");
        }
        return BaseJsonVo.success((Object)"\u9a8c\u8bc1\u6210\u529f");
    }
}

