/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.invite;

import cc.lechun.active.dao.invite.ActiveInviteDetailMapper;
import cc.lechun.active.dao.invite.ActiveInviteMapper;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailVo;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.invite.RankListBaseVo;
import cc.lechun.active.entity.invite.RankListVo;
import cc.lechun.active.entity.redpackage.RedpackageConfigDetailVo;
import cc.lechun.active.entity.tempCode.FundVo;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerNickVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveInviteService
extends ActiveBaseService
implements ActiveInviteInterface {
    @Autowired
    private ActiveInviteMapper activeInviteMapper;
    @Autowired
    private ActiveInviteDetailMapper activeInviteDetailMapper;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;

    @Override
    public List<CustomerNickVo> getInviteCustomerNickVoList(String bindCode, String customerId) {
        ActiveInviteEntity query = new ActiveInviteEntity();
        query.setBindCode(bindCode);
        query.setCustomerId(customerId);
        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)this.activeInviteMapper.getSingle(query);
        if (activeInviteEntity == null) {
            return new ArrayList<CustomerNickVo>();
        }
        ArrayList<CustomerNickVo> result = new ArrayList<CustomerNickVo>();
        List<ActiveInviteDetailEntity> detailEntityList = this.getInviteDetailList(activeInviteEntity.getInviteId());
        for (ActiveInviteDetailEntity inviteEntity : detailEntityList) {
            CustomerNickVo customerNickVo = new CustomerNickVo();
            CustomerEntity customerEntity = this.customerInterface.getCustomer(inviteEntity.getCustomerId());
            customerNickVo.setHeadImageUrl(customerEntity == null ? "" : customerEntity.getHeadImageUrl());
            customerNickVo.setNickName(customerEntity == null ? "" : customerEntity.getNickName());
            customerNickVo.setStatus(inviteEntity.getStatus());
            customerNickVo.setStatusName(inviteEntity.getStatus() == 1 ? "\u9080\u8bf7\u6210\u529f" : "\u672a\u53c2\u4e0e");
            result.add(customerNickVo);
        }
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="ActiveInviteService.getRankList", expiration=120)
    public PageInfo<RankListVo> getRankList(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) int pageSize, @ParameterValueKeyProvider(order=2) int currentPage) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            this.logger.info("\u6d3b\u52a8bindCode:{} \u6d3b\u52a8\u4e0d\u5b58\u5728", (Object)bindCode);
            return new PageInfo();
        }
        ArrayList<RankListVo> list = new ArrayList<RankListVo>();
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setBindCode(bindCode);
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        page.setOrderBy("INVITE_COUNT desc,INVITE_ID");
        List<ActiveInviteEntity> queryList = this.activeInviteMapper.getRankList(bindCode, activeEntity.getBeginTime());
        if (queryList == null) {
            return new PageInfo();
        }
        int i = 1;
        for (ActiveInviteEntity inviteEntity : queryList) {
            RankListVo rankListVo = new RankListVo();
            CustomerEntity customerEntity = this.customerInterface.getCustomer(inviteEntity.getCustomerId());
            rankListVo.setHeadImageUrl(customerEntity == null ? "" : customerEntity.getHeadImageUrl());
            rankListVo.setNickName(customerEntity == null ? "" : customerEntity.getNickName());
            rankListVo.setRank("NO." + ((currentPage - 1) * pageSize + i++));
            rankListVo.setInviteNum(inviteEntity.getInviteCount());
            ArrayList<String> result = new ArrayList<String>();
            List<ActiveInviteDetailEntity> detailEntityList = this.getInviteDetailList(inviteEntity.getInviteId());
            int flag = 0;
            for (ActiveInviteDetailEntity detailEntity : detailEntityList) {
                if (detailEntity.getStatus() != 1 || ++flag > 5) continue;
                CustomerEntity detailCustomerEntity = this.customerInterface.getCustomer(detailEntity.getAcceptCustomerId());
                result.add(detailCustomerEntity == null ? "" : detailCustomerEntity.getHeadImageUrl());
            }
            rankListVo.setHeadImgList(result);
            list.add(rankListVo);
        }
        PageInfo pg = new PageInfo();
        pg.setList(list);
        pg.setTotal(page.getTotal());
        return pg;
    }

    @Override
    public List<RankListBaseVo> getRankList(String bindCode, String customerId, Integer status) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            this.logger.info("\u6d3b\u52a8bindCode:{} \u6d3b\u52a8\u4e0d\u5b58\u5728", (Object)bindCode);
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        ActiveInviteEntity query = new ActiveInviteEntity();
        query.setBindCode(bindCode);
        query.setCustomerId(customerId);
        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)this.activeInviteMapper.getSingle(query);
        if (activeInviteEntity == null) {
            this.logger.info("\u7528\u6237:{}\u672a\u53c2\u4e0e\u6d3b\u52a8\u6d3b\u52a8:{} ", (Object)customerId, (Object)activeEntity.getActiveName());
            return Collections.emptyList();
        }
        return this.activeInviteDetailMapper.getRankListByCustomerId(activeEntity.getBeginTime(), activeInviteEntity.getInviteId(), status);
    }

    @Override
    public BaseJsonVo updateRechangeStatus(String customerId, String orderMainNo) {
        Integer tiketId = this.activeInviteDetailMapper.getInviteUserTicketId(orderMainNo);
        if (tiketId != null && tiketId > 0) {
            if (this.activeInviteDetailMapper.updateRechangeStatus(orderMainNo, customerId, tiketId) > 0) {
                ActiveInviteDetailEntity temp = new ActiveInviteDetailEntity();
                temp.setTicketId(tiketId);
                temp.setAcceptCustomerId(customerId);
                temp.setIsnew(2);
                ActiveInviteDetailEntity activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(temp);
                if (activeInviteDetailEntity != null) {
                    return BaseJsonVo.success((Object)activeInviteDetailEntity);
                }
            } else {
                this.logger.info("\u975e\u7ea2\u5305\u6d3b\u52a8\u9080\u8bf7\u65b0\u7528\u6237\u4f18\u60e0\u5238\u4e0b\u5355\u7684\u8ba2\u5355:{}", (Object)orderMainNo);
            }
        }
        this.logger.info("\u975e\u62a2\u7ea2\u5305\u65b0\u7528\u6237\u7528\u5238\u4e0b\u7684\u8ba2\u5355:{}", (Object)orderMainNo);
        return BaseJsonVo.error((String)"");
    }

    @Override
    public List<ActiveInviteDetailEntity> getInviteDetailList(String inviteId) {
        ActiveInviteDetailEntity temp = new ActiveInviteDetailEntity();
        temp.setInviteId(inviteId);
        return this.activeInviteDetailMapper.getList(temp);
    }

    @Override
    public List<ActiveInviteDetailEntity> getInviteDetailList(String accessCustomerId, String bindCode) {
        ActiveInviteDetailEntity temp = new ActiveInviteDetailEntity();
        temp.setAcceptCustomerId(accessCustomerId);
        temp.setBindCode(bindCode);
        return this.activeInviteDetailMapper.getList(temp);
    }

    @Override
    public boolean updateInviteNum(String inviteId, Integer num) {
        return this.activeInviteMapper.updateInviteNum(inviteId) >= 1;
    }

    @Override
    public FundVo getFund(String customerId, String bindCode) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setBindCode(bindCode);
        activeInviteEntity.setCustomerId(customerId);
        FundVo fundVo = new FundVo();
        List list = this.activeInviteMapper.getList(activeInviteEntity);
        if (list == null || list.size() == 0) {
            return fundVo;
        }
        list.forEach(c -> {
            fundVo.setLockAmount(c.getUnavailableCount() + fundVo.getLockAmount());
            fundVo.setAmount(c.getBalanceCount() + fundVo.getAmount());
            fundVo.setTakedAmount(c.getUsedCount() + fundVo.getTakedAmount());
        });
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setInviteId(((ActiveInviteEntity)list.get(0)).getInviteId());
        activeInviteDetailEntity.setCustomerId(customerId);
        List detailEntityList = this.activeInviteDetailMapper.getList(activeInviteDetailEntity);
        if (detailEntityList == null || detailEntityList.size() == 0) {
            return fundVo;
        }
        List<String> tempUnfinishList = detailEntityList.stream().filter(d -> d.getFundsStatus() == 0 && d.getStatus() == 1).map(ActiveInviteDetailEntity::getAcceptCustomerId).collect(Collectors.toList());
        fundVo.setUnfinishedUserUrl(new ArrayList<String>());
        if (tempUnfinishList != null && tempUnfinishList.size() >= 1) {
            List<CustomerEntity> unfinishCustomerList = this.customerInterface.getCustomerByCustomerIds(tempUnfinishList);
            ArrayList unfinishList = unfinishCustomerList.stream().filter(d -> d.getStatus() == 1).map(CustomerEntity::getHeadImageUrl).collect(Collectors.toList());
            fundVo.setUnfinishedUserUrl(unfinishList == null ? new ArrayList() : unfinishList);
        }
        fundVo.setFinishedUserUrl(new ArrayList<String>());
        List<String> tempfinishList = detailEntityList.stream().filter(d -> d.getFundsStatus() == 1).map(ActiveInviteDetailEntity::getAcceptCustomerId).collect(Collectors.toList());
        fundVo.setFinishedUserUrl(new ArrayList<String>());
        if (tempfinishList != null && tempfinishList.size() >= 1) {
            List<CustomerEntity> unfinishCustomerList = this.customerInterface.getCustomerByCustomerIds(tempfinishList);
            ArrayList finishList = unfinishCustomerList.stream().filter(d -> d.getStatus() == 1).map(CustomerEntity::getHeadImageUrl).collect(Collectors.toList());
            fundVo.setFinishedUserUrl(finishList == null ? new ArrayList() : finishList);
        }
        return fundVo;
    }

    @Override
    public ActiveInviteDetailEntity getActiveInviteDetailEntity(ActiveInviteDetailEntity queryActiveInviteDetailEntity) {
        return (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryActiveInviteDetailEntity);
    }

    @Override
    public BaseJsonVo getActiveInviteDetailEntity(String thirdTradNo, String orderNo, Date date) {
        ArrayList<ActiveInviteDetailVo> list = new ArrayList<ActiveInviteDetailVo>();
        ActiveInviteDetailVo activeInviteDetailVo = new ActiveInviteDetailVo();
        if (StringUtils.isEmpty((String)orderNo) && StringUtils.isNotEmpty((String)thirdTradNo)) {
            MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByThirdTradeNo(thirdTradNo, date);
            if (orderPayEntity != null) {
                orderNo = orderPayEntity == null ? "" : orderPayEntity.getOrderMainNo();
                this.logger.info("\u6839\u636e\u6d41\u6c34\u53f7\u67e5\u8be2\u7684\u8ba2\u5355\u4e3a:{}", (Object)orderNo);
            } else {
                return BaseJsonVo.error((String)"\u672a\u77e5\u4ea4\u6613\u6d41\u6c34\u53f7\uff0c\u8bf7\u786e\u8ba4\u6d41\u6c34\u53f7\u662f\u6b63\u786e");
            }
        }
        if (StringUtils.isNotEmpty((String)orderNo)) {
            ActiveInviteDetailEntity detailEntity = this.activeInviteDetailMapper.getInviteDetailByOrderNo(orderNo, date);
            if (detailEntity == null) {
                return BaseJsonVo.error((String)"\u9080\u8bf7\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u8ba2\u5355\u53f7\u3001\u6d41\u6c34\u53f7\u662f\u5426\u4e3a\u6d3b\u52a8\u8ba2\u5355");
            }
            ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(detailEntity.getBindCode());
            if (activeEntity != null) {
                activeInviteDetailVo.setActiveEntity(activeEntity);
            }
            if (detailEntity.getCustomerId().equals(detailEntity.getAcceptCustomerId())) {
                activeInviteDetailVo.setSource(new CustomerDetailVo());
            } else {
                CustomerDetailVo source = this.customerInterface.getCustomerDetail(detailEntity.getCustomerId(), 1);
                if (source != null) {
                    source.setCustomerId("http://erpnew.lechun.cc/mall_customer_edit.html?customerid=" + detailEntity.getCustomerId());
                    activeInviteDetailVo.setSource(source);
                }
            }
            activeInviteDetailVo.setActiveInviteDetailEntity(detailEntity);
            list.add(activeInviteDetailVo);
            return BaseJsonVo.success(list);
        }
        return BaseJsonVo.error((String)"\u6d41\u6c34\u53f7\u3001\u8ba2\u5355\u53f7\u5176\u4e2d\u4e00\u9879\u5fc5\u987b\u8f93\u5165");
    }

    @Override
    public ActiveInviteDetailEntity getActiveInviteDetailEntity(String customerId, String bindCode) {
        List tempList;
        ActiveInviteDetailEntity query = new ActiveInviteDetailEntity();
        query.setAcceptCustomerId(customerId);
        query.setBindCode(bindCode);
        List list = this.activeInviteDetailMapper.getList(query);
        if (CollectionUtils.isNotEmpty((Collection)list) && CollectionUtils.isNotEmpty(tempList = list.stream().filter(d -> StringUtils.isNotEmpty((String)d.getCustomerId())).collect(Collectors.toList()))) {
            tempList.sort((d1, d2) -> d2.getInviteDetailId() - d1.getInviteDetailId());
            return (ActiveInviteDetailEntity)tempList.get(0);
        }
        return null;
    }

    public ActiveInviteDetailEntity getActiveInviteDetailEntity(String customerId, String bindCode, String orderMainNo) {
        ActiveInviteDetailEntity query = new ActiveInviteDetailEntity();
        query.setAcceptCustomerId(customerId);
        query.setBindCode(bindCode);
        query.setOrderMainNo(orderMainNo);
        return (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(query);
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(String inviteId) {
        return (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(ActiveInviteEntity queryActiveInviteEntity) {
        return (ActiveInviteEntity)this.activeInviteMapper.getSingle(queryActiveInviteEntity);
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            throw new RuntimeException(baseJsonVo.getMessage());
        }
        return this.getActiveInviteEntity(customerId, bindCode, activeEntity);
    }

    @Override
    public ActiveInviteEntity getActiveInviteEntity(String customerId, String bindCode, ActiveEntity activeEntity) {
        ActiveInviteEntity queryActiveInvite = new ActiveInviteEntity();
        queryActiveInvite.setBindCode(bindCode);
        queryActiveInvite.setCustomerId(customerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(queryActiveInvite);
        if (activeInviteEntity == null) {
            activeInviteEntity = new ActiveInviteEntity();
            activeInviteEntity.setActiveNo(activeEntity.getActiveNo());
            activeInviteEntity.setActiveType(activeEntity.getActiveType());
            activeInviteEntity.setUnavailableCount(0);
            if (activeEntity.getActiveType() == 30 || activeEntity.getActiveType() == 41) {
                activeInviteEntity.setInviteCount(0);
            } else {
                activeInviteEntity.setInviteCount(activeEntity.getInviteNum() != null ? activeEntity.getInviteNum() : 0);
            }
            activeInviteEntity.setUsedCount(0);
            activeInviteEntity.setBalanceCount(0);
            activeInviteEntity.setCreateTime(DateUtils.now());
            activeInviteEntity.setIsPrize(0);
            activeInviteEntity.setActiveQrcodeId(0);
            activeInviteEntity.setBindCode(bindCode);
            activeInviteEntity.setCustomerId(customerId);
            activeInviteEntity.setInviteId(String.valueOf(RandomUtils.generateId()));
            boolean temp = this.activeInviteMapper.insertSelective(activeInviteEntity) >= 1;
            return temp ? activeInviteEntity : null;
        }
        return activeInviteEntity;
    }

    @Override
    public BaseJsonVo saveActiveInvite(ActiveInviteEntity activeInviteEntity) {
        boolean temp = false;
        if (StringUtils.isEmpty((String)activeInviteEntity.getInviteId())) {
            activeInviteEntity.setInviteId(IDGenerate.getUniqueIdStr());
            temp = this.activeInviteMapper.insertSelective(activeInviteEntity) >= 1;
        } else {
            boolean bl = temp = this.activeInviteMapper.updateByPrimaryKeySelective(activeInviteEntity) >= 1;
        }
        if (!temp) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveActiveInvite(MallOrderMainEntity orderMain, ActiveEntity activeEntity, String source) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setBindCode(orderMain.getBindCode());
        singleActiveInviteEntity.setCustomerId(orderMain.getCustomerId());
        ActiveInviteEntity queryActiveInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (queryActiveInviteEntity != null) {
            activeInviteEntity = queryActiveInviteEntity;
            this.logger.info("\u5b58\u5728\u9080\u8bf7\u4eba\u8bb0\u5f55...{}", (Object)activeInviteEntity.toString());
        } else {
            activeInviteEntity.setUnavailableCount(0);
            activeInviteEntity.setBalanceCount(0);
            activeInviteEntity.setInviteCount(0);
            activeInviteEntity.setActiveQrcodeId(0);
            activeInviteEntity.setActiveNo(orderMain.getActiveNo());
            activeInviteEntity.setActiveType(activeEntity.getActiveType());
            activeInviteEntity.setBindCode(orderMain.getBindCode());
            activeInviteEntity.setIsPrize(0);
            activeInviteEntity.setCreateTime(DateUtils.now());
            activeInviteEntity.setUsedCount(0);
            activeInviteEntity.setSubBindCode("");
            activeInviteEntity.setReleaseSystemId("");
            activeInviteEntity.setCustomerId(orderMain.getCustomerId());
        }
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setCustomerId(source == null ? "" : source);
        activeInviteDetailEntity.setBalance(0);
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setIsnew(0);
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setVersionDetailId(orderMain.getVersionDetailId() == null ? orderMain.getVersionDetailId() : "");
        this.logger.info("\u63d0\u4ea4\u8ba2\u5355\u540e\uff0c\u4fdd\u5b58\u6d3b\u52a8\u9080\u8bf7\u8bb0\u5f55{},{}", (Object)activeInviteEntity.toString(), (Object)activeInviteDetailEntity.toString());
        return this.saveActiveInvite(activeInviteEntity, activeInviteDetailEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo saveActiveInvite(ActiveEntity activeEntity, String sourceCustomerId, String bindCode, CustomerDetailVo customerDetailVo, Integer platformId) {
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setActiveNo(activeEntity.getActiveNo());
        singleActiveInviteEntity.setCustomerId(sourceCustomerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (activeInviteEntity == null) {
            this.logger.info("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,customerId={}", (Object)sourceCustomerId);
            throw new RuntimeException("\u672a\u77e5\u9080\u8bf7\u7528\u6237");
        }
        this.activeInviteMapper.updateActiveInviteNum(activeInviteEntity.getInviteId());
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setAcceptCustomerId(customerDetailVo.getCustomerId());
        activeInviteDetailEntity.setCustomerId(sourceCustomerId);
        activeInviteDetailEntity.setOrderMainNo("");
        activeInviteDetailEntity.setBalance(0);
        activeInviteDetailEntity.setInviteId(activeInviteEntity.getInviteId());
        activeInviteDetailEntity.setBindCode(activeInviteEntity.getBindCode());
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setStatus(1);
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setVersionDetailId("");
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setIsnew(1);
        activeInviteDetailEntity.setCreateTime(DateUtils.now());
        return this.saveActiveInviteDetail(activeInviteDetailEntity);
    }

    @Override
    public BaseJsonVo saveActiveInvite(String sourceCustomerId, String bindCode, CustomerDetailVo customerDetailVo) {
        return this.saveActiveInvite(sourceCustomerId, bindCode, customerDetailVo.getCustomerId());
    }

    @Override
    public BaseJsonVo saveActiveInvite(String sourceCustomerId, String bindCode, String customerId) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        return this.saveActiveInvite(sourceCustomerId, bindCode, customerId, (Integer)0);
    }

    @Override
    public BaseJsonVo saveActiveInvite(String sourceCustomerId, ActiveEntity activeEntity, String customerId) {
        return this.saveActiveInvite(sourceCustomerId, activeEntity, customerId, (Integer)0);
    }

    @Override
    public BaseJsonVo saveActiveInvite(String sourceCustomerId, String bindCode, String customerId, Integer status) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        return this.saveActiveInvite(sourceCustomerId, activeEntity, customerId, status);
    }

    @Override
    public BaseJsonVo saveActiveInvite(String sourceCustomerId, ActiveEntity activeEntity, String customerId, Integer status) {
        this.logger.info("\u8bb0\u5f55\u6d3b\u52a8:{}\u7528\u6237:{}\u9080\u8bf7\u7528\u6237:{}", new Object[]{activeEntity.getActiveName(), sourceCustomerId, customerId});
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setActiveNo(activeEntity.getActiveNo());
        singleActiveInviteEntity.setCustomerId(sourceCustomerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (activeInviteEntity == null) {
            activeInviteEntity = this.getActiveInviteEntity(sourceCustomerId, activeEntity.getBindCode(), activeEntity);
        }
        ActiveInviteDetailEntity queryDetail = new ActiveInviteDetailEntity();
        queryDetail.setAcceptCustomerId(customerId);
        queryDetail.setInviteId(activeInviteEntity.getInviteId());
        ActiveInviteDetailEntity sigleDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryDetail);
        if (sigleDetailEntity == null) {
            ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
            activeInviteDetailEntity.setAcceptCustomerId(customerId);
            activeInviteDetailEntity.setCustomerId(sourceCustomerId);
            activeInviteDetailEntity.setOrderMainNo("");
            activeInviteDetailEntity.setBalance(0);
            activeInviteDetailEntity.setInviteId(activeInviteEntity.getInviteId());
            activeInviteDetailEntity.setBindCode(activeInviteEntity.getBindCode());
            activeInviteDetailEntity.setReleaseSystemId("");
            activeInviteDetailEntity.setIp("");
            activeInviteDetailEntity.setStatus(status);
            activeInviteDetailEntity.setSubBindCode("");
            activeInviteDetailEntity.setVersionDetailId("");
            activeInviteDetailEntity.setFundsStatus(0);
            activeInviteDetailEntity.setIsnew(0);
            activeInviteDetailEntity.setCreateTime(DateUtils.now());
            this.logger.info("\u8bb0\u5f55\u6d3b\u52a8:{}\u7528\u6237:{}\u9080\u8bf7\u7528\u6237:{}\u5df2\u8bb0\u5f55", new Object[]{activeEntity.getActiveName(), sourceCustomerId, customerId});
            this.saveActiveInviteDetail(activeInviteDetailEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo setActiveInviteOrder(String sourceCustomerId, String bindCode, String customerId, String orderMainNo) {
        ActiveInviteDetailEntity activeInviteDetailEntity = null;
        if (StringUtils.isEmpty((String)sourceCustomerId)) {
            activeInviteDetailEntity = this.getActiveInviteDetailEntity(customerId, bindCode);
        } else {
            ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(sourceCustomerId, bindCode);
            if (activeInviteEntity == null) {
                this.logger.info("\u7528\u6237{}\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728, \u8ba2\u5355\u6807\u8bc6\u5931\u8d25", (Object)customerId);
            }
            ActiveInviteDetailEntity queryDetail = new ActiveInviteDetailEntity();
            queryDetail.setAcceptCustomerId(customerId);
            queryDetail.setInviteId(activeInviteEntity.getInviteId());
            activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryDetail);
        }
        if (activeInviteDetailEntity == null) {
            this.logger.info("\u7528\u6237:{}\u9080\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728,\u8ba2\u5355\u6807\u8bc6\u5931\u8d25", (Object)customerId);
            return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u624d\u80fd\u9886\u53d6\u5662~~");
        }
        this.logger.info("\u9080\u8bf7\u660e\u7ec6:{}", (Object)activeInviteDetailEntity.toString());
        activeInviteDetailEntity.setOrderMainNo(orderMainNo);
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(activeInviteDetailEntity);
        this.logger.info("\u7528\u6237:{} \u9080\u8bf7\u4eba:{} \u8ba2\u5355\u53f7:{} \u5df2\u6807\u8bb0", new Object[]{customerId, activeInviteDetailEntity.getCustomerId(), orderMainNo});
        return BaseJsonVo.success((Object)activeInviteDetailEntity.getCustomerId());
    }

    @Override
    public BaseJsonVo setActiveInviteSuccess(String sourceCustomerId, String bindCode, CustomerDetailVo customerDetailVo) {
        return this.setActiveInviteSuccessByCustomerId(sourceCustomerId, bindCode, customerDetailVo.getCustomerId());
    }

    @Override
    public BaseJsonVo setActiveInviteSuccessByCustomerId(String sourceCustomerId, String bindCode, String customerId) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setActiveNo(activeEntity.getActiveNo());
        singleActiveInviteEntity.setCustomerId(sourceCustomerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (activeInviteEntity == null) {
            this.logger.info("reeeeeeeeeee\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,customerId={}", (Object)sourceCustomerId);
            return BaseJsonVo.error((String)("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,customerId=" + sourceCustomerId));
        }
        HashMap map = new HashMap();
        ActiveInviteDetailEntity queryDetail = new ActiveInviteDetailEntity();
        queryDetail.setAcceptCustomerId(customerId);
        queryDetail.setInviteId(activeInviteEntity.getInviteId());
        ActiveInviteDetailEntity sigleDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryDetail);
        if (sigleDetailEntity == null) {
            this.logger.info("reeeeeeeeeee1-1");
            return BaseJsonVo.error((String)("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,customerId=" + sourceCustomerId));
        }
        int code = 1;
        if (sigleDetailEntity.getStatus() == 0) {
            this.activeInviteMapper.updateActiveInviteNum(activeInviteEntity.getInviteId());
            if (activeInviteEntity.getInviteCount() >= activeEntity.getInviteNum()) {
                this.logger.info("reeeeeeeeeee1-2");
                code = 0;
            }
            ActiveInviteDetailEntity updateDetail = new ActiveInviteDetailEntity();
            updateDetail.setInviteDetailId(sigleDetailEntity.getInviteDetailId());
            updateDetail.setStatus(1);
            this.activeInviteDetailMapper.updateByPrimaryKeySelective(updateDetail);
        } else {
            this.logger.info("reeeeeeeee\u7528\u6237:{},bindCode={},\u9080\u8bf7\u4eba:{},\u9080\u8bf7\u6210\u529f\u8bb0\u5f55\u5df2\u5b58\u5728", new Object[]{customerId, bindCode, sourceCustomerId});
            code = 0;
        }
        return BaseJsonVo.success((Object)code);
    }

    @Override
    public BaseJsonVo setActiveInviteSuccessByCustomerId(String bindCode, String customerId, Integer status) {
        this.logger.info("bindCode={},customerId={},sourceCustomerId:{}", new Object[]{bindCode, customerId, ""});
        ActiveInviteDetailEntity queryDetail = new ActiveInviteDetailEntity();
        queryDetail.setAcceptCustomerId(customerId);
        queryDetail.setBindCode(bindCode);
        ActiveInviteDetailEntity activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryDetail);
        if (activeInviteDetailEntity == null || activeInviteDetailEntity.getInviteDetailId() == null) {
            this.logger.info("\u7528\u6237:{}\u9080\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728,\u66f4\u65b0\u9080\u8bf7\u5931\u8d25", (Object)customerId);
            return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u624d\u80fd\u9886\u53d6\u5662~~");
        }
        if (activeInviteDetailEntity.getStatus() == status) {
            return BaseJsonVo.success((Object)activeInviteDetailEntity.getInviteId());
        }
        this.logger.info("\u9080\u8bf7\u660e\u7ec6:{}", (Object)activeInviteDetailEntity.toString());
        boolean temp = this.activeInviteMapper.updateActiveInviteNum(activeInviteDetailEntity.getInviteId()) > 0;
        this.logger.info("\u9080\u8bf7\u4eba:{}\u9080\u8bf7\u6b21\u6570\u66f4\u65b0:{},\u9886\u53d6\u4eba:{}", new Object[]{activeInviteDetailEntity.getCustomerId(), temp, customerId});
        activeInviteDetailEntity.setStatus(status);
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(activeInviteDetailEntity);
        this.logger.info("\u7528\u6237:{},\u6d3b\u52a8:bindCode={},\u9080\u8bf7\u4eba:{} \u9080\u8bf7\u6210\u529f", new Object[]{customerId, bindCode, activeInviteDetailEntity.getCustomerId()});
        return BaseJsonVo.success((Object)activeInviteDetailEntity.getInviteId());
    }

    @Override
    @Transactional
    public BaseJsonVo setActiveInviteSuccess(String bindCode, String customerId, String orderMainNo) {
        this.logger.info("bindCode={},customerId={},\u8ba2\u5355\u53f7:{}", new Object[]{bindCode, customerId, orderMainNo});
        ActiveInviteDetailEntity queryDetail = new ActiveInviteDetailEntity();
        queryDetail.setAcceptCustomerId(customerId);
        queryDetail.setBindCode(bindCode);
        queryDetail.setOrderMainNo(orderMainNo);
        ActiveInviteDetailEntity activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryDetail);
        if (activeInviteDetailEntity == null || activeInviteDetailEntity.getInviteDetailId() == null) {
            this.logger.info("\u7528\u6237:{}\u9080\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728,\u66f4\u65b0\u9080\u8bf7\u5931\u8d25", (Object)customerId);
            return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u624d\u80fd\u9886\u53d6\u5662~~");
        }
        this.logger.info("\u9080\u8bf7\u660e\u7ec6:{}", (Object)activeInviteDetailEntity.toString());
        boolean temp = this.updateInviteNum(activeInviteDetailEntity.getInviteId(), (Integer)1);
        this.logger.info("\u9080\u8bf7\u4eba:{}\u793c\u7269\u6b21\u6570\u6263\u51cf:{},\u9886\u53d6\u4eba:{}", (Object)activeInviteDetailEntity.getCustomerId(), (Object)customerId);
        activeInviteDetailEntity.setStatus(1);
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(activeInviteDetailEntity);
        this.logger.info("\u7528\u6237:{},\u6d3b\u52a8:bindCode={},\u9080\u8bf7\u4eba:{} \u9080\u8bf7\u6210\u529f", new Object[]{customerId, bindCode, activeInviteDetailEntity.getCustomerId()});
        return BaseJsonVo.success((Object)activeInviteDetailEntity.getCustomerId());
    }

    @Override
    public BaseJsonVo setActiveInviteSuccess4NoOrder(String bindCode, String customerId, String sourceCustomerId) {
        ActiveInviteDetailEntity activeInviteDetailEntity;
        this.logger.info("bindCode={},customerId={},sourceCustomerId:{}", new Object[]{bindCode, customerId, sourceCustomerId});
        ActiveInviteDetailEntity queryDetail = new ActiveInviteDetailEntity();
        queryDetail.setAcceptCustomerId(customerId);
        queryDetail.setBindCode(bindCode);
        if (StringUtils.isNotEmpty((String)sourceCustomerId)) {
            queryDetail.setCustomerId(sourceCustomerId);
        }
        if ((activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryDetail)) == null || activeInviteDetailEntity.getInviteDetailId() == null) {
            this.logger.info("\u7528\u6237:{}\u9080\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728,\u66f4\u65b0\u9080\u8bf7\u5931\u8d25", (Object)customerId);
            return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u624d\u80fd\u9886\u53d6\u5662~~");
        }
        if (activeInviteDetailEntity.getStatus() >= 1) {
            return BaseJsonVo.success((Object)activeInviteDetailEntity.getCustomerId());
        }
        this.logger.info("\u9080\u8bf7\u660e\u7ec6:{}", (Object)activeInviteDetailEntity.toString());
        boolean temp = this.updateInviteNum(activeInviteDetailEntity.getInviteId(), (Integer)1);
        this.logger.info("\u9080\u8bf7\u4eba:{}\u793c\u7269\u6b21\u6570\u6263\u51cf:{},\u9886\u53d6\u4eba:{}", (Object)activeInviteDetailEntity.getCustomerId(), (Object)customerId);
        activeInviteDetailEntity.setStatus(1);
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(activeInviteDetailEntity);
        this.logger.info("\u7528\u6237:{},\u6d3b\u52a8:bindCode={},\u9080\u8bf7\u4eba:{} \u9080\u8bf7\u6210\u529f", new Object[]{customerId, bindCode, activeInviteDetailEntity.getCustomerId()});
        return BaseJsonVo.success((Object)activeInviteDetailEntity.getCustomerId());
    }

    @Override
    public BaseJsonVo<ActiveInviteEntity> saveActiveInvite(ActiveEntity activeEntity, String bindCode, String customerId, Integer platformId) {
        ActiveInviteEntity singleActiveInviteEntity = new ActiveInviteEntity();
        singleActiveInviteEntity.setActiveNo(activeEntity.getActiveNo());
        singleActiveInviteEntity.setCustomerId(customerId);
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(singleActiveInviteEntity);
        if (activeInviteEntity == null) {
            this.logger.info("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,customerId={}", (Object)customerId);
            return this.saveActiveInvite(activeEntity, bindCode, customerId);
        }
        return BaseJsonVo.success((Object)activeInviteEntity);
    }

    @Override
    public BaseJsonVo saveActiveInviteByOpenId(ActiveEntity activeEntity, String bindCode, String openId, Integer platformId) {
        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetailByOpenid(openId, platformId);
        if (customerDetailVo == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4fe1\u606f\u6709\u8bef");
        }
        return this.saveActiveInvite(activeEntity, bindCode, customerDetailVo.getCustomerId(), platformId);
    }

    @Override
    public BaseJsonVo saveActiveInvite(ActiveEntity activeEntity, String bindCode, String customerId) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setInviteId(IDGenerate.getUniqueIdStr());
        activeInviteEntity.setActiveNo(activeEntity.getActiveNo());
        activeInviteEntity.setVersionDetailId("");
        activeInviteEntity.setActiveType(activeEntity.getActiveType());
        activeInviteEntity.setReleaseSystemId("");
        activeInviteEntity.setCustomerId(customerId);
        activeInviteEntity.setSubBindCode("");
        activeInviteEntity.setCreateTime(DateUtils.now());
        activeInviteEntity.setIsPrize(0);
        activeInviteEntity.setBindCode(bindCode);
        activeInviteEntity.setBalanceCount(0);
        activeInviteEntity.setInviteCount(activeEntity.getActiveType() == 2 ? (activeEntity.getInviteNum() == null ? 0 : activeEntity.getInviteNum()) : 0);
        activeInviteEntity.setUnavailableCount(0);
        activeInviteEntity.setActiveQrcodeId(0);
        activeInviteEntity.setUsedCount(0);
        return this.activeInviteMapper.insertSelective(activeInviteEntity) >= 1 ? BaseJsonVo.success((Object)activeInviteEntity) : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveInviteByInviteId(MallOrderMainEntity orderMain, ActiveEntity activeEntity, String inviteId) {
        return this.saveActiveInviteByInviteId(orderMain, activeEntity, inviteId, 0);
    }

    @Override
    public BaseJsonVo saveActiveInviteByInviteId(MallOrderMainEntity orderMain, ActiveEntity activeEntity, String inviteId, Integer amount) {
        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)inviteId));
        if (activeInviteEntity == null) {
            this.logger.error("\u9080\u8bf7\u4eba\u8bb0\u5f55\u4e0d\u5b58\u5728,InviteId={}", (Object)inviteId);
            throw new RuntimeException("\u9080\u8bf7\u8bb0\u5f55\u6709\u8bef");
        }
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setInviteId(inviteId);
        activeInviteDetailEntity.setCreateTime(DateUtils.now());
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setCustomerId(activeInviteEntity.getCustomerId());
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setIsnew(0);
        activeInviteDetailEntity.setBalance(amount);
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setFundsStatus(0);
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setVersionDetailId(orderMain.getVersionDetailId() == null ? orderMain.getVersionDetailId() : "");
        this.logger.info("\u63d0\u4ea4\u8ba2\u5355\u540e\uff0c\u4fdd\u5b58\u6d3b\u52a8\u9080\u8bf7\u8bb0\u5f55{},{}", (Object)activeInviteEntity.toString(), (Object)activeInviteDetailEntity.toString());
        return this.activeInviteDetailMapper.insertSelective(activeInviteDetailEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo saveActiveInvite(ActiveInviteEntity activeInviteEntity, ActiveInviteDetailEntity activeInviteDetailEntity) {
        try {
            if (StringUtils.isEmpty((String)activeInviteDetailEntity.getCustomerId())) {
                if (StringUtils.isEmpty((String)activeInviteEntity.getInviteId())) {
                    boolean temp;
                    activeInviteEntity.setInviteId(RandomUtils.generateStrId());
                    activeInviteEntity.setPrizeTime(DateUtils.now());
                    activeInviteEntity.setVersionDetailId("");
                    this.logger.info("\u5f00\u59cb\u5199\u5165\u9080\u8bf7\u4eba\u8bb0\u5f55...{}", (Object)activeInviteEntity.toString());
                    boolean bl = temp = this.activeInviteMapper.insert(activeInviteEntity) >= 1;
                    if (temp) {
                        this.logger.info("\u9080\u8bf7\u8bb0\u5f55\u5199\u5165\u6210\u529f:{}", (Object)activeInviteEntity.toString());
                    } else {
                        this.logger.info("\u9080\u8bf7\u8bb0\u5f55\u5199\u5165\u5931\u8d25 :{}", (Object)activeInviteEntity.toString());
                    }
                }
                activeInviteDetailEntity.setCustomerId(activeInviteEntity.getCustomerId());
            } else {
                this.logger.info("\u901a\u8fc7\u9080\u8bf7\u4eba\u4e0b\u5355...{}", (Object)activeInviteDetailEntity.toString());
                ActiveInviteEntity queryInvite = new ActiveInviteEntity();
                queryInvite.setCustomerId(activeInviteDetailEntity.getCustomerId());
                queryInvite.setBindCode(activeInviteEntity.getBindCode());
                ActiveInviteEntity temp = this.getActiveInviteEntity(queryInvite);
                if (temp == null) {
                    this.logger.error("\u67e5\u8be2\u9080\u8bf7\u4ebaid\u65f6\u51fa\u9519");
                    throw new RuntimeException("\u9080\u8bf7\u51fa\u9519");
                }
                activeInviteDetailEntity.setInviteId(temp.getInviteId());
                if (StringUtils.isEmpty((String)activeInviteEntity.getInviteId())) {
                    activeInviteEntity.setInviteId(RandomUtils.generateStrId());
                    int k = this.activeInviteMapper.insertSelective(activeInviteEntity);
                    if (k <= 0) {
                        throw new RuntimeException("\u9080\u8bf7\u8bb0\u5f55\u5199\u5165\u5931\u8d25");
                    }
                }
            }
            if (StringUtils.isEmpty((String)activeInviteDetailEntity.getInviteId())) {
                activeInviteDetailEntity.setInviteId(activeInviteEntity.getInviteId());
            }
            activeInviteDetailEntity.setCreateTime(DateUtils.now());
            activeInviteDetailEntity.setStatus(0);
            this.logger.info("\u5f00\u59cb\u5199\u5165\u9080\u8bf7\u8bb0\u5f55\u660e\u7ec6:{}", (Object)activeInviteDetailEntity.toString());
            int k = this.activeInviteDetailMapper.insert(activeInviteDetailEntity);
            if (k <= 0) {
                throw new RuntimeException("\u9080\u8bf7\u8bb0\u5f55\u660e\u7ec6\u5199\u5165\u5931\u8d25");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo saveActiveInviteDetail(ActiveInviteDetailEntity activeInviteDetailEntity) {
        boolean temp = false;
        temp = activeInviteDetailEntity.getInviteDetailId() == null ? this.activeInviteDetailMapper.insertSelective(activeInviteDetailEntity) >= 1 : this.activeInviteDetailMapper.updateByPrimaryKeySelective(activeInviteDetailEntity) >= 1;
        return temp ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveActiveInviteDetail(String inviteId, String customerId, String sourceCustomerId, int orderNum, RedpackageConfigDetailVo redpackageConfigVo) {
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setInviteId(inviteId);
        activeInviteDetailEntity.setAcceptCustomerId(customerId);
        activeInviteDetailEntity.setBalance(redpackageConfigVo.getBalance());
        activeInviteDetailEntity.setBindCode(redpackageConfigVo.getBindCode());
        activeInviteDetailEntity.setFundsStatus(redpackageConfigVo.getAmount());
        activeInviteDetailEntity.setCreateTime(DateUtils.now());
        activeInviteDetailEntity.setCustomerId(sourceCustomerId);
        activeInviteDetailEntity.setIp("");
        activeInviteDetailEntity.setStatus(1);
        activeInviteDetailEntity.setIsnew(orderNum == 0 ? 1 : 0);
        activeInviteDetailEntity.setReleaseSystemId("");
        activeInviteDetailEntity.setSubBindCode("");
        activeInviteDetailEntity.setVersionDetailId("");
        return this.saveActiveInviteDetail(activeInviteDetailEntity);
    }

    @Override
    public BaseJsonVo saveActiveInviteDetail(String inviteId, String customerId, String acceptCustomerId, String bindCode, Integer status) {
        ActiveInviteDetailEntity query = new ActiveInviteDetailEntity();
        query.setInviteId(inviteId);
        query.setAcceptCustomerId(acceptCustomerId);
        ActiveInviteDetailEntity result = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(query);
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        if (result != null && result.getInviteDetailId() != null) {
            if (status == 0) {
                return BaseJsonVo.success((Object)"\u5b58\u5728\u9080\u8bf7\u8bb0\u5f55");
            }
            activeInviteDetailEntity.setInviteId(inviteId);
            activeInviteDetailEntity.setAcceptCustomerId(acceptCustomerId);
            activeInviteDetailEntity.setBindCode(bindCode);
            activeInviteDetailEntity.setStatus(status);
            activeInviteDetailEntity.setInviteDetailId(result.getInviteDetailId());
        } else {
            activeInviteDetailEntity.setInviteId(inviteId);
            activeInviteDetailEntity.setAcceptCustomerId(acceptCustomerId);
            activeInviteDetailEntity.setCreateTime(DateUtils.now());
            activeInviteDetailEntity.setCustomerId(customerId);
            activeInviteDetailEntity.setBindCode(bindCode);
            activeInviteDetailEntity.setIp("");
            activeInviteDetailEntity.setIsnew(0);
            activeInviteDetailEntity.setReleaseSystemId("");
            activeInviteDetailEntity.setSubBindCode("");
            activeInviteDetailEntity.setVersionDetailId("");
            activeInviteDetailEntity.setStatus(status);
        }
        if (status == 1) {
            Integer num = this.activeInviteMapper.updateActiveInviteNum(inviteId);
            this.logger.info("\u66f4\u65b0inviteId={}\u9080\u8bf7\u4eba\u6570:{}", (Object)inviteId, (Object)(num >= 1 ? 1 : 0));
        }
        return this.saveActiveInviteDetail(activeInviteDetailEntity);
    }

    @Override
    @Transactional
    public BaseJsonVo addActiveInviteNum(ActiveInviteDetailEntity activeInviteDetailEntity) {
        int num = this.activeInviteDetailMapper.updateActiveInviteDetailInfo(activeInviteDetailEntity);
        if (num == 0) {
            this.logger.info("\u975e\u9080\u8bf7\u8d2d\u4e70\u7528\u6237\uff0c{}", (Object)activeInviteDetailEntity.toString());
            return BaseJsonVo.error((String)"\u66f4\u65b0\u9080\u8bf7\u4eba\u8bb0\u5f55\u51fa\u9519");
        }
        ActiveInviteDetailEntity queryInviteDetail = new ActiveInviteDetailEntity();
        queryInviteDetail.setAcceptCustomerId(activeInviteDetailEntity.getAcceptCustomerId());
        queryInviteDetail.setBindCode(activeInviteDetailEntity.getBindCode());
        queryInviteDetail.setOrderMainNo(activeInviteDetailEntity.getOrderMainNo());
        activeInviteDetailEntity = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(queryInviteDetail);
        if (activeInviteDetailEntity != null) {
            this.logger.info("\u53c2\u4e0e\u4eba\u4fe1\u606f:{}", (Object)activeInviteDetailEntity.toString());
            if (StringUtils.isNotEmpty((String)activeInviteDetailEntity.getAcceptCustomerId()) && StringUtils.isNotEmpty((String)activeInviteDetailEntity.getCustomerId())) {
                if (!activeInviteDetailEntity.getAcceptCustomerId().equals(activeInviteDetailEntity.getCustomerId())) {
                    ActiveInviteEntity updateActiveInvite = (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)activeInviteDetailEntity.getInviteId()));
                    if (updateActiveInvite != null) {
                        num = this.activeInviteMapper.updateActiveInviteNum(updateActiveInvite.getInviteId());
                        if (num == 0) {
                            this.logger.error("\u9080\u8bf7\u4eba \u9080\u8bf7\u8bb0\u5f55\u4eba\u6570\u589e\u52a01 \u51fa\u9519:{}", (Object)activeInviteDetailEntity.toString());
                            return BaseJsonVo.error((String)"\u589e\u52a0\u9080\u8bf7\u6570\u51fa\u9519.");
                        }
                        return BaseJsonVo.success((Object)updateActiveInvite);
                    }
                    this.logger.error("\u67e5\u8be2\u9080\u8bf7\u4eba\u4fe1\u606f\u51fa\u9519:{}", (Object)activeInviteDetailEntity.toString());
                    return BaseJsonVo.error((String)"\u9080\u8bf7\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728.");
                }
                this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u4e2a\u7528\u6237\u4e0d\u5904\u74061,{}", (Object)activeInviteDetailEntity.toString());
            } else {
                this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u4e2a\u7528\u6237\u4e0d\u5904\u74062,{}", (Object)activeInviteDetailEntity.toString());
            }
        }
        return BaseJsonVo.error((String)"\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u4e2a\u7528\u6237");
    }

    @Override
    public BaseJsonVo setPrize(String customerId, String bindCode) {
        int k = this.activeInviteMapper.setPrizeByBindCode(DateUtils.now(), bindCode, customerId);
        return k >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @Override
    public BaseJsonVo updateUnTakedFund(MallOrderMainEntity orderMain) {
        boolean flag;
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        ActiveInviteDetailEntity result = (ActiveInviteDetailEntity)this.activeInviteDetailMapper.getSingle(activeInviteDetailEntity);
        if (result == null) {
            this.logger.info("\u4e0d\u662f\u6709\u6548\u7684\u6d3b\u52a8\u8ba2\u5355. orderNo={}", (Object)orderMain.getOrderMainNo());
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u6d3b\u52a8\u8ba2\u5355");
        }
        boolean bl = flag = result.getAcceptCustomerId() == null || result.getCustomerId() == null || result.getCustomerId().equals(result.getAcceptCustomerId());
        if (flag) {
            this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u7528\u6237\u4e0d\u8ba1\u6570:{}", (Object)result.toString());
            return BaseJsonVo.error((String)"\u4e0d\u7b26\u5408\u9080\u8bf7\u6761\u4ef6");
        }
        ActiveInviteDetailEntity updateInviteDetail = new ActiveInviteDetailEntity();
        updateInviteDetail.setStatus(1);
        updateInviteDetail.setFundsStatus(0);
        updateInviteDetail.setBalance(orderMain.getPayAmount().intValue());
        updateInviteDetail.setInviteDetailId(result.getInviteDetailId());
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(updateInviteDetail);
        BaseJsonVo baseJsonVo = this.activeInviteMapper.updateUnTakedFund(orderMain.getPayAmount().intValue(), result.getInviteId()) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25");
        this.logger.info("\u9080\u8bf7\u57fa\u91d1\u589e\u52a0{},orderNo={}", (Object)baseJsonVo.isSuccess(), (Object)orderMain.getOrderMainNo());
        if (baseJsonVo.isSuccess()) {
            baseJsonVo.setValue((Object)result);
        }
        return baseJsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo updatePrizeFund(String customerId, String bindCode) {
        boolean temp;
        ActiveInviteEntity activeInviteEntity = this.getActiveInviteEntity(customerId, bindCode);
        if (activeInviteEntity.getBalanceCount() < 0) {
            this.logger.info("\u67e5\u8be2\u5230\u65e0\u53ef\u53d6\u57fa\u91d1..customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
            return BaseJsonVo.error((String)"\u65e0\u53ef\u53d6\u57fa\u91d1");
        }
        boolean bl = temp = this.activeInviteMapper.updatePrizeFund(activeInviteEntity.getInviteId(), activeInviteEntity.getBalanceCount()) >= 1;
        if (!temp) {
            this.logger.info("\u57fa\u91d1\u5df2\u63d0\u8d77..customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
            return BaseJsonVo.error((String)"\u57fa\u91d1\u5df2\u63d0\u8d77,\u65e0\u53ef\u53d6\u57fa\u91d1");
        }
        boolean bl2 = temp = this.activeInviteDetailMapper.updateTakedFundStatus(activeInviteEntity.getInviteId()) >= 1;
        if (!temp) {
            this.logger.info("\u8bbe\u7f6e\u9080\u8bf7\u57fa\u91d1\u72b6\u6001\u4e3a\u5df2\u63d0\u8d77\u5931\u8d25..customerId={},bindCode={}", (Object)customerId, (Object)bindCode);
            return BaseJsonVo.error((String)"\u57fa\u91d1\u5df2\u63d0\u8d77,\u65e0\u53ef\u53d6\u57fa\u91d1");
        }
        return BaseJsonVo.success((Object)activeInviteEntity.getBalanceCount());
    }

    @Override
    @Transactional
    public void updateInviteNum(ActiveInviteDetailEntity activeInviteDetailEntity, Integer amount) {
        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)this.activeInviteMapper.selectByPrimaryKey((Serializable)((Object)activeInviteDetailEntity.getInviteId()));
        ActiveInviteEntity updatActiveInviteEntity = new ActiveInviteEntity();
        updatActiveInviteEntity.setInviteId(activeInviteDetailEntity.getInviteId());
        updatActiveInviteEntity.setBalanceCount(activeInviteEntity.getBalanceCount() + amount);
        updatActiveInviteEntity.setUnavailableCount(activeInviteEntity.getUnavailableCount() - amount);
        this.activeInviteMapper.updateByPrimaryKeySelective(updatActiveInviteEntity);
        ActiveInviteDetailEntity updatActiveInviteDetailEntity = new ActiveInviteDetailEntity();
        updatActiveInviteDetailEntity.setInviteDetailId(activeInviteDetailEntity.getInviteDetailId());
        updatActiveInviteDetailEntity.setFundsStatus(1);
        this.activeInviteDetailMapper.updateByPrimaryKeySelective(updatActiveInviteDetailEntity);
    }

    @Override
    public int updateInviteNum2(String inviteId, Integer num) {
        return this.activeInviteMapper.updateInviteNum2(inviteId, num);
    }

    @Override
    public Integer getInviteNum(String customerId, Integer activeType) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setCustomerId(customerId);
        activeInviteEntity.setIsPrize(0);
        activeInviteEntity.setActiveType(activeType);
        List list = this.activeInviteMapper.getList(activeInviteEntity);
        int num = 0;
        if (list != null && list.size() >= 1) {
            for (ActiveInviteEntity ai : list) {
                if (ai.getInviteCount() == null) continue;
                num += ai.getInviteCount().intValue();
            }
        }
        return num;
    }

    @Override
    public Integer getInviteNum(String customerId, String bindCode) {
        ActiveInviteEntity activeInviteEntity = new ActiveInviteEntity();
        activeInviteEntity.setCustomerId(customerId);
        activeInviteEntity.setIsPrize(0);
        activeInviteEntity.setBindCode(bindCode);
        List list = this.activeInviteMapper.getList(activeInviteEntity);
        int num = 0;
        if (list != null && list.size() >= 1) {
            for (ActiveInviteEntity ai : list) {
                if (ai.getInviteCount() == null) continue;
                num += ai.getInviteCount().intValue();
            }
        }
        return num;
    }
}

