/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.redpackage;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.entity.redpackage.ActiveOrderRecordEntity;
import cc.lechun.active.entity.redpackage.RedpackageConfigDetailVo;
import cc.lechun.active.entity.redpackage.RedpackageConfigVo;
import cc.lechun.active.entity.redpackage.TakedRedpackageDetailVo;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveOrderRecordInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.iservice.redpackage.RedpackageInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RedpackageService
extends ActiveBaseService
implements RedpackageInterface {
    @Autowired
    private ActiveOrderRecordInterface activeOrderRecordService;
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Autowired
    private ActiveInviteInterface activeInviteService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ActiveCashticketInterface activeCashticketService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private AccountBalanceInterface balanceService;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;

    @Override
    public BaseJsonVo confirmOrder(MallOrderMainEntity orderMain) {
        BaseJsonVo baseJsonVo = this.activeInviteService.updateRechangeStatus(orderMain.getCustomerId(), orderMain.getOrderMainNo());
        if (baseJsonVo.isSuccess()) {
            ActiveInviteDetailEntity activeInviteDetailEntity = (ActiveInviteDetailEntity)baseJsonVo.getValue();
            this.balanceService.activeCharge(activeInviteDetailEntity.getCustomerId(), activeInviteDetailEntity.getBindCode(), activeInviteDetailEntity.getGiveBalance());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public boolean setTicketId(ActiveInviteDetailEntity activeInviteDetailEntity) {
        List<Integer> ticketIdList = this.activeCashticketService.getCashticketTicketId(activeInviteDetailEntity.getBindCode(), activeInviteDetailEntity.getAcceptCustomerId());
        if (CollectionUtils.isEmpty(ticketIdList)) {
            this.logger.info("\u67e5\u8be2\u9886\u53d6\u4f18\u60e0\u5238ticketId\u51fa\u9519,{}", (Object)activeInviteDetailEntity.toString());
            return false;
        }
        this.logger.info("\u62a2\u7ea2\u5305\u65b0\u7528\u6237\u9886\u53d6\u4f18\u60e0\u5238id={}", (Object)ticketIdList.get(0));
        activeInviteDetailEntity.setIsnew(1);
        ActiveInviteDetailEntity temp = this.activeInviteService.getActiveInviteDetailEntity(activeInviteDetailEntity);
        if (temp == null) {
            this.logger.info("\u67e5\u8be2\u7528\u6237\u9080\u8bf7\u660e\u7ec6\u51fa\u9519,{}", (Object)activeInviteDetailEntity.toString());
            return false;
        }
        ActiveInviteDetailEntity update = new ActiveInviteDetailEntity();
        update.setInviteDetailId(temp.getInviteDetailId());
        update.setTicketId(ticketIdList.get(0));
        update.setGiveBalance(600);
        return this.activeInviteService.saveActiveInviteDetail(update).isSuccess();
    }

    @Override
    @ReadThroughSingleCache(namespace="RedpackageService.getTakedRedpackageRecord", expiration=600)
    public RedpackageConfigVo getTakedRedpackageRecord(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer userType) {
        this.logger.info("bindCode={},userType={}", (Object)bindCode, (Object)userType);
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        List<RedpackageConfigDetailVo> list = this.activeCashticketService.getRedpackageConfigVoList(activeEntity.getActiveNo(), 2, userType);
        if (list != null & list.size() >= 1) {
            return list.stream().filter(c -> bindCode.equals(c.getBindCode())).findFirst().get();
        }
        return null;
    }

    @Override
    public List<TakedRedpackageDetailVo> getTakedRedpackageVoList(String inviteId) {
        ArrayList<TakedRedpackageDetailVo> list = new ArrayList<TakedRedpackageDetailVo>();
        List<ActiveInviteDetailEntity> inviteDetailEntityList = this.activeInviteService.getInviteDetailList(inviteId);
        inviteDetailEntityList.sort((c1, c2) -> c2.getInviteDetailId() - c1.getInviteDetailId());
        if (inviteDetailEntityList != null && inviteDetailEntityList.size() >= 1) {
            inviteDetailEntityList.stream().forEach(d -> {
                TakedRedpackageDetailVo takedRedpackageVo = new TakedRedpackageDetailVo();
                BeanUtils.copyProperties((Object)d, (Object)takedRedpackageVo);
                takedRedpackageVo.setAmount(d.getFundsStatus());
                takedRedpackageVo.setCustomerId(d.getAcceptCustomerId());
                if (d.getBalance() > 0) {
                    takedRedpackageVo.setUserType(d.getCustomerId().equals(d.getAcceptCustomerId()) ? 1 : 2);
                } else {
                    takedRedpackageVo.setUserType(3);
                }
                CustomerEntity customerEntity = this.customerService.getCustomer(d.getAcceptCustomerId());
                takedRedpackageVo.setNickName(customerEntity.getNickName());
                takedRedpackageVo.setHeadImageUrl(customerEntity.getHeadImageUrl());
                takedRedpackageVo.setSay(this.getRedpackageSay());
                takedRedpackageVo.setBalance(d.getBalance());
                list.add(takedRedpackageVo);
            });
        }
        return list;
    }

    @Override
    public Map<String, List<String>> getActivePicList(String orderNo, int type) {
        return this.getActivePicList(orderNo, type, 0);
    }

    private Map<String, List<String>> getActivePicList(String orderNo, int type, int sort) {
        Map<String, List<String>> picUrlMap = this.picInterface.getProductPicUrlMap("3392696440501367443", SalesTypeEnum.SALES_ACTIVE.getValue());
        if (CollectionUtils.isNotEmpty((Collection)picUrlMap.get(ProductPicTypeEnum.ACT_LIST.getName()))) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < 3; ++i) {
                list.add(sort + i * 3);
            }
            int num = new Random().nextInt(list.size());
            sort = (Integer)list.get(num);
        }
        if (picUrlMap.get(ProductPicTypeEnum.ACT_LIST.getName()).size() < sort) {
            this.logger.error("\u7ea2\u5305\u6d3b\u52a8\u56fe\u7247\u914d\u7f6e\u6709\u8bef\uff0c\u56fe\u7247\u914d\u7f6e\u7684\u5f20\u6570\u5c11\u4e8e\u5165\u53e3\u5f20\u6570");
            sort = 0;
        }
        this.logger.info("\u8ba2\u5355:{},\u5c55\u793a\u987a\u5e8f:{}", (Object)orderNo, (Object)sort);
        return this.getActivePicList(picUrlMap, sort, type);
    }

    private Map<String, List<String>> getActivePicList(int sort, int type) {
        Map<String, List<String>> picUrlMap = this.picInterface.getProductPicUrlMap("3392696440501367443", SalesTypeEnum.SALES_ACTIVE.getValue());
        return this.getActivePicList(picUrlMap, sort, type);
    }

    private Map<String, List<String>> getActivePicList(Map<String, List<String>> picUrlMap, int sort, int type) {
        ArrayList<String> list = new ArrayList<String>();
        this.logger.info("\u968f\u673a\u5e8f\u6570:{}", (Object)sort);
        if (type == 1) {
            list.add(picUrlMap.get(ProductPicTypeEnum.ACT_LIST.getName()).get(sort));
            list.add(picUrlMap.get(ProductPicTypeEnum.ACT_LONGPERIOD.getName()).get(sort));
            picUrlMap.put(ProductPicTypeEnum.ACT_HEAD.getName(), list);
        } else if (type == 2) {
            list.add(picUrlMap.get(ProductPicTypeEnum.ACT_SAMLL.getName()).get(sort));
            picUrlMap.put(ProductPicTypeEnum.ACT_SAMLL.getName(), list);
        } else if (type == 3) {
            list.add(picUrlMap.get(ProductPicTypeEnum.ACT_DETAILBIG.getName()).get(sort));
            picUrlMap.put(ProductPicTypeEnum.ACT_SUGGEST.getName(), list);
        }
        return picUrlMap;
    }

    private String getRedpackageSay() {
        String[] arr = "\u8036\uff0c\u62a2\u5230\u4e50\u7eaf\u5976\u7968\u5566\u3002\u9178\u5976\uff0c\u8ba4\u51c6\u4e50\u7eaf\u54d2\u3002\u591a\u8c22\uff01\u5173\u6ce8\u4e50\u7eaf\u5f88\u4e45\u4e86\u3002\u4e50\u7eaf\u9971\u8179\u53c8\u4f4e\u8102\uff0c\u6211\u6700\u7231\u5403\u3002\u54c8\u54c8\uff0c\u4ece\u6b64\u9178\u5976\u5f53\u996d\u5403\u3002\u4e09\u4e09\u4e09\u500d\u7eaf\u51c0\u8425\u517b\uff0c\u503c\u5f97\u62e5\u6709\u3002\u4e0b\u5468\u4efd\u7684\u4e50\u7eaf\uff0c\u6211\u6765\u54af\u3002\u7167\u987e\u597d\u81ea\u5df1\uff0c\u5403\u5403\u5403\u4e50\u7eaf\u3002".split("\u3002");
        int k = new Random().nextInt(arr.length);
        return arr[k];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public BaseJsonVo getInvite(String orderNo, String bindCode, String customerId) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        BaseJsonVo baseJsonVo = this.checkRedpackageShare(orderNo, activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int sort = 0;
        if (this.customerService.checkQiyeweixinContactor(customerId)) {
            this.logger.info("\u7528\u6237:{},\u5df2\u52a0\u8fc7\u4f01\u5fae", (Object)customerId);
            sort = 0;
        } else {
            try {
                BaseJsonVo jsonVo = this.biOrderDetailInvoke.getCustomerValidOrders(customerId);
                this.logger.info("jsonVo\uff08\u67e5BI\u540e\uff09" + JsonUtils.toJson((Object)jsonVo, (boolean)false));
                if (jsonVo.isSuccess()) {
                    Integer orderNum = (Integer)jsonVo.getValue();
                    this.logger.info("\u7528\u6237:{},\u8ba2\u5355\u6570:{}", (Object)customerId, (Object)orderNum);
                    sort = Objects.equals(orderNum, 1) ? 1 : 2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.info("\u7ea2\u5305\u6d3b\u52a8:customerId={}");
        map.put("piclist", this.getActivePicList(orderNo, 1, sort));
        ActiveOrderRecordEntity activeOrderRecordEntity = this.activeOrderRecordService.getActiveOrderRecordEntityByOrderNo(orderNo, activeEntity.getActiveNo());
        if (activeOrderRecordEntity == null) {
            baseJsonVo = this.activeInviteService.saveActiveInvite(activeEntity, bindCode, customerId);
            if (!baseJsonVo.isSuccess()) return BaseJsonVo.error((String)"~\u5662\u54e6\u51fa\u9519\u4e86,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)baseJsonVo.getValue();
            if (!this.activeOrderRecordService.saveActiveOrderRecord(activeEntity.getActiveNo(), activeEntity.getInviteNum(), orderNo, activeInviteEntity.getInviteId())) {
                throw new RuntimeException("~\u5662\u54e6\u51fa\u9519\u4e86,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            map.put("num", activeEntity.getInviteNum());
            map.put("inviteId", activeInviteEntity.getInviteId());
            return BaseJsonVo.success(map);
        } else {
            map.put("num", activeOrderRecordEntity.getNum());
            map.put("inviteId", activeOrderRecordEntity.getInviteId());
        }
        return BaseJsonVo.success(map);
    }

    private BaseJsonVo checkRedpackageShare(String orderNo, ActiveEntity activeEntity) {
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallOrderMainEntity orderMainEntity = this.mallOrderMainService.selectByPrimaryKey(orderNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u8ba2\u5355\u53f7");
        }
        if (orderMainEntity.getOrderClass().intValue() != OrderClassEnum.BUY_CARD_CUT_ORDER.getValue() && (orderMainEntity.getStatus() <= 2 || orderMainEntity.getStatus() >= 20)) {
            return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u5206\u4eab\u7ea2\u5305");
        }
        return baseJsonVo;
    }

    @Override
    @Transactional
    public BaseJsonVo takeRedpackage(String inviteId, String bindCode, String customerId, Integer platFormId) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        BaseJsonVo baseJsonVo = this.checkRedpackage(inviteId, customerId, activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        ActiveInviteEntity activeInviteEntity = (ActiveInviteEntity)baseJsonVo.getValue();
        this.logger.info("\u53d1\u7ea2\u5305\u4fe1\u606f2,inviteId={}:{}", (Object)inviteId, (Object)activeInviteEntity.toString());
        String message = "";
        String inviteKey = inviteId + ":num";
        RedpackageConfigDetailVo redpackageConfigVo = null;
        if (!this.activeInviteService.updateInviteNum(inviteId, (Integer)1)) {
            message = "\u7ea2\u5305\u62a2\u5149\u4e86";
            return new BaseJsonVo(4, "\u7ea2\u5305\u62a2\u5149\u4e86");
        }
        int orderNum = 0;
        CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
        if (customerEntity != null) {
            int n = orderNum = customerEntity.getCurrentOrderCount() != null && customerEntity.getCurrentOrderCount() >= 1 ? 2 : 0;
        }
        int type = orderNum == 0 ? 3 : (customerId.equals(activeInviteEntity.getCustomerId()) ? 1 : 2);
        List<RedpackageConfigDetailVo> configVoList = this.activeCashticketService.getRedpackageConfigVoList(activeEntity.getActiveNo(), 2, type);
        if (configVoList == null || configVoList.size() == 0) {
            this.logger.error("\u7ea2\u5305\u914d\u7f6e\u9519\u8bef,activeNo:{},activeType={},type={}", new Object[]{activeEntity.getActiveNo(), 2, type});
            message = "\u65e0\u6548\u7684\u7ea2\u5305\u914d\u7f6e";
            throw new RuntimeException("\u5662\u54e6~\u65e0\u6548\u7684\u7ea2\u5305");
        }
        this.logger.info("\u53d1\u7ea2\u5305\u7528\u6237:{},\u9886\u53d6\u7ea2\u5305\u7528\u6237:{},\u8ba2\u5355\u6570:{}", new Object[]{activeInviteEntity.getCustomerId(), customerId, orderNum});
        redpackageConfigVo = configVoList.get(new Random().nextInt(configVoList.size()));
        baseJsonVo = this.activeInviteService.saveActiveInviteDetail(inviteId, customerId, activeInviteEntity.getCustomerId(), orderNum, redpackageConfigVo);
        if (!baseJsonVo.isSuccess()) {
            message = "\u7ea2\u5305\u9886\u53d6\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5";
            throw new RuntimeException("\u5662\u54e6~\u7ea2\u5305\u9886\u53d6\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.logger.info("\u5f00\u59cb\u7ed9\u7528\u6237{}\u53d1\u653e\u7ea2\u5305:{}", (Object)customerId, (Object)redpackageConfigVo.toString());
        this.activeCashticketService.sendTicket4BaseAsynchronous(customerId, redpackageConfigVo.getBindCode(), "", platFormId, true);
        String hasRecordKey = customerId + ":" + inviteId;
        this.redisService.save(hasRecordKey, "1");
        String finishKey = customerId + ":" + DateUtils.date() + ":Num";
        this.redisService.increment(finishKey, 1L);
        long takedNum = this.redisService.increment(inviteKey, 1L);
        String canSendFastCouponKey = inviteId + ":SendFastCoupon";
        if (takedNum == 1L) {
            this.redisService.save(canSendFastCouponKey, 1, 86400L);
        }
        this.logger.info("\u7ea2\u5305\u9886\u53d6\u4e2a\u6570:{},\u7ea2\u5305\u603b\u4e2a\u6570:{}", (Object)takedNum, (Object)activeEntity.getInviteNum());
        if (takedNum >= (long)activeEntity.getInviteNum().intValue()) {
            String notHaveKey = inviteId + ":Record";
            this.redisService.save(notHaveKey, "1");
            boolean canSendFastCoupon = false;
            boolean bl = canSendFastCoupon = this.redisService.get(canSendFastCouponKey) != null;
            if (canSendFastCoupon) {
                this.logger.info("24\u5c0f\u65f6\u5185\u7ea2\u5305\u88ab\u9886\u53d6\u5b8c\uff0c\u5956\u52b1\u7528\u6237:{}", (Object)activeInviteEntity.getCustomerId());
                this.activeCashticketService.sendTicket4BaseAsynchronous(activeInviteEntity.getCustomerId(), "e37dc043046c4b82806ae55b80ea73ce", "", platFormId, true);
            }
        }
        if (type == 3) {
            ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
            activeInviteDetailEntity.setInviteId(inviteId);
            activeInviteDetailEntity.setAcceptCustomerId(customerId);
            activeInviteDetailEntity.setCustomerId(activeInviteEntity.getCustomerId());
            activeInviteDetailEntity.setBindCode(redpackageConfigVo.getBindCode());
            activeInviteDetailEntity.setFundsStatus(redpackageConfigVo.getAmount());
            this.messageQueueService.sendTaskMessage(MessageQueueTagEnum.redpackageInvite, MessageParam.messageParam((String)customerId, (Object)activeInviteDetailEntity), 2L);
            this.logger.info("\u65b0\u7528\u6237customerId={}\u9886\u53d6\u7ea2\u5305\u9080\u8bf7\u8bb0\u5f55\u5df2\u63a8\u9001inviteId={}", (Object)customerId, (Object)inviteId);
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo checkRedpackage(String inviteId, String customerId, ActiveEntity activeEntity) {
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        String hasRecordKey = customerId + ":" + inviteId;
        if (this.redisService.get(hasRecordKey) != null) {
            this.logger.info("\u7ea2\u5305\u5df2\u9886\u53d6,inviteId={},\u7528\u6237customerId={}", (Object)inviteId, (Object)customerId);
            return new BaseJsonVo(2, "\u7ea2\u5305\u5df2\u9886\u53d6\u4e86\u5662~");
        }
        String notHaveKey = inviteId + ":Record";
        if (this.redisService.get(notHaveKey) != null) {
            this.logger.info("\u7ea2\u5305\u9886\u53d6\u8bb0\u5f55:{}", this.redisService.get(notHaveKey));
            this.logger.info("\u7ea2\u5305\u62a2\u5149\u4e86,inviteId={},\u7528\u6237customerId={}", (Object)inviteId, (Object)customerId);
            return new BaseJsonVo(4, "\u7ea2\u5305\u62a2\u5149\u4e86");
        }
        String finishKey = customerId + ":" + DateUtils.date() + ":Num";
        if (this.redisService.get(finishKey) != null && (Integer)this.redisService.get(finishKey) >= 5) {
            this.logger.info("\u5f53\u65e5\u7ea2\u5305\u9886\u53d6\u8d85\u8fc7\u9650\u5236,inviteId={},\u7528\u6237customerId={}", (Object)inviteId, (Object)customerId);
            return new BaseJsonVo(7, "\u5f53\u65e5\u7ea2\u5305\u9886\u53d6\u8d85\u8fc7\u9650\u5236");
        }
        ActiveInviteEntity activeInviteEntity = this.activeInviteService.getActiveInviteEntity(inviteId);
        if (activeInviteEntity == null) {
            this.logger.error("inviteId={},customerId={}", (Object)inviteId, (Object)customerId);
            return BaseJsonVo.error((String)"~\u5662\u54e6,\u65e0\u6548\u7684\u7ea2\u5305\u5206\u4eab");
        }
        this.logger.info("\u53d1\u7ea2\u5305\u4fe1\u606f{}:{}", (Object)inviteId, (Object)activeInviteEntity.toString());
        if (activeInviteEntity.getInviteCount() == 0) {
            if (activeInviteEntity.getCreateTime().after(DateUtils.StrToDate((String)"2019-07-02 01:18:23", (String)""))) {
                this.logger.info("\u7ea2\u5305\u62a2\u5149\u4e862,inviteId={},customerId={}", (Object)inviteId, (Object)customerId);
                return new BaseJsonVo(4, "\u7ea2\u5305\u62a2\u5149\u4e86");
            }
            List<ActiveInviteDetailEntity> list = this.activeInviteService.getInviteDetailList(inviteId);
            if (list.size() >= activeEntity.getInviteNum()) {
                this.logger.info("\u7ea2\u5305\u62a2\u5149\u4e863,inviteId={},customerId={}", (Object)inviteId, (Object)customerId);
                return new BaseJsonVo(4, "\u7ea2\u5305\u62a2\u5149\u4e86");
            }
        }
        ActiveInviteDetailEntity temp2 = new ActiveInviteDetailEntity();
        temp2.setAcceptCustomerId(customerId);
        temp2.setInviteId(inviteId);
        ActiveInviteDetailEntity detailEntity = this.activeInviteService.getActiveInviteDetailEntity(temp2);
        if (detailEntity != null) {
            this.logger.info("\u7ea2\u5305\u5df2\u9886\u53d62,inviteId={},\u7528\u6237customerId={}", (Object)inviteId, (Object)customerId);
            return new BaseJsonVo(2, "\u7ea2\u5305\u5df2\u9886\u53d6");
        }
        return BaseJsonVo.success((Object)activeInviteEntity);
    }
}

