/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.refund;

import cc.lechun.active.iservice.refund.RefundInterface;
import cc.lechun.apiinvoke.refund.CsmsRefundInvoke;
import cc.lechun.common.file.OssService;
import cc.lechun.csmsapi.dto.refund.RefundParamDto;
import cc.lechun.csmsapi.dto.refund.RefundProductParamDto;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.trade.DetailOrderGroupMapper;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.entity.trade.DetailOrderGroupEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderProductVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefundService
implements RefundInterface {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private DetailOrderGroupMapper detailOrderGroupMapper;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private OssService ossService;
    @Autowired
    private CsmsRefundInvoke csmsRefundInvoke;

    @Override
    public BaseJsonVo refundInfo(String orderNo, String orderProductNo) {
        HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
        Integer afterSaleType = 1;
        if (StringUtils.isNotEmpty((String)orderProductNo)) {
            afterSaleType = 2;
        }
        rtnMap.put("switchRefundType", Integer.valueOf(afterSaleType == 1 ? 0 : 1));
        ArrayList payRst = new ArrayList();
        if (StringUtils.isNotEmpty((String)orderProductNo)) {
            HashMap<String, String> payMap;
            DetailOrderGroupEntity detailOrderGroupEntity = (DetailOrderGroupEntity)this.detailOrderGroupMapper.selectByPrimaryKey((Serializable)((Object)orderProductNo));
            MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(detailOrderGroupEntity.getOrderMainNo());
            if (mallOrderMainEntity.getOrderSource() == 26 || mallOrderMainEntity.getOrderSource() == 28 || mallOrderMainEntity.getOrderSource() == 29 || mallOrderMainEntity.getOrderSource() == 30 || mallOrderMainEntity.getOrderSource() == 31 || mallOrderMainEntity.getOrderSource() == 32 || mallOrderMainEntity.getOrderSource() == 33 || mallOrderMainEntity.getOrderSource() == 34 || mallOrderMainEntity.getOrderSource() == 35 || mallOrderMainEntity.getOrderSource() == 36 || mallOrderMainEntity.getOrderSource() == 42) {
                return BaseJsonVo.error((String)"\u8bf7\u5728\u6211\u7684\u5361\u5305\u91cc\u53d6\u6d88\u8ba1\u5212");
            }
            if (detailOrderGroupEntity.getWechatPayAmount() != null && detailOrderGroupEntity.getWechatPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                payMap = new HashMap<String, String>();
                payMap.put("payType", "\u5fae\u4fe1\u652f\u4ed8");
                payMap.put("payAmount", detailOrderGroupEntity.getWechatPayAmount().setScale(2, 4).toPlainString());
                payRst.add(payMap);
            }
            if (detailOrderGroupEntity.getBalanceAmount() != null && detailOrderGroupEntity.getBalanceAmount().compareTo(BigDecimal.ZERO) > 0) {
                payMap = new HashMap();
                payMap.put("payType", "\u4f59\u989d\u652f\u4ed8");
                payMap.put("payAmount", detailOrderGroupEntity.getBalanceAmount().setScale(2, 4).toPlainString());
                payRst.add(payMap);
            }
        } else if (StringUtils.isNotEmpty((String)orderNo)) {
            String orderMainNo = this.orderInterface.getmallOrder(orderNo).getOrderMainNo();
            if (StringUtils.isEmpty((String)orderMainNo)) {
                return BaseJsonVo.error((String)"\u65e0\u6cd5\u67e5\u8be2\u8ba2\u5355\u53f7");
            }
            List<MallOrderPayEntity> list = this.orderPayInterface.getList(orderMainNo);
            for (MallOrderPayEntity pay : list) {
                HashMap<String, String> payMap;
                if (pay.getPaytypeId() == 11) {
                    return BaseJsonVo.error((String)"\u5976\u5361\u8ba2\u5355\u4e0d\u652f\u6301\u9000\u6b3e\uff0c\u8bf7\u5230\u6211\u7684\u5361\u5305\u66f4\u6539\u914d\u9001\u8ba1\u5212");
                }
                if (pay.getPaytypeId() == 2) {
                    payMap = new HashMap<String, String>();
                    payMap.put("payType", "\u5fae\u4fe1\u652f\u4ed8");
                    payMap.put("payAmount", pay.getPayamount().toPlainString());
                    payRst.add(payMap);
                }
                if (pay.getPaytypeId() == 8) {
                    payMap = new HashMap();
                    payMap.put("payType", "\u4f59\u989d\u652f\u4ed8");
                    payMap.put("payAmount", pay.getPayamount().toPlainString());
                    payRst.add(payMap);
                }
                if (pay.getPaytypeId() != 3) continue;
                payMap = new HashMap();
                if (afterSaleType == 1) {
                    CashticketEntity cashticket;
                    CashticketCustomerEntity cashticketCustomer = this.cashticketCustomerInterface.getCashticketCustomer(pay.getCashticketId());
                    if (cashticketCustomer != null && (cashticket = this.cashticketInterface.getCashticket(cashticketCustomer.getTicketId())) != null) {
                        payMap.put("payType", "\u4f18\u60e0\u5238");
                        payMap.put("payAmount", cashticket.getTicketName());
                    }
                } else {
                    payMap.put("payType", "\u4f18\u60e0\u5238");
                    payMap.put("payAmount", "\u672a\u53d1\u8d27\u624d\u53ef\u4ee5\u9000\u5662");
                }
                payRst.add(payMap);
            }
        }
        rtnMap.put("pay", payRst);
        ArrayList<String> refundReason = new ArrayList<String>();
        if (afterSaleType == 1) {
            refundReason.add("\u672a\u6536\u5230\u8d27");
            refundReason.add("\u672a\u6309\u7ea6\u5b9a\u65f6\u95f4\u53d1\u8d27");
            refundReason.add("\u62cd\u9519/\u591a\u62cd/\u4e0d\u559c\u6b22");
            refundReason.add("\u5176\u4ed6");
        } else {
            refundReason.add("\u5546\u54c1\u8150\u70c2/\u53d8\u8d28/\u6709\u5f02\u7269");
            refundReason.add("\u5356\u5bb6\u53d1\u9519\u8d27");
            refundReason.add("\u6536\u5230\u5546\u54c1\u5c11\u4ef6/\u7834\u635f\u7b49");
            refundReason.add("\u5176\u4ed6");
        }
        rtnMap.put("refundReason", refundReason);
        return BaseJsonVo.success(rtnMap);
    }

    @Override
    public BaseJsonVo refundApply(String orderNo, String orderProductNo, Integer refundType, String refundReason, String refundRemark, String[] files) throws IOException {
        ArrayList<String> picUrls = new ArrayList<String>();
        if (files != null && files.length > 0) {
            for (String file : files) {
                picUrls.add(file);
            }
        }
        Integer afterSaleType = 1;
        if (StringUtils.isEmpty((String)orderNo)) {
            MallOrderProductEntity orderProductByID = this.orderProductInterface.getOrderProductByID(orderProductNo);
            orderNo = orderProductByID.getOrderNo();
            afterSaleType = 2;
        }
        MallOrderEntity mallOrderEntity = this.orderInterface.getmallOrder(orderNo);
        String orderMainNo = mallOrderEntity.getOrderMainNo();
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        RefundParamDto refundParamDto = new RefundParamDto();
        refundParamDto.setRefundPics(picUrls);
        refundParamDto.setUserName(mallOrderMainEntity.getCustomerId());
        refundParamDto.setOrderMainNo(orderMainNo);
        refundParamDto.setOrderNo(orderNo);
        refundParamDto.setRefundType(String.valueOf(refundType));
        refundParamDto.setRefundReason(refundReason);
        refundParamDto.setRemark(refundRemark);
        List<MallOrderPayEntity> payList = this.orderPayInterface.getList(orderMainNo);
        List couponPays = payList.stream().filter(pay -> pay.getPaytypeId() == 3).collect(Collectors.toList());
        if (couponPays != null && couponPays.size() > 0) {
            refundParamDto.setIsRefundCoupon(afterSaleType.intValue());
        } else {
            refundParamDto.setIsRefundCoupon(2);
        }
        refundParamDto.setOrderSource(mallOrderMainEntity.getOrderSource());
        ArrayList refundProducts = new ArrayList();
        BaseJsonVo<List<OriginOrderProductVO>> originOrderProductResult = this.mallOrderMainInterface.getOriginOrderProduct(orderNo);
        if (originOrderProductResult.isSuccess()) {
            List originOrderProducts = (List)originOrderProductResult.getValue();
            originOrderProducts.forEach(originOrderProduct -> {
                if (StringUtils.isEmpty((String)orderProductNo) || orderProductNo.equals(originOrderProduct.getParentOid())) {
                    RefundProductParamDto refundProduct = new RefundProductParamDto();
                    refundProduct.setOid(originOrderProduct.getOid());
                    refundProduct.setProductId(originOrderProduct.getProductId());
                    refundProduct.setProductName(originOrderProduct.getProductName());
                    refundProduct.setProductNum(String.valueOf(originOrderProduct.getProductNum().intValue()));
                    refundProduct.setProductPrice(originOrderProduct.getProductPrice());
                    refundProduct.setProductRefundAmount(originOrderProduct.getPayAmount());
                    refundProduct.setRefundCashAmountApply(originOrderProduct.getPayWechatPerAmount());
                    refundProduct.setRefundBalanceAmountApply(originOrderProduct.getPayBalancePerAmount());
                    refundProduct.setRefundCashAmountCheck(originOrderProduct.getPayWechatPerAmount());
                    refundProduct.setRefundBalanceAmountCheck(originOrderProduct.getPayBalancePerAmount());
                    refundProduct.setGroupId(originOrderProduct.getSuitId());
                    refundProduct.setGroupName(originOrderProduct.getSuitName());
                    refundProducts.add(refundProduct);
                }
            });
        }
        refundParamDto.setRefundProductList(refundProducts);
        BaseJsonVo baseJsonVo = this.csmsRefundInvoke.refundApplyForWeixin(refundParamDto);
        this.logger.info("\u7528\u6237\u7533\u8bf7\u9000\u6b3e\uff0corderNo={},orderProductNo={},\u53c2\u6570\uff1a{},\u7ed3\u679c\uff1a{}", new Object[]{orderNo, orderProductNo, JsonUtils.toJson((Object)refundParamDto, (boolean)false), JsonUtils.toJson((Object)baseJsonVo, (boolean)false)});
        if (!baseJsonVo.isSuccess()) {
            this.logger.error("\u7528\u6237\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff0corderNo={},orderProductNo={},\u53c2\u6570\uff1a{},\u7ed3\u679c\uff1a{}", new Object[]{orderNo, orderProductNo, JsonUtils.toJson((Object)refundParamDto, (boolean)false), JsonUtils.toJson((Object)baseJsonVo, (boolean)false)});
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo refundCancel(String refundNo) {
        return this.csmsRefundInvoke.refundCancelByCustomer(refundNo);
    }

    @Override
    public BaseJsonVo getRefundInfo(String refundNo) {
        return this.csmsRefundInvoke.getRefundInfo(refundNo);
    }
}

