/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.active.ActiveWhiteInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.active.ActiveBaseService;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;

public class ActiveSaleBase
extends ActiveBaseService {
    @Autowired
    protected ActiveWhiteInterface activeWhiteInterface;
    @Autowired
    protected MallOrderMainInterface orderMainInterface;
    @Autowired
    protected ActiveCashticketInterface activeCashticketService;
    @Autowired
    protected MallOrderInterface mallOrderInterface;
    @Autowired
    protected MessageQueueService messageQueueService;
    @Autowired
    protected ActiveInviteInterface activeInviteService;
    @Autowired
    protected ActiveCustomerInterface activeCustomerService;

    public BaseJsonVo beforeSetCacheCheck(String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo afterCreateOrderBase(MallMainOrderVo mainOrderVo) {
        try {
            ExecutorService pool = Executors.newFixedThreadPool(1);
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(mainOrderVo.getMainOrderNo());
            CompletableFuture<Void> prductCompletableFuture = CompletableFuture.runAsync(() -> this.activeCustomerService.saveActiveCustomerRecord(orderMainEntity), pool);
            pool.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo afterCreateOrderBase(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo, Integer amount) {
        String inviteId = "";
        try {
            if (StringUtils.isNotEmpty((String)mainOrderVo.getMallOrderVos().get(0).getDefineField())) {
                this.logger.info("\u63a5\u53d7:json:{}", (Object)mainOrderVo.getMallOrderVos().get(0).getDefineField());
                if (JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId") != null && StringUtils.isEmpty((String)(inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId").toString()))) {
                    this.logger.info("\u6d3b\u52a8inviteId \u4e3a\u7a7a,\u8ba2\u5355\u53f7:{},\u975e\u9080\u8bf7\u8d2d\u4e70\uff0ccustomerId={}", (Object)mainOrderVo.getMainOrderNo(), (Object)mainOrderVo.getCustomerId());
                }
            } else {
                this.logger.info("\u8ba2\u5355\u53f7:{} \u5b57\u6bb5:inviteId  \u4e3a\u7a7a", (Object)mainOrderVo.getMainOrderNo());
            }
            if (StringUtils.isNotEmpty((String)inviteId)) {
                MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(mainOrderVo.getMainOrderNo());
                ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(orderMain.getActiveNo());
                return this.activeInviteService.saveActiveInviteByInviteId(orderMain, activeEntity, inviteId, amount);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo afterPayBase(MallOrderMainEntity orderMain) {
        try {
            ExecutorService pool = Executors.newFixedThreadPool(1);
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.activeCustomerService.updateActiveCustomerRecord(orderMain), pool);
        }
        catch (Exception e) {
            this.logger.error("\u7528\u6237\u53c2\u4e0e\u6d3b\u52a8\u51fa\u9519:{},{}", (Object)orderMain.getOrderMainNo(), (Object)e.getMessage());
            e.printStackTrace();
        }
        this.logger.info("\u8ba2\u5355:{}\u6570\u636e\u57cb\u70b9\u5b8c\u6210", (Object)orderMain.getOrderMainNo());
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo confirmOrder(MallOrderMainEntity orderMain) {
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo canJoin(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            this.logger.info("\u65e0\u6548\u7684\u6d3b\u52a8, bindCode={}", (Object)bindCode);
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (baseJsonVo.isSuccess()) {
            baseJsonVo.setValue((Object)activeEntity);
        }
        return baseJsonVo;
    }

    public boolean checkIsWhite(String customerId) {
        Boolean isWhile = this.activeWhiteInterface.existsWhiteList(customerId, 1);
        return isWhile != null && isWhile != false;
    }

    public void sendCoupon(String customerId, String bindCode, Integer platFormId) {
        this.activeCashticketService.sendTicket4Base(customerId, bindCode, "", platFormId, true);
    }

    public void collectionActiveOrderData(MallOrderMainEntity orderMain) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(orderMain.getActiveNo());
        if (activeEntity != null) {
            HashMap<String, Object> messageBody = new HashMap<String, Object>();
            messageBody.put("userId", orderMain.getCustomerId());
            messageBody.put("dataFrom", activeEntity.getActiveName());
            messageBody.put("bindCode", orderMain.getBindCode());
            messageBody.put("activeNo", orderMain.getActiveNo());
            messageBody.put("versionName", "\u6d3b\u52a8\u8ba2\u5355\u7edf\u8ba1");
            messageBody.put("createTime", DateUtils.now());
            this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.activeData, MessageParam.messageParam((String)orderMain.getOrderMainNo(), messageBody));
        }
    }

    public void updateOrderComplete(MallOrderMainEntity mallOrderEntity, String orderStatusName) {
        try {
            boolean orderStatus = this.orderMainInterface.updateOrderMainStatus(mallOrderEntity.getOrderMainNo(), orderStatusName, mallOrderEntity.getCustomerId(), OrderStatusEnum.PAYCONFIRM.getValue());
            List<MallOrderEntity> orderEntities = this.mallOrderInterface.getOrderList(mallOrderEntity.getOrderMainNo());
            if (orderEntities != null) {
                for (MallOrderEntity o : orderEntities) {
                    if (this.mallOrderInterface.updateOrderStatus(o.getOrderNo(), orderStatusName, mallOrderEntity.getCustomerId(), OrderStatusEnum.PAYCONFIRM.getValue())) continue;
                    this.logger.error("\u66f4\u65b0\u5b50\u8ba2\u5355\u5931\u8d25,\u8ba2\u5355\u53f7={}", (Object)mallOrderEntity.getOrderMainNo());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BaseJsonVo updateActiveJoinStatus(MallOrderMainEntity orderMain) {
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo refund(MallOrderMainEntity orderMain) {
        return BaseJsonVo.success((Object)"");
    }
}

