/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.active.ActiveCustomerEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.fit.FitInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.vo.FitActiveInviteResultVo;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class BaseFitHandle
extends ActiveSaleBase {
    @Autowired
    protected ActiveCustomerInterface activeCustomerService;
    @Autowired
    protected ActiveInviteInterface activeInviteInterface;
    @Autowired
    protected MessageInterface messageService;
    @Autowired
    protected CustomerInterface customerService;
    @Autowired
    protected FitInterface fitService;
    @Autowired
    private RedisService redisService;

    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        if (!this.checkIsWhite(customerId)) {
            if (this.redisService.sIsMember(bindCode + ":customer", customerId)) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u5df2\u53c2\u4e0e");
            }
            BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            boolean temp = false;
            temp = this.activeCustomerService.getJoinActiveStatus(customerId, bindCode) >= 1;
            this.logger.info("\u63d0\u4ea4\u8ba2\u5355\u524d\u5224\u65ad\u6d3b\u52a8\u662f\u5426\u53c2\u4e0e:{}", (Object)temp);
            return temp ? BaseJsonVo.error((String)"\u554a\u5662~\u6d3b\u52a8\u5df2\u53c2\u4e0e,\u53ea\u80fd\u53c2\u4e0e\u4e00\u6b21\u5662!") : BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Transactional
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        this.logger.info("\u7c7b\u4e94\u5757\u94b1\u6d3b\u52a8\u63d0\u4ea4\u4e86\u8ba2\u5355...");
        String sourceCustomerId = "";
        try {
            sourceCustomerId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("source").toString();
            this.logger.info("\u9080\u8bf7sourceCustomerId={}", (Object)(StringUtils.isNotEmpty((String)sourceCustomerId) ? sourceCustomerId : ""));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(mainOrderVo.getMainOrderNo());
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(orderMain.getActiveNo());
        BaseJsonVo baseJsonVo = this.activeCustomerService.saveActiveCustomerRecord(orderMain, sourceCustomerId, activeEntity);
        if (!baseJsonVo.isSuccess()) {
            throw new RuntimeException("\u5199\u5165\u7528\u6237\u53c2\u4e0e\u8bb0\u5f55\u5931\u8d25");
        }
        if (StringUtils.isNotEmpty((String)sourceCustomerId)) {
            return this.activeInviteInterface.saveActiveInvite(orderMain, activeEntity, sourceCustomerId);
        }
        return BaseJsonVo.success((Object)"");
    }

    @Transactional
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain, Integer keyworldId) {
        this.collectionActiveOrderData(orderMain);
        this.logger.info("\u6570\u636e\u57cb\u70b9\u5b8c\u6210,\u8ba2\u5355\u53f7={}", (Object)orderMain.getOrderMainNo());
        this.updateActiveJoinStatus(orderMain);
        this.logger.info("\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u72b6\u6001\u66f4\u65b0\u5b8c\u6210,\u8ba2\u5355\u53f7={}", (Object)orderMain.getOrderMainNo());
        this.sendCoupon(orderMain.getCustomerId(), orderMain.getBindCode(), orderMain.getPlatformId());
        this.logger.info("\u652f\u4ed8\u540e\u53d1\u653e\u4f18\u60e0\u5238\u5b8c\u6210,\u8ba2\u5355\u53f7={}", (Object)orderMain.getOrderMainNo());
        this.updateOrderComplete(orderMain, OrderStatusEnum.COMPLETION.getName());
        this.logger.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5b8c\u6210,\u8ba2\u5355\u53f7={}", (Object)orderMain.getOrderMainNo());
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(orderMain.getActiveNo());
        this.activeInviteService.saveActiveInvite(activeEntity, orderMain.getBindCode(), orderMain.getCustomerId());
        ActiveInviteDetailEntity activeInviteDetailEntity = new ActiveInviteDetailEntity();
        activeInviteDetailEntity.setStatus(0);
        activeInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
        activeInviteDetailEntity.setBindCode(orderMain.getBindCode());
        activeInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
        BaseJsonVo<FitActiveInviteResultVo> baseJsonVo = this.activeInviteInterface.addActiveInviteNum(activeInviteDetailEntity);
        ActiveInviteEntity activeInvite = null;
        if (baseJsonVo.isSuccess()) {
            activeInvite = (ActiveInviteEntity)baseJsonVo.getValue();
            this.logger.info("\u6d3b\u52a8\u9080\u8bf7\u8bb0\u5f55\u66f4\u65b0\u5b8c\u6210.\u9080\u8bf7\u8bb0\u5f55\u4fe1\u606f:{}", (Object)activeInvite.toString());
        }
        if (activeInvite != null) {
            if (activeInvite.getIsPrize() != null && activeInvite.getIsPrize() < 1) {
                HashMap<String, String> map = new HashMap<String, String>();
                CustomerEntity customerDetailVo = this.customerService.getCustomer(orderMain.getCustomerId());
                if (customerDetailVo != null) {
                    map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
                    baseJsonVo = this.fitService.getActiveInvite(orderMain.getBindCode(), activeInvite.getCustomerId());
                    if (baseJsonVo.isSuccess()) {
                        int num;
                        FitActiveInviteResultVo fitActiveInviteResultVo = (FitActiveInviteResultVo)baseJsonVo.getValue();
                        if (fitActiveInviteResultVo != null && (num = fitActiveInviteResultVo.getBaseCount() - fitActiveInviteResultVo.getCount()) >= 0) {
                            map.put("num", String.valueOf(num > 0 ? fitActiveInviteResultVo.getBaseCount() - fitActiveInviteResultVo.getCount() : 0));
                            map.put("bindCode", orderMain.getBindCode());
                            this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, keyworldId, activeInvite.getCustomerId(), map);
                            this.logger.info("\u9080\u8bf7\u4eba\u6d88\u606f\u63a8\u9001\u5b8c\u6210.\u8ba2\u5355\u53f7:{}", (Object)orderMain.getOrderMainNo());
                        }
                    } else {
                        this.logger.error("\u63a8\u9001\u6d88\u606f\u5931\u8d25,\u67e5\u8be2\u9080\u8bf7\u4eba\u8bb0\u5f55\u51fa\u9519");
                    }
                }
            } else {
                this.logger.info("\u5df2\u5151\u5956\u7528\u6237\u4e0d\u63a8\u9001\u6d88\u606f,{}", (Object)activeInvite.toString());
            }
        } else {
            this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u7528\u6237\uff0c\u597d\u53cb\u53c2\u4e0e\u6d3b\u52a8\u6d88\u606f\u4e0d\u63a8\u9001");
        }
        this.logger.info("\u4e94\u5757\u94b1\u6d3b\u52a8\u652f\u4ed8\u5b8c\u6210\u903b\u8f91\u5904\u7406\u5b8c\u6bd5,\u8ba2\u5355\u53f7:{}", (Object)orderMain.getOrderMainNo());
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo updateActiveJoinStatus(MallOrderMainEntity orderMain) {
        ActiveCustomerEntity activeCustomerEntity = new ActiveCustomerEntity();
        activeCustomerEntity.setOrderMainNo(orderMain.getOrderMainNo());
        activeCustomerEntity.setStatus(0);
        BaseJsonVo baseJsonVo = this.activeCustomerService.updateCustomerActiveRecordByOrderNo(activeCustomerEntity);
        if (baseJsonVo.isSuccess()) {
            this.logger.info("\u6d3b\u52a8\u53c2\u4e0e\u72b6\u6001\u66f4\u65b0\u5b8c\u6210.\u8ba2\u5355\u53f7:{}", (Object)orderMain.getOrderMainNo());
        } else {
            this.logger.error("\u6d3b\u52a8\u53c2\u4e0e\u72b6\u6001\u66f4\u65b0\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)orderMain.getOrderMainNo());
        }
        return baseJsonVo;
    }
}

