/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activeType_4")
public class SaleQrcodeHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Autowired
    private ActiveInviteInterface activeInviteService;
    @Autowired
    protected MessageInterface messageService;
    @Autowired
    protected CustomerInterface customerService;

    @Override
    public BaseJsonVo confirmOrder(MallOrderMainEntity orderMain) {
        try {
            ActiveInviteDetailEntity queryActiveInviteDetailEntity = new ActiveInviteDetailEntity();
            queryActiveInviteDetailEntity.setBindCode(orderMain.getBindCode());
            queryActiveInviteDetailEntity.setOrderMainNo(orderMain.getOrderMainNo());
            queryActiveInviteDetailEntity.setFundsStatus(0);
            queryActiveInviteDetailEntity.setAcceptCustomerId(orderMain.getCustomerId());
            ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteService.getActiveInviteDetailEntity(queryActiveInviteDetailEntity);
            if (activeInviteDetailEntity != null) {
                if (activeInviteDetailEntity.getAcceptCustomerId() != null && activeInviteDetailEntity.getCustomerId() != null && !activeInviteDetailEntity.getCustomerId().equals(activeInviteDetailEntity.getAcceptCustomerId())) {
                    if (activeInviteDetailEntity.getBalance() != null && activeInviteDetailEntity.getBalance() > 0) {
                        this.logger.info("\u5b58\u5728\u53ef\u53d6\u57fa\u91d1:{}", (Object)activeInviteDetailEntity.toString());
                        this.activeInviteService.updateInviteNum(activeInviteDetailEntity, activeInviteDetailEntity.getBalance());
                    }
                } else {
                    this.logger.info("\u9080\u8bf7\u4eba\u548c\u88ab\u9080\u8bf7\u4eba\u4e3a\u540c\u4e00\u7528\u6237\u4e0d\u8ba1\u6570,\u9080\u8bf7\u8bb0\u5f55\u660e\u7ec6:{}", (Object)activeInviteDetailEntity.toString());
                }
            } else {
                this.logger.info("\u4e0d\u662f\u5b58\u5728\u53ef\u53d6\u57fa\u91d1:\u8ba2\u5355\u53f7:{}, \u53c2\u4e0e\u7528\u6237:{},\u4e0d\u5b58\u5728\u53ef\u53d6\u57fa\u91d1", (Object)orderMain.getOrderMainNo(), (Object)orderMain.getCustomerId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        List tt;
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setCustomerId(customerId);
        orderMainEntity.setBindCode(bindCode);
        List<MallOrderMainEntity> list = this.orderMainInterface.getOrderMainList(orderMainEntity);
        if (list != null && list.size() >= 1 && (tt = list.stream().filter(c -> c.getStatus() >= 3 && c.getStatus() < 20).collect(Collectors.toList())) != null && tt.size() >= 1) {
            return BaseJsonVo.error((String)"\u554a\u5662~\u6d3b\u52a8\u5df2\u53c2\u4e0e,\u53ea\u80fd\u53c2\u4e0e\u4e00\u6b21\u5662!");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo beforeSetCacheCheck(String customerId, MallOrderCacheInVo mallOrderCacheInVo) {
        return super.beforeSetCacheCheck(customerId, mallOrderCacheInVo);
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        String inviteId = "";
        try {
            if (StringUtils.isNotEmpty((String)mainOrderVo.getMallOrderVos().get(0).getDefineField())) {
                this.logger.info("\u63a5\u53d7:json:{}", (Object)mainOrderVo.getMallOrderVos().get(0).getDefineField());
                inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId").toString();
                if (StringUtils.isEmpty((String)inviteId)) {
                    this.logger.error("\u56fe\u7247\u4f20\u64ad\u6d3b\u52a8inviteId \u4e3a\u7a7a,\u8ba2\u5355\u53f7:{},\u975e\u9080\u8bf7\u8d2d\u4e70\uff0ccustomerId={}", (Object)mainOrderVo.getMainOrderNo(), (Object)mainOrderVo.getCustomerId());
                    return BaseJsonVo.success((Object)"\u975e\u9080\u8bf7\u8d2d\u4e70");
                }
            } else {
                this.logger.info("\u8ba2\u5355\u53f7:{} \u5b57\u6bb5:getDefineField  \u4e3a\u7a7a", (Object)mainOrderVo.getMallOrderVos().get(0));
                return BaseJsonVo.success((Object)"\u975e\u9080\u8bf7\u8d2d\u4e70");
            }
            MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(mainOrderVo.getMainOrderNo());
            ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(orderMain.getActiveNo());
            ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(orderMain.getBindCode());
            if (activeQrcodeEntity == null) {
                this.logger.error("\u6d3b\u52a8\u4e8c\u7ef4\u7801\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5. bindCode={}", (Object)orderMain.getBindCode());
                return BaseJsonVo.success((Object)"");
            }
            int amount = activeQrcodeEntity.getShareCount() == null || activeQrcodeEntity.getShareCount() == 0 || activeQrcodeEntity.getShareCount() == 1 ? 10 : activeQrcodeEntity.getShareCount();
            return this.activeInviteService.saveActiveInviteByInviteId(orderMain, activeEntity, inviteId, amount);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return BaseJsonVo.success((Object)"");
        }
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain) {
        this.collectionActiveOrderData(orderMain);
        this.logger.info("\u8ba2\u5355:{}\u6570\u636e\u57cb\u70b9\u5b8c\u6210", (Object)orderMain.getOrderMainNo());
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(orderMain.getBindCode());
        if (activeQrcodeEntity == null) {
            this.logger.error("\u6d3b\u52a8\u4e8c\u7ef4\u7801\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5. bindCode={}", (Object)orderMain.getBindCode());
        }
        int amount = activeQrcodeEntity.getShareCount() == null || activeQrcodeEntity.getShareCount() == 0 || activeQrcodeEntity.getShareCount() == 1 ? 10 : activeQrcodeEntity.getShareCount();
        orderMain.setPayAmount(new BigDecimal(amount));
        BaseJsonVo baseJsonVo = this.activeInviteService.updateUnTakedFund(orderMain);
        if (baseJsonVo.isSuccess()) {
            ActiveInviteDetailEntity result = (ActiveInviteDetailEntity)baseJsonVo.getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(orderMain.getCustomerId(), orderMain.getPlatformId());
            if (customerDetailVo != null) {
                map.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "\u533f\u540d\u4f19\u4f34");
                map.put("amount", String.valueOf(orderMain.getPayAmount()));
                map.put("bindCode", orderMain.getBindCode());
                this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, (Integer)2195, result.getCustomerId(), map);
            }
        }
        return baseJsonVo;
    }
}

