/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.file;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.weixin.MessageRemainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MallMessageRemainInterface;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MallImportExcelService {
    private static final Logger log = LoggerFactory.getLogger(MallImportExcelService.class);
    @Autowired
    private MallMessageRemainInterface mallMessageRemainInterface;
    @Autowired
    private CustomerInterface customerInterface;

    public BaseJsonVo importCustomerInfoUrl(MultipartFile file, String actionId) {
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        String filename = file.getOriginalFilename();
        if (StringUtils.isEmpty((String)filename) || !filename.endsWith(".xls") && !filename.endsWith(".xlsx")) {
            BaseJsonVo.paramError((String)"\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u53ea\u80fd\u4e3a .xls \u7ed3\u5c3e\u6216 .xlsx \u7ed3\u5c3e\u7684 excel \u6587\u4ef6\uff01\uff01\uff01\uff01\uff01");
            return baseJsonVo;
        }
        try {
            ArrayList<MessageRemainEntity> messageRemainEntityList;
            List<String> idList = this.readExcelContentByList(file);
            if (idList.size() > 0) {
                List<CustomerEntity> customerVoList;
                List<CustomerEntity> customerEntityList;
                messageRemainEntityList = new ArrayList<MessageRemainEntity>();
                List<CustomerDetailVo> customerDetailVoList = this.customerInterface.getCustomerDetailByOpenIds(idList, 1);
                if (customerDetailVoList.size() > 0) {
                    int i = this.mallMessageRemainInterface.deleteAll();
                    for (CustomerDetailVo customerDetailVo : customerDetailVoList) {
                        MessageRemainEntity messageRemainEntity = new MessageRemainEntity();
                        messageRemainEntity.setChannelCustomerId(customerDetailVo.getOpenId());
                        messageRemainEntity.setNickName(customerDetailVo.getNickName());
                        messageRemainEntity.setStatus(0);
                        messageRemainEntity.setAction(actionId);
                        messageRemainEntity.setCreateTime(new Date());
                        messageRemainEntity.setType("");
                        messageRemainEntity.setUpdateTime(new Date());
                        messageRemainEntityList.add(messageRemainEntity);
                    }
                }
                if ((customerEntityList = this.customerInterface.getCustomerByCustomerIds(idList)).size() > 0) {
                    int i = this.mallMessageRemainInterface.deleteAll();
                    for (CustomerEntity customerEntity : customerEntityList) {
                        MessageRemainEntity messageRemainEntity = new MessageRemainEntity();
                        messageRemainEntity.setChannelCustomerId(customerEntity.getChannelCustomerId());
                        messageRemainEntity.setNickName(customerEntity.getNickName());
                        messageRemainEntity.setStatus(0);
                        messageRemainEntity.setAction(actionId);
                        messageRemainEntity.setCreateTime(new Date());
                        messageRemainEntity.setType("");
                        messageRemainEntity.setUpdateTime(new Date());
                        messageRemainEntityList.add(messageRemainEntity);
                    }
                }
                if ((customerVoList = this.customerInterface.getCustomerBySignIds(idList)).size() > 0) {
                    int n = this.mallMessageRemainInterface.deleteAll();
                    for (CustomerEntity customerEntity : customerVoList) {
                        MessageRemainEntity messageRemainEntity = new MessageRemainEntity();
                        messageRemainEntity.setChannelCustomerId(customerEntity.getChannelCustomerId());
                        messageRemainEntity.setNickName(customerEntity.getNickName());
                        messageRemainEntity.setStatus(0);
                        messageRemainEntity.setAction(actionId);
                        messageRemainEntity.setCreateTime(new Date());
                        messageRemainEntity.setType("");
                        messageRemainEntity.setUpdateTime(new Date());
                        messageRemainEntityList.add(messageRemainEntity);
                    }
                }
                if (messageRemainEntityList == null || messageRemainEntityList.size() <= 0) {
                    return BaseJsonVo.success((Object)"\u6839\u636e\u6587\u6863\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
                }
            } else {
                return BaseJsonVo.success((Object)"\u6587\u6863\u4e3a\u7a7a");
            }
            this.mallMessageRemainInterface.insertMessageRemainBatch(messageRemainEntityList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return BaseJsonVo.error((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458");
        }
        return BaseJsonVo.success((Object)"\u4e0a\u4f20\u6210\u529f");
    }

    public List<String> readExcelContentByList(MultipartFile file) {
        Object workbook = null;
        boolean isExcel2003 = file.getOriginalFilename().endsWith(".xls");
        ArrayList<String> list = new ArrayList<String>();
        try {
            workbook = isExcel2003 ? new HSSFWorkbook(file.getInputStream()) : new XSSFWorkbook(file.getInputStream());
            Sheet sheet = workbook.getSheetAt(0);
            int rowNum = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < rowNum; ++i) {
                String cellValue = "";
                Row rowHead = sheet.getRow(i);
                HashMap map = new HashMap();
                Cell cell = rowHead.getCell(0);
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case 1: {
                            cellValue = cell.getStringCellValue();
                            break;
                        }
                        case 4: {
                            cellValue = Boolean.toString(cell.getBooleanCellValue());
                            break;
                        }
                        case 2: {
                            cellValue = new BigDecimal(cell.getNumericCellValue()).toPlainString();
                            break;
                        }
                        case 0: {
                            cellValue = new BigDecimal(cell.getNumericCellValue()).toPlainString();
                            break;
                        }
                        case 3: {
                            cellValue = "";
                            break;
                        }
                        case 5: {
                            cellValue = "\u975e\u6cd5\u5b57\u7b26";
                            break;
                        }
                        default: {
                            cellValue = "\u672a\u77e5\u7c7b\u578b";
                        }
                    }
                }
                list.add(cellValue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }
}

