/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.login;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.common.EnvironmentEnum;
import cc.lechun.common.enums.common.ServerEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.web.ResponseUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import java.net.InetAddress;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LoginInterceptor.class);
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    DistributionInviteInterface inviteInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private RedisService redisService;
    @Value(value="${lechun.environment}")
    private String environment;

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        block21: {
            String urlPrint = httpServletRequest.getRequestURI().substring(1);
            if ("index/health".equals(urlPrint)) {
                return true;
            }
            try {
                String distributorRelationCode;
                Object currentOrderCount;
                String testId;
                httpServletResponse.setHeader("X-Application-Context", "application");
                InetAddress address = IpUtil.getLocalHostLANAddress();
                if (address != null) {
                    String lc = ServerEnum.getServerTag(address.getHostName());
                    httpServletResponse.setHeader("lc", lc);
                }
                if (EnvironmentEnum.LOCAL.getValue().equals(this.environment)) break block21;
                String url = httpServletRequest.getRequestURI().substring(1);
                PlatFormAndGroupVo platFormAndGroupVo = new PlatFormAndGroupVo();
                if (this.redisService.get("LOGIN_PLATFROMGROUPVO") != null) {
                    platFormAndGroupVo = (PlatFormAndGroupVo)this.redisService.get("LOGIN_PLATFROMGROUPVO");
                } else {
                    platFormAndGroupVo.setPlatformId(1);
                    platFormAndGroupVo.setPlatformName("\u4e50\u7eaf\u5fae\u4fe1\u5546\u57ce");
                    platFormAndGroupVo.setPlatformDesc("\u4e50\u7eaf\u5fae\u4fe1\u5546\u57ce");
                    platFormAndGroupVo.setPlatformType(1);
                    platFormAndGroupVo.setPlatformGroupId(1000);
                    platFormAndGroupVo.setStatus(1);
                    platFormAndGroupVo.setCreateTime(DateUtils.StrToDate((String)"2018-01-12 14:49:57", (String)""));
                    platFormAndGroupVo.setApiPath("");
                    platFormAndGroupVo.setWebPath("/home/lechun/web/wechatweb/");
                    platFormAndGroupVo.setDomainPage("https://wx.lechun.cc");
                    platFormAndGroupVo.setDomainServer("https://mallapi.lechun.cc/");
                    platFormAndGroupVo.setPlatformGroupName("\u4e50\u7eaf");
                    platFormAndGroupVo.setPlatformGroupDesc("\u4e50\u7eaf\u9178\u5976");
                    platFormAndGroupVo.setGroupStatus(1);
                    this.redisService.save("LOGIN_PLATFROMGROUPVO", platFormAndGroupVo, 1800L);
                }
                List ls = null;
                if (this.redisService.get("LOGIN_WHITE_IP_LIST_35") != null) {
                    ls = (List)this.redisService.get("LOGIN_WHITE_IP_LIST_35");
                } else {
                    ls = this.dictionaryInterface.getValidDictionaryList(platFormAndGroupVo.getPlatformGroupId(), 35).stream().map(dictionaryEntity -> dictionaryEntity.getDictionaryName()).collect(Collectors.toList());
                    this.redisService.save("LOGIN_WHITE_IP_LIST_35", ls, 1800L);
                }
                if (!(ls.contains(url) || (testId = (String)this.redisService.get("lechun_testId")) != null && httpServletRequest.getParameter("testId").equals(testId))) {
                    String rurl = httpServletRequest.getHeader("referer");
                    if (rurl == null || rurl.isEmpty()) {
                        ResponseUtils.writeCorsJsonDate((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Object)new BaseJsonVo(40001, "\u9a8c\u8bc1\u5931\u8d25\uff01"));
                        return false;
                    }
                    if (this.redisService.get("LOGIN_WHITE_IP_LIST_37") != null) {
                        ls = (List)this.redisService.get("LOGIN_WHITE_IP_LIST_37");
                    } else {
                        ls = this.dictionaryInterface.getValidDictionaryList(platFormAndGroupVo.getPlatformGroupId(), 37).stream().map(dictionaryEntity -> dictionaryEntity.getDictionaryName()).collect(Collectors.toList());
                        this.redisService.save("LOGIN_WHITE_IP_LIST_37", ls, 1800L);
                    }
                    boolean isExistsDomain = false;
                    for (String str : ls) {
                        if (!rurl.contains(str)) continue;
                        isExistsDomain = true;
                        break;
                    }
                    if (!isExistsDomain) {
                        ResponseUtils.writeCorsJsonDate((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Object)new BaseJsonVo(40001, "\u9a8c\u8bc1\u5931\u8d25\uff01"));
                        return false;
                    }
                }
                Boolean hasSet = false;
                String customerId = this.customerLoginService.getCustomerIdFromCookie();
                if (customerId != null && StringUtils.isNotEmpty((String)customerId) && (currentOrderCount = this.redisService.get("customerVo:" + customerId)) != null) {
                    this.customerLoginService.setSensorCookie(customerId, (Integer)currentOrderCount);
                    hasSet = true;
                }
                if (!hasSet.booleanValue()) {
                    try {
                        CustomerDetailVo customerVo = this.customerLoginService.getCustomer(true);
                        if (customerVo != null && StringUtils.isNotEmpty((String)customerVo.getCustomerId())) {
                            this.customerLoginService.setSensorCookie(customerVo.getCustomerId(), customerVo.getCurrentOrderCount());
                            this.redisService.save("customerVo:" + customerVo.getCustomerId(), customerVo.getCurrentOrderCount(), 3600L);
                        }
                    }
                    catch (AuthorizeException e) {
                        logger.info("\u5f53\u524d\u672a\u767b\u9646\uff0c\u4e0d\u62e6\u622a");
                    }
                }
                String ref = httpServletRequest.getHeader("referer");
                if ("4".equals(httpServletRequest.getParameter("platFormId"))) {
                    ref = httpServletRequest.getParameter("referer");
                }
                logger.info("\u5206\u9500\u8bb0\u5f55ref\uff1a" + httpServletRequest.getParameter("platFormId") + "," + ref);
                if (("active/getShare".equalsIgnoreCase(urlPrint) || "fit/getShare".equalsIgnoreCase(urlPrint)) && StringUtils.isNotEmpty((String)(distributorRelationCode = httpServletRequest.getParameter("ncp_bat")))) {
                    Boolean bl = this.inviteInterface.invite(distributorRelationCode, customerId, ref, 1);
                }
            }
            catch (Exception e) {
                String uid = IDGenerate.getUniqueIdStr();
                logger.error("\u62e6\u622a\u8bf7\u6c42\u9a8c\u8bc1\u5931\u8d251:" + urlPrint + ";uid=" + uid + ";", (Throwable)e);
                ResponseUtils.writeCorsJsonDate((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Object)BaseJsonVo.error());
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

