/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.domain.qrcode;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.dao.qrcode.QrcodeSubMapper;
import cc.lechun.mall.entity.qrcode.QrcodeEntity;
import cc.lechun.mall.entity.qrcode.QrcodeScanEntity;
import cc.lechun.mall.entity.qrcode.QrcodeSubEntity;
import cc.lechun.mall.entity.qrcode.QrcodeSubVO;
import cc.lechun.mall.idomain.qrcode.IQrcodeDomain;
import cc.lechun.mall.iservice.qrcode.QrcodeInterface;
import cc.lechun.mall.iservice.qrcode.QrcodeScanInterface;
import cc.lechun.mall.iservice.qrcode.QrcodeSubInterface;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QrcodeDomain
implements IQrcodeDomain {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    QrcodeInterface qrcodeService;
    @Autowired
    QrcodeSubInterface qrcodeSubService;
    @Autowired
    QrcodeScanInterface qrcodeScanService;
    @Autowired
    RedisService redisService;
    @Autowired
    OssService ossService;
    @Autowired
    QrcodeSubMapper qrcodeSubMapper;

    @Override
    public QrcodeSubVO nextQrcodeSub(Integer qrcodeId, String customerId) {
        QrcodeSubEntity qrcodeSubEntity = this.currentQrcodeSub(qrcodeId, customerId);
        String redisKey = "CURRENT_QRCODEVO_" + (qrcodeSubEntity == null ? "null" : qrcodeSubEntity.getId());
        Object o = this.redisService.get(redisKey);
        if (o != null) {
            return (QrcodeSubVO)o;
        }
        QrcodeSubVO vo = new QrcodeSubVO();
        QrcodeEntity qrcodeEntity = (QrcodeEntity)this.qrcodeService.selectByPrimaryKey(qrcodeId);
        vo.setQrEconomicWechat(qrcodeEntity.getQrEconomicWechat());
        vo.setQrEconomicTel(qrcodeEntity.getQrEconomicTel());
        vo.setQrSuccTip(qrcodeEntity.getQrSuccTip());
        vo.setQrFailTip(qrcodeEntity.getQrFailTip());
        vo.setQrName(qrcodeEntity.getQrName());
        if (qrcodeSubEntity != null) {
            vo.setQrcodeId(qrcodeId);
            vo.setQrcodeSubId(qrcodeSubEntity.getId());
            vo.setSubQrImg(this.ossService.getImageResoure(qrcodeSubEntity.getSubQrImg()));
            vo.setSubQrName(qrcodeSubEntity.getSubQrName());
        }
        this.redisService.save(redisKey, vo, qrcodeSubEntity == null ? 300 : 86400);
        return vo;
    }

    @Override
    @Transactional
    public Boolean qrcodeScan(Integer qrcodeSubId, String customerId) {
        int result = this.qrcodeSubMapper.incrementScanCount(qrcodeSubId);
        QrcodeSubEntity qrcode = (QrcodeSubEntity)this.qrcodeSubService.selectByPrimaryKey(qrcodeSubId);
        QrcodeScanEntity scan = new QrcodeScanEntity();
        scan.setCustomerId(customerId);
        scan.setScanType(3);
        scan.setQrId(qrcode.getQrId());
        scan.setSubQrId(qrcodeSubId);
        scan.setCreateTime(DateUtils.now());
        this.qrcodeScanService.insert(scan);
        this.redisService.increment("CURRENT_QRCODE_COUNT_" + qrcode.getQrId(), 1L);
        return true;
    }

    @Override
    public QrcodeSubEntity currentQrcodeSub(Integer qrcodeId, String customerId) {
        QrcodeSubEntity returnSub = null;
        if (this.redisService.sIsMember("Avilable_QR_IDS", qrcodeId)) {
            QrcodeSubEntity sub = (QrcodeSubEntity)this.redisService.get("CURRENT_QRCODE_" + qrcodeId);
            if (sub != null) {
                Integer subCount = (Integer)this.redisService.get("CURRENT_QRCODE_COUNT_" + qrcodeId);
                if (subCount == null) {
                    this.redisService.save("CURRENT_QRCODE_COUNT_" + qrcodeId, 0);
                    returnSub = sub;
                } else if (sub.getQrSwitchNum() == 0 || subCount < sub.getQrSwitchNum()) {
                    returnSub = sub;
                } else {
                    QrcodeSubEntity nextSub = this.qrcodeSubMapper.getNext(qrcodeId, sub.getId());
                    if (nextSub == null) {
                        QrcodeSubEntity param = new QrcodeSubEntity();
                        param.setSubStatus(1);
                        param.setQrId(qrcodeId);
                        List list = this.qrcodeSubService.getList(param);
                        if (list == null || list.size() == 0) {
                            returnSub = null;
                        } else {
                            nextSub = (QrcodeSubEntity)list.get(0);
                        }
                    }
                    this.redisService.save("CURRENT_QRCODE_" + qrcodeId, nextSub);
                    this.redisService.save("CURRENT_QRCODE_COUNT_" + qrcodeId, 0);
                    returnSub = nextSub;
                }
            } else {
                QrcodeSubEntity param = new QrcodeSubEntity();
                param.setSubStatus(1);
                param.setQrId(qrcodeId);
                List list = this.qrcodeSubService.getList(param);
                if (list == null || list.size() == 0) {
                    returnSub = null;
                } else {
                    this.redisService.save("CURRENT_QRCODE_" + qrcodeId, list.get(0));
                    this.redisService.save("CURRENT_QRCODE_COUNT_" + qrcodeId, 0);
                    returnSub = (QrcodeSubEntity)list.get(0);
                }
            }
            QrcodeEntity qr = (QrcodeEntity)this.qrcodeService.selectByPrimaryKey(qrcodeId);
            if (!(qr == null || qr.getQrType() == 2 && StringUtils.isEmpty((String)customerId))) {
                QrcodeScanEntity scan = new QrcodeScanEntity();
                scan.setCustomerId(customerId);
                scan.setScanType(1);
                scan.setQrId(qrcodeId);
                scan.setSubQrId(null);
                scan.setCreateTime(DateUtils.now());
                this.qrcodeScanService.insert(scan);
                if (returnSub != null) {
                    QrcodeScanEntity scan2 = new QrcodeScanEntity();
                    scan2.setCustomerId(customerId);
                    scan2.setScanType(2);
                    scan2.setQrId(qrcodeId);
                    scan2.setSubQrId(returnSub.getId());
                    scan2.setCreateTime(DateUtils.now());
                    this.qrcodeScanService.insert(scan2);
                }
            }
        }
        return returnSub;
    }
}

