/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.accessLog;

import cc.lechun.apiinvoke.bi.TrackInvoke;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.accessLog.OrderAccessLogInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderAccessLogService
implements OrderAccessLogInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private TrackInvoke trackInvoke;

    @Override
    public BaseJsonVo writeAccessLog(MallOrderMainEntity orderMainEntity, String eventEn, String eventCn) {
        try {
            CustomerEntity customerEntity = this.customerInterface.getCustomer(orderMainEntity.getCustomerId());
            if (customerEntity != null) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("customerId", customerEntity.getCustomerId());
                dataMap.put("youshuChannelId", orderMainEntity.getChanId());
                dataMap.put("keyEn", eventEn);
                dataMap.put("keyCn", eventCn);
                dataMap.put("bindCode", customerEntity.getBindCode());
                dataMap.put("ncpBat", orderMainEntity.getNcpBat());
                dataMap.put("orderMainNo", orderMainEntity.getOrderMainNo());
                dataMap.put("freight", orderMainEntity.getFreight());
                dataMap.put("orderAmount", orderMainEntity.getOrderAmount());
                dataMap.put("payAmount", orderMainEntity.getPayAmount());
                dataMap.put("cardPayShow", orderMainEntity.getPointCut() != null && orderMainEntity.getPointCut().intValue() > 0 ? 1 : 0);
                MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
                orderProductEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
                orderProductEntity.setOrderProductType(3);
                if (this.orderProductInterface.isExists(orderProductEntity)) {
                    dataMap.put("exchange", 1);
                }
                return this.trackInvoke.trackDataNew(orderMainEntity.getPlatformId(), "pages/payment/index", "pages/payment/index", "\u652f\u4ed8\u9875", customerEntity.getSign(), 2, dataMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.error((String)"\u5199\u5165\u8bbf\u95ee\u65e5\u5fd7\u5f02\u5e38");
    }
}

