/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchNewRuleDetailMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.sales.MallGroupService;
import cc.lechun.mall.service.sales.MallPromotionService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketBatchNewRuleService
extends BaseService
implements CashticketBatchNewRuleInterface {
    @Autowired
    private CashticketBatchNewRuleDetailMapper cashticketBatchNewRuleDetailMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    private MallPromotionService mallPromotionService;
    @Autowired
    private MallGroupService mallGroupService;
    @Autowired
    private PlatFormService platFormService;
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleService;

    @Override
    @ReadThroughSingleCache(namespace="getCashRule", expiration=7200)
    public List<CashticketBatchNewRuleVo> getCashRule(@ParameterValueKeyProvider String ticketBatchId) {
        return this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
    }

    @Override
    @ReadThroughSingleCache(namespace="CashticketBatchNewRuleService.getCashRule", expiration=7200)
    public List<CashticketBatchNewRuleVo> getCashRule(@ParameterValueKeyProvider(order=0) String itemId, @ParameterValueKeyProvider(order=1) Integer itemType) {
        return this.cashticketBatchNewRuleDetailMapper.getCashRuleListByItemId(itemId, itemType);
    }

    @Override
    public List<CashticketBatchNewRuleVo> getCashRule(List<String> itemIdList, Integer itemType) {
        return this.cashticketBatchNewRuleDetailMapper.getCashRuleListByItemIdList(itemIdList, itemType);
    }

    private String getName(Integer ruleType, String detailIds) {
        String detailIdNames;
        block6: {
            String[] detailIdss;
            block8: {
                block7: {
                    block5: {
                        if (StringUtils.isEmpty((String)detailIds)) {
                            return "";
                        }
                        detailIdss = detailIds.split(",");
                        detailIdNames = "";
                        if (ruleType.intValue() != CashRuleTypeEnum.danpin.getValue()) break block5;
                        MallProductEntity detail = null;
                        for (String str : detailIdss) {
                            detail = this.productService.getProduct(str);
                            if (detail == null) continue;
                            detailIdNames = detailIdNames + detail.getProName() + ",";
                        }
                        break block6;
                    }
                    if (ruleType.intValue() != CashRuleTypeEnum.cuxiao.getValue()) break block7;
                    MallPromotionEntity detail = null;
                    for (String str : detailIdss) {
                        detail = this.mallPromotionService.getPromotion(str);
                        if (detail == null) continue;
                        detailIdNames = detailIdNames + detail.getPromotionName() + ",";
                    }
                    break block6;
                }
                if (ruleType.intValue() != CashRuleTypeEnum.taozhuang.getValue()) break block8;
                MallProductGroupEntity detail = null;
                for (String str : detailIdss) {
                    detail = this.mallGroupService.getGroup(str);
                    if (detail == null) continue;
                    detailIdNames = detailIdNames + detail.getGroupName() + ",";
                }
                break block6;
            }
            if (ruleType.intValue() != CashRuleTypeEnum.pingtai.getValue()) break block6;
            PlatFormEntity detail = null;
            for (String str : detailIdss) {
                detail = this.platFormService.getPlatForm(Integer.parseInt(str));
                if (detail == null) continue;
                detailIdNames = detailIdNames + detail.getPlatformName() + ",";
            }
        }
        return detailIdNames;
    }
}

