/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketBatchService
extends BaseService
implements CashticketBatchInterface {
    @Autowired
    private CashticketBatchMapper cashticketBatchMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    public CashticketBatchEntity getCashticketBatchByTicketNo(String ticketNo) {
        CashticketBatchEntity temp = new CashticketBatchEntity();
        temp.setTicketNo(ticketNo);
        return (CashticketBatchEntity)this.cashticketBatchMapper.getSingle(temp);
    }

    @Override
    public CashticketBatchEntity getCashticketBatch(String ticketBatchId) {
        return (CashticketBatchEntity)this.cashticketBatchMapper.selectByPrimaryKey((Serializable)((Object)ticketBatchId));
    }

    @Override
    public boolean updateCashticketBatchAlreadyQuantity(String ticketBatchId, int already_quantity) {
        boolean flag;
        boolean bl = flag = this.cashticketBatchMapper.updateCashticketBatchAlreadyQuantity(ticketBatchId, already_quantity) > 0;
        if (flag) {
            this.removeCache(ticketBatchId);
        }
        return flag;
    }

    private void removeCache(String ticketBatchId) {
        this.memcachedService.delete("getCashticketBatch", ticketBatchId);
    }
}

