/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.iservice.cashticket.CashticketClassInterface;
import cc.lechun.mall.service.dictionary.DictionaryService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketClassService
implements CashticketClassInterface {
    @Autowired
    private DictionaryService dictionaryService;

    @Override
    @ReadThroughSingleCache(namespace="CashticketClassService.getCashticketClass", expiration=600)
    public List<DictionaryEntity> getCashticketClass(@ParameterValueKeyProvider int platformGroupId) {
        return this.dictionaryService.getValidDictionaryList(platformGroupId, 8);
    }

    @Override
    public String getCashticketClassName(List<DictionaryEntity> list, int ticketClass) {
        if (list == null || list.size() == 0) {
            return "";
        }
        Optional<DictionaryEntity> dictionaryEntity = list.stream().filter(c -> (ticketClass + "").equals(c.getDictionaryKey())).findFirst();
        return dictionaryEntity.isPresent() ? dictionaryEntity.get().getDictionaryName() : "";
    }
}

