/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.active.form.cash.CustomerCashticketQuaryForm;
import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.common.enums.cashticket.CashBathStatusEnum;
import cc.lechun.common.enums.cashticket.CashComposeUseEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashPeriodTypeEnum;
import cc.lechun.common.enums.cashticket.CashRuleStatusEnum;
import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.common.enums.cashticket.CashTicketTypeEnum;
import cc.lechun.common.enums.cashticket.MallCashUseStatusEnum;
import cc.lechun.common.enums.cashticket.ProductCashRuleTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.CollectionUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.cashticket.CashticketCustomerMapper;
import cc.lechun.mall.dao.cashticket.CashticketSendLogMapper;
import cc.lechun.mall.entity.cashticket.CanUseCashticketVo;
import cc.lechun.mall.entity.cashticket.CashItemVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.entity.cashticket.CashticketSendLogEntity;
import cc.lechun.mall.entity.cashticket.CashticketSimpleVo;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.cashticket.SelectCashVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallUseCashItemVO;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.cashticket.CashticketClassInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketNoticeInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.service.cashticket.BestChooseCash;
import cc.lechun.mall.service.cashticket.CashticketBatchNewRuleService;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import cc.lechun.mall.service.cashticket.CashticketService;
import cc.lechun.mall.service.customer.CustomerService;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.weixin.MessageService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketCustomerService
extends BaseService
implements CashticketCustomerInterface {
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private CashticketSendLogMapper cashticketSendLogMapper;
    @Autowired
    private CashticketCustomerMapper cashticketCustomerMapper;
    @Autowired
    private CashticketBatchNewRuleService cashticketBatchNewRuleService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CashticketService cashticketService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    @Lazy
    private MessageService messageService;
    @Autowired
    private PlatFormService platformService;
    @Autowired
    private CashticketClassInterface cashticketClassService;
    @Autowired
    private MallProductCategoryInterface productCategoryInterface;
    @Autowired
    private CashticketNoticeInterface cashticketNoticeInterface;
    @Autowired
    private BestChooseCash bestChooseCash;

    @Override
    public Page<CashticketCustomerEntity> getCustomerCashticketList(PageForm pageForm, CustomerCashticketQuaryForm customerCashticketQuaryForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
        cashticketCustomerEntity.setCustomerId(customerCashticketQuaryForm.getCustomerId());
        this.cashticketCustomerMapper.getList(cashticketCustomerEntity);
        return page;
    }

    @Override
    @Transactional
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = new CashticketEntity()) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                cashticketEntity.setLaststatus(CashStatusEnum.yijihuo.getValue());
            }
            if (this.cashticketService.updateByPrimaryKeySelective(cashticketEntity) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, String customerId, CashStatusEnum cashStatusEnum) {
        CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
        cashticketCustomerEntity.setTicketId(ticketId);
        cashticketCustomerEntity.setCustomerId(customerId);
        cashticketCustomerEntity.setStatus(cashStatusEnum.getValue());
        if (cashStatusEnum.getValue() != CashStatusEnum.yijihuo.getValue()) {
            if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketCustomerEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                // empty if block
            }
        }
        this.updateCashticketStatus(ticketId, cashStatusEnum);
        return this.cashticketCustomerMapper.updateByPrimaryKeySelective(cashticketCustomerEntity) > 0;
    }

    @Override
    public List<Integer> getCashticketTicketId(String bindCode, String customerId) {
        return this.cashticketCustomerMapper.getCashticketTicketId(customerId, bindCode);
    }

    @Override
    public List<CashticketCustomerEntity> getCashticketTicketList(String bindCode, String customerId) {
        CashticketCustomerEntity query = new CashticketCustomerEntity();
        query.setBindCode(bindCode);
        query.setCustomerId(customerId);
        return this.cashticketCustomerMapper.getList(query);
    }

    @Override
    @Transactional
    public boolean insertCashticketCustomer(CashticketBatchEntity cashticketBatchEntity, CashticketCustomerEntity cashticketCustomerEntity, Integer platformId) {
        String message = "";
        CashticketEntity cash = this.cashticketService.addCashTicketNos(cashticketBatchEntity);
        if (cash == null) {
            this.logger.error("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        this.logger.info("\u4f18\u60e0\u5238ticketNo\u8bb0\u5f55:{}", (Object)cash.getTicketNo());
        cash = this.cashticketService.getCashticket4No(cash.getTicketNo());
        if (cash == null) {
            this.logger.error("\u67e5\u8be2\u5df2\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        cashticketCustomerEntity.setTicketId(cash.getTicketId());
        this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u8bb0\u5f55:{}", (Object)cash.toString());
        if (this.cashticketCustomerMapper.insertSelective(cashticketCustomerEntity) == 0) {
            this.logger.error("\u4f18\u60e0\u5238\u9886\u53d6\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        this.logger.info("\u4f18\u60e0\u5238\u9886\u53d6\u6210\u529f,{}", (Object)cashticketCustomerEntity.toString());
        if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.changeable_cash.getValue() && cashticketBatchEntity.getAmount().compareTo(cashticketCustomerEntity.getTicketAmount()) > 0 && !this.cashticketService.updateCashticketAmount(cash.getTicketId(), cashticketCustomerEntity.getTicketAmount())) {
            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25,\u66f4\u65b0\u91d1\u989d\u5931\u8d25";
            throw new RuntimeException(message);
        }
        return true;
    }

    @Override
    public CashticketCustomerEntity getCashticketCustomer(int ticketCustomerId) {
        return (CashticketCustomerEntity)this.cashticketCustomerMapper.selectByPrimaryKey(Integer.valueOf(ticketCustomerId));
    }

    @Override
    @Transactional
    public BaseJsonVo useCashTicketCustomer(String customerId, int ticketCustomerId, String orderMainNo, BigDecimal realyDeduction) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        if (!cashticketCustomerEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u4f18\u60e0\u52b5");
        }
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(cashticketCustomerEntity.getTicketBatchId());
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getAllCashticketList4Status(cashticketBatchEntity.getPlatformGroupId(), customerId, ticketCustomerId, 1);
        if (ls == null || ls.size() == 0) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u5df2\u5931\u6548");
        }
        if (this.cashticketCustomerMapper.updateCustomerCashStasusUse(customerId, orderMainNo, realyDeduction, ticketCustomerId) <= 0) {
            return BaseJsonVo.paramError((String)"\u4f18\u60e0\u52b5\u65e0\u6cd5\u4f7f\u7528");
        }
        this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yishiyong);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo returnCashTicketCustomer(int ticketCustomerId, String orderMainNo) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            CashticketCustomerEntity query = new CashticketCustomerEntity();
            query.setTicketId(ticketCustomerId);
            query.setOrderMainNo(orderMainNo);
            query.setStatus(CashStatusEnum.yishiyong.getValue());
            cashticketCustomerEntity = (CashticketCustomerEntity)CollectionUtils.listToEntiy((List)this.cashticketCustomerMapper.getList(query));
        }
        cashticketCustomerEntity.setOrderMainNo("");
        cashticketCustomerEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        this.cashticketCustomerMapper.updateByPrimaryKeySelective(cashticketCustomerEntity);
        this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yijihuo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<CashticketCustomerEntity> getCashticketCustomerList(String customerId, String ticketBatchId) {
        CashticketCustomerEntity param = new CashticketCustomerEntity();
        param.setCustomerId(customerId);
        param.setTicketBatchId(ticketBatchId);
        return this.cashticketCustomerMapper.getList(param);
    }

    @Override
    public CashticketCustomerEntity getEnableCashticketCustomerList(String customerId, String ticketBatchId) {
        CashticketCustomerEntity param = new CashticketCustomerEntity();
        param.setCustomerId(customerId);
        param.setTicketBatchId(ticketBatchId);
        param.setStatus(1);
        return (CashticketCustomerEntity)this.cashticketCustomerMapper.getSingle(param);
    }

    @Override
    public BaseJsonVo sendTicket4Code(String customerId, CashticketBatchEntity cashticketBatchEntity, int count, int ticketId, int platformId, boolean isSendMessage) {
        return ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).sendTicket(customerId, cashticketBatchEntity, count, "", "", "", ticketId, platformId, isSendMessage, 0.0);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, String versionDetailId, int platformId, boolean isSendMessage) {
        return ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).sendChangeAmountTicket(customerId, ticketBatchId, count, activeNo, bindCode, versionDetailId, 0.0, platformId, isSendMessage);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, double amount, String versionDetailId, int platformId, boolean isSendMessage) {
        return ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).sendChangeAmountTicket(customerId, ticketBatchId, count, activeNo, bindCode, versionDetailId, amount, platformId, isSendMessage);
    }

    @Override
    public BaseJsonVo sendChangeAmountTicket(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, String versionDetailId, double amount, int platformId, boolean isSendMessage) {
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
        return ((CashticketCustomerService)SpringContextUtil.getBean(this.getClass())).sendTicket(customerId, cashticketBatchEntity, count, activeNo, bindCode, versionDetailId, 0, platformId, isSendMessage, amount);
    }

    @Override
    @Transactional
    public BaseJsonVo sendTicket(String customerId, CashticketBatchEntity cashticketBatchEntity, int count, String activeNo, String bindCode, String versionDetailId, int ticketId, int platformId, boolean sendMessage, double amount) {
        boolean isActivite;
        this.logger.info("\u4f18\u60e0\u5238\u53d1\u653e customerId={},\u6279\u6b21:{},\u6570\u91cf:{},activeNo={},ticketId={},platformId={},sendMessage={},amount={}", new Object[]{customerId, cashticketBatchEntity.getTicketBatchName(), count, activeNo, ticketId, platformId, sendMessage, amount});
        String message = "";
        if (cashticketBatchEntity == null) {
            message = "\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21";
            throw new RuntimeException(message);
        }
        if (count < 1) {
            message = "\u53d1\u9001\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1";
            throw new RuntimeException(message);
        }
        if (cashticketBatchEntity.getStatus() == 0) {
            message = "\u4f18\u60e0\u52b5\u5df2\u5931\u6548";
            throw new RuntimeException(message);
        }
        if (cashticketBatchEntity.getQuantity() > 0 && cashticketBatchEntity.getAlreadyQuantity() >= cashticketBatchEntity.getQuantity()) {
            message = "\u5662~\u6765\u8fdf\u4e86,\u4f18\u60e0\u5238\u88ab\u9886\u5149\u4e86";
            this.logger.info(cashticketBatchEntity.getTicketBatchName() + message);
            throw new RuntimeException(message);
        }
        if (amount > 0.0 && cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() && new BigDecimal(amount).compareTo(cashticketBatchEntity.getAmount()) == 1) {
            message = "\u5151\u6362\u91d1\u989d\u8d85\u8fc7\u5141\u8bb8\u5151\u6362\u6700\u5927\u91d1\u989d";
            throw new RuntimeException(message);
        }
        CustomerEntity customerEntity = this.customerService.getCustomer(customerId);
        if (customerEntity == null) {
            message = "\u65e0\u6548\u7684\u7528\u6237";
            throw new RuntimeException(message);
        }
        String ncpBat = "";
        HttpServletRequest httpServletRequest = RequestDetail.getCurrentRequest();
        if (httpServletRequest != null && StringUtils.isEmpty((String)(ncpBat = httpServletRequest.getParameter("ncp_bat")))) {
            ncpBat = httpServletRequest.getParameter("ncpBat");
        }
        boolean bl = isActivite = ticketId == 0;
        if (!customerEntity.getPlatformGroupId().equals(cashticketBatchEntity.getPlatformGroupId())) {
            message = "\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6240\u5c5e\u516c\u53f8";
            throw new RuntimeException(message);
        }
        int j = 0;
        for (int i = 0; i < count; ++i) {
            boolean isSuccess = false;
            while (!isSuccess) {
                if (j > 10) {
                    message = "\u4f18\u60e0\u52b5\u53d1\u653e\u5f02\u5e38";
                    throw new RuntimeException(message);
                }
                List<CashticketCustomerEntity> ls = this.getCashticketCustomerList(customerId, cashticketBatchEntity.getTicketBatchId());
                if (ls != null && cashticketBatchEntity.getUserTackCount() > 0 && ls.size() >= cashticketBatchEntity.getUserTackCount()) {
                    message = cashticketBatchEntity.getTicketBatchName() + "\u5df2\u9886\u53d6,\u4e0d\u53ef\u4ee5\u91cd\u590d\u9886\u53d6~";
                    this.logger.info("\u4f18\u60e0\u5238:{},{}", (Object)cashticketBatchEntity.getTicketBatchName(), (Object)message);
                    if (cashticketBatchEntity.getUserVisible() != null && cashticketBatchEntity.getUserVisible() == 1) {
                        this.messageService.sendCustomerTextMessage4CustmoerId(customerId, platformId, message, 0);
                    }
                    throw new RuntimeException(message);
                }
                CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
                cashticketCustomerEntity.setTicketId(ticketId);
                cashticketCustomerEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
                cashticketCustomerEntity.setCustomerId(customerId);
                cashticketCustomerEntity.setSourceActiveNo(activeNo);
                cashticketCustomerEntity.setStatus(CashStatusEnum.yijihuo.getValue());
                cashticketCustomerEntity.setBindCode(bindCode);
                cashticketCustomerEntity.setVersionDetailId(versionDetailId);
                cashticketCustomerEntity.setNcpBat(ncpBat);
                if (cashticketBatchEntity.getPeriodType().intValue() == CashPeriodTypeEnum.tianshu.getValue()) {
                    cashticketCustomerEntity.setBeginTime(DateUtils.currentDate());
                    cashticketCustomerEntity.setEndTime(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(cashticketBatchEntity.getDays() + 1)));
                } else {
                    cashticketCustomerEntity.setBeginTime(cashticketBatchEntity.getBeginTime());
                    cashticketCustomerEntity.setEndTime(DateUtils.getAddDateByDay((Date)cashticketBatchEntity.getEndTime(), (int)1));
                }
                cashticketCustomerEntity.setCreateTime(DateUtils.now());
                cashticketCustomerEntity.setTicketAmount(cashticketBatchEntity.getAmount());
                if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.static_cash.getValue()) {
                    cashticketCustomerEntity.setTicketAmount(cashticketBatchEntity.getAmount());
                } else if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.changeable_cash.getValue()) {
                    cashticketCustomerEntity.setTicketAmount(new BigDecimal(amount));
                } else {
                    message = "\u5238\u91d1\u989d\u7c7b\u578b\u6709\u8bef";
                    throw new RuntimeException(message);
                }
                if (this.cashticketBatchService.updateCashticketBatchAlreadyQuantity(cashticketBatchEntity.getTicketBatchId(), 1)) {
                    this.logger.info("\u67e5\u770b\u4f18\u60e0\u5238\u53d1\u653e\u6765\u6e90:{}", (Object)isActivite);
                    if (isActivite) {
                        isSuccess = this.insertCashticketCustomer(cashticketBatchEntity, cashticketCustomerEntity, platformId);
                    } else if (this.cashticketService.updateCashticketStatus(ticketId, CashStatusEnum.yijihuo, cashticketBatchEntity)) {
                        if (this.cashticketCustomerMapper.insertSelective(cashticketCustomerEntity) == 0) {
                            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25";
                            throw new RuntimeException(message);
                        }
                        cashticketBatchEntity.setAlreadyQuantity(cashticketBatchEntity.getAlreadyQuantity() + 1);
                        if (cashticketBatchEntity.getTicketType().intValue() == CashTicketTypeEnum.changeable_cash.getValue() && cashticketBatchEntity.getAmount().compareTo(cashticketCustomerEntity.getTicketAmount()) > 0 && !this.cashticketService.updateCashticketAmount(ticketId, cashticketCustomerEntity.getTicketAmount())) {
                            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25";
                            throw new RuntimeException(message);
                        }
                        isSuccess = true;
                    }
                } else {
                    message = "\u5662~\u6765\u8fdf\u4e86,\u4f18\u60e0\u5238\u88ab\u9886\u5149\u4e86";
                    throw new RuntimeException(message);
                }
                LocalTime time = LocalTime.now();
                int hour = time.getHour();
                if (isSuccess && sendMessage && cashticketBatchEntity.getUserVisible() != null && cashticketBatchEntity.getUserVisible() == 1 && hour >= 8 && hour <= 20) {
                    ExecutorService pool = Executors.newFixedThreadPool(1);
                    CompletableFuture<Void> cashMessageFuture = CompletableFuture.runAsync(() -> this.sendCashMessage(customerId, cashticketBatchEntity, cashticketCustomerEntity, platformId), pool);
                    pool.shutdown();
                }
                ++j;
            }
        }
        return BaseJsonVo.success((Object)"\u5151\u6362\u6210\u529f");
    }

    private void sendCashMessage(String customerId, CashticketBatchEntity cashticketBatchEntity, CashticketCustomerEntity cashticketCustomerEntity, int platformId) {
        this.cashticketNoticeInterface.sendMessage(customerId, cashticketBatchEntity.getTicketBatchName(), cashticketCustomerEntity.getCreateTime(), cashticketCustomerEntity.getEndTime(), cashticketBatchEntity.getRemark());
        PlatFormEntity platFormEntity = this.platformService.getPlatForm(platformId);
        HashMap map = this.getMssageCashSendSuccess(cashticketBatchEntity, cashticketCustomerEntity.getTicketAmount(), cashticketCustomerEntity.getEndTime(), platFormEntity.getDomainPage());
        this.messageService.sendWechatMessage(platFormEntity.getPlatformGroupId(), MessageActionConstants.cashSendSuccess, customerId, (Map<String, String>)map);
    }

    private HashMap getMssageCashSendSuccess(CashticketBatchEntity cashticketBatchEntity, BigDecimal amount, Date endTime, String domin_page) {
        HashMap<String, String> map = new HashMap<String, String>();
        String pre = "";
        pre = cashticketBatchEntity.getMinUseamount().doubleValue() == 0.0 ? "\u65e0\u95e8\u69db" : "\u6ee1" + cashticketBatchEntity.getMinUseamount().doubleValue();
        if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
            pre = pre + "\u51cf" + amount;
        } else if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
            pre = pre + "\u4eab" + MathUtils.divBigDecimal((Number)cashticketBatchEntity.getDiscountAmount(), (Number)10, (Integer)2) + "\u6298";
        }
        map.put("cashTitle", pre);
        map.put("cashName", cashticketBatchEntity.getTicketBatchName());
        map.put("cashdDomin", domin_page);
        map.put("cashEndTime", DateUtils.formatDate((Date)endTime, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
        return map;
    }

    @Override
    public void saveSendLog(String customerId, CashticketBatchEntity cashticketBatchEntity, String ticketBatchId, String bindCode, String versionDetailId, BaseJsonVo vo, int ticketId, String ticketNo, int count) {
        try {
            vo.setMessage(count + ":" + vo.getMessage());
            CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
            if (cashticketBatchEntity != null) {
                cashticketSendLogEntity.setAmount(cashticketBatchEntity.getAmount());
                cashticketSendLogEntity.setTicketBatchName(cashticketBatchEntity.getTicketBatchName());
                cashticketSendLogEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
            } else {
                cashticketSendLogEntity.setTicketBatchId(ticketBatchId);
            }
            cashticketSendLogEntity.setTicketNo(ticketNo);
            cashticketSendLogEntity.setTicketId(ticketId);
            cashticketSendLogEntity.setBindCode(bindCode);
            cashticketSendLogEntity.setCustomerId(customerId);
            cashticketSendLogEntity.setCreateTime(DateUtils.now());
            cashticketSendLogEntity.setMessage(JSON.toJSONString((Object)vo));
            cashticketSendLogEntity.setVersionDetailId(versionDetailId);
            cashticketSendLogEntity.setStatus(vo.isSuccess() ? 1 : 0);
            this.cashticketSendLogMapper.insertSelective(cashticketSendLogEntity);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }

    @Override
    public void saveSendLog(String customerId, String ticketBatchId, String status, String bindCode, String versionDetailId, String message, String count) {
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
        CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
        if (cashticketBatchEntity != null) {
            cashticketSendLogEntity.setAmount(cashticketBatchEntity.getAmount());
            cashticketSendLogEntity.setTicketBatchName(cashticketBatchEntity.getTicketBatchName());
            cashticketSendLogEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        }
        cashticketSendLogEntity.setTicketNo("");
        cashticketSendLogEntity.setTicketId(0);
        cashticketSendLogEntity.setBindCode(bindCode);
        cashticketSendLogEntity.setCustomerId(customerId);
        cashticketSendLogEntity.setCreateTime(DateUtils.now());
        cashticketSendLogEntity.setMessage(message + ",\u4f18\u60e0\u5238\u6570\u91cf:" + count);
        cashticketSendLogEntity.setVersionDetailId(versionDetailId);
        cashticketSendLogEntity.setStatus(Integer.valueOf(status));
        this.cashticketSendLogMapper.insertSelective(cashticketSendLogEntity);
    }

    @Override
    public List<CashticketVo> getValidCashticketList(int platformGroupId, String customerId, Integer userType) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 1);
        if (ls != null && ls.size() > 0) {
            List<DictionaryEntity> cashClassList = this.cashticketClassService.getCashticketClass(platformGroupId);
            for (CashticketSimpleVo simpleVo : ls) {
                this.getCashticketVo(rs, cashClassList, simpleVo);
            }
            rs.sort(new Comparator<CashticketVo>(){

                @Override
                public int compare(CashticketVo o1, CashticketVo o2) {
                    return o2.getTicketCustomerId() - o1.getTicketCustomerId();
                }
            });
        }
        return rs;
    }

    @Override
    @WriteDataSource
    public List<CashticketVo> getTakedCashticketList(PageForm pageForm, int platformGroupId, String customerId, String bindCode) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        this.cashticketCustomerMapper.getCashticketList4BindCode(platformGroupId, customerId, bindCode);
        PageInfo pg = page.toPageInfo();
        if (pg != null && pg.getList() != null) {
            ArrayList<DictionaryEntity> cashClassList = new ArrayList<DictionaryEntity>();
            for (CashticketSimpleVo simpleVo : pg.getList()) {
                this.getCashticketVo(rs, cashClassList, simpleVo);
            }
        }
        return rs;
    }

    private void getCashticketVo(List<CashticketVo> rs, List<DictionaryEntity> cashClassList, CashticketSimpleVo simpleVo) {
        CashticketVo cashticketVo = this.getCashticketVo(simpleVo, true, BigDecimal.ZERO);
        cashticketVo.setTicetClass(simpleVo.getTicetClass());
        if (simpleVo.getTicetClass() != null) {
            cashticketVo.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, simpleVo.getTicetClass()));
        } else {
            cashticketVo.setTicetClassName("");
        }
        rs.add(cashticketVo);
    }

    @Override
    public List<CashticketVo> getUseCashticketList(int platformGroupId, String customerId) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 3);
        ls.forEach(cashticketSimpleVo -> rs.add(this.getCashticketVo((CashticketSimpleVo)cashticketSimpleVo, false, new BigDecimal(0))));
        return rs;
    }

    @Override
    public List<CashticketVo> getInvalidCashticketList(int platformGroupId, String customerId) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 2);
        if (ls != null && ls.size() > 0) {
            for (CashticketSimpleVo simpleVo : ls) {
                rs.add(this.getCashticketVo(simpleVo, false, new BigDecimal(0)));
            }
        }
        return rs;
    }

    @Override
    public CanUseCashticketVo getEnabledCashticketList(int cacheType, int platformGroupId, List<Integer> selectCashticketList, String customerId, List<MallOrderVo> orderVos) {
        CanUseCashticketVo canUseCashticketVo = new CanUseCashticketVo();
        List<Object> ls = new ArrayList();
        this.logger.info("\u9009\u62e9\u7684\u4f18\u60e0\u5238 platformGroupId={},customerId={},checkCashticketVoList={},select_status_valid={},orderVos={}", new Object[]{platformGroupId, customerId, selectCashticketList, 1, JsonUtils.toJson(orderVos, (boolean)false)});
        ls = cacheType == 2 ? this.cashticketCustomerMapper.getCashticketList4cashList(platformGroupId, customerId, selectCashticketList, 1) : this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 1);
        if (ls.size() == 0) {
            canUseCashticketVo.setNum(0);
            return canUseCashticketVo;
        }
        ArrayList<CashticketVo> unUseList = new ArrayList<CashticketVo>();
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        this.logger.info("[rs]-before-build:{}", (Object)JsonUtils.toJson(ls, (boolean)false));
        ArrayList<CashItemVo> cashItemVoList = new ArrayList<CashItemVo>();
        List<DictionaryEntity> cashClassList = this.cashticketClassService.getCashticketClass(platformGroupId);
        List<MallProductCategoryEntity> categoryList = this.productCategoryInterface.getCategoryList();
        List<CashticketBatchNewRuleVo> productCashRuleList = null;
        List<CashticketBatchNewRuleVo> promotionCashRuleList = null;
        ArrayList<String> productIdList = new ArrayList<String>();
        ArrayList<String> promotionList = new ArrayList<String>();
        for (MallOrderVo mallOrderVo : orderVos) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mallOrderVo.getProducts())) {
                productIdList.addAll(mallOrderVo.getProducts().stream().map(MallProductEntity::getProId).collect(Collectors.toList()));
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(mallOrderVo.getPromotions())) continue;
            promotionList.addAll(mallOrderVo.getPromotions().stream().map(MallPromotionEntity::getPromotionId).collect(Collectors.toList()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productIdList)) {
            productCashRuleList = this.cashticketBatchNewRuleService.getCashRule(productIdList, (Integer)SalesTypeEnum.SALES_PRODUCT.getValue());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(promotionList)) {
            promotionCashRuleList = this.cashticketBatchNewRuleService.getCashRule(promotionList, (Integer)SalesTypeEnum.SALES_PROMOTION.getValue());
        }
        for (CashticketSimpleVo cashticketSimpleVo : ls) {
            CashItemVo cashItemVo2 = new CashItemVo();
            cashItemVo2.setTicketAmount(cashticketSimpleVo.getAmount());
            cashItemVo2.setTicketCustomerId(cashticketSimpleVo.getTicketCustomerId());
            cashItemVo2.setComposeUse(cashticketSimpleVo.getComposeUse());
            cashItemVo2.setTicketBatchName(cashticketSimpleVo.getTicketBatchName());
            boolean productCashFlag = false;
            List<CashticketBatchNewRuleVo> rule_ls = this.cashticketBatchNewRuleService.getCashRule(cashticketSimpleVo.getTicketBatchId(), (Integer)ProductCashRuleTypeEnum.cash.getValue());
            Map<Integer, CashticketBatchNewRuleVo> rule_map = rule_ls == null || rule_ls.size() == 0 ? null : rule_ls.stream().collect(Collectors.toMap(o -> o.getRuleType(), o -> o));
            BigDecimal total_use_cash_amonut = BigDecimal.ZERO;
            for (MallOrderVo mallOrderVo : orderVos) {
                if (mallOrderVo.getProducts() != null) {
                    total_use_cash_amonut = this.caclUseCash4Product(cashticketSimpleVo, total_use_cash_amonut, mallOrderVo, productCashRuleList, cashItemVo2, categoryList, rule_map);
                }
                if (mallOrderVo.getPromotions() == null) continue;
                total_use_cash_amonut = this.caclUseCash4Promotion(cashticketSimpleVo, total_use_cash_amonut, mallOrderVo, promotionCashRuleList, cashItemVo2, categoryList, rule_map, cacheType);
            }
            this.logger.info("\u4f18\u60e0\u5238:{} simpleVo.getMinUseamount()={},\u7528\u6237:{},\u5546\u54c1\u53ef\u7528\u5238\u91d1\u989d total_use_cash_amonut ={},", new Object[]{cashticketSimpleVo.getTicketBatchName(), cashticketSimpleVo.getMinUseamount(), customerId, total_use_cash_amonut});
            if (total_use_cash_amonut.compareTo(BigDecimal.ZERO) > 0) {
                if (total_use_cash_amonut.compareTo(cashticketSimpleVo.getMinUseamount()) >= 0) {
                    BigDecimal enableCashticketAmount = null;
                    if (cashticketSimpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
                        enableCashticketAmount = total_use_cash_amonut.compareTo(cashticketSimpleVo.getAmount()) >= 0 ? cashticketSimpleVo.getAmount() : total_use_cash_amonut;
                    } else if (cashticketSimpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
                        enableCashticketAmount = MathUtils.divBigDecimal((Double)MathUtils.mulBigDecimal((Number)total_use_cash_amonut, (Number)(100 - cashticketSimpleVo.getDiscountAmount())).doubleValue(), (Double)100.0, (Integer)2);
                    }
                    if (Objects.equals(cashticketSimpleVo.getFreeCash(), 1)) {
                        enableCashticketAmount = BigDecimal.ZERO;
                    }
                    this.logger.info("\u4f18\u60e0\u5238:{} simpleVo.getMinUseamount()={},\u7528\u6237:{},\u5546\u54c1\u53ef\u7528\u5238\u91d1\u989d total_use_cash_amonut ={},\u62b5\u6263\u91d1\u989d:{}", new Object[]{cashticketSimpleVo.getTicketBatchName(), cashticketSimpleVo.getMinUseamount(), customerId, total_use_cash_amonut, enableCashticketAmount});
                    cashItemVo2.setEnableCashticketAmount(enableCashticketAmount);
                    cashItemVo2.setTotal_use_cash_amonut(total_use_cash_amonut);
                    if (enableCashticketAmount == null) continue;
                    CashticketVo cashticketVo3 = this.getCashticketVo(cashticketSimpleVo, true, enableCashticketAmount, productCashFlag);
                    cashticketVo3.setTicetClass(cashticketSimpleVo.getTicetClass());
                    cashticketVo3.setTotalUseCashAmonut(total_use_cash_amonut);
                    cashticketVo3.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, cashticketSimpleVo.getTicetClass()));
                    rs.add(cashticketVo3);
                    cashItemVoList.add(cashItemVo2);
                    continue;
                }
                this.logger.info("\u4f18\u60e0\u5238:{}, \u5546\u54c1\u53ef\u7528\u5238\u91d1\u989d:{},\u4f18\u60e0\u5238\u6700\u4f4e\u7528\u5238\u91d1\u989d:{}", new Object[]{cashticketSimpleVo.getTicketBatchName(), total_use_cash_amonut, cashticketSimpleVo.getMinUseamount()});
                if (cacheType == 2) continue;
                CashticketVo cashticketVo2 = this.getCashticketVo(cashticketSimpleVo, true, BigDecimal.ZERO, productCashFlag);
                cashticketVo2.setTicetClass(cashticketSimpleVo.getTicetClass());
                cashticketVo2.setTotalUseCashAmonut(total_use_cash_amonut);
                cashticketVo2.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, cashticketSimpleVo.getTicetClass()));
                cashticketVo2.setUseNotice("\u5dee" + PriceUtils.subtract((BigDecimal)cashticketSimpleVo.getMinUseamount(), (BigDecimal)total_use_cash_amonut) + "\u5143\u53ef\u7528");
                unUseList.add(cashticketVo2);
                continue;
            }
            if (cacheType == 2) continue;
            CashticketVo cashticketVo2 = this.getCashticketVo(cashticketSimpleVo, true, BigDecimal.ZERO, productCashFlag);
            cashticketVo2.setTicetClass(cashticketSimpleVo.getTicetClass());
            cashticketVo2.setTotalUseCashAmonut(total_use_cash_amonut);
            cashticketVo2.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, cashticketSimpleVo.getTicetClass()));
            cashticketVo2.setUseNotice("\u4e0d\u53ef\u7528,\u6ca1\u6709\u7b26\u5408\u4f7f\u7528\u6761\u4ef6\u7684\u5546\u54c1");
            unUseList.add(cashticketVo2);
        }
        this.setNoUseCash(cacheType, selectCashticketList, orderVos, cashItemVoList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(rs)) {
            this.logger.info("[rs]-after-build:{}", (Object)JsonUtils.toJson(rs, (boolean)false));
            if (cacheType == 1) {
                Collections.sort(rs);
                Collections.sort(cashItemVoList);
            }
            try {
                ArrayList<CashticketVo> rs1 = new ArrayList<CashticketVo>();
                ArrayList arrayList = new ArrayList();
                ArrayList cashItemVoList1 = new ArrayList();
                ArrayList cashItemVoList2 = new ArrayList();
                this.logger.info("[selectCashticketList]:{}", (Object)JsonUtils.toJson(selectCashticketList, (boolean)false));
                if (selectCashticketList.size() > 0) {
                    rs.forEach(cashticketVo -> {
                        if (selectCashticketList.stream().filter(ticketCustomerId2 -> ticketCustomerId2.intValue() == cashticketVo.getTicketCustomerId().intValue()).findAny().isPresent()) {
                            rs1.add((CashticketVo)cashticketVo);
                            this.logger.info("YES:{}", (Object)JsonUtils.toJson((Object)cashticketVo, (boolean)false));
                        } else {
                            rs2.add(cashticketVo);
                            this.logger.info("NO:{}", (Object)JsonUtils.toJson((Object)cashticketVo, (boolean)false));
                        }
                    });
                    canUseCashticketVo.setList(rs1);
                    this.logger.info("after-filter-canUseCashticketVo:{}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false));
                } else {
                    canUseCashticketVo.setList(rs);
                    this.logger.info("after-no-filter-canUseCashticketVo:{}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false));
                }
                this.logger.info("[cashItemVoList]-after-build:{}", (Object)JsonUtils.toJson(cashItemVoList, (boolean)false));
                if (cashItemVoList.size() > 0) {
                    cashItemVoList.forEach(cashItemVo -> {
                        if (selectCashticketList.stream().filter(ticketCustomerId2 -> ticketCustomerId2.intValue() == cashItemVo.getTicketCustomerId().intValue()).findAny().isPresent()) {
                            cashItemVoList1.add(cashItemVo);
                            this.logger.info("YES:{}", (Object)JsonUtils.toJson((Object)cashItemVo, (boolean)false));
                        } else {
                            cashItemVoList2.add(cashItemVo);
                            this.logger.info("NO:{}", (Object)JsonUtils.toJson((Object)cashItemVo, (boolean)false));
                        }
                    });
                }
                this.logger.info("before-getDefaultUseCash,canUseCashticketVo={},cashItemVoList={},cashItemVoList1={},cashItemVoList2={}", new Object[]{JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false), JsonUtils.toJson(cashItemVoList, (boolean)false), JsonUtils.toJson(cashItemVoList1, (boolean)false), JsonUtils.toJson(cashItemVoList2, (boolean)false)});
                canUseCashticketVo.setSelectCashVo(this.getDefaultUseCash(canUseCashticketVo, cashItemVoList1.size() == 0 ? cashItemVoList : cashItemVoList1));
                if (cacheType != 2) {
                    canUseCashticketVo.getList().addAll(arrayList);
                }
                Collections.sort(canUseCashticketVo.getList());
                this.logger.info("almost-over-[canUseCashticketVo]:{}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false));
                if (cacheType == 1 || cacheType == 2 || cacheType == 3) {
                    this.calculateCashUseAmount(canUseCashticketVo, orderVos);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            canUseCashticketVo.setList(null);
            canUseCashticketVo.setNum(0);
            canUseCashticketVo.setSelectCashVo(null);
        }
        canUseCashticketVo.setUnUseList(unUseList);
        this.logger.info("the-over-[canUseCashticketVo]:{}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false));
        return canUseCashticketVo;
    }

    private void setNoUseCash(int cacheType, List<Integer> selectCashticketList, List<MallOrderVo> orderVos, List<CashItemVo> cashItemVoList) {
        if (cacheType == 2 && !selectCashticketList.isEmpty()) {
            ArrayList<MallProductVO> mallProductVOList = new ArrayList<MallProductVO>();
            ArrayList<MallPromotionVO> mallPromotionVOList = new ArrayList<MallPromotionVO>();
            for (MallOrderVo mallOrderVo : orderVos) {
                if (!mallOrderVo.getProducts().isEmpty()) {
                    mallProductVOList.addAll(mallOrderVo.getProducts());
                }
                if (mallOrderVo.getPromotions().isEmpty()) continue;
                mallPromotionVOList.addAll(mallOrderVo.getPromotions());
            }
            if (mallProductVOList.size() > 0) {
                mallProductVOList.forEach(mallProductVO -> {
                    mallProductVO.setUseCoupon(0);
                    boolean useCash = false;
                    for (CashItemVo cashItemVo : cashItemVoList) {
                        for (MallUseCashItemVO useCashItemVO : cashItemVo.getUseCashItemVOList()) {
                            if (!Objects.equals(useCashItemVO.getItemId(), mallProductVO.getProId()) || !Objects.equals(useCashItemVO.getProductType(), SalesTypeEnum.SALES_PRODUCT.getValue())) continue;
                            useCash = true;
                            mallProductVO.setUseCoupon(1);
                            break;
                        }
                        if (!useCash) continue;
                        break;
                    }
                });
            }
            if (mallPromotionVOList.size() > 0) {
                mallPromotionVOList.forEach(mallPromotionVO -> {
                    mallPromotionVO.setUseCoupon(0);
                    boolean useCash = false;
                    for (CashItemVo cashItemVo : cashItemVoList) {
                        for (MallUseCashItemVO useCashItemVO : cashItemVo.getUseCashItemVOList()) {
                            if (!Objects.equals(useCashItemVO.getItemId(), mallPromotionVO.getPromotionId()) || !Objects.equals(useCashItemVO.getProductType(), SalesTypeEnum.SALES_PROMOTION.getValue())) continue;
                            useCash = true;
                            mallPromotionVO.setUseCoupon(1);
                            break;
                        }
                        if (!useCash) continue;
                        break;
                    }
                });
            }
        }
    }

    private BigDecimal caclUseCash4Product(CashticketSimpleVo simpleVo, BigDecimal total_use_cash_amonut, MallOrderVo mallOrderVo, List<CashticketBatchNewRuleVo> productCashRuleList, CashItemVo cashItemVo, List<MallProductCategoryEntity> categoryList, Map<Integer, CashticketBatchNewRuleVo> rule_map) {
        for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
            List<CashticketBatchNewRuleVo> tempRuleList;
            if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
            if (!(productCashRuleList.isEmpty() || (tempRuleList = productCashRuleList.stream().filter(r -> Objects.equals(r.getTicketBatchId(), mallProductVO.getProId())).collect(Collectors.toList())).isEmpty() || this.canUseCash(tempRuleList, simpleVo))) {
                this.logger.info("\u5355\u54c1\u5546\u54c1:{}\u4e0d\u80fd\u4f7f\u7528:{}\u4f18\u60e0\u5238", (Object)mallProductVO.getProName(), (Object)simpleVo.getTicketBatchName());
                continue;
            }
            BaseJsonVo baseJsonVo = this.getCashUseStatus(rule_map, mallProductVO.getProId(), CashRuleTypeEnum.danpin.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode());
            boolean flag = baseJsonVo.isSuccess();
            if (!flag && rule_map != null && StringUtils.isNotEmpty((String)mallProductVO.getProductCategoryId())) {
                flag = this.getCashUseStatus(rule_map, mallProductVO.getProductCategoryId(), CashRuleTypeEnum.product_class.getValue(), categoryList);
                this.logger.info("\u5546\u54c1:{},\u7c7b\u76ee:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallProductVO.getProName(), mallProductVO.getProductCategoryId(), flag});
            }
            this.logger.info("\u5546\u54c1:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallProductVO.getProName(), simpleVo.getTicketBatchName(), flag});
            if (!flag) continue;
            total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallProductVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallProductVO.getFactPrice()).subtract(mallProductVO.getFullcutAmount()));
            this.logger.info("\u5546\u54c1:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{},\u53ef\u7528\u91d1\u989d:{}", new Object[]{mallProductVO.getProName(), simpleVo.getTicketBatchName(), flag, total_use_cash_amonut});
            MallUseCashItemVO mallUseCashItemVO = new MallUseCashItemVO();
            mallUseCashItemVO.setCount(mallProductVO.getCount());
            mallUseCashItemVO.setFactPrice(mallProductVO.getFactPrice());
            mallUseCashItemVO.setDeliverCount(mallOrderVo.getDeliverCount());
            mallUseCashItemVO.setItemId(mallProductVO.getItemId());
            mallUseCashItemVO.setItemName(mallProductVO.getProName());
            mallUseCashItemVO.setProductType(SalesTypeEnum.SALES_PRODUCT.getValue());
            mallUseCashItemVO.setFullcutAmount(mallProductVO.getFullcutAmount());
            cashItemVo.getUseCashItemVOList().add(mallUseCashItemVO);
        }
        return total_use_cash_amonut;
    }

    private BigDecimal caclUseCash4Promotion(CashticketSimpleVo simpleVo, BigDecimal total_use_cash_amonut, MallOrderVo mallOrderVo, List<CashticketBatchNewRuleVo> promotionCashRuleList, CashItemVo cashItemVo, List<MallProductCategoryEntity> categoryList, Map<Integer, CashticketBatchNewRuleVo> rule_map, int cacheType) {
        for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
            this.logger.info("\u5f00\u59cb\u67e5\u8be2\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), mallPromotionVO.getUseCoupon().intValue() == MallCashUseStatusEnum.use.getValue()});
            if (mallPromotionVO.getUseCoupon().intValue() == MallCashUseStatusEnum.use.getValue()) {
                List<CashticketBatchNewRuleVo> tempRuleList;
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(promotionCashRuleList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(tempRuleList = promotionCashRuleList.stream().filter(r -> Objects.equals(r.getTicketBatchId(), mallPromotionVO.getPromotionId())).collect(Collectors.toList())) && !this.canUseCash(tempRuleList, simpleVo)) {
                    this.logger.info("\u4fc3\u9500:{}\u4e0d\u80fd\u4f7f\u7528:{}\u4f18\u60e0\u5238 \u4e0d\u6ee1\u8db3\u4ea7\u54c1\u5238\u4f7f\u7528\u6761\u4ef6", (Object)mallPromotionVO.getPromotionName(), (Object)simpleVo.getTicketBatchName());
                    continue;
                }
                BaseJsonVo baseJsonVo = this.getCashUseStatus(rule_map, mallPromotionVO.getPromotionId(), CashRuleTypeEnum.cuxiao.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode());
                boolean useFlag = baseJsonVo.isSuccess();
                this.logger.info("\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), useFlag});
                if (!useFlag) {
                    if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(mallPromotionVO.getProductType()).intValue()) {
                        useFlag = this.getCashUseStatus(rule_map, mallPromotionVO.getProduct().getProductCategoryId(), CashRuleTypeEnum.product_class.getValue(), categoryList);
                    } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(mallPromotionVO.getProductType()).intValue()) {
                        for (MallProductVO productVO : mallPromotionVO.getGroup().getProductList()) {
                            useFlag = this.getCashUseStatus(rule_map, productVO.getProductCategoryId(), CashRuleTypeEnum.product_class.getValue(), categoryList);
                            if (useFlag) continue;
                            this.logger.info("\u4fc3\u9500:{},\u5546\u54c1:{}\u4e0d\u80fd\u4f7f\u7528\u5238:{} \u4e0d\u7b26\u5408\u7c7b\u76ee\u9650\u5236\u4f7f\u7528\u6761\u4ef6", new Object[]{mallPromotionVO.getPromotionName(), productVO.getProName(), simpleVo.getTicketBatchName()});
                            break;
                        }
                    }
                    this.logger.info("\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), useFlag});
                }
                if (useFlag) {
                    BigDecimal fullCutAmount = mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getFullcutAmount() : mallPromotionVO.getProduct().getFullcutAmount();
                    total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallPromotionVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallPromotionVO.getFactPrice()).subtract(fullCutAmount));
                    MallUseCashItemVO mallUseCashItemVO = new MallUseCashItemVO();
                    mallUseCashItemVO.setCount(mallPromotionVO.getCount());
                    mallUseCashItemVO.setFactPrice(mallPromotionVO.getFactPrice());
                    mallUseCashItemVO.setDeliverCount(mallOrderVo.getDeliverCount());
                    mallUseCashItemVO.setItemId(mallPromotionVO.getPromotionId());
                    mallUseCashItemVO.setItemName(mallPromotionVO.getPromotionName());
                    mallUseCashItemVO.setProductType(SalesTypeEnum.SALES_PROMOTION.getValue());
                    mallUseCashItemVO.setFullcutAmount(fullCutAmount);
                    cashItemVo.getUseCashItemVOList().add(mallUseCashItemVO);
                }
                this.logger.info("\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), useFlag});
            }
            this.logger.info("\u4fc3\u9500:{},\u4f18\u60e0\u5238:{},\u662f\u5426\u53ef\u7528:{}", new Object[]{mallPromotionVO.getPromotionName(), simpleVo.getTicketBatchName(), mallPromotionVO.getUseCoupon()});
        }
        return total_use_cash_amonut;
    }

    private boolean canUseCash(List<CashticketBatchNewRuleVo> productCashList, CashticketSimpleVo simpleVo) {
        List cashList;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(productCashList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(cashList = productCashList.stream().map(CashticketBatchNewRuleVo::getDetailIds).collect(Collectors.toList()))) {
            return cashList.stream().anyMatch(c -> c.contains(simpleVo.getTicketBatchId()));
        }
        return false;
    }

    private SelectCashVo getDefaultUseCash(CanUseCashticketVo canUseCashticketVo, List<CashItemVo> cashItemVoList) {
        SelectCashVo selectCashVo = new SelectCashVo();
        ArrayList<Integer> selectCashticketList = new ArrayList<Integer>();
        if (canUseCashticketVo.getList().size() == 1) {
            this.logger.info("1-getDefaultUseCash:canUseCashticketVo={},selectCashticketList={}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false), (Object)JsonUtils.toJson(selectCashticketList, (boolean)false));
            return this.getSelectCashVo(canUseCashticketVo, selectCashticketList);
        }
        List<CashItemVo> unComposeCashticketVos = cashItemVoList.stream().filter(mallCashticketVo -> mallCashticketVo.getComposeUse().intValue() == CashComposeUseEnum.unavailable.getValue() && mallCashticketVo.getEnableCashticketAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List<CashItemVo> composeCashticketVos = cashItemVoList.stream().filter(mallCashticketVo -> mallCashticketVo.getComposeUse().intValue() == CashComposeUseEnum.available.getValue() && mallCashticketVo.getEnableCashticketAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        if (unComposeCashticketVos.size() == 0 || composeCashticketVos.size() == 0) {
            this.logger.info("2-getDefaultUseCash:canUseCashticketVo={},selectCashticketList={}", (Object)JsonUtils.toJson((Object)canUseCashticketVo, (boolean)false), (Object)JsonUtils.toJson(selectCashticketList, (boolean)false));
            return this.getSelectCashVo(canUseCashticketVo, selectCashticketList);
        }
        BestChooseCash.CashCompose cashCompose = this.bestChooseCash.get(composeCashticketVos, unComposeCashticketVos);
        this.logger.info("\u67e5\u770bcashCompose:{}", (Object)cashCompose.toString());
        if (cashCompose.getItemList().size() >= 2) {
            selectCashticketList.addAll(cashCompose.getItemList().stream().map(BestChooseCash.CashComposeItem::getTicketCustomerId).collect(Collectors.toList()));
            for (BestChooseCash.CashComposeItem cashComposeItem : cashCompose.getItemList()) {
                Optional<CashticketVo> result = canUseCashticketVo.getList().stream().filter(cash -> cash.getTicketCustomerId().equals(cashComposeItem.getTicketCustomerId())).findFirst();
                if (!result.isPresent()) continue;
                this.logger.info("\u5238\u7c7b\u578b:{}, TicketCustomerId={},\u62b5\u6263\u91d1\u989d:{}", new Object[]{CashComposeUseEnum.getName(cashComposeItem.getComPoseType()), result.get().getTicketCustomerId(), result.get().getEnableCashticketAmount()});
                if (cashComposeItem.getComPoseType() == CashComposeUseEnum.available.getValue()) {
                    result.get().setEnableCashticketAmount(composeCashticketVos.stream().filter(cashItemVo -> cashItemVo.getTicketCustomerId().equals(cashComposeItem.getTicketCustomerId())).findFirst().get().getEnableCashticketAmount());
                }
                if (cashComposeItem.getComPoseType() == CashComposeUseEnum.unavailable.getValue()) {
                    result.get().setEnableCashticketAmount(unComposeCashticketVos.stream().filter(cashItemVo -> cashItemVo.getTicketCustomerId().equals(cashComposeItem.getTicketCustomerId())).findFirst().get().getEnableCashticketAmount());
                }
                this.logger.info("\u5238\u7c7b\u578b:{} TicketCustomerId={},\u8ba1\u7b97\u540e\u62b5\u6263\u91d1\u989d:{}", new Object[]{CashComposeUseEnum.getName(cashComposeItem.getComPoseType()), result.get().getTicketCustomerId(), result.get().getEnableCashticketAmount()});
            }
        } else {
            selectCashticketList.add(cashItemVoList.get(0).getTicketCustomerId());
            selectCashVo.setDescName(cashItemVoList.get(0).getTicketBatchName());
            this.logger.info("\u4f7f\u7528\u5355\u4e2a\u5238:{}", (Object)selectCashVo.toString());
        }
        selectCashVo.setCashAmout(cashCompose.getEnableCashticketAmount());
        selectCashVo.setDescName("\u63a8\u8350\u4f18\u60e0\u7ec4\u5408");
        selectCashVo.setSelectCashList(selectCashticketList);
        this.logger.info("\u63a8\u8350\u4f18\u60e0\u7ec4\u5408:{}", (Object)selectCashVo.toString());
        return selectCashVo;
    }

    private SelectCashVo getSelectCashVo(CanUseCashticketVo canUseCashticketVo, List<Integer> selectCashticketList) {
        SelectCashVo selectCashVo = new SelectCashVo();
        canUseCashticketVo.setNum(1);
        selectCashVo.setFreeCash(canUseCashticketVo.getList().get(0).getFreeCash());
        selectCashticketList.add(canUseCashticketVo.getList().get(0).getTicketCustomerId());
        selectCashVo.setDescName(canUseCashticketVo.getList().get(0).getTicketBatchName());
        selectCashVo.setCashAmout(canUseCashticketVo.getList().get(0).getEnableCashticketAmount());
        selectCashVo.setSelectCashList(selectCashticketList);
        return selectCashVo;
    }

    private void calculateCashUseAmount(CanUseCashticketVo canUseCashticketVo, List<MallOrderVo> orderVos) {
        block13: {
            MallOrderVo mallOrderVo;
            BigDecimal diff_amount;
            block15: {
                block14: {
                    for (CashticketVo cashticketVo : canUseCashticketVo.getList()) {
                        BigDecimal total_use_cash_amonut = cashticketVo.getTotalUseCashAmonut();
                        this.logger.info("\u4f18\u60e0\u5238:{}\u62b5\u6263\u91d1\u989d:{},\u603b\u7684\u53ef\u7528\u5238\u5546\u54c1\u91d1\u989d:{}", new Object[]{cashticketVo.getTicketBatchName(), cashticketVo.getEnableCashticketAmount(), total_use_cash_amonut});
                        for (MallOrderVo mallOrderVo2 : orderVos) {
                            BigDecimal single_amount;
                            BigDecimal couponAmount = BigDecimal.ZERO;
                            boolean order_use_cash = false;
                            if (mallOrderVo2.getProducts() != null) {
                                for (MallProductVO mallProductVO : mallOrderVo2.getProducts()) {
                                    this.logger.info("\u5546\u54c1:{},\u662f\u5426\u53ef\u7528\u4f18\u60e0\u5238:{}", (Object)mallProductVO.getProName(), (Object)mallProductVO.getUseCoupon());
                                    if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                                    order_use_cash = true;
                                    single_amount = cashticketVo.getEnableCashticketAmount().multiply(mallProductVO.getFactPrice().subtract(PriceUtils.divide((BigDecimal)mallProductVO.getFullcutAmount(), (BigDecimal)BigDecimal.valueOf(mallProductVO.getCount().intValue()), (int)6, (Integer)4))).divide(total_use_cash_amonut, 6, 4);
                                    mallProductVO.setCouponAmount(mallProductVO.getCouponAmount().add(single_amount));
                                    this.logger.info("\u5546\u54c1:{},\u5206\u63a8\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallProductVO.getProName(), (Object)mallProductVO.getCouponAmount());
                                    couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount, (Number)mallProductVO.getCount()));
                                }
                            }
                            if (mallOrderVo2.getGroups() != null) {
                                for (MallGroupVO mallGroupVO : mallOrderVo2.getGroups()) {
                                    if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                                    order_use_cash = true;
                                    single_amount = cashticketVo.getEnableCashticketAmount().multiply(mallGroupVO.getFactPrice().subtract(PriceUtils.divide((BigDecimal)mallGroupVO.getFullcutAmount(), (BigDecimal)BigDecimal.valueOf(mallGroupVO.getCount().intValue()), (int)6, (Integer)4))).divide(total_use_cash_amonut, 6, 4);
                                    mallGroupVO.setCouponAmount(mallGroupVO.getCouponAmount().add(single_amount));
                                    couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount, (Number)mallGroupVO.getCount()));
                                }
                            }
                            if (mallOrderVo2.getPromotions() != null) {
                                for (MallPromotionVO mallPromotionVO : mallOrderVo2.getPromotions()) {
                                    this.logger.info("\u5546\u54c1:{},\u662f\u5426\u53ef\u7528\u4f18\u60e0\u5238:{}", (Object)mallPromotionVO.getPromotionName(), (Object)mallPromotionVO.getUseCoupon());
                                    if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                                    order_use_cash = true;
                                    BigDecimal fullCutAmount = PriceUtils.divide((BigDecimal)(mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getFullcutAmount() : mallPromotionVO.getProduct().getFullcutAmount()), (BigDecimal)BigDecimal.valueOf(mallPromotionVO.getCount().intValue()), (int)6, (Integer)4);
                                    BigDecimal single_amount2 = cashticketVo.getEnableCashticketAmount().multiply(mallPromotionVO.getFactPrice().subtract(fullCutAmount)).divide(total_use_cash_amonut, 6, 4);
                                    mallPromotionVO.setCouponAmount(single_amount2);
                                    this.logger.info("\u5546\u54c1:{},\u5206\u63a8\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallPromotionVO.getPromotionName(), (Object)mallPromotionVO.getCouponAmount());
                                    couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount2, (Number)mallPromotionVO.getCount()));
                                }
                            }
                            mallOrderVo2.setUseCoupon(order_use_cash);
                            if (canUseCashticketVo.getSelectCashVo() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(canUseCashticketVo.getSelectCashVo().getSelectCashList())) {
                                for (Integer ticketId : canUseCashticketVo.getSelectCashVo().getSelectCashList()) {
                                    if (!Objects.equals(ticketId, cashticketVo.getTicketCustomerId())) continue;
                                    mallOrderVo2.setCouponAmount(mallOrderVo2.getCouponAmount().add(couponAmount));
                                }
                            }
                            this.logger.info("\u5b50\u5355\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallOrderVo2.getCouponAmount());
                        }
                    }
                    BigDecimal orderCouponAmount = BigDecimal.valueOf(orderVos.stream().mapToDouble(c -> MathUtils.mulBigDecimal((Number)c.getCouponAmount(), (Number)c.getDeliverCount()).doubleValue()).sum());
                    BigDecimal enableCouponAmount = canUseCashticketVo.getList().stream().filter(cash -> canUseCashticketVo.getSelectCashVo() != null && canUseCashticketVo.getSelectCashVo().getSelectCashList().stream().anyMatch(selectTiceket -> Objects.equals(selectTiceket, cash.getTicketCustomerId()))).map(CashticketVo::getEnableCashticketAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    diff_amount = enableCouponAmount.subtract(orderCouponAmount);
                    this.logger.info("\u8ba2\u5355\u7528\u6237\u5238\u91d1\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u5dee\u989d:{}", new Object[]{orderCouponAmount, enableCouponAmount, diff_amount});
                    if (diff_amount.doubleValue() == 0.0) break block13;
                    mallOrderVo = orderVos.get(0);
                    mallOrderVo.setCouponAmount(mallOrderVo.getCouponAmount().add(diff_amount));
                    this.logger.info("\u5b50\u5355\u4f18\u60e0\u5238\u91d1\u989d:{}", (Object)mallOrderVo.getCouponAmount());
                    if (mallOrderVo.getProducts() == null) break block14;
                    for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
                        if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        mallProductVO.setCouponAmount(mallProductVO.getCouponAmount().add(diff_amount));
                        break block13;
                    }
                    break block13;
                }
                if (mallOrderVo.getGroups() == null) break block15;
                for (MallGroupVO mallGroupVO : mallOrderVo.getGroups()) {
                    if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    mallGroupVO.setCouponAmount(mallGroupVO.getCouponAmount().add(diff_amount));
                    break block13;
                }
                break block13;
            }
            if (mallOrderVo.getPromotions() == null) break block13;
            for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
                if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                mallPromotionVO.setCouponAmount(mallPromotionVO.getCouponAmount().add(diff_amount));
                break;
            }
        }
    }

    @Override
    public List<CashticketVo> getEnabledCashticketList(int platformGroupId, int ticketCustomerId, String customerId, List<MallOrderVo> orderVos) {
        if (orderVos == null || orderVos.size() == 0) {
            return this.getValidCashticketList(platformGroupId, customerId, 0);
        }
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, ticketCustomerId, 1);
        this.logger.info("\u8fd4\u56de\u4f18\u60e0\u5238\u884c\u6570\uff1a{},platformGroupId={},customerId={},ticketCustomerId={},select_status_valid={}", new Object[]{ls.size(), platformGroupId, customerId, ticketCustomerId, 1});
        if (ls == null || ls.size() == 0) {
            return rs;
        }
        boolean jxbdz_fk = true;
        if (orderVos.get(0).getOrderSource() == OrderSourceEnum.COLLAGE.getValue()) {
            return null;
        }
        List<DictionaryEntity> cashClassList = this.cashticketClassService.getCashticketClass(platformGroupId);
        block2: for (CashticketSimpleVo simpleVo : ls) {
            List<CashticketBatchNewRuleVo> rule_ls = this.cashticketBatchNewRuleService.getCashRule(simpleVo.getTicketBatchId());
            boolean productCashFlag = org.apache.commons.collections.CollectionUtils.isNotEmpty(rule_ls);
            Map<Integer, CashticketBatchNewRuleVo> rule_map = rule_ls == null || rule_ls.size() == 0 ? null : rule_ls.stream().collect(Collectors.toMap(o -> o.getRuleType(), o -> o));
            BigDecimal total_use_cash_amonut = new BigDecimal(0);
            for (MallOrderVo mallOrderVo : orderVos) {
                BaseJsonVo baseJsonVo;
                if (mallOrderVo.getProducts() != null) {
                    for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
                        if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        baseJsonVo = this.getCashUseStatus(rule_map, mallProductVO.getProId(), CashRuleTypeEnum.danpin.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode());
                        boolean flag = baseJsonVo.isSuccess();
                        if (!flag) {
                            baseJsonVo = this.getCashUseStatus(rule_map, String.valueOf(mallProductVO.getTransportType()), CashRuleTypeEnum.transport.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode());
                            flag = baseJsonVo.isSuccess();
                        }
                        if (!flag) {
                            baseJsonVo = this.getCashUseStatus(rule_map, mallProductVO.getProductCategoryId(), CashRuleTypeEnum.product_class.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode());
                            flag = baseJsonVo.isSuccess();
                        }
                        if (flag) {
                            total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallProductVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallProductVO.getFactPrice()).subtract(mallProductVO.getFullcutAmount()));
                            if (((Boolean)baseJsonVo.getValue()).booleanValue()) {
                                productCashFlag = (Boolean)baseJsonVo.getValue();
                            }
                        } else if (ticketCustomerId != 0) {
                            mallProductVO.setUseCoupon(MallCashUseStatusEnum.no_use.getValue());
                        }
                        jxbdz_fk = false;
                    }
                }
                if (mallOrderVo.getGroups() != null) {
                    for (MallGroupVO mallGroupVO : mallOrderVo.getGroups()) {
                        if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        baseJsonVo = this.getCashUseStatus(rule_map, mallGroupVO.getGroupId(), CashRuleTypeEnum.taozhuang.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode());
                        if (baseJsonVo.isSuccess()) {
                            total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallGroupVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallGroupVO.getFactPrice()).subtract(mallGroupVO.getFullcutAmount()));
                            if (((Boolean)baseJsonVo.getValue()).booleanValue()) {
                                productCashFlag = (Boolean)baseJsonVo.getValue();
                            }
                        } else if (ticketCustomerId != 0) {
                            mallGroupVO.setUseCoupon(MallCashUseStatusEnum.no_use.getValue());
                        }
                        jxbdz_fk = false;
                    }
                }
                if (mallOrderVo.getPromotions() == null) continue;
                for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
                    if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    baseJsonVo = this.getCashUseStatus(rule_map, mallPromotionVO.getPromotionId(), CashRuleTypeEnum.cuxiao.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode());
                    if (baseJsonVo.isSuccess()) {
                        BigDecimal fullCutAmount = mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getFullcutAmount() : mallPromotionVO.getProduct().getFullcutAmount();
                        total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallPromotionVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallPromotionVO.getFactPrice()).subtract(fullCutAmount));
                        if (((Boolean)baseJsonVo.getValue()).booleanValue()) {
                            productCashFlag = (Boolean)baseJsonVo.getValue();
                        }
                    } else if (ticketCustomerId != 0) {
                        mallPromotionVO.setUseCoupon(MallCashUseStatusEnum.no_use.getValue());
                    }
                    jxbdz_fk = false;
                }
            }
            this.logger.info("total_use_cash_amonut.doubleValue() >= simpleVo.getMinUseamount().doubleValue()," + total_use_cash_amonut.doubleValue() + "," + simpleVo.getMinUseamount().doubleValue());
            if (!(total_use_cash_amonut.doubleValue() >= simpleVo.getMinUseamount().doubleValue())) continue;
            BigDecimal enableCashticketAmount = null;
            if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
                enableCashticketAmount = total_use_cash_amonut.doubleValue() > simpleVo.getAmount().doubleValue() ? simpleVo.getAmount() : total_use_cash_amonut;
            } else if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
                enableCashticketAmount = MathUtils.divBigDecimal((Double)MathUtils.mulBigDecimal((Number)total_use_cash_amonut, (Number)(100 - simpleVo.getDiscountAmount())).doubleValue(), (Double)100.0, (Integer)2);
            }
            this.logger.info("\u4f18\u60e0\u5238\u91d1\u989d\uff1a{}", (Object)enableCashticketAmount);
            if (enableCashticketAmount != null && enableCashticketAmount.doubleValue() != 0.0) {
                CashticketVo cashticketVo = this.getCashticketVo(simpleVo, true, enableCashticketAmount, productCashFlag);
                cashticketVo.setTicetClass(simpleVo.getTicetClass());
                cashticketVo.setTicetClassName(this.cashticketClassService.getCashticketClassName(cashClassList, simpleVo.getTicetClass()));
                rs.add(cashticketVo);
                this.logger.info("\u4f18\u60e0\u5238rs\uff1a{},", (Object)rs.size());
            }
            if (ticketCustomerId == 0) continue;
            for (MallOrderVo mallOrderVo : orderVos) {
                BigDecimal single_amount;
                BigDecimal couponAmount = new BigDecimal(0);
                boolean order_use_cash = false;
                if (mallOrderVo.getProducts() != null) {
                    for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
                        if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        order_use_cash = true;
                        single_amount = enableCashticketAmount.multiply(mallProductVO.getFactPrice().subtract(PriceUtils.divide((BigDecimal)mallProductVO.getFullcutAmount(), (BigDecimal)BigDecimal.valueOf(mallProductVO.getCount().intValue()), (int)6, (Integer)4))).divide(total_use_cash_amonut, 6, 4);
                        mallProductVO.setCouponAmount(single_amount);
                        couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount, (Number)mallProductVO.getCount()));
                    }
                }
                if (mallOrderVo.getGroups() != null) {
                    for (MallGroupVO mallGroupVO : mallOrderVo.getGroups()) {
                        if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        order_use_cash = true;
                        single_amount = enableCashticketAmount.multiply(mallGroupVO.getFactPrice().subtract(PriceUtils.divide((BigDecimal)mallGroupVO.getFullcutAmount(), (BigDecimal)BigDecimal.valueOf(mallGroupVO.getCount().intValue()), (int)6, (Integer)4))).divide(total_use_cash_amonut, 6, 4);
                        mallGroupVO.setCouponAmount(single_amount);
                        couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount, (Number)mallGroupVO.getCount()));
                    }
                }
                if (mallOrderVo.getPromotions() != null) {
                    for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
                        if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        order_use_cash = true;
                        BigDecimal fullCutAmount = PriceUtils.divide((BigDecimal)(mallPromotionVO.getGroup() != null ? mallPromotionVO.getGroup().getFullcutAmount() : mallPromotionVO.getProduct().getFullcutAmount()), (BigDecimal)BigDecimal.valueOf(mallPromotionVO.getCount().intValue()), (int)6, (Integer)4);
                        BigDecimal single_amount2 = enableCashticketAmount.multiply(mallPromotionVO.getFactPrice().subtract(fullCutAmount)).divide(total_use_cash_amonut, 6, 4);
                        mallPromotionVO.setCouponAmount(single_amount2);
                        couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount2, (Number)mallPromotionVO.getCount()));
                    }
                }
                mallOrderVo.setUseCoupon(order_use_cash);
                mallOrderVo.setCouponAmount(couponAmount);
            }
            BigDecimal orderCouponAmount = BigDecimal.valueOf(orderVos.stream().mapToDouble(c -> MathUtils.mulBigDecimal((Number)c.getCouponAmount(), (Number)c.getDeliverCount()).doubleValue()).sum());
            BigDecimal diff_amount = enableCashticketAmount.subtract(orderCouponAmount);
            if (diff_amount.doubleValue() == 0.0) continue;
            MallOrderVo mallOrderVo = orderVos.get(0);
            mallOrderVo.setCouponAmount(mallOrderVo.getCouponAmount().add(diff_amount));
            if (mallOrderVo.getProducts() != null) {
                for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
                    if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    mallProductVO.setCouponAmount(mallProductVO.getCouponAmount().add(diff_amount));
                    continue block2;
                }
                continue;
            }
            if (mallOrderVo.getGroups() != null) {
                for (MallGroupVO mallGroupVO : mallOrderVo.getGroups()) {
                    if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    mallGroupVO.setCouponAmount(mallGroupVO.getCouponAmount().add(diff_amount));
                    continue block2;
                }
                continue;
            }
            if (mallOrderVo.getPromotions() == null) continue;
            for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
                if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                mallPromotionVO.setCouponAmount(mallPromotionVO.getCouponAmount().add(diff_amount));
                continue block2;
            }
        }
        this.logger.info("\u53ef\u7528\u4f30\u91cf\u5238\u96c6\u5408:{}", (Object)JSON.toJSONString(orderVos));
        if (rs.size() > 0) {
            try {
                Collections.sort(rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (jxbdz_fk) {
            rs = null;
        }
        return rs;
    }

    @Override
    public Boolean getCustomerHasTicket(String customerId, String ticketBatchId) {
        Integer hasAndUsedTicket = this.getCustomerHasAndUsedTicket(customerId, ticketBatchId);
        if (hasAndUsedTicket == 0) {
            return false;
        }
        return true;
    }

    @Override
    public Integer getCustomerHasAndUsedTicket(String customerId, String ticketBatchId) {
        CashticketCustomerEntity entity = new CashticketCustomerEntity();
        entity.setCustomerId(customerId);
        entity.setTicketBatchId(ticketBatchId);
        List entities = this.cashticketCustomerMapper.getList(entity);
        if (entities != null && entities.size() > 0) {
            if (((CashticketCustomerEntity)entities.get(0)).getStatus() == 1) {
                Date now = DateUtils.now();
                if (now.after(((CashticketCustomerEntity)entities.get(0)).getBeginTime()) && now.before(((CashticketCustomerEntity)entities.get(0)).getEndTime())) {
                    return 1;
                }
                return 3;
            }
            if (((CashticketCustomerEntity)entities.get(0)).getStatus() == 2) {
                return 2;
            }
        }
        return 0;
    }

    private CashticketVo getCashticketVo(CashticketSimpleVo simpleVo, boolean status, BigDecimal enableCashticketAmount, boolean productCashFlag) {
        CashticketVo vo = new CashticketVo();
        vo.setTicketCustomerId(simpleVo.getTicketCustomerId());
        vo.setTicketBatchName(simpleVo.getTicketBatchName());
        vo.setTimes(DateUtils.formatDate((Date)simpleVo.getBeginTime(), (String)"yyyy.MM.dd") + "-" + DateUtils.formatDate((Date)simpleVo.getEndTime(), (String)"yyyy.MM.dd"));
        vo.setEnable(this.getCashStatus(simpleVo, status));
        vo.setTicketAmount(Objects.equals(simpleVo.getFreeCash(), 1) ? BigDecimal.ZERO : simpleVo.getAmount());
        vo.setDiscountMode(simpleVo.getDiscountMode().shortValue());
        vo.setDiscountAmount(MathUtils.divBigDecimal((Number)simpleVo.getDiscountAmount(), (Number)10, (Integer)2));
        vo.setRemark(simpleVo.getRemark());
        vo.setEnableCashticketAmount(enableCashticketAmount);
        vo.setProductType(productCashFlag ? 2 : 1);
        vo.setComposeUse(simpleVo.getComposeUse());
        vo.setFreeCash(simpleVo.getFreeCash());
        if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
            vo.setTicketAmount(enableCashticketAmount);
        }
        if (simpleVo.getMinUseamount().compareTo(BigDecimal.ZERO) == 0) {
            vo.setCutDesc("\u65e0\u95e8\u69db");
        } else if (new BigDecimal(simpleVo.getMinUseamount().intValue()).compareTo(simpleVo.getMinUseamount()) == 0) {
            vo.setCutDesc("\u6ee1" + simpleVo.getMinUseamount().intValue() + "\u53ef\u7528");
        } else {
            vo.setCutDesc("\u6ee1" + simpleVo.getMinUseamount().doubleValue() + "\u53ef\u7528");
        }
        vo.setUseType(simpleVo.getUseType());
        vo.setMinUseamount(simpleVo.getMinUseamount());
        vo.setTicketBatchId(simpleVo.getTicketBatchId());
        if (StringUtils.isEmpty((String)simpleVo.getCashUseUrl())) {
            vo.setGoType(2);
            vo.setProId("");
            vo.setUseUrl("");
            vo.setUseProductType(0);
            boolean flag = false;
            if (simpleVo.getUseType() == 1) {
                vo.setGoType(1);
                vo.setProId("");
                vo.setUseUrl("");
            }
            if (simpleVo.getUseType() == 2) {
                String[] arr;
                List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleService.getCashRule(simpleVo.getTicketBatchId());
                if (list != null && list.size() == 1 && ((arr = list.get(0).getDetailIds().split(",")).length == 1 && list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() || list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue())) {
                    flag = true;
                }
                if (flag) {
                    vo.setGoType(4);
                    vo.setProId(list.get(0).getDetailIds());
                    vo.setUseUrl("");
                    vo.setUseProductType(list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() ? 4 : (list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue() ? 1 : CashRuleTypeEnum.taozhuang.getValue()));
                }
            }
        } else {
            String[] arr;
            vo.setGoType(3);
            vo.setProId("");
            boolean flag = false;
            List<CashticketBatchNewRuleVo> list = this.cashticketBatchNewRuleService.getCashRule(simpleVo.getTicketBatchId());
            if (list != null && list.size() == 1 && ((arr = list.get(0).getDetailIds().split(",")).length == 1 && list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() || list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue())) {
                flag = true;
            }
            if (flag) {
                vo.setProId(list.get(0).getDetailIds());
                vo.setUseProductType(list.get(0).getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue() ? 4 : (list.get(0).getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue() ? 1 : CashRuleTypeEnum.taozhuang.getValue()));
            }
            vo.setUseUrl(simpleVo.getCashUseUrl());
        }
        vo.setTicketStatus(simpleVo.getTicketStatus());
        vo.setUseTypeName(simpleVo.getUseType() == 1 ? "\u901a\u7528\u5238" : "\u5546\u54c1\u5238");
        return vo;
    }

    private CashticketVo getCashticketVo(CashticketSimpleVo simpleVo, boolean status, BigDecimal enableCashticketAmount) {
        return this.getCashticketVo(simpleVo, status, enableCashticketAmount, false);
    }

    private int getCashStatus(CashticketSimpleVo simpleVo, boolean status) {
        if (status) {
            return CashStatusEnum.yijihuo.getValue();
        }
        if (simpleVo.getBatchStatus().intValue() == CashBathStatusEnum.jinyong.getValue()) {
            return CashStatusEnum.jinyong.getValue();
        }
        if (simpleVo.getTicketStatus().intValue() == CashStatusEnum.yishiyong.getValue()) {
            return CashStatusEnum.yishiyong.getValue();
        }
        return CashStatusEnum.guoqi.getValue();
    }

    private BaseJsonVo getCashUseStatus(Map<Integer, CashticketBatchNewRuleVo> rule_map, String detail_id, int cash_rule_type, int platFormId, String bindCode) {
        boolean productCash = false;
        if (rule_map != null && rule_map.size() > 0) {
            CashticketBatchNewRuleVo rule_vo;
            boolean flag = false;
            CashticketBatchNewRuleVo rule_plat_vo = rule_map.get(CashRuleTypeEnum.pingtai.getValue());
            if (rule_plat_vo != null) {
                if (rule_map.keySet().size() == 1) {
                    flag = true;
                }
                if (rule_plat_vo.getStats().intValue() != CashRuleStatusEnum.quanbu.getValue()) {
                    if (StringUtils.isEmpty((String)rule_plat_vo.getDetailIds())) {
                        return BaseJsonVo.error((String)"");
                    }
                    List<String> rule_detail_list = Arrays.asList(rule_plat_vo.getDetailIds().split(","));
                    if (!rule_detail_list.contains(platFormId + "")) {
                        return BaseJsonVo.error((String)"");
                    }
                }
            }
            if ((rule_vo = rule_map.get(cash_rule_type)) == null) {
                return flag ? BaseJsonVo.success((Object)productCash) : BaseJsonVo.error((String)"");
            }
            if (rule_vo.getStats().intValue() != CashRuleStatusEnum.quanbu.getValue()) {
                if (StringUtils.isEmpty((String)rule_vo.getDetailIds())) {
                    return BaseJsonVo.error((String)"");
                }
                List<String> rule_detail_list = Arrays.asList(rule_vo.getDetailIds().split(","));
                if (!rule_detail_list.contains(detail_id)) {
                    if (CashRuleTypeEnum.product_class.getValue() != cash_rule_type) {
                        return BaseJsonVo.error((String)"");
                    }
                    List<MallProductCategoryEntity> list = this.productCategoryInterface.getCategoryList();
                    ArrayList<MallProductCategoryEntity> resultList = new ArrayList<MallProductCategoryEntity>();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                        for (String item : rule_detail_list) {
                            List<MallProductCategoryEntity> enableCategoryList = this.getCategoryChildrenList(detail_id, resultList, list);
                            for (MallProductCategoryEntity categoryEntity : enableCategoryList) {
                                if (!Objects.equals(categoryEntity.getCategoryId(), detail_id)) continue;
                                productCash = true;
                                return BaseJsonVo.success((Object)productCash);
                            }
                        }
                    }
                } else {
                    productCash = true;
                }
            }
        }
        return BaseJsonVo.success((Object)productCash);
    }

    private boolean getCashUseStatus(Map<Integer, CashticketBatchNewRuleVo> rule_map, String detail_id, int cash_rule_type, List<MallProductCategoryEntity> list) {
        boolean flag = false;
        CashticketBatchNewRuleVo rule_vo = rule_map.get(cash_rule_type);
        if (rule_vo == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)rule_vo.getDetailIds())) {
            return false;
        }
        List<String> rule_detail_list = Arrays.asList(rule_vo.getDetailIds().split(","));
        ArrayList<MallProductCategoryEntity> resultList = new ArrayList<MallProductCategoryEntity>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            for (String item : rule_detail_list) {
                if (!StringUtils.isNotEmpty((String)item)) continue;
                List<MallProductCategoryEntity> enableCategoryList = this.getCategoryChildrenList(item, resultList, list);
                for (MallProductCategoryEntity categoryEntity : enableCategoryList) {
                    if (!Objects.equals(categoryEntity.getCategoryId(), detail_id)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Integer getCashticketCount(String customerId, Integer enable) {
        return this.cashticketCustomerMapper.getCashticketCount(customerId, enable);
    }

    private List<MallProductCategoryEntity> getMallProductCategoryEntityList(String categoryId, List<MallProductCategoryEntity> resultList, List<MallProductCategoryEntity> list) {
        Optional<MallProductCategoryEntity> categoryEntityOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), categoryId)).findFirst();
        if (categoryEntityOptional.isPresent()) {
            String tempCategoryId = categoryEntityOptional.get().getParentId();
            Optional<MallProductCategoryEntity> tempCategoryEntityOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), tempCategoryId)).findFirst();
            if (categoryEntityOptional.isPresent()) {
                resultList.add(tempCategoryEntityOptional.get());
                return this.getMallProductCategoryEntityList(tempCategoryEntityOptional.get().getCategoryId(), resultList, list);
            }
        }
        return resultList;
    }

    private List<MallProductCategoryEntity> getCategoryChildrenList(String categoryId, List<MallProductCategoryEntity> resultList, List<MallProductCategoryEntity> list) {
        Optional<MallProductCategoryEntity> selfOptional;
        List tempList = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getParentId(), categoryId)).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tempList)) {
            resultList.addAll(tempList);
            Iterator iterator = tempList.iterator();
            if (iterator.hasNext()) {
                MallProductCategoryEntity categoryEntity = (MallProductCategoryEntity)iterator.next();
                return this.getCategoryChildrenList(categoryEntity.getCategoryId(), resultList, list);
            }
        }
        if ((selfOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), categoryId)).findFirst()).isPresent()) {
            resultList.add(selfOptional.get());
        }
        return resultList;
    }
}

