/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketCustomerMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.cashticket.CashticketNoticeInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketNoticeService
extends BaseService
implements CashticketNoticeInterface {
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private CashticketCustomerMapper cashticketCustomerMapper;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private RedisService redisService;

    @Override
    public void sendMessage(String customerId, String ticketName, Date createTime, Date endTime, String remark) {
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("ticketName", ticketName);
            paramsMap.put("createTime", DateUtils.formatDate((Date)createTime, (String)"yyyy-MM-dd"));
            paramsMap.put("endTime", DateUtils.formatDate((Date)endTime, (String)"yyyy-MM-dd"));
            paramsMap.put("notice", StringUtils.isNotEmpty((String)remark) ? remark : "\u8bf7\u53ca\u65f6\u4f7f\u7528\u5662");
            this.messageInterface.sendWechatMessage(MessageActionConstants.cashTakedNotice, customerId, paramsMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u63a8\u9001\u4f18\u60e0\u5238\u9886\u53d6\u6d88\u606f\u5931\u8d25,customerId={},ticketName={},remark={},platformId=", new Object[]{customerId, ticketName, remark});
        }
    }

    @Override
    public BaseJsonVo sendExpireMessage(Date date) {
        List<CashticketCustomerEntity> list = this.cashticketCustomerMapper.getCashticketListByEndDate(date);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, CashticketCustomerEntity> result = list.stream().collect(Collectors.toMap(CashticketCustomerEntity::getCustomerId, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(CashticketCustomerEntity::getTicketAmount))));
            for (Map.Entry<String, CashticketCustomerEntity> entry : result.entrySet()) {
                try {
                    CashticketCustomerEntity cashticketCustomerEntity = entry.getValue();
                    cashticketCustomerEntity.setSendExpireMessage(1);
                    CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(cashticketCustomerEntity.getTicketBatchId());
                    int sendSuccess = 1;
                    if (cashticketBatchEntity.getUserVisible() == 1) {
                        BaseJsonVo baseJsonVo = this.sendExpireMessage(cashticketCustomerEntity.getCustomerId(), cashticketBatchEntity.getTicketBatchName(), cashticketCustomerEntity.getEndTime(), cashticketBatchEntity.getRemark(), cashticketBatchEntity.getAmount());
                        sendSuccess = baseJsonVo.isSuccess() ? 1 : 0;
                    }
                    cashticketCustomerEntity.setSendTacketSuccess(sendSuccess);
                    this.cashticketCustomerMapper.updateByPrimaryKeySelective(cashticketCustomerEntity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendExpireMessage(String customerId, String ticketName, Date endTime, String remark, BigDecimal amount) {
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("ticketName", ticketName);
            paramsMap.put("endTime", DateUtils.formatDate((Date)endTime, (String)"yyyy-MM-dd"));
            paramsMap.put("notice", remark);
            paramsMap.put("amount", amount.toString());
            return this.messageInterface.sendWechatMessage(MessageActionConstants.cashExpireNotice, customerId, paramsMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u63a8\u9001\u4f18\u60e0\u5238\u8fc7\u671f\u6d88\u606f\u5931\u8d25,customerId={},ticketName={},remark={}", new Object[]{customerId, ticketName, remark});
            return BaseJsonVo.error((String)"\u63a8\u9001\u5931\u8d25");
        }
    }
}

