/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketMapper;
import cc.lechun.mall.entity.cashticket.CashticketActivTionVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import cc.lechun.mall.service.cashticket.CashticketCustomerService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketService
extends BaseService
implements CashticketInterface {
    @Autowired
    private CashticketMapper cashticketMapper;
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private CashticketCustomerService cashticketCustomerService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="getCashticket")
    public CashticketEntity getCashticket(@ParameterValueKeyProvider int ticketId) {
        return (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId));
    }

    @Override
    public CashticketEntity getCashticket4No(String ticketNo) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketNo(ticketNo);
        List ls = this.cashticketMapper.getList(cashticketEntity);
        if (ls != null && ls.size() > 0) {
            return (CashticketEntity)ls.get(0);
        }
        return null;
    }

    @Override
    public CashticketActivTionVo getWaitActivtionCashticketList(String ticketBatchId) {
        return this.cashticketMapper.getWaitActivtionCashticketList(ticketBatchId);
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = new CashticketEntity()) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            } else if (cashStatusEnum.getValue() == CashStatusEnum.jinyong.getValue()) {
                cashticketEntity.setLaststatus(CashStatusEnum.yijihuo.getValue());
            }
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            if (this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketStatus(int ticketId, CashStatusEnum cashStatusEnum, CashticketBatchEntity cashticketBatchEntity) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId))) != null) {
            cashticketEntity.setTicketId(ticketId);
            cashticketEntity.setStatus(cashStatusEnum.getValue());
            this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            if (cashStatusEnum.getValue() == CashStatusEnum.yijihuo.getValue()) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(cashticketEntity.getActivtionCount() + 1);
            } else if (cashStatusEnum.getValue() == CashStatusEnum.yishiyong.getValue()) {
                cashticketEntity.setUsedTime(DateUtils.now());
            }
            if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                if (this.cashticketMapper.updateStatusByPrimaryKeySelective(cashticketEntity) == 1) {
                    return true;
                }
            } else {
                this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateCashticketAmount(int ticketId, BigDecimal amount) {
        CashticketEntity cashticketEntity;
        if (ticketId != 0 && (cashticketEntity = (CashticketEntity)this.cashticketMapper.selectByPrimaryKey(Integer.valueOf(ticketId))) != null) {
            cashticketEntity.setTicketAmount(amount);
            return this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity) == 1;
        }
        return false;
    }

    private void addCashTicketNos(CashticketBatchEntity cashticketBatchEntity, int ticketNoNum) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        cashticketEntity.setTicketName(cashticketBatchEntity.getTicketBatchName());
        cashticketEntity.setTicketAmount(cashticketBatchEntity.getAmount());
        cashticketEntity.setStatus(CashStatusEnum.weijihuo.getValue());
        cashticketEntity.setActivtionCount(0);
        int k = 0;
        long new_ticketNoNum = MathUtils.mulBigDecimal((Number)ticketNoNum, (Number)3).longValue();
        int i = 0;
        while ((long)i < new_ticketNoNum && k < ticketNoNum) {
            cashticketEntity.setCreateTime(DateUtils.now());
            if (cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                cashticketEntity.setTicketNo(this.getTicketNo(cashticketBatchEntity.getTicketPosition()));
            } else {
                cashticketEntity.setTicketNo(this.getTicketNo());
            }
            try {
                int l = this.cashticketMapper.insertSelective(cashticketEntity);
                if (l > 0 && cashticketBatchEntity.getCreateType().intValue() == CashCreateTypeEnum.juan.getValue()) {
                    this.redisService.sadd("ticketNo", cashticketEntity.getTicketNo());
                    ++k;
                }
            }
            catch (Exception e) {
                this.logger.error("\u5151\u6362\u7801\u91cd\u590d \u4e0d\u9700\u8981\u5904\u7406", (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    public CashticketEntity addCashTicketNos(CashticketBatchEntity cashticketBatchEntity) {
        CashticketEntity cashticketEntity = new CashticketEntity();
        cashticketEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        cashticketEntity.setTicketName(cashticketBatchEntity.getTicketBatchName());
        cashticketEntity.setTicketAmount(cashticketBatchEntity.getAmount());
        cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        cashticketEntity.setActivtionCount(1);
        int k = 0;
        cashticketEntity.setCreateTime(DateUtils.now());
        cashticketEntity.setTicketNo(this.getTicketNo());
        cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        try {
            this.logger.info("\u751f\u6210\u4f18\u60e0\u5238:{}", (Object)cashticketEntity.toString());
            int l = this.cashticketMapper.insertSelective(cashticketEntity);
            if (l > 0) {
                this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u6210\u529f:{}", (Object)cashticketEntity.toString());
                return cashticketEntity;
            }
            if (++k < 10) {
                this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u5f00\u59cb\u91cd\u65b0\u751f\u6210:{}", (Object)cashticketEntity.toString());
                return this.addCashTicketNos(cashticketBatchEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketEntity.toString());
        }
        return null;
    }

    @Override
    @Transactional
    public BaseJsonVo convertTicketNo(String customerId, int platformId, String ticketNo) {
        try {
            BaseJsonVo vo = this.convertTicketNoLog(customerId, platformId, ticketNo);
            this.cashticketCustomerService.saveSendLog(customerId, null, "", "", "", vo, 0, ticketNo, 1);
            return vo;
        }
        catch (Exception e) {
            this.cashticketCustomerService.saveSendLog(customerId, null, "", "", "", BaseJsonVo.error(), 0, ticketNo, 1);
            return BaseJsonVo.error((String)e.getMessage());
        }
    }

    @Override
    public BaseJsonVo convertByTicketBatchId(String customerId, int platformId, String ticketBatchId) {
        CashticketActivTionVo cashticketActivTionVo = this.getWaitActivtionCashticketList(ticketBatchId);
        if (cashticketActivTionVo == null) {
            CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
            this.addCashTicketNos(cashticketBatchEntity, 1);
            cashticketActivTionVo = this.getWaitActivtionCashticketList(ticketBatchId);
            if (cashticketActivTionVo == null) {
                return BaseJsonVo.paramError((String)"\u5151\u6362\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            }
        }
        return this.convertTicketNoLog(customerId, platformId, cashticketActivTionVo.getTicketNo());
    }

    public BaseJsonVo convertTicketNoLog(String customerId, int platformId, String ticketNo) {
        ticketNo = ticketNo.trim();
        boolean flag = false;
        String message = "";
        CashticketBatchEntity cashticketBatchEntity = null;
        CashticketEntity cashticketEntity = this.getCashticket4No(ticketNo);
        if (cashticketEntity == null) {
            message = "\u65e0\u6548\u7684\u5151\u6362\u7801";
            CashticketBatchEntity temp = new CashticketBatchEntity();
            temp.setTicketNo(ticketNo);
            cashticketBatchEntity = this.cashticketBatchService.getCashticketBatchByTicketNo(ticketNo);
            if (cashticketBatchEntity == null) {
                message = "\u65e0\u6548\u7684\u5151\u6362\u7801";
                return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5151\u6362\u7801");
            }
        } else {
            cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(cashticketEntity.getTicketBatchId());
        }
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u5151\u6362\u7801\u6279\u6b21");
        }
        if (cashticketEntity != null) {
            if (cashticketEntity.getActivtionCount() >= 1) {
                return BaseJsonVo.paramError((String)"\u5151\u6362\u7801\u5df2\u5151\u6362");
            }
            if (cashticketEntity.getStatus().intValue() == CashStatusEnum.jinyong.getValue()) {
                return BaseJsonVo.paramError((String)"\u5151\u6362\u7801\u5df2\u7981\u7528");
            }
        }
        BaseJsonVo vo = null;
        try {
            vo = this.cashticketCustomerService.sendTicket4Code(customerId, cashticketBatchEntity, 1, cashticketEntity == null ? 0 : cashticketEntity.getTicketId(), platformId, Integer.valueOf(1).equals(cashticketBatchEntity.getUserVisible()));
            if (vo.isSuccess() && cashticketEntity != null) {
                cashticketEntity.setActivtionTime(DateUtils.now());
                cashticketEntity.setActivtionCount(cashticketEntity.getActivtionCount() + 1);
                cashticketEntity.setStatus(CashStatusEnum.yijihuo.getValue());
                this.cashticketMapper.updateByPrimaryKeySelective(cashticketEntity);
                this.memcachedService.delete("getCashticket", cashticketEntity.getTicketId() + "");
            }
        }
        catch (Exception e) {
            return BaseJsonVo.error((String)e.getMessage());
        }
        return vo;
    }

    private String getTicketNo(int ticketPosition) {
        String randNo = RandomUtils.generateString((int)ticketPosition);
        if (this.redisService.sIsMember("ticketNo", randNo)) {
            return this.getTicketNo(ticketPosition);
        }
        return randNo;
    }

    private String getTicketNo() {
        String randNo = IDGenerate.getUniqueIdStr();
        if (!this.redisService.sadd("ticketNo", randNo)) {
            return this.getTicketNo();
        }
        return randNo;
    }
}

