/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerAdCookieMapper;
import cc.lechun.mall.entity.customer.CustomerAdCookieEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.customer.CustomerAdCookieInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import weixin.popular.api.AdWechatAPI;
import weixin.popular.bean.advertisement.AdSourceResult;

@Service
public class CustomerAdCookieService
extends BaseService<CustomerAdCookieEntity, Integer>
implements CustomerAdCookieInterface {
    @Resource
    private CustomerAdCookieMapper customerAdCookieMapper;
    @Autowired
    private WeiXinBaseService weiWinBaseService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private CustomerInterface customerInterface;

    @Override
    @Async
    public BaseJsonVo saveAdCookieCustomerInfo(String customerId, String cookieValue, String clickId, Integer dataSource, Integer itemType, String itemId) {
        CustomerAdCookieEntity customerAdCookieEntity = new CustomerAdCookieEntity();
        if (StringUtils.isNotEmpty((String)cookieValue)) {
            customerAdCookieEntity = new CustomerAdCookieEntity();
            customerAdCookieEntity.setAdCookie(cookieValue);
            CustomerAdCookieEntity customerAdCookieEntity1 = (CustomerAdCookieEntity)this.getSingle(customerAdCookieEntity, 0L);
            if (customerAdCookieEntity1 != null) {
                customerAdCookieEntity1.setCustomerId(customerId);
                return this.customerAdCookieMapper.updateByPrimaryKey(customerAdCookieEntity1) >= 1 ? BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if (StringUtils.isNotEmpty((String)clickId)) {
            if (itemType == null) {
                customerAdCookieEntity.setItemType(0);
                customerAdCookieEntity.setItemId("");
            } else {
                customerAdCookieEntity.setItemType(itemType);
                customerAdCookieEntity.setItemId(itemId);
            }
        }
        customerAdCookieEntity.setCustomerId(customerId);
        customerAdCookieEntity.setClickId(clickId);
        customerAdCookieEntity.setAdCookie("");
        customerAdCookieEntity.setAdFlag(dataSource);
        customerAdCookieEntity.setCreateTime(DateUtils.now());
        this.customerAdCookieMapper.insert(customerAdCookieEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo<CustomerAdCookieEntity> checkAdCustomter(String customerId, Integer platformId) {
        CustomerAdCookieEntity customerAdCookieEntity = new CustomerAdCookieEntity();
        customerAdCookieEntity.setCustomerId(customerId);
        List list = this.customerAdCookieMapper.getList(customerAdCookieEntity);
        if (list.size() > 0) {
            Object day = this.redisCacheUtil.get("ADVERTISEMENT_ORDER_TIME:" + platformId);
            if (day != null && day instanceof Integer) {
                int dayTime = Integer.valueOf(day.toString());
                Optional<CustomerAdCookieEntity> one = list.stream().filter(a -> a.getCreateTime().after(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)(-dayTime)))).findFirst();
                if (one.isPresent()) {
                    return BaseJsonVo.success((Object)one.get());
                }
            }
            return BaseJsonVo.error((String)"\u4e0d\u5728\u6709\u6548\u671f\u5185\u7684\u5e7f\u544a\u7528\u6237\u8ba2\u5355");
        }
        return BaseJsonVo.error((String)"\u975e\u5e7f\u544a\u7528\u6237\u8ba2\u5355");
    }

    @Override
    public BaseJsonVo<Boolean> createDatasource(Integer platformId, Integer platformGroupId, String type, String name, String description) {
        String accessToken = this.weiWinBaseService.getAccessTokenValueByPlatformId(platformId);
        WeiXinBaseEntity weiXinBaseEntity = this.weiWinBaseService.getAccessTokenByPlatformId(platformId);
        if (StringUtils.isNotEmpty((String)accessToken)) {
            AdSourceResult adSourceResult = AdWechatAPI.createDatasource((String)accessToken, (String)weiXinBaseEntity.getAppid(), (String)type, (String)name, (String)description);
            this.logger.info("\u521b\u5efa\u5e7f\u544a\u6570\u636e\u6e90:{}", adSourceResult.getErrcode().equals("0") ? adSourceResult.getData().getUser_action_set_id() : "\u5931\u8d25");
            List<DictionaryEntity> list = this.dictionaryInterface.getValidDictionaryList(platformGroupId, 212);
            DictionaryEntity dictionaryEntity = new DictionaryEntity();
            if (list.size() > 0) {
                dictionaryEntity = list.get(list.size() - 1);
                Integer key = Integer.valueOf(dictionaryEntity.getDictionaryKey()) + 1;
                dictionaryEntity.setDictionaryKey(key.toString());
                dictionaryEntity.setDictionaryName(adSourceResult.getData().getUser_action_set_id().toString());
                dictionaryEntity.setRemark("\u5e7f\u544a\u6295\u653e\u6570\u636e\u6e90");
                short s = (short)(dictionaryEntity.getSort().intValue() + 1);
                dictionaryEntity.setSort(s);
                dictionaryEntity.setDictionaryTypeId(212);
                dictionaryEntity.setPlatformGroupId(platformGroupId);
            } else {
                dictionaryEntity.setDictionaryKey("1");
                dictionaryEntity.setDictionaryName(adSourceResult.getData().getUser_action_set_id().toString());
                dictionaryEntity.setRemark("\u5e7f\u544a\u6295\u653e\u6570\u636e\u6e90");
                dictionaryEntity.setSort((short)1);
                dictionaryEntity.setDictionaryTypeId(212);
                dictionaryEntity.setPlatformGroupId(platformGroupId);
            }
            this.dictionaryInterface.saveDictionary(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey(), dictionaryEntity.getDictionaryName(), dictionaryEntity.getSort().shortValue(), dictionaryEntity.getRemark());
            return BaseJsonVo.success((Object)adSourceResult.getData().getUser_action_set_id().toString());
        }
        return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5e73\u53f0");
    }
}

