/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.apiinvoke.refund.MallOrderInvoke;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerFreeMapper;
import cc.lechun.mall.entity.customer.CustomerFreeAddVo;
import cc.lechun.mall.entity.customer.CustomerFreeEntity;
import cc.lechun.mall.entity.customer.CustomerFreeEntityVo;
import cc.lechun.mall.entity.distribution.DistributionOrderEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallSelectFreeVO;
import cc.lechun.mall.entity.sales.OrderFreeProductVO;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeLogInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeRecordInterface;
import cc.lechun.mall.iservice.distribution.DistributionOrderInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardFreeInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderProductVO;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerFreeService
extends BaseService<CustomerFreeEntity, Integer>
implements CustomerFreeInterface {
    @Resource
    private CustomerFreeMapper customerFreeMapper;
    @Autowired
    private MallFreeInterface freeInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private PrepayCardFreeInterface prepayCardFreeInterface;
    @Autowired
    private CustomerFreeInterface customerFreeInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private DistributorRelationInterface distributorRelationInterface;
    @Autowired
    private DistributionOrderInterface distributionOrderInterface;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;
    @Autowired
    private PrepayCardInterface prepayCardInterface;
    @Autowired
    private CustomerFreeRecordInterface customerFreeRecordInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private CustomerFreeLogInterface customerFreeLogInterface;
    @Autowired
    MallOrderInvoke mallOrderInvoke;
    @Autowired
    MallOrderInterface mallOrderInterface;

    @Override
    public BaseJsonVo saveNewUserFree(String items, String orderMainNo, Integer platformGroupId) {
        this.logger.info("items={},orderMainNo={}", (Object)items, (Object)orderMainNo);
        BaseJsonVo<List<MallFreeVO>> baseJsonVo = this.freeInterface.newBuildFree4Cart(platformGroupId, orderMainNo);
        if (!baseJsonVo.isSuccess()) {
            return BaseJsonVo.error((String)"\u4e0d\u5b58\u5728\u65b0\u7528\u6237\u8d60\u54c1\uff0c\u8bf7\u8054\u7cfb\u5728\u7ebf\u5ba2\u670d");
        }
        try {
            List itemVoList;
            items = URLDecoder.decode(items, "utf-8");
            this.logger.info("items={},orderMainNo={}", (Object)items, (Object)orderMainNo);
            if (!items.startsWith("[")) {
                items = "[" + items + "]";
            }
            if (CollectionUtils.isEmpty((Collection)(itemVoList = JsonUtils.getListByArray(MallSelectFreeVO.class, (String)items)))) {
                this.logger.error("\u8ba2\u5355:{},\u8d60\u54c1:{}\uff0c\u4e0d\u6b63\u786e", (Object)orderMainNo, (Object)items);
                return BaseJsonVo.error((String)"\u8d60\u54c1\u4e0d\u6b63\u786e");
            }
            ArrayList<OrderFreeProductVO> freeProductVOS = new ArrayList<OrderFreeProductVO>();
            for (MallSelectFreeVO item : itemVoList) {
                if (item.getQuantity() > 1) {
                    throw new RuntimeException("\u9009\u62e9\u7684\u8d60\u54c1\u6570\u91cf\u4e0d\u6b63\u786e");
                }
                for (MallFreeVO f : (List)baseJsonVo.getValue()) {
                    Optional<MallProductVO> productVOOptional = f.getProductList().stream().filter(productVO -> Objects.equals(productVO.getProId(), item.getItemId())).findFirst();
                    if (!productVOOptional.isPresent()) continue;
                    this.logger.info("\u5b58\u5728\u8d60\u54c1:{}", (Object)item.getItemId());
                    OrderFreeProductVO orderFreeProductVO = new OrderFreeProductVO();
                    orderFreeProductVO.setBarCode(productVOOptional.get().getBarCode());
                    orderFreeProductVO.setQuantity(item.getQuantity());
                    freeProductVOS.add(orderFreeProductVO);
                    break;
                }
                this.logger.info("\u5b58\u5728\u8d60\u54c1:{}", (Object)item.getItemId());
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(freeProductVOS)) {
                this.logger.error("\u672a\u5339\u914d\u5230\u8d60\u54c1 \u8ba2\u5355:{}", (Object)orderMainNo);
                return BaseJsonVo.error((String)"\u672a\u627e\u5230\u8d60\u54c1\uff0c\u8bf7\u8054\u7cfb\u5728\u7ebf\u5ba2\u670d");
            }
            if (freeProductVOS.size() > 1) {
                return BaseJsonVo.error((String)"\u8d60\u54c1\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u5728\u7ebf\u5ba2\u670d");
            }
            String json = JsonUtils.toJson(freeProductVOS, (boolean)false);
            this.logger.info("\u8c03\u7528\u552e\u540e\u52a0\u8d60\u54c1,\u8ba2\u5355\u53f7:{},\u5546\u54c1:{}", (Object)orderMainNo, (Object)json);
            String orderNo = orderMainNo;
            MallOrderEntity orderQuery = new MallOrderEntity();
            orderQuery.setOrderMainNo(orderMainNo);
            MallOrderEntity orderEntity = this.mallOrderInterface.getmallOrder(orderQuery);
            if (orderEntity != null) {
                orderNo = orderEntity.getOrderNo();
                this.logger.info("\u5546\u57ce\u8ba2\u5355\u7684\u4e3b\u8ba2\u5355\u53f7:{},\u8981\u53d8\u6210\u5b50\u5355\u53f7{}", (Object)orderMainNo, (Object)orderNo);
            }
            return this.mallOrderInvoke.addOrderProducts(orderNo, json);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.logger.error("\u52a0\u8d60\u54c1\u5931\u8d25" + e);
            return BaseJsonVo.error((String)"\u672a\u5339\u914d\u5230\u8d60\u54c1,\u8bf7\u8054\u7cfb\u5728\u7ebf\u5ba2\u670d");
        }
    }

    @Override
    public List<CustomerFreeEntityVo> getCustomerFreePool(String customerId) {
        CustomerFreeEntity search = new CustomerFreeEntity();
        search.setCustomerId(customerId);
        search.setStatus(1);
        List lst = this.getList(search);
        ArrayList<CustomerFreeEntityVo> result = new ArrayList<CustomerFreeEntityVo>();
        for (CustomerFreeEntity cf : lst) {
            CustomerFreeEntityVo cfVo = new CustomerFreeEntityVo();
            try {
                PrepayCardBatchEntity batchEntity;
                MallFreeEntity freeEntity;
                ObjectConvert.fatherConvertToChild((Object)cf, (Object)cfVo);
                if (StringUtil.isNotEmpty((String)cf.getFreeId()) && (freeEntity = this.freeInterface.selectByPrimaryKey(cf.getFreeId())) != null) {
                    cfVo.setFreeName(freeEntity.getFreeName());
                    if (freeEntity.getBeginTime().after(new Date()) || freeEntity.getEndTime().before(new Date())) {
                        cfVo.setStatus(3);
                    }
                }
                if (Integer.valueOf(1).equals(cf.getSource()) && cf.getCardBatchId() != null && (batchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(cf.getCardBatchId())) != null) {
                    cfVo.setCardBatchName(batchEntity.getBatchName());
                }
                if (cfVo.getQuantity() == null) {
                    cfVo.setQuantity(0);
                }
                if (cfVo.getUseQuantity() == null) {
                    cfVo.setUseQuantity(0);
                }
                cfVo.setEnableQuantity(cfVo.getQuantity() - cfVo.getUseQuantity());
                if (cfVo.getEnableQuantity() < 0) {
                    cfVo.setEnableQuantity(0);
                }
                if (cfVo.getEnableQuantity() <= 0 || cfVo.getStatus() != 1) continue;
                result.add(cfVo);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public List<CustomerFreeEntityVo> getSelectCustomerFreePool(String customerId) {
        List<CustomerFreeEntityVo> list = this.getCustomerFreePool(customerId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)list.get(0).getCardId()));
            String key = MD5.sign((String)(customerId + ":" + prepayCardEntity.getCardType() + ":FreeList"));
            List itemVoList = (List)this.redisCacheUtil.get(key);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemVoList)) {
                for (CustomerFreeEntityVo freeEntityVo : list) {
                    for (MallSelectFreeVO freeVO : itemVoList) {
                        if (!Objects.equals(freeEntityVo.getFreeId(), freeVO.getFreeId()) || !Objects.equals(freeEntityVo.getProductId(), freeVO.getItemId())) continue;
                        freeEntityVo.setQuantity(freeEntityVo.getQuantity() - freeVO.getQuantity());
                        freeEntityVo.setSelectQuantity(freeVO.getQuantity());
                    }
                }
            }
        }
        return list;
    }

    public BaseJsonVo<OriginOrderVO> confirmOriginOrder(String cardBarCode, String orderNo) {
        BaseJsonVo<OriginOrderVO> originJson = this.mallOrderMainInterface.getOriginOrder(orderNo);
        if (!originJson.isSuccess()) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u6b631");
        }
        BaseJsonVo<List<OriginOrderProductVO>> jsonVo = this.mallOrderMainInterface.getOriginOrderProduct(orderNo);
        if (jsonVo.isSuccess()) {
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((Collection)jsonVo.getValue()))) {
                return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u6b63");
            }
            List lst = ((List)jsonVo.getValue()).stream().filter(c -> cardBarCode.equals(c.getProductCbarcode())).collect(Collectors.toList());
            if (lst.size() > 0) {
                return BaseJsonVo.success((Object)originJson.getValue());
            }
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0e\u5361\u4e0d\u5bf9\u5e94\uff0c\u8bf7\u67e5\u6b63");
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u67e5\u627e\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    public Map<String, Object> getProductItem(CustomerFreeEntityVo cfVo) {
        BaseJsonVo<MallIndexPromotionVo> baseJsonVo;
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        if (Integer.valueOf(4).equals(cfVo.getProductType())) {
            BaseJsonVo<MallIndexProductVo> baseJsonVo2 = this.productInterface.buildIndexProductVo(cfVo.getProductId());
            if (baseJsonVo2.isSuccess()) {
                ((MallIndexProductVo)baseJsonVo2.getValue()).setQuantity(cfVo.getSelectQuantity());
                ((MallIndexProductVo)baseJsonVo2.getValue()).setLimitBuyCount(cfVo.getEnableQuantity());
                ((MallIndexProductVo)baseJsonVo2.getValue()).setCardOriginPrice(((MallIndexProductVo)baseJsonVo2.getValue()).getPrice());
                ((MallIndexProductVo)baseJsonVo2.getValue()).setSalePrice(BigDecimal.ZERO);
                ((MallIndexProductVo)baseJsonVo2.getValue()).setSaleValue(BigDecimal.ZERO);
                map = ObjectConvert.objectConvertToObjectMap((Object)baseJsonVo2.getValue());
            }
        } else if (Integer.valueOf(1).equals(cfVo.getProductType()) && (baseJsonVo = this.promotionInterface.buildIndexPromotionVo(cfVo.getProductId())).isSuccess()) {
            ((MallIndexPromotionVo)baseJsonVo.getValue()).setQuantity(cfVo.getSelectQuantity());
            ((MallIndexPromotionVo)baseJsonVo.getValue()).setLimitBuyCount(cfVo.getEnableQuantity());
            ((MallIndexPromotionVo)baseJsonVo.getValue()).setSalePrice(BigDecimal.ZERO);
            map = ObjectConvert.objectConvertToObjectMap((Object)baseJsonVo.getValue());
        }
        map.put("customerFreeId", cfVo.getId());
        map.put("freeId", cfVo.getFreeId());
        map.put("cardBatchId", cfVo.getCardBatchId());
        map.put("freeMethod", cfVo.getFreeMethod());
        return map;
    }

    @Override
    public BaseJsonVo autoFreeProductToPool(String cardId, String customerId) {
        if (StringUtil.isEmpty((String)cardId)) {
            return BaseJsonVo.error((String)"\u5361Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)cardId));
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u5361\u4e0d\u5b58\u5728");
        }
        if (StringUtil.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!customerId.equals(prepayCardEntity.getBelongCustomerId())) {
            return BaseJsonVo.error((String)"\u5361\u4e0d\u5b58\u57281");
        }
        PrepayCardBatchEntity cardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(prepayCardEntity.getBatchId());
        if (cardBatchEntity == null) {
            return BaseJsonVo.error((String)"\u6279\u6b21\u4e0d\u5b58\u5728");
        }
        PrepayCardFreeEntity cardFreeEntity = new PrepayCardFreeEntity();
        cardFreeEntity.setBatchId(prepayCardEntity.getBatchId());
        cardFreeEntity.setFreeType(1);
        cardFreeEntity.setFreeMethod(2);
        cardFreeEntity.setStatus(1);
        int exists = this.prepayCardFreeInterface.existsByEntity(cardFreeEntity);
        if (exists > 0) {
            List<Map<String, Object>> lst = this.prepayCardFreeInterface.getCardFreeProduct(prepayCardEntity.getBatchId(), customerId, cardId);
            for (Map<String, Object> map : lst) {
                if (!"1".equals(map.get("freeType").toString()) || !"2".equals(map.get("freeMethod").toString())) continue;
                int quantity = Integer.valueOf(map.get("quantity").toString());
                List rows = (List)map.get("freeProducts");
                for (int i = 0; i < quantity; ++i) {
                    CustomerFreeEntity customerFreeEntity = new CustomerFreeEntity();
                    int index = (int)(Math.random() * (double)rows.size());
                    customerFreeEntity.setProductId(((Map)rows.get(index)).get("productId").toString());
                    customerFreeEntity.setProductName(((Map)rows.get(index)).get("productName").toString());
                    customerFreeEntity.setProductType(Integer.valueOf(((Map)rows.get(index)).get("productType").toString()));
                    customerFreeEntity.setCustomerId(customerId);
                    customerFreeEntity.setFreeId(map.get("freeId").toString());
                    customerFreeEntity.setFreeMethod(Integer.valueOf(map.get("freeMethod").toString()));
                    customerFreeEntity.setStatus(1);
                    customerFreeEntity.setQuantity(1);
                    customerFreeEntity.setCardBatchId(prepayCardEntity.getBatchId());
                    customerFreeEntity.setCardId(prepayCardEntity.getCardId());
                    customerFreeEntity.setSource(1);
                    customerFreeEntity.setCreateTime(new Date());
                    customerFreeEntity.setCreater("system");
                    BaseJsonVo jsonVo = this.customerFreeInterface.addFreeProductToPool(customerFreeEntity, Integer.valueOf(map.get("id").toString()));
                    if (jsonVo.isSuccess()) continue;
                    return jsonVo;
                }
            }
            return BaseJsonVo.success((Object)"\u52a0\u5165\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u6279\u6b21\u8d60\u54c1\u8bb0\u5f55");
    }

    @Override
    public BaseJsonVo customerAddFreeProductToPool(String cardId, String customerId, List<CustomerFreeAddVo> freeAddVos) {
        if (StringUtil.isEmpty((String)cardId)) {
            return BaseJsonVo.error((String)"\u5361Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)cardId));
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u5361\u4e0d\u5b58\u5728");
        }
        if (StringUtil.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!customerId.equals(prepayCardEntity.getBelongCustomerId())) {
            return BaseJsonVo.error((String)"\u5361\u4e0d\u5b58\u57281");
        }
        PrepayCardBatchEntity cardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(prepayCardEntity.getBatchId());
        if (cardBatchEntity == null) {
            return BaseJsonVo.error((String)"\u6279\u6b21\u4e0d\u5b58\u5728");
        }
        CustomerFreeEntity search = new CustomerFreeEntity();
        search.setCustomerId(customerId);
        search.setCardBatchId(prepayCardEntity.getBatchId());
        search.setCardId(cardId);
        if (this.existsByEntity(search, 0L) > 0) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u5361\u5df2\u8bbe\u7f6e\u8d60\u54c1\uff0c\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e");
        }
        for (CustomerFreeAddVo vo : freeAddVos) {
            if (vo.getId() == null) {
                return BaseJsonVo.error((String)"\u683c\u5f0f\u9519\u8befId");
            }
            if (vo.getQuantity() == null) {
                return BaseJsonVo.error((String)"\u683c\u5f0f\u9519\u8bef-\u6570\u91cf");
            }
            if (StringUtil.isEmpty((String)vo.getProductId())) {
                return BaseJsonVo.error((String)"\u683c\u5f0f\u9519\u8bef-\u5546\u54c1");
            }
            PrepayCardFreeEntity freeEntity = (PrepayCardFreeEntity)this.prepayCardFreeInterface.selectByPrimaryKey(vo.getId());
            if (Integer.valueOf(2).equals(freeEntity.getFreeType()) && !this.prepayCardFreeInterface.checkCustomerIsChooseFree(customerId, freeEntity.getBatchId(), 1)) {
                return BaseJsonVo.error((String)"\u4e0d\u80fd\u6dfb\u52a0\u8be5\u8d60\u54c1,\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            List<MallFreeProductEntity> productEntities = this.freeInterface.getMallFreeProduct(freeEntity.getFreeId());
            if (productEntities.stream().filter(c -> c.getProductId().equals(vo.getProductId())).count() == 0L) {
                return BaseJsonVo.error((String)"\u8d60\u54c1\u9009\u62e9\u9519\u8bef");
            }
            if (Integer.valueOf(2).equals(freeEntity.getFreeMethod())) {
                int quantity = vo.getQuantity();
                CustomerFreeEntity customerFreeEntity = new CustomerFreeEntity();
                customerFreeEntity.setProductId(vo.getProductId());
                customerFreeEntity.setProductName(vo.getProductName());
                customerFreeEntity.setProductType(vo.getProductType());
                customerFreeEntity.setCustomerId(customerId);
                customerFreeEntity.setFreeId(freeEntity.getFreeId());
                customerFreeEntity.setFreeMethod(freeEntity.getFreeMethod());
                customerFreeEntity.setStatus(1);
                customerFreeEntity.setQuantity(quantity);
                customerFreeEntity.setCardBatchId(prepayCardEntity.getBatchId());
                customerFreeEntity.setCardId(prepayCardEntity.getCardId());
                customerFreeEntity.setSource(1);
                customerFreeEntity.setCreateTime(new Date());
                customerFreeEntity.setCreater(customerId);
                customerFreeEntity.setPrepayFreeId(freeEntity.getId().toString());
                BaseJsonVo jsonVo = this.customerFreeInterface.addFreeProductToPool(customerFreeEntity, freeEntity.getId());
                if (jsonVo.isSuccess()) continue;
                return jsonVo;
            }
            return BaseJsonVo.error((String)"\u4e0d\u652f\u6301\u6dfb\u52a0\u5230\u8d60\u54c1\u6c60");
        }
        this.customerFreeRecordInterface.updateRecordUsed(customerId, prepayCardEntity.getBatchId());
        return BaseJsonVo.success((Object)"\u52a0\u5165\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public BaseJsonVo addFreeProductToPool(CustomerFreeEntity customerFreeEntity, Integer prepayFreeId) {
        if (prepayFreeId == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1Id\u4e3a\u7a7a");
        }
        if (customerFreeEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)customerFreeEntity.getCustomerId())) {
            return BaseJsonVo.error((String)"\u5ba2\u6237\u4e3a\u7a7a");
        }
        if (customerFreeEntity.getSource() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8d60\u9001\u6765\u6e90");
        }
        if (Integer.valueOf(1).equals(customerFreeEntity.getSource()) && customerFreeEntity.getCardBatchId() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u5361\u6279\u6b21");
        }
        if (StringUtil.isEmpty((String)customerFreeEntity.getFreeId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8d60\u54c1");
        }
        if (StringUtil.isEmpty((String)customerFreeEntity.getProductId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8d60\u54c1\u5546\u54c1");
        }
        if (StringUtil.isEmpty((String)customerFreeEntity.getProductName())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8d60\u54c1\u5546\u54c11");
        }
        if (customerFreeEntity.getProductType() == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u5546\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (customerFreeEntity.getQuantity() == null) {
            return BaseJsonVo.error((String)"\u8d60\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)customerFreeEntity.getCardId())) {
            return BaseJsonVo.error((String)"\u5361Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int quantity = customerFreeEntity.getQuantity();
        customerFreeEntity.setStatus(1);
        customerFreeEntity.setCreateTime(new Date());
        if (!Integer.valueOf(1).equals(customerFreeEntity.getSource())) return BaseJsonVo.error((String)"\u6682\u4e0d\u652f\u6301\u975e\u5976\u5361\u8d60\u54c1\u52a0\u5165\u8d60\u54c1\u6c60");
        PrepayCardFreeEntity cardFreeEntity = new PrepayCardFreeEntity();
        cardFreeEntity.setFreeId(customerFreeEntity.getFreeId());
        cardFreeEntity.setBatchId(customerFreeEntity.getCardBatchId());
        cardFreeEntity.setStatus(1);
        cardFreeEntity.setId(prepayFreeId);
        cardFreeEntity = (PrepayCardFreeEntity)this.prepayCardFreeInterface.getSingle(cardFreeEntity);
        if (cardFreeEntity == null) return BaseJsonVo.error((String)"\u5361\u6279\u6b21\u5173\u8054\u8d60\u54c1\u65e0\u6548");
        customerFreeEntity.setFreeMethod(cardFreeEntity.getFreeMethod());
        CustomerFreeEntity search = new CustomerFreeEntity();
        search.setCustomerId(customerFreeEntity.getCustomerId());
        search.setCardBatchId(customerFreeEntity.getCardBatchId());
        search.setFreeId(customerFreeEntity.getFreeId());
        search.setCardId(customerFreeEntity.getCardId());
        List freeEntities = this.customerFreeMapper.getList(search);
        int count = freeEntities.stream().filter(c -> !Integer.valueOf(0).equals(c.getStatus())).mapToInt(c -> c.getQuantity()).sum();
        if (count + customerFreeEntity.getQuantity() > cardFreeEntity.getFreeQuantity()) {
            return BaseJsonVo.error((String)"\u6279\u6b21\u4e0b\u8d60\u54c1\u8d85\u9650");
        }
        if (StringUtil.isNotEmpty((String)customerFreeEntity.getOrderMainNo())) {
            PrepayCardBatchEntity cardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(customerFreeEntity.getCardBatchId());
            if (cardBatchEntity == null) return BaseJsonVo.error((String)"\u5361\u6279\u6b21\u4e0d\u5b58\u5728");
            String cardBarCode = cardBatchEntity.getMilkCardBarcode();
            if (StringUtil.isEmpty((String)cardBarCode)) {
                return BaseJsonVo.error((String)"\u5361\u6279\u6b21\u6ca1\u6709\u914d\u7f6e\u536169\u7801");
            }
            BaseJsonVo<OriginOrderVO> jsonVo = this.confirmOriginOrder(cardBarCode, customerFreeEntity.getOrderMainNo());
            if (!jsonVo.isSuccess()) {
                return BaseJsonVo.error((String)jsonVo.getMessage());
            }
            MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(customerFreeEntity.getOrderMainNo());
            MallOrderEntity order = this.orderInterface.getmallOrder(customerFreeEntity.getOrderMainNo());
            if (orderMainEntity != null || order != null) return BaseJsonVo.error((String)"\u5fae\u4fe1\u8ba2\u5355\u53f7\u7531\u7cfb\u7edf\u81ea\u52a8\u8bb0\u5f55\u4e1a\u7ee9\uff0c\u65e0\u9700\u8f93\u5165");
            BaseJsonVo jsonVo1 = this.setDistributionOrder(customerFreeEntity.getQyWeixinUserid(), customerFreeEntity.getOrderMainNo(), ((OriginOrderVO)jsonVo.getValue()).getCustomerId(), ((OriginOrderVO)jsonVo.getValue()).getPayTime(), ((OriginOrderVO)jsonVo.getValue()).getPayAmount());
            if (!jsonVo1.isSuccess()) {
                return jsonVo1;
            }
            this.biOrderDetailInvoke.orderBindCustomer(customerFreeEntity.getCustomerId(), "", customerFreeEntity.getOrderMainNo(), 1);
            return BaseJsonVo.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        CustomerFreeEntity search2 = new CustomerFreeEntity();
        search2.setCustomerId(customerFreeEntity.getCustomerId());
        search2.setProductId(customerFreeEntity.getProductId());
        search2.setFreeId(customerFreeEntity.getFreeId());
        search2.setSource(customerFreeEntity.getSource());
        search2.setCardBatchId(customerFreeEntity.getCardBatchId());
        search2.setCardId(customerFreeEntity.getCardId());
        search2.setStatus(1);
        search2 = (CustomerFreeEntity)this.customerFreeMapper.getSingle(search2);
        if (search2 != null) {
            customerFreeEntity.setId(search2.getId());
            customerFreeEntity.setQuantity(search2.getQuantity() + customerFreeEntity.getQuantity());
        }
        int i = 0;
        if (customerFreeEntity.getId() == null) {
            customerFreeEntity.setUseQuantity(0);
            i = this.insert(customerFreeEntity);
            this.customerFreeLogInterface.insertCustomerFreeLog(customerFreeEntity.getCustomerId(), customerFreeEntity.getOrderMainNo(), customerFreeEntity.getId(), quantity, 0);
        } else {
            i = this.updateByPrimaryKeySelective(customerFreeEntity);
            this.customerFreeLogInterface.insertCustomerFreeLog(customerFreeEntity.getCustomerId(), customerFreeEntity.getOrderMainNo(), customerFreeEntity.getId(), quantity, 0);
        }
        if (i != 1) return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo useFreeProdcutFromPool(String customerId, String orderMainNo, List<Map<String, Integer>> freeMaps) {
        if (StringUtil.isEmpty((String)customerId)) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u9009\u62e9\u5ba2\u6237");
        }
        if (freeMaps == null || freeMaps.isEmpty()) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u9009\u62e9\u8d60\u54c1");
        }
        CustomerFreeEntity updateEntity = new CustomerFreeEntity();
        updateEntity.setUseTime(new Date());
        updateEntity.setUseOrderMainNo(orderMainNo);
        for (Map<String, Integer> map : freeMaps) {
            Integer customerFreeId = map.get("customerFreeId");
            Integer quantity = map.get("quantity");
            updateEntity.setId(customerFreeId);
            CustomerFreeEntity customerFreeEntity = (CustomerFreeEntity)this.customerFreeMapper.selectByPrimaryKey(customerFreeId);
            if (customerFreeEntity == null) {
                return BaseJsonVo.error((String)"\u8d60\u54c1\u65e0\u8d60\u54c1");
            }
            if (!customerId.equals(customerFreeEntity.getCustomerId())) {
                return BaseJsonVo.error((String)"\u5ba2\u6237\u65e0\u6b64\u8d60\u54c1");
            }
            if (StringUtil.isNotEmpty((String)customerFreeEntity.getUseOrderMainNo())) {
                if (customerFreeEntity.getUseOrderMainNo().contains(orderMainNo)) {
                    return BaseJsonVo.error((String)"\u8d60\u54c1\u5df2\u6263\u51cf");
                }
                updateEntity.setUseOrderMainNo(customerFreeEntity.getUseOrderMainNo() + "," + orderMainNo);
            }
            int usedQuantity = customerFreeEntity.getUseQuantity() == null ? 0 : customerFreeEntity.getUseQuantity();
            updateEntity.setUseQuantity(quantity);
            if (!Integer.valueOf(1).equals(customerFreeEntity.getStatus())) {
                return BaseJsonVo.error((String)"\u8d60\u54c1\u65e0\u6548\u6216\u5df2\u4f7f\u7528");
            }
            if (updateEntity.getUseQuantity() + usedQuantity > customerFreeEntity.getQuantity()) {
                return BaseJsonVo.error((String)"\u8d60\u54c1\u6c60\u6570\u91cf\u4e0d\u8db3");
            }
            MallFreeEntity freeEntity = this.freeInterface.selectByPrimaryKey(customerFreeEntity.getFreeId());
            if (freeEntity != null) {
                if (freeEntity.getBeginTime().after(new Date()) || freeEntity.getEndTime().before(new Date())) {
                    return BaseJsonVo.error((String)"\u8d60\u54c1\u672a\u5230\u9886\u53d6\u65e5\u671f\u6216\u5df2\u8fc7\u671f");
                }
            } else {
                return BaseJsonVo.error((String)"\u8d60\u54c1\u4e0d\u5b58\u5728");
            }
            int i = this.customerFreeMapper.updateByUseFree(updateEntity);
            this.customerFreeLogInterface.insertCustomerFreeLog(customerId, orderMainNo, customerFreeId, quantity, 1);
            this.remoteCache(customerFreeId);
            if (i != 0) continue;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u8d60\u54c1\u4f7f\u7528\u5f02\u5e38");
        }
        return BaseJsonVo.success((Object)"\u8d60\u54c1\u4f7f\u7528\u6210\u529f");
    }

    @Override
    public BaseJsonVo useFreeProdcutFromPool(MallOrderMainEntity orderMainEntity) {
        this.logger.info("\u7528\u6237:{},\u8ba2\u5355\uff1a{},\u5f00\u59cb\u4f7f\u7528\u8d60\u54c1", (Object)orderMainEntity.getCustomerId(), (Object)orderMainEntity.getOrderMainNo());
        if (StringUtils.isEmpty((String)orderMainEntity.getBindCode())) {
            this.logger.error("\u8ba2\u5355:{}\u5361\u7c7b\u578b\u4e3a\u7a7a", (Object)orderMainEntity.getOrderMainNo());
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5361\u7c7b\u578b");
        }
        if (orderMainEntity.getBindCode().length() > 2) {
            this.logger.error("\u8ba2\u5355:{}\u5361\u7c7b\u578b:{}\u4e0d\u6b63\u786e", (Object)orderMainEntity.getOrderMainNo(), (Object)orderMainEntity.getBindCode());
            return BaseJsonVo.success((Object)"\u65e0\u6548\u7684\u5361\u7c7b\u578b");
        }
        String key = MD5.sign((String)(orderMainEntity.getCustomerId() + ":" + orderMainEntity.getBindCode() + ":FreeList"));
        List itemVoList = (List)this.redisCacheUtil.get(key);
        this.logger.info("\u7528\u6237:{},\u9009\u62e9\u7684\u8d60\u54c1:{}", (Object)orderMainEntity.getCustomerId(), (Object)JsonUtils.toJson((Object)itemVoList, (boolean)false));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemVoList)) {
            ArrayList<Map<String, Integer>> freeMaps = new ArrayList<Map<String, Integer>>();
            for (MallSelectFreeVO item : itemVoList) {
                HashMap<String, Integer> freeMap = new HashMap<String, Integer>();
                freeMap.put("customerFreeId", item.getCustomerFreeId());
                freeMap.put("quantity", item.getQuantity());
                freeMaps.add(freeMap);
            }
            this.logger.info("\u8ba2\u5355\u53f7:{},\u8d60\u54c1\u53c2\u6570:{}", (Object)orderMainEntity.getOrderMainNo(), (Object)JsonUtils.toJson(freeMaps, (boolean)false));
            BaseJsonVo baseJsonVo = this.customerFreeInterface.useFreeProdcutFromPool(orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo(), freeMaps);
            this.logger.info("\u7528\u6237:{},\u8ba2\u5355:{}\u8c03\u7528\u4f7f\u7528\u8d60\u54c1\u63a5\u53e3:{},\u6d88\u606f:{}", new Object[]{orderMainEntity.getCustomerId(), orderMainEntity.getOrderMainNo(), baseJsonVo.isSuccess(), baseJsonVo.getMessage()});
            if (baseJsonVo.isSuccess()) {
                this.redisCacheUtil.remove(key);
            }
            return baseJsonVo;
        }
        return BaseJsonVo.success((Object)"\u65e0\u8d60\u54c1");
    }

    @Override
    public BaseJsonVo saveFreeProdcut(List<MallSelectFreeVO> itemVoList, String cardType, String customerId) {
        List<CustomerFreeEntityVo> freeEntityVoList = this.getCustomerFreePool(customerId);
        for (MallSelectFreeVO itemVo : itemVoList) {
            List size_ls = freeEntityVoList.stream().filter(f -> Objects.equals(f.getProductId(), itemVo.getItemId()) && Objects.equals(f.getProductType(), itemVo.getItemType())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(size_ls)) {
                this.logger.error("\u8d60\u54c1:{},\u7c7b\u578b:{},\u7528\u6237:{} \u65e0\u6548", new Object[]{itemVo.getItemId(), itemVo.getItemType(), customerId});
                return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u8d60\u54c1");
            }
            if (((CustomerFreeEntityVo)size_ls.get(0)).getEnableQuantity() >= itemVo.getQuantity()) continue;
            this.logger.error("\u8d60\u54c1:{},\u7c7b\u578b:{},\u7528\u6237:{} \u8d60\u54c1\u6570\u91cf\u6709\u8bef", new Object[]{itemVo.getItemId(), itemVo.getItemType(), customerId});
            return BaseJsonVo.error((String)"\u8d60\u54c1\u6570\u91cf\u6709\u8bef");
        }
        String key = MD5.sign((String)(customerId + ":" + cardType + ":FreeList"));
        this.redisCacheUtil.set(key, itemVoList, Long.valueOf(7200L));
        return BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo setDistributionOrder(String qiyeWexinUserid, String orderMainNo, String customerId, Date createTime, BigDecimal amount) {
        if (StringUtil.isNotEmpty((String)qiyeWexinUserid)) {
            DistributorRelationEntity e = new DistributorRelationEntity();
            e.setRelationUserId(qiyeWexinUserid);
            e = (DistributorRelationEntity)this.distributorRelationInterface.getSingle(e);
            if (e != null) {
                DistributionOrderEntity distributionOrderEntity = new DistributionOrderEntity();
                distributionOrderEntity.setOrderMainNo(orderMainNo);
                if (this.distributionOrderInterface.getSingle(distributionOrderEntity) != null) {
                    return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u52a0\u5165\u4e1a\u7ee9\uff0c\u8bf7\u66f4\u6362\u8ba2\u5355\u53f7");
                }
                distributionOrderEntity = new DistributionOrderEntity();
                distributionOrderEntity.setOrderNo(orderMainNo);
                if (this.distributionOrderInterface.getSingle(distributionOrderEntity) != null) {
                    return BaseJsonVo.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u52a0\u5165\u4e1a\u7ee9\uff0c\u8bf7\u66f4\u6362\u8ba2\u5355\u53f7");
                }
                distributionOrderEntity.setOrderMainNo(orderMainNo);
                distributionOrderEntity.setOrderNo(orderMainNo);
                distributionOrderEntity.setInvitedCustomerId(customerId);
                distributionOrderEntity.setDistributorId(e.getDistributorId());
                distributionOrderEntity.setDistributorRelationId(e.getId());
                distributionOrderEntity.setDistributorRelationUserId(e.getRelationUserId());
                distributionOrderEntity.setStatus(1);
                distributionOrderEntity.setCreateTime(createTime);
                distributionOrderEntity.setPlatformId(100);
                distributionOrderEntity.setSaleAmount(amount);
                distributionOrderEntity.setOrderAmount(amount);
                distributionOrderEntity.setExpectOrderAmount(amount);
                distributionOrderEntity.setUpdateTime(createTime);
                distributionOrderEntity.setInviteTime(createTime);
                this.distributionOrderInterface.insertSelective(distributionOrderEntity);
            } else {
                return BaseJsonVo.error((String)"\u6ca1\u6709\u627e\u5230\u4f60\u7684\u9080\u8bf7\u7801\uff0c\u8bf7\u8054\u7cfb\u6280\u672f");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo recordFreeAndDistribution(String orderMainNo, String qiyeWexinUserid, String customerId) {
        BaseJsonVo<OriginOrderVO> originJson = this.mallOrderMainInterface.getOriginOrder(orderMainNo);
        if (!originJson.isSuccess()) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u6b631");
        }
        BaseJsonVo<List<OriginOrderProductVO>> jsonVo = this.mallOrderMainInterface.getOriginOrderProduct(orderMainNo);
        if (jsonVo.isSuccess()) {
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((Collection)jsonVo.getValue()))) {
                return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u6b63");
            }
            List lst = (List)jsonVo.getValue();
            boolean existsPrepayCard = false;
            for (OriginOrderProductVO p : lst) {
                PrepayCardBatchEntity search = new PrepayCardBatchEntity();
                search.setBatchType(3);
                search.setMilkCardBarcode(p.getProductCbarcode());
                PrepayCardBatchEntity b = (PrepayCardBatchEntity)this.prepayCardBatchInterface.getSingle(search);
                if (b == null) continue;
                this.customerFreeRecordInterface.savefreeRecord(customerId, orderMainNo, b.getBatchId(), qiyeWexinUserid);
                existsPrepayCard = true;
            }
            if (!existsPrepayCard) {
                return BaseJsonVo.error((String)"\u8ba2\u5355\u53f7\u4e0d\u662f\u65b0\u5976\u5361\u8ba2\u5355\uff0c\u8bf7\u67e5\u6b63");
            }
        } else {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u67e5\u627e\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        MallOrderEntity order = this.orderInterface.getmallOrder(orderMainNo);
        if (orderMainEntity == null && order == null) {
            BaseJsonVo jsonVo1 = this.setDistributionOrder(qiyeWexinUserid, orderMainNo, customerId, ((OriginOrderVO)originJson.getValue()).getPayTime(), ((OriginOrderVO)originJson.getValue()).getPayAmount());
            if (!jsonVo1.isSuccess()) {
                return jsonVo1;
            }
            this.biOrderDetailInvoke.orderBindCustomer(customerId, "", orderMainNo, 1);
            return BaseJsonVo.success((Object)"\u6388\u6743\u6210\u529f\uff0c\u4e1a\u7ee9\u6dfb\u52a0\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u6388\u6743\u6210\u529f\uff0c\u5fae\u4fe1\u8ba2\u5355\u53f7\u7531\u7cfb\u7edf\u81ea\u52a8\u8bb0\u5f55\u4e1a\u7ee9\uff0c\u6b64\u6b21\u6388\u6743\u4e0d\u4f1a\u8bb0\u5f55\u4e1a\u7ee9");
    }

    @Override
    public BaseJsonVo refundFree(String orderMainNo) {
        MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MallOrderProductEntity search = new MallOrderProductEntity();
        search.setOrderMainNo(orderMainNo);
        search.setOrderProductType(2);
        List<MallOrderProductEntity> orderProductList = this.orderProductInterface.getOrderProductList(search);
        CustomerFreeEntity search1 = new CustomerFreeEntity();
        search1.setUseOrderMainNo(SqlUtils.sqlLike((String)orderMainNo, (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        search1.setCustomerId(orderMainEntity.getCustomerId());
        List freeEntities = this.getList(search1, 0L);
        block0: for (MallOrderProductEntity p : orderProductList) {
            List usedList = freeEntities.stream().filter(c -> c.getProductId().equals(p.getProductId())).collect(Collectors.toList());
            int quantity = p.getQuantity();
            for (CustomerFreeEntity f : usedList) {
                CustomerFreeEntity update = new CustomerFreeEntity();
                update.setId(f.getId());
                update.setUseOrderMainNo(f.getUseOrderMainNo().replace("," + orderMainNo, "").replace(orderMainNo + ",", "").replace(orderMainNo, ""));
                int returnQuantity = f.getUseQuantity() - quantity >= 0 ? quantity : f.getUseQuantity();
                update.setUseQuantity(f.getUseQuantity() - returnQuantity);
                if (f.getStatus() == 2) {
                    update.setStatus(f.getQuantity() > update.getUseQuantity() ? 1 : 2);
                }
                this.updateByPrimaryKeySelective(update);
                this.customerFreeLogInterface.insertCustomerFreeLog(orderMainEntity.getCustomerId(), orderMainNo, f.getId(), returnQuantity, 2);
                if ((quantity -= returnQuantity) > 0) continue;
                continue block0;
            }
        }
        return BaseJsonVo.success((Object)"\u8fd4\u8fd8\u8d60\u54c1\u6210\u529f");
    }

    @Override
    public BaseJsonVo disableFree(String cardId) {
        this.customerFreeMapper.disableFree(cardId);
        return BaseJsonVo.success((Object)"");
    }
}

