/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.customer;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.customer.CustomerSafeQuestionMapper;
import cc.lechun.mall.entity.customer.CustomerSafeQuestionEntity;
import cc.lechun.mall.iservice.customer.CustomerSafeQuestionInterface;
import com.alibaba.fastjson.JSON;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerSafeQuestionService
extends BaseService
implements CustomerSafeQuestionInterface {
    @Autowired
    private CustomerSafeQuestionMapper customerSafeQuestionMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="getCustomerSafeQuestion", expiration=7200)
    public List<CustomerSafeQuestionEntity> getCustomerSafeQuestion(@ParameterValueKeyProvider String customerId) {
        CustomerSafeQuestionEntity customerSafeQuestionEntity = new CustomerSafeQuestionEntity();
        customerSafeQuestionEntity.setCustomerId(customerId);
        return this.customerSafeQuestionMapper.getList(customerSafeQuestionEntity);
    }

    @Override
    @InvalidateSingleCache(namespace="getCustomerSafeQuestion")
    @Transactional
    public CustomerSafeQuestionEntity saveCustomerSafeQuestion(@ParameterValueKeyProvider String customerId, int safeQuestionId, String safeQuestionName, String answer) {
        this.deleteCustomerSafeQuestion(customerId);
        CustomerSafeQuestionEntity customerSafeQuestionEntity = new CustomerSafeQuestionEntity();
        customerSafeQuestionEntity.setCustomerId(customerId);
        customerSafeQuestionEntity.setAnswer(answer);
        customerSafeQuestionEntity.setCreateTime(DateUtils.now());
        customerSafeQuestionEntity.setCustomerSafeQuestionId(IDGenerate.getUniqueID() + "");
        customerSafeQuestionEntity.setSafeQuestionId(safeQuestionId);
        customerSafeQuestionEntity.setSafeQuestionName(safeQuestionName);
        this.customerSafeQuestionMapper.insertSelective(customerSafeQuestionEntity);
        this.memcachedService.delete("getCustomerSafeQuestion", customerId);
        return customerSafeQuestionEntity;
    }

    @Override
    public CustomerSafeQuestionEntity saveCustomerSafeQuestion(String customerId, String safeQuestion) {
        HashMap map = (HashMap)JSON.parseObject((String)safeQuestion, HashMap.class);
        return this.saveCustomerSafeQuestion(customerId, Integer.parseInt(map.get("questionId").toString()), map.get("questionName").toString(), map.get("answer").toString());
    }

    @Override
    public void deleteCustomerSafeQuestion(String customerId) {
        List<CustomerSafeQuestionEntity> ls = this.getCustomerSafeQuestion(customerId);
        if (ls != null && ls.size() > 0) {
            ls.forEach(customerSafeQuestionEntity -> this.customerSafeQuestionMapper.deleteByPrimaryKey((Serializable)((Object)customerSafeQuestionEntity.getCustomerSafeQuestionId())));
        }
        this.memcachedService.delete("getCustomerSafeQuestion", customerId);
    }
}

