/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.utils.HttpUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JUMService
implements DeliverKuaidiInterface {
    private Logger logger = LoggerFactory.getLogger(JUMService.class);
    String host = "https://jmexpresv2.market.alicloudapi.com";
    String path = "/express/query-v2";
    String method = "POST";
    String appcode = "4283dea1b8d54be2ba8bfe1bb1e7922d";

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        block9: {
            this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f8\uff0cwayBillNo={}", (Object)wayBillNo);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "APPCODE " + this.appcode);
            headers.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            HashMap<String, String> querys = new HashMap<String, String>();
            HashMap<String, String> bodys = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((String)phone)) {
                bodys.put("mobile", phone);
            }
            if (!StringUtils.isNotEmpty((String)wayBillNo)) {
                return null;
            }
            bodys.put("number", wayBillNo);
            try {
                HttpResponse response = HttpUtils.doPost(this.host, this.path, this.method, headers, querys, bodys);
                String s = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.info("{}\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f:{}", (Object)wayBillNo, (Object)s);
                Map rtnMap = (Map)JsonUtils.fromJson((String)s, Map.class);
                if (rtnMap.containsKey("code") && (Integer)rtnMap.get("code") == 200) {
                    if (!rtnMap.containsKey("data")) {
                        this.logger.error("\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53c2\u6570[deliverCode={},wayBillNo={},phone={}],\u8fd4\u56de\uff1a{}", new Object[]{deliverCode, wayBillNo, phone, s});
                        return null;
                    }
                    Map dataMap = (Map)rtnMap.get("data");
                    ArrayList lst = new ArrayList();
                    if (!dataMap.containsKey("theLastTime") || !dataMap.containsKey("logisticsTraceDetails")) {
                        this.logger.error("\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53c2\u6570[deliverCode={},wayBillNo={},phone={}],\u8fd4\u56de\uff1a{}", new Object[]{deliverCode, wayBillNo, phone, s});
                        return null;
                    }
                    Date lastTime = DateUtils.StrToDate((String)((String)dataMap.get("theLastTime")));
                    for (Map traceDetail : (List)dataMap.get("logisticsTraceDetails")) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("time", DateUtils.formatDate((Date)new Date((Long)traceDetail.get("time")), (String)""));
                        map.put("ftime", (String)map.get("time"));
                        map.put("context", (String)traceDetail.get("desc"));
                        lst.add(map);
                    }
                    if (lst.size() > 0) {
                        MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                        expressEntity.setDeliverNo(deliverCode);
                        expressEntity.setCreateTime(new Date());
                        Collections.reverse(lst);
                        expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                        expressEntity.setExpressNo(wayBillNo);
                        expressEntity.setLastTime(lastTime);
                        expressEntity.setIsSubscribe(1);
                        expressEntity.setStatus(this.getStatus((String)dataMap.get("logisticsStatus")));
                        this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f9\uff0cwayBillNo={},expressEntity={}", (Object)wayBillNo, (Object)JsonUtils.toJson((Object)expressEntity, (boolean)false));
                        return expressEntity;
                    }
                    break block9;
                }
                this.logger.error("\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53c2\u6570[deliverCode={},wayBillNo={},phone={}],\u8fd4\u56decode={},taskNo={},msg={}", new Object[]{deliverCode, wayBillNo, phone, rtnMap.get("code"), rtnMap.get("taskNo"), rtnMap.get("msg")});
                return null;
            }
            catch (Exception e) {
                this.logger.error("\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0cwayBillNo={},\u5f02\u5e38:", (Object)wayBillNo, (Object)e);
            }
        }
        this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f10\uff0cwayBillNo={}", (Object)wayBillNo);
        return null;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String thirdExpressNo, String param) {
        return null;
    }

    @Override
    public DeliverCode getCode() {
        return DeliverCode.jum;
    }

    private Integer getStatus(String opeTitle) {
        if ("SIGN".equals(opeTitle)) {
            return 3;
        }
        if ("ACCEPT".equals(opeTitle)) {
            return 1;
        }
        if ("TRANSPORT".equals(opeTitle)) {
            return 0;
        }
        if ("DELIVERING".equals(opeTitle)) {
            return 5;
        }
        return 0;
    }
}

