/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.deliver.MallFreightIntervalMapper;
import cc.lechun.mall.dao.deliver.MallFreightMapper;
import cc.lechun.mall.entity.deliver.MallFreightCalVo;
import cc.lechun.mall.entity.deliver.MallFreightEntity;
import cc.lechun.mall.entity.deliver.MallFreightIntervalEntity;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.iservice.deliver.MallFreightInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFreightService
implements MallFreightInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallFreightService.class);
    @Autowired
    private MallFreightMapper mallFreightMapper;
    @Autowired
    private MallFreightIntervalMapper mallFreightIntervalMapper;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @Override
    public JSONArray getFreightByCityAmountDeliveryType(List<MallFreightCalVo> mallFreightCalVoList) {
        JSONArray freightArray = new JSONArray();
        if (mallFreightCalVoList != null && mallFreightCalVoList.size() > 0) {
            BigDecimal freightAmount = BigDecimal.ZERO;
            for (MallFreightCalVo mallFreightCalVo : mallFreightCalVoList) {
                this.freightRulesCal(mallFreightCalVo, freightArray, freightAmount, mallFreightCalVo.getCityId(), mallFreightCalVo.getDeliverId(), mallFreightCalVo.getAmount());
            }
        }
        return freightArray;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallFreightService.getFreighByCityIds", expiration=300)
    public MallFreightEntity getFreighByCityIds(@ParameterValueKeyProvider(order=0) String freightCityIds, @ParameterValueKeyProvider(order=1) String deliveryType, @ParameterValueKeyProvider(order=2) Integer platFormGroupId) {
        return this.mallFreightMapper.getFreighByCityIds(freightCityIds, deliveryType, platFormGroupId);
    }

    private void freightRulesCal(MallFreightCalVo mallFreightCalVo, JSONArray freightArray, BigDecimal freightAmount, String cityId, String deliverId, BigDecimal amount) {
        List<DictionaryEntity> dics;
        logger.info("\u8ba1\u7b97\u8fd0\u8d39\u53c2\u6570mallFreightCalVo={}", (Object)JSON.toJSONString((Object)mallFreightCalVo));
        BigDecimal levelFreightAmount = BigDecimal.ZERO;
        boolean isFreeFreight = false;
        if ((mallFreightCalVo.getPromotionId() != null && !mallFreightCalVo.getPromotionId().isEmpty() || mallFreightCalVo.getBindCode() != null && !mallFreightCalVo.getBindCode().isEmpty()) && (dics = this.dictionaryInterface.getValidDictionaryList(mallFreightCalVo.getPlatFormGroupId(), 104)) != null && dics.size() > 0) {
            for (DictionaryEntity d : dics) {
                if (mallFreightCalVo.getPromotionId() != null && !mallFreightCalVo.getPromotionId().isEmpty() && d.getDictionaryName() != null && !d.getDictionaryName().isEmpty() && mallFreightCalVo.getPromotionId().contains(d.getDictionaryName())) {
                    isFreeFreight = true;
                    break;
                }
                if (mallFreightCalVo.getBindCode() == null || mallFreightCalVo.getBindCode().isEmpty() || d.getDictionaryName() == null || d.getDictionaryName().isEmpty() || !mallFreightCalVo.getBindCode().equals(d.getDictionaryName())) continue;
                isFreeFreight = true;
                break;
            }
        }
        if (mallFreightCalVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK.getValue() || mallFreightCalVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue() || mallFreightCalVo.getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue() || mallFreightCalVo.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue() || isFreeFreight) {
            freightArray = null;
        } else {
            JSONObject jsonObject = new JSONObject();
            MallFreightEntity mallFreightEntity = ((MallFreightService)SpringContextUtil.getBean(this.getClass())).getFreighByCityIds(mallFreightCalVo.getCityId(), mallFreightCalVo.getDeliverId(), mallFreightCalVo.getPlatFormGroupId());
            logger.info("=======\u8fd0\u8d39freightRulesCal==mallFreightEntity============{}", (Object)JSON.toJSONString((Object)mallFreightEntity));
            if (mallFreightEntity == null) {
                mallFreightEntity = ((MallFreightService)SpringContextUtil.getBean(this.getClass())).getFreighByCityIds("-1", mallFreightCalVo.getDeliverId(), mallFreightCalVo.getPlatFormGroupId());
            } else if (mallFreightEntity.getSendAmount() == null && (mallFreightEntity = ((MallFreightService)SpringContextUtil.getBean(this.getClass())).getFreighByCityIds("-1", mallFreightCalVo.getDeliverId(), mallFreightCalVo.getPlatFormGroupId())) == null) {
                freightArray = null;
                logger.info("_____\u6ca1\u6709\u67e5\u5230\u8fd0\u8d39\uff0c\u67e5\u8be2\u6761\u4ef6\uff1acityId:" + mallFreightCalVo.getCityId() + ",deliverId:" + mallFreightCalVo.getDeliverId() + ",platformGroupId:" + mallFreightCalVo.getPlatFormGroupId());
                return;
            }
            String freightId = mallFreightEntity.getId();
            List<MallFreightIntervalEntity> mallFreightIntervalEntityList = this.mallFreightIntervalMapper.getFreighByAmount(freightId, mallFreightCalVo.getAmount());
            if (mallFreightIntervalEntityList != null && mallFreightIntervalEntityList.size() > 0) {
                MallFreightIntervalEntity mallFreightIntervalEntity = mallFreightIntervalEntityList.get(0);
                freightAmount = mallFreightIntervalEntity.getFreightAmount();
            }
            Boolean quickBalanceStatus = true;
            Boolean coldBalanceStatus = true;
            Boolean nomalBalanceStatus = true;
            if ("1".equals(mallFreightCalVo.getDeliverId())) {
                if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getSendAmount()) < 0) {
                    jsonObject.put("coldchainNotice", (Object)("\u6ee1" + mallFreightEntity.getSendAmount() + "\u5143\u8d77\u9001\uff0c\u5f53\u524d\u8fd8\u5dee" + mallFreightEntity.getSendAmount().subtract(mallFreightCalVo.getAmount()) + "\u5143"));
                } else if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getFreightFreeAmount()) >= 0) {
                    jsonObject.put("coldchainNotice", (Object)("\u5b9e\u4ed8\u91d1\u989d\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                    freightAmount = new BigDecimal(0);
                } else {
                    jsonObject.put("coldchainNotice", (Object)("\u5b9e\u4ed8\u91d1\u989d\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                    levelFreightAmount = mallFreightEntity.getFreightFreeAmount();
                }
            } else if ("2".equals(mallFreightCalVo.getDeliverId())) {
                if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getSendAmount()) < 0) {
                    jsonObject.put("nomalNotice", (Object)("\u6ee1" + mallFreightEntity.getSendAmount() + "\u5143\u8d77\u9001\uff0c\u5f53\u524d\u8fd8\u5dee" + mallFreightEntity.getSendAmount().subtract(mallFreightCalVo.getAmount()) + "\u5143"));
                } else if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getFreightFreeAmount()) >= 0) {
                    jsonObject.put("nomalNotice", (Object)("\u5b9e\u4ed8\u91d1\u989d\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                    freightAmount = new BigDecimal(0);
                } else {
                    jsonObject.put("nomalNotice", (Object)("\u5b9e\u4ed8\u91d1\u989d\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                    levelFreightAmount = mallFreightEntity.getFreightFreeAmount();
                }
            } else if ("3".equals(mallFreightCalVo.getDeliverId())) {
                if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getSendAmount()) < 0) {
                    quickBalanceStatus = false;
                    jsonObject.put("quickNotice", (Object)("\u6ee1" + mallFreightEntity.getSendAmount() + "\u5143\u8d77\u9001\uff0c\u5f53\u524d\u8fd8\u5dee" + mallFreightEntity.getSendAmount().subtract(mallFreightCalVo.getAmount()) + "\u5143"));
                } else if (mallFreightCalVo.getAmount().compareTo(mallFreightEntity.getFreightFreeAmount()) >= 0) {
                    jsonObject.put("quickNotice", (Object)("\u5b9e\u4ed8\u91d1\u989d\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                    freightAmount = new BigDecimal(0);
                } else {
                    jsonObject.put("quickNotice", (Object)("\u5b9e\u4ed8\u91d1\u989d\u6ee1" + mallFreightEntity.getFreightFreeAmount() + "\u5143\u514d\u8fd0\u8d39"));
                    levelFreightAmount = mallFreightEntity.getFreightFreeAmount();
                }
            }
            jsonObject.put("quickBalanceStatus", (Object)quickBalanceStatus);
            jsonObject.put("nomalBalanceStatus", (Object)nomalBalanceStatus);
            jsonObject.put("coldBalanceStatus", (Object)coldBalanceStatus);
            freightAmount.add(freightAmount);
            jsonObject.put("freightAmount", (Object)freightAmount);
            jsonObject.put("levelFreightAmount", (Object)levelFreightAmount);
            if (freightAmount.compareTo(BigDecimal.ZERO) > 0) {
                String levelFreightAmountDesc = Objects.equals(mallFreightCalVo.getDeliverId(), "1") ? "\u51b7\u94fe\u5b9e\u4ed8\u672a\u6ee1" + levelFreightAmount : "\u5e38\u6e29\u5b9e\u4ed8\u672a\u6ee1" + levelFreightAmount;
                logger.info("\u8fd0\u8d39\u6587\u6848:{}", (Object)levelFreightAmountDesc);
                jsonObject.put("levelFreightAmountDesc", (Object)levelFreightAmountDesc);
            } else {
                jsonObject.put("levelFreightAmountDesc", (Object)"");
            }
            jsonObject.put("deliveryType", (Object)mallFreightCalVo.getDeliverId());
            freightArray.add((Object)jsonObject);
        }
    }
}

