/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.mall.iservice.trade.MallOrderExpressInterface;
import cc.lechun.utils.shunfeng.ShunFenUtils;
import cc.lechun.utils.shunfeng.entity.Route;
import cc.lechun.utils.shunfeng.entity.SfCallbackRequest;
import cc.lechun.utils.shunfeng.entity.WaybillRoute;
import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShunfengService
implements DeliverKuaidiInterface {
    @Autowired
    private ShunFenUtils shunFenUtils;
    @Autowired
    private MallOrderExpressInterface expressInterface;

    @Override
    public DeliverCode getCode() {
        return DeliverCode.shunfeng;
    }

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        try {
            List<Route> routes = this.shunFenUtils.trace(wayBillNo, phone);
            ArrayList lst = new ArrayList();
            int i = 0;
            Date lastTime = new Date();
            for (Route r : routes) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("time", r.getAcceptTime());
                map.put("ftime", r.getAcceptTime());
                map.put("context", r.getRemark());
                lst.add(map);
                if (i == 0) {
                    lastTime = DateUtils.StrToDate((String)r.getAcceptTime(), (String)"yyyy-MM-dd HH:mm:ss");
                }
                ++i;
            }
            if (lst.size() > 0) {
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(deliverCode);
                expressEntity.setCreateTime(new Date());
                expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                expressEntity.setExpressNo(wayBillNo);
                expressEntity.setLastTime(lastTime);
                expressEntity.setIsSubscribe(1);
                expressEntity.setStatus(this.getStatus(routes.get(0).getOpcode()));
                return expressEntity;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Integer getStatus(String opCode) {
        if ("80".equals(opCode) || "8000".equals(opCode)) {
            return 3;
        }
        if ("99".equals(opCode)) {
            return 7;
        }
        if ("648".equals(opCode)) {
            return 6;
        }
        return 0;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String deliverNo, String param) {
        try {
            String expressNo = "";
            SfCallbackRequest callbackRequest = (SfCallbackRequest)JsonUtils.fromJson((String)param, SfCallbackRequest.class);
            List<WaybillRoute> waybillRoutes = this.shunFenUtils.shunFengCallback(callbackRequest);
            if (waybillRoutes != null) {
                HashMap<String, String> map;
                ArrayList lst = new ArrayList();
                for (WaybillRoute waybillRoute : waybillRoutes) {
                    map = new HashMap<String, String>();
                    map.put("id", waybillRoute.getId());
                    map.put("time", waybillRoute.getAcceptTime());
                    map.put("ftime", waybillRoute.getAcceptTime());
                    map.put("context", waybillRoute.getRemark());
                    expressNo = waybillRoute.getMailno();
                    lst.add(map);
                }
                if (lst.size() > 0) {
                    MallOrderExpressEntity search = this.expressInterface.getExpressEntity(deliverNo, expressNo);
                    if (search != null && StringUtils.isNotEmpty((String)search.getData())) {
                        JSONArray array = JSONArray.parseArray((String)search.getData());
                        for (int i = 0; i < array.size(); ++i) {
                            Object a = array.getJSONObject(i).get((Object)"id");
                            if (a == null || lst.stream().filter(c -> ((String)c.get("id")).equals(a.toString())).count() > 0L) continue;
                            map = new HashMap();
                            map.put("id", array.getJSONObject(i).get((Object)"id").toString());
                            map.put("time", array.getJSONObject(i).get((Object)"time").toString());
                            map.put("ftime", array.getJSONObject(i).get((Object)"ftime").toString());
                            map.put("context", array.getJSONObject(i).get((Object)"context").toString());
                            lst.add(map);
                        }
                    }
                    MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                    expressEntity.setCreateTime(new Date());
                    expressEntity.setOrderNo("");
                    expressEntity.setExpressNo(expressNo);
                    expressEntity.setDeliverNo(deliverNo);
                    expressEntity.setStatus(this.getStatus(waybillRoutes.get(waybillRoutes.size() - 1).getOpCode()));
                    expressEntity.setIsSubscribe(1);
                    expressEntity.setSubscribeCode("200");
                    expressEntity.setLastTime(new Date());
                    expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                    return expressEntity;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

