/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.dictionary;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import cc.lechun.mall.dao.dictionary.DictionaryMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.service.platform.PlatFormGroupService;
import com.github.pagehelper.util.StringUtil;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionaryService
implements DictionaryInterface {
    private static final Logger log = LoggerFactory.getLogger(DictionaryService.class);
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private PlatFormGroupService platFormGroupService;

    @Override
    public DictionaryEntity getSingle(DictionaryEntity dictionaryEntity) {
        return (DictionaryEntity)this.dictionaryMapper.getSingle(dictionaryEntity);
    }

    @Override
    @WriteDataSource
    public DictionaryEntity saveDictionary(int platformGroupId, int dictionaryTypeId, String dictionaryKey, String dictionaryName, int sort, String remark) {
        DictionaryEntity dictionaryEntity = new DictionaryEntity();
        dictionaryEntity.setPlatformGroupId(platformGroupId);
        dictionaryEntity.setDictionaryKey(dictionaryKey);
        dictionaryEntity.setDictionaryName(dictionaryName);
        dictionaryEntity.setDictionaryTypeId(dictionaryTypeId);
        dictionaryEntity.setStatus((short)1);
        dictionaryEntity.setSort((short)sort);
        dictionaryEntity.setRemark(remark);
        this.dictionaryMapper.saveDictionary(dictionaryEntity);
        this.removeCache(platformGroupId, dictionaryEntity.getDictionaryId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey());
        return dictionaryEntity;
    }

    @Override
    @WriteDataSource
    public DictionaryEntity updateDictionary(int dictionaryId, String dictionaryKey, String dictionaryName, int sort, String remark) {
        DictionaryEntity dictionaryEntity = this.getDictionary(dictionaryId);
        this.removeCache(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey());
        dictionaryEntity.setDictionaryKey(dictionaryKey);
        dictionaryEntity.setDictionaryName(dictionaryName);
        dictionaryEntity.setSort((short)sort);
        dictionaryEntity.setRemark(remark);
        this.dictionaryMapper.updateByPrimaryKeySelective(dictionaryEntity);
        return dictionaryEntity;
    }

    @Override
    @ReadThroughSingleCache(namespace="dictionary", expiration=7200)
    @ReadDataSource
    public DictionaryEntity getDictionary(@ParameterValueKeyProvider int dictionaryId) {
        return (DictionaryEntity)this.dictionaryMapper.selectByPrimaryKey(Integer.valueOf(dictionaryId));
    }

    @Override
    @ReadThroughSingleCache(namespace="dictionary_key", expiration=7200)
    @ReadDataSource
    public DictionaryEntity getDictionary(@ParameterValueKeyProvider(order=0) int platformGroupId, @ParameterValueKeyProvider(order=1) int dictionaryTypeId, @ParameterValueKeyProvider(order=2) String dictionaryKey) {
        List<DictionaryEntity> ls = this.dictionaryMapper.getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (ls != null && ls.size() > 0) {
            return ls.get(0);
        }
        return null;
    }

    @Override
    public String getDictionaryToString(int platformGroupId, int dictionaryTypeId, String dictionaryKey) {
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        return dictionaryEntity == null ? "" : (dictionaryEntity.getDictionaryName() == null ? "" : dictionaryEntity.getDictionaryName());
    }

    @Override
    @ReadThroughSingleCache(namespace="getDictionaryToInteger", expiration=7200)
    public Integer getDictionaryToInteger(@ParameterValueKeyProvider(order=0) int platformGroupId, @ParameterValueKeyProvider(order=1) int dictionaryTypeId, @ParameterValueKeyProvider(order=2) String dictionaryKey) {
        Integer value = null;
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (dictionaryEntity != null && !StringUtil.isEmpty((String)dictionaryEntity.getDictionaryName())) {
            try {
                value = Integer.valueOf(dictionaryEntity.getDictionaryName());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return value;
    }

    @Override
    @ReadThroughSingleCache(namespace="getDictionaryToInt", expiration=7200)
    public int getDictionaryToInt(@ParameterValueKeyProvider(order=0) int platformGroupId, @ParameterValueKeyProvider(order=1) int dictionaryTypeId, @ParameterValueKeyProvider(order=2) String dictionaryKey) {
        int value = 0;
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (dictionaryEntity != null && !StringUtil.isEmpty((String)dictionaryEntity.getDictionaryName())) {
            try {
                value = Integer.parseInt(dictionaryEntity.getDictionaryName());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public double getDictionaryToDouble(int platformGroupId, int dictionaryTypeId, String dictionaryKey) {
        double value = 0.0;
        DictionaryEntity dictionaryEntity = ((DictionaryService)AopContext.currentProxy()).getDictionary(platformGroupId, dictionaryTypeId, dictionaryKey);
        if (dictionaryEntity != null && !StringUtil.isEmpty((String)dictionaryEntity.getDictionaryName())) {
            try {
                value = Double.parseDouble(dictionaryEntity.getDictionaryName());
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return value;
    }

    @Override
    @ReadThroughSingleCache(namespace="ValidDictionaryListNew", expiration=600)
    public List<DictionaryEntity> getValidDictionaryList(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) Integer dictionaryTypeId) {
        return this.dictionaryMapper.getValidDictionaryList(platformGroupId, dictionaryTypeId);
    }

    @Override
    @ReadThroughSingleCache(namespace="getSaleOutDaysList", expiration=7200)
    public List<DictionaryEntity> getSaleOutDaysList(@ParameterValueKeyProvider(order=0) Integer platformGroupId, @ParameterValueKeyProvider(order=1) Integer dictionaryTypeId) {
        return this.dictionaryMapper.getValidDictionaryList(platformGroupId, dictionaryTypeId);
    }

    @Override
    @ReadThroughSingleCache(namespace="dictionaryService.getValidDictionaryList", expiration=60)
    public List<DictionaryEntity> getValidDictionaryList(@ParameterValueKeyProvider Integer dictionaryTypeId) {
        return this.dictionaryMapper.getValidDictionaryList4DictionaryTypeId(dictionaryTypeId);
    }

    private void removeCache(Integer platformGroupId, Integer dictionaryId, Integer dictionaryTypeId, String dictionaryKey) {
        this.memcachedService.delete("dictionary", dictionaryId + "");
        List<PlatFormGroupEntity> ls = this.platFormGroupService.getPlatFormGroupList();
        if (ls != null && ls.size() > 0) {
            ls.forEach(platFormGroupEntity -> {
                this.memcachedService.delete("dictionary_key", new String[]{platFormGroupEntity.getPlatformGroupId() + "", dictionaryTypeId + "", dictionaryKey});
                this.memcachedService.delete("ValidDictionaryListNew", new String[]{platFormGroupEntity.getPlatformGroupId() + "", dictionaryTypeId + ""});
            });
        }
        this.memcachedService.delete("dictionary_key", new String[]{"0", dictionaryTypeId + "", dictionaryKey});
        this.memcachedService.delete("ValidDictionaryListNew", new String[]{"0", dictionaryTypeId + ""});
    }
}

