/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionInviteLogMapper;
import cc.lechun.mall.entity.distribution.DistributionInviteLogEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.iservice.distribution.DistributionInviteLogInterface;
import cc.lechun.mall.iservice.distribution.DistributorGroupInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionInviteLogService
extends BaseService<DistributionInviteLogEntity, Integer>
implements DistributionInviteLogInterface {
    @Resource
    private DistributionInviteLogMapper distributionInviteLogMapper;
    @Autowired
    private DistributorGroupInterface groupInterface;
    @Autowired
    private DistributorInterface distributorInterface;

    @Override
    public int insertAndReturnAutoIncrementID(Boolean inviteResult, DistributorRelationEntity relationEntity, String customerId, Integer inviteType, String referer, String inviteId, Integer hasInviteLogId, Integer renewable) {
        DistributionInviteLogEntity log = new DistributionInviteLogEntity();
        log.setDistributorId(relationEntity.getDistributorId());
        log.setDistributorRelationId(relationEntity.getId());
        log.setDistributorRelationUserId(relationEntity.getRelationUserId());
        log.setInvitedCustomerId(customerId);
        log.setInviteType(inviteType);
        log.setInviteTime(DateUtils.now());
        log.setInviteSource(referer);
        log.setInviteId(inviteId);
        if (renewable == 1) {
            log.setStatus(1);
            log.setUneffectLogId(hasInviteLogId);
        } else if (!inviteResult.booleanValue()) {
            log.setStatus(0);
            log.setUneffectLogId(hasInviteLogId);
        } else {
            log.setStatus(1);
        }
        int logId = this.insert(log);
        if (logId > 0) {
            return log.getId();
        }
        return 0;
    }

    @Override
    public DistributionInviteLogEntity findByTicketId(Integer ticketId) {
        if (ticketId == null) {
            return null;
        }
        DistributionInviteLogEntity param = new DistributionInviteLogEntity();
        param.setInviteSource(ticketId.toString());
        param.setInviteType(2);
        DistributionInviteLogEntity logEntity = (DistributionInviteLogEntity)this.getSingle(param);
        if (logEntity != null && this.distributorInterface.checkInviteType(logEntity.getDistributorId(), 4).isSuccess()) {
            return logEntity;
        }
        return null;
    }

    @Override
    public int updateLogStatusDisabled(Integer logId) {
        if (logId == null) {
            return 0;
        }
        DistributionInviteLogEntity logEntity = new DistributionInviteLogEntity();
        logEntity.setId(logId);
        logEntity.setStatus(0);
        return this.updateByPrimaryKeySelective(logEntity);
    }
}

