/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionOrderMapper;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.distribution.DistributionInviteEntity;
import cc.lechun.mall.entity.distribution.DistributionOrderEntity;
import cc.lechun.mall.entity.distribution.DistributionOrderItemEntity;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorGroupEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductShareVo;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteLogInterface;
import cc.lechun.mall.iservice.distribution.DistributionOrderInterface;
import cc.lechun.mall.iservice.distribution.DistributionOrderItemInterface;
import cc.lechun.mall.iservice.distribution.DistributorGroupInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class DistributionOrderService
extends BaseService<DistributionOrderEntity, Integer>
implements DistributionOrderInterface {
    @Resource
    private DistributionOrderMapper distributionOrderMapper;
    @Autowired
    MallOrderInterface orderInterface;
    @Autowired
    MallOrderPayInterface payInterface;
    @Autowired
    DistributionInviteLogInterface inviteLogInterface;
    @Autowired
    DictionaryInterface dictionaryInterface;
    @Autowired
    DistributionInviteInterface inviteInterface;
    @Autowired
    DistributorRelationInterface distributorRelationInterface;
    @Lazy
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private DistributorGroupInterface groupInterface;
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    private DistributorItemInterface distributorItemInterface;
    @Autowired
    private DistributionOrderItemInterface orderItemInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;

    @Override
    public void makeOrder(MallOrderMainEntity orderMainEntity) {
        if (orderMainEntity == null) {
            return;
        }
        if (Integer.valueOf(25).equals(orderMainEntity.getOrderSource())) {
            return;
        }
        this.logger.info("\u5206\u9500\u8ba2\u5355\u8bb0\u5f55\u5f00\u59cb,\u4e3b\u8ba2\u5355\uff1a" + orderMainEntity.getOrderMainNo());
        DistributionInviteEntity inviteMe = null;
        if (StringUtils.isEmpty((String)orderMainEntity.getNcpBat())) {
            String ncp;
            List<MallOrderPayEntity> payList = this.payInterface.getList(orderMainEntity.getOrderMainNo());
            List ticketPays = payList.stream().filter(pay -> pay.getPaySubtypeId().intValue() == PaySubTypeEnum.COUPON_SUB_PAY.getValue()).collect(Collectors.toList());
            for (MallOrderPayEntity p : ticketPays) {
                CashticketCustomerEntity cashticketCustomerEntity = this.cashticketCustomerInterface.getCashticketCustomer(p.getCashticketId());
                if (cashticketCustomerEntity == null || !StringUtils.isNotEmpty((String)cashticketCustomerEntity.getNcpBat())) continue;
                orderMainEntity.setNcpBat(cashticketCustomerEntity.getNcpBat());
                MallOrderMainEntity updateOrderMain = new MallOrderMainEntity();
                updateOrderMain.setNcpBat(orderMainEntity.getNcpBat());
                updateOrderMain.setOrderMainNo(orderMainEntity.getOrderMainNo());
                this.mallOrderMainInterface.updateOrderMain(updateOrderMain);
                break;
            }
            if (StringUtils.isEmpty((String)orderMainEntity.getNcpBat()) && StringUtils.isNotEmpty((String)(ncp = this.getInviteCodeByBalance(orderMainEntity.getOrderMainNo())))) {
                orderMainEntity.setNcpBat(ncp);
                MallOrderMainEntity updateOrderMain = new MallOrderMainEntity();
                updateOrderMain.setNcpBat(ncp);
                updateOrderMain.setOrderMainNo(orderMainEntity.getOrderMainNo());
                this.mallOrderMainInterface.updateOrderMain(updateOrderMain);
            }
        }
        if ((inviteMe = this.inviteInterface.findInviteMe(orderMainEntity)) == null) {
            this.logger.info("\u8ba2\u5355\u8bb0\u5f55\u6ca1\u6709\u9080\u8bf7\u5173\u7cfb\uff0c\u4e0d\u662f\u79c1\u57df\u8ba2\u5355,\u4e3b\u8ba2\u5355\uff1a" + orderMainEntity.getOrderMainNo());
            return;
        }
        List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainEntity.getOrderMainNo());
        for (MallOrderEntity order : orderEntities) {
            DistributionOrderEntity distributionOrderEntity = new DistributionOrderEntity();
            distributionOrderEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
            distributionOrderEntity.setOrderNo(order.getOrderNo());
            distributionOrderEntity.setSaleAmount(this.getOrderSaleAmount(order));
            distributionOrderEntity.setOrderAmount(order.getOrderAmount().subtract(order.getCouponAmount()));
            if (distributionOrderEntity.getOrderAmount().doubleValue() < 0.0) {
                distributionOrderEntity.setOrderAmount(BigDecimal.ZERO);
            }
            distributionOrderEntity.setInvitedCustomerId(orderMainEntity.getCustomerId());
            distributionOrderEntity.setPlatformId(orderMainEntity.getPlatformId());
            if (!this.validateRepeat(distributionOrderEntity, "orderNo", "\u5b50\u8ba2\u5355\u53f7").isSuccess()) {
                this.logger.info("\u5206\u9500\u8ba2\u5355\u5b50\u8ba2\u5355{}\u5df2\u7ecf\u5b58\u5728", (Object)order.getOrderNo());
                return;
            }
            distributionOrderEntity.setDistributorId(inviteMe.getDistributorId());
            distributionOrderEntity.setDistributorRelationId(inviteMe.getDistributorRelationId());
            distributionOrderEntity.setDistributorRelationUserId(inviteMe.getDistributorRelationUserId());
            distributionOrderEntity.setInviteId(inviteMe.getId());
            distributionOrderEntity.setInviteTime(inviteMe.getInviteTime());
            BaseJsonVo<DistributorRelationEntity> inviteDistributor = this.distributorRelationInterface.checkDistributorByRelationUserId(distributionOrderEntity.getDistributorRelationUserId());
            if (!inviteDistributor.isSuccess()) {
                this.logger.info("\u5206\u9500\u8ba2\u5355\u8bb0\u5f55\u6ca1\u6709\u9080\u8bf7\u5173\u7cfb,\u4e3b\u8ba2\u5355\uff1a" + orderMainEntity.getOrderMainNo() + ",\u9519\u8bef\u539f\u56e0\uff1a" + inviteDistributor.getMessage());
                return;
            }
            distributionOrderEntity.setHasSettled(0);
            BaseJsonVo<Map<String, BigDecimal>> jsonVo = this.getOrderProductAmount(order.getOrderNo(), distributionOrderEntity.getDistributorId());
            if (jsonVo.isSuccess()) {
                Map map = (Map)jsonVo.getValue();
                distributionOrderEntity.setStatus(1);
                distributionOrderEntity.setExpectOrderAmount((BigDecimal)map.get("amount"));
                distributionOrderEntity.setExpectPercentageAmount((BigDecimal)map.get("perAmount"));
            } else {
                this.logger.info("\u9080\u8bf7\u8ba2\u5355\u6d88\u606f\uff1a" + jsonVo.getMessage());
                distributionOrderEntity.setStatus(0);
                distributionOrderEntity.setExpectOrderAmount(BigDecimal.ZERO);
                distributionOrderEntity.setExpectPercentageAmount(BigDecimal.ZERO);
            }
            distributionOrderEntity.setCreateTime(orderMainEntity.getCreateTime());
            distributionOrderEntity.setUpdateTime(DateUtils.now());
            this.distributionOrderMapper.insert(distributionOrderEntity);
            this.logger.info("\u5206\u9500\u8ba2\u5355\u8bb0\u5f55\u7ed3\u675f,\u4e3b\u8ba2\u5355\uff1a" + orderMainEntity.getOrderMainNo());
        }
    }

    private String getInviteCodeByBalance(String orderMainNo) {
        String ncpBat = "";
        BaseJsonVo<Map<String, BigDecimal>> json = this.balanceAccountInvoke.getOrderPayDetail(orderMainNo);
        if (json != null && json.isSuccess() && json.getValue() != null) {
            Map maps = (Map)json.getValue();
            for (String k : maps.keySet()) {
                this.logger.info("\u79c1\u57df\u4f59\u989d\u5f97\u5230\u652f\u4ed8\u660e\u7ec6\uff0c" + k);
                MallOrderMainEntity mainEntity = this.mallOrderMainInterface.selectByPrimaryKey(k);
                if (mainEntity == null || !StringUtils.isNotEmpty((String)mainEntity.getNcpBat())) continue;
                ncpBat = mainEntity.getNcpBat();
                break;
            }
        }
        return ncpBat;
    }

    private BigDecimal getOrderSaleAmount(MallOrderEntity order) {
        BaseJsonVo<Map<String, BigDecimal>> json;
        BigDecimal resultAmount = order.getOrderAmount().subtract(order.getCouponAmount());
        BigDecimal mainRate = BigDecimal.ONE;
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
        if (mallOrderMainEntity != null) {
            mainRate = PriceUtils.divide((BigDecimal)order.getOrderAmount(), (BigDecimal)mallOrderMainEntity.getOrderAmount(), (int)6, (Integer)4);
        }
        if ((json = this.balanceAccountInvoke.getOrderPayDetail(order.getOrderMainNo())) != null) {
            if (json.isSuccess()) {
                if (json.getValue() != null) {
                    BigDecimal existsAmount = BigDecimal.ZERO;
                    Map maps = (Map)json.getValue();
                    for (String k : maps.keySet()) {
                        this.logger.info("\u79c1\u57df\u4f59\u989d\u5f97\u5230\u652f\u4ed8\u660e\u7ec6\uff0c\u8ba2\u5355\u53f7\uff1a" + k + ",\u91d1\u989d\uff1a" + maps.get(k));
                        BigDecimal rate = this.getDistributionOrderEnableRate(k);
                        existsAmount = existsAmount.add(((BigDecimal)maps.get(k)).multiply(mainRate).multiply(rate));
                    }
                    if ((resultAmount = resultAmount.subtract(existsAmount)).compareTo(BigDecimal.ZERO) < 0) {
                        resultAmount = BigDecimal.ZERO;
                    }
                }
            } else {
                this.logger.error("\u8c03\u7528balance-getOrderPayDetail\u63a5\u53e3\u5f02\u5e38:" + json.getMessage());
            }
        }
        return resultAmount;
    }

    private BigDecimal getDistributionOrderEnableRate(String orderMainNo) {
        BigDecimal rate = BigDecimal.ZERO;
        if (StringUtils.isEmpty((String)orderMainNo)) {
            return rate;
        }
        try {
            DistributionOrderEntity distributionOrderEntity = new DistributionOrderEntity();
            distributionOrderEntity.setOrderMainNo(orderMainNo);
            List disExists = this.distributionOrderMapper.getList(distributionOrderEntity);
            BigDecimal orderAmount = BigDecimal.valueOf(disExists.stream().mapToDouble(c -> c.getOrderAmount().doubleValue()).sum());
            if (orderAmount.doubleValue() > 0.0) {
                BigDecimal saleAmount = BigDecimal.valueOf(disExists.stream().mapToDouble(c -> c.getSaleAmount().doubleValue()).sum());
                rate = saleAmount.divide(orderAmount, 6, 4);
                rate = rate.doubleValue() < 0.0 ? BigDecimal.ZERO : rate;
                rate = rate.doubleValue() > 1.0 ? BigDecimal.ONE : rate;
                this.logger.info("\u79c1\u57df\u4f59\u989d\u5f97\u5230\u652f\u4ed8\u660e\u7ec6\uff0crate:" + orderAmount + "_" + rate + "_" + orderMainNo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rate;
    }

    private BaseJsonVo<Map<String, BigDecimal>> getOrderProductAmount(String orderNo, Integer distributorId) {
        if (distributorId == null) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u9080\u8bf7\u4eba");
        }
        DistributorEntity distributorEntity = (DistributorEntity)this.distributorInterface.selectByPrimaryKey(distributorId);
        if (distributorEntity == null) {
            return BaseJsonVo.error((String)"\u67e5\u627e\u9080\u8bf7\u4eba\u5931\u8d25");
        }
        DistributorGroupEntity groupEntity = (DistributorGroupEntity)this.groupInterface.selectByPrimaryKey(distributorEntity.getGroupId());
        if (groupEntity == null) {
            return BaseJsonVo.error((String)"\u67e5\u627e\u9080\u8bf7\u4eba\u5206\u7ec4\u5931\u8d25");
        }
        BigDecimal amountTotal = BigDecimal.ZERO;
        BigDecimal perAmountTotal = BigDecimal.ZERO;
        List<MallOrderProductShareVo> lst = this.orderProductInterface.getOrderProductShareAmount(orderNo);
        if (lst.size() == 0) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u5546\u54c1");
        }
        this.orderItemInterface.deleteOrderItemByOrderNo(orderNo);
        for (MallOrderProductShareVo v : lst) {
            String itemId = "";
            Integer groupType = v.getGroupType();
            if (Integer.valueOf(1).equals(v.getGroupType())) {
                itemId = v.getPromotionId();
            }
            if (Integer.valueOf(2).equals(v.getGroupType())) {
                itemId = v.getGroupId();
            }
            if (Integer.valueOf(4).equals(v.getGroupType())) {
                itemId = v.getProductId();
            }
            BigDecimal percentage = BigDecimal.ZERO;
            Integer status = 0;
            BaseJsonVo<BigDecimal> jsonVo = this.distributorItemInterface.getDistributorItemPercentageByItemId(itemId, groupType, groupEntity.getId());
            if (jsonVo.isSuccess()) {
                percentage = (BigDecimal)jsonVo.getValue();
                status = 1;
            }
            DistributionOrderItemEntity orderItemEntity = new DistributionOrderItemEntity();
            orderItemEntity.setCreateTime(new Date());
            orderItemEntity.setOrderAmount(v.getOrderAmount().subtract(v.getCouponAmount()));
            if (orderItemEntity.getOrderAmount().doubleValue() < 0.0) {
                orderItemEntity.setOrderAmount(BigDecimal.ZERO);
            }
            orderItemEntity.setOrderMainNo(v.getOrderMainNo());
            orderItemEntity.setOrderNo(v.getOrderNo());
            orderItemEntity.setPercentage(percentage);
            orderItemEntity.setPercentageAmount(percentage.multiply(orderItemEntity.getOrderAmount()));
            orderItemEntity.setPlatformId(groupEntity.getPlatformId());
            orderItemEntity.setRefundAmount(BigDecimal.ZERO);
            orderItemEntity.setStatus(status);
            orderItemEntity.setItemId(itemId);
            orderItemEntity.setItemType(groupType);
            orderItemEntity.setQuantity(v.getQuantity());
            orderItemEntity.setOrderProductNo(v.getOrderProductNo());
            if (status == 1) {
                amountTotal = amountTotal.add(orderItemEntity.getOrderAmount());
                perAmountTotal = perAmountTotal.add(orderItemEntity.getPercentageAmount());
            }
            this.orderItemInterface.insert(orderItemEntity);
        }
        if (amountTotal.doubleValue() > 0.0) {
            HashedMap map = new HashedMap();
            map.put("amount", amountTotal);
            map.put("perAmount", perAmountTotal);
            return BaseJsonVo.success((Object)map);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u5546\u54c1\u53ef\u8fd4\u5229");
    }

    @Override
    public BaseJsonVo updateDistributionOrderItemQuantity() {
        DistributionOrderItemEntity itemEntity = new DistributionOrderItemEntity();
        itemEntity.setQuantity(0);
        List lst = this.orderItemInterface.getList(itemEntity);
        if (lst.size() > 0) {
            List stream = lst.stream().map(c -> c.getOrderNo()).distinct().collect(Collectors.toList());
            for (String s : stream) {
                DistributionOrderEntity orderEntity = new DistributionOrderEntity();
                orderEntity.setOrderNo(s);
                if ((orderEntity = (DistributionOrderEntity)this.getSingle(orderEntity)) == null) continue;
                this.getOrderProductAmount(s, orderEntity.getDistributorId());
            }
        }
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }
}

