/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorRelationMapper;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import com.github.pagehelper.util.StringUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributorRelationService
extends BaseService<DistributorRelationEntity, Integer>
implements DistributorRelationInterface {
    @Resource
    private DistributorRelationMapper distributorRelationMapper;
    @Autowired
    private DistributorInterface distributorInterface;

    @Override
    public DistributorRelationEntity getDistributorRelationByRelationUserId(String customerId, Integer relationType) {
        DistributorRelationEntity param = new DistributorRelationEntity();
        param.setRelationUserId(customerId);
        param.setRelationType(relationType);
        List list = this.distributorRelationMapper.getList(param);
        if (list != null && list.size() > 0) {
            return (DistributorRelationEntity)list.get(0);
        }
        return null;
    }

    @Override
    public BaseJsonVo<DistributorRelationEntity> checkDistributorByRelationId(Integer relationId) {
        if (relationId == null) {
            return BaseJsonVo.error((String)"relationId\u4e3a\u7a7a");
        }
        DistributorRelationEntity relationEntity = (DistributorRelationEntity)this.selectByPrimaryKey(relationId);
        if (relationEntity == null || relationEntity.getStatus() != 1) {
            return BaseJsonVo.error((String)"\u5206\u9500\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
        }
        if (this.distributorInterface.checkDistributorById(relationEntity.getDistributorId()).isSuccess()) {
            return BaseJsonVo.success((Object)relationEntity);
        }
        return BaseJsonVo.error((String)"\u5206\u9500\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
    }

    @Override
    public BaseJsonVo<DistributorRelationEntity> checkDistributorByRelationUserId(String relationUserId) {
        if (StringUtil.isEmpty((String)relationUserId)) {
            return BaseJsonVo.error((String)"\u7528\u6237Id\u4e3a\u7a7a");
        }
        DistributorRelationEntity relationEntity = new DistributorRelationEntity();
        relationEntity.setRelationUserId(relationUserId);
        relationEntity.setStatus(1);
        relationEntity = (DistributorRelationEntity)this.getSingle(relationEntity);
        if (relationEntity == null || relationEntity.getStatus() != 1) {
            return BaseJsonVo.error((String)"\u5206\u9500\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
        }
        if (this.distributorInterface.checkDistributorById(relationEntity.getDistributorId()).isSuccess()) {
            return BaseJsonVo.success((Object)relationEntity);
        }
        return BaseJsonVo.error((String)"\u5206\u9500\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
    }

    @Override
    public BaseJsonVo<DistributorRelationEntity> checkDistributorByRelationCode(String relationCode) {
        if (StringUtil.isEmpty((String)relationCode)) {
            return BaseJsonVo.error((String)"\u9080\u8bf7\u7801\u4e3a\u7a7a");
        }
        DistributorRelationEntity relationEntity = new DistributorRelationEntity();
        relationEntity.setDistributorRelationCode(relationCode);
        relationEntity = (DistributorRelationEntity)this.getSingle(relationEntity);
        if (relationEntity == null) {
            return BaseJsonVo.error((String)"\u5206\u9500\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
        }
        if (this.distributorInterface.checkDistributorById(relationEntity.getDistributorId()).isSuccess()) {
            return BaseJsonVo.success((Object)relationEntity);
        }
        return BaseJsonVo.error((String)"\u5206\u9500\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
    }
}

