/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.ShareMapper;
import cc.lechun.mall.entity.distribution.ShareEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.utils.URLUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareService
extends BaseService<ShareEntity, Integer>
implements ShareInterface {
    @Autowired
    ShareMapper shareMapper;
    @Autowired
    OssService ossService;
    @Autowired
    MallProductInterface productInterface;
    @Autowired
    MallPromotionInterface promotionInterface;
    @Autowired
    MallGroupInterface groupInterface;
    @Autowired
    CustomerInterface customerInterface;
    @Autowired
    private MallProductPicInterface mallProductPicInterface;
    @Autowired
    private MallPromotionProductInterface mallPromotionProductInterface;

    @Override
    public ShareEntity findByPage(String page, Integer platformId) {
        ShareEntity param = new ShareEntity();
        param.setPageName(page.indexOf("?") > 0 ? page.substring(0, page.indexOf("?")) : page);
        param.setDefaultConfig(0);
        List list = this.getList(param);
        this.logger.info("findByPage:" + (page.indexOf("?") > 0 ? page.substring(0, page.indexOf("?")) : page));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ShareEntity)list.get(0);
        }
        String[] pageUrls = page.split("/");
        page = pageUrls[pageUrls.length - 1].split("\\.")[0];
        if (4 == platformId) {
            this.logger.info("page0:{}", (Object)page);
            page = pageUrls[pageUrls.length - 1].split("\\?")[0];
        }
        param.setPageName(page);
        list = this.getList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ShareEntity)list.get(0);
        }
        return this.getDefaultShareEntity();
    }

    private ShareEntity getDefaultShareEntity() {
        ShareEntity param = new ShareEntity();
        param.setDefaultConfig(1);
        List listDefault = this.getList(param);
        if (listDefault != null && listDefault.size() > 0) {
            return (ShareEntity)listDefault.get(0);
        }
        param.setShareDigest("\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
        param.setShareTitle("\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
        param.setShareImageUrl("imgStorage/3075236650530049932.png");
        return param;
    }

    @Override
    public BaseJsonVo getShare(String pageUrl, String inviteCode, String customerId, String nickName, String productId, Integer groupType, int platformId) {
        if (StringUtils.isNotEmpty((String)pageUrl)) {
            if (pageUrl.endsWith("/")) {
                pageUrl = pageUrl + "index.html";
            }
            ShareEntity share = null;
            HashMap<String, String> shareMap = new HashMap<String, String>();
            shareMap.put("qrcodeUrl", "");
            if (StringUtils.isNotEmpty((String)productId)) {
                MallProductEntity productEntity = this.productInterface.getProduct(productId);
                if (productEntity != null && productEntity.getProState() != 1) {
                    share = new ShareEntity();
                    String title = "@" + (StringUtils.isNotEmpty((String)nickName) ? nickName : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec") + "\u60f3\u9080\u8bf7\u4f60\u4e00\u8d77\u901b\u4e00\u901b\u4e50\u7eaf\u535a\u7269\u9986";
                    String digest = String.format("\u6211\u6b63\u5728\u4e50\u7eaf\u535a\u7269\u9986\u53c2\u89c2\uff0c\u91cc\u9762\u7684\u85cf\u54c1\u7adf\u7136\u4f1a\u8bf4\u8bdd\u3002#\u4e50\u7eaf\u535a\u7269\u9986\u91cc\u9762\u7684\u85cf\u54c1\u7adf\u7136\u6d3b\u8fc7\u6765\u4e86\uff0c\u5feb\u6765\u770b\u770b\uff01", productEntity.getProName());
                    Object titleObject = this.redisCacheUtil.get("MUSEUM_SHARE_TITLE");
                    Object digestObject = this.redisCacheUtil.get("MUSEUM_SHARE_DIGEST");
                    if (titleObject != null) {
                        title = titleObject.toString();
                        title = title.replace("{productName}", productEntity.getProName()).replace("{nickName}", nickName);
                    }
                    if (digestObject != null) {
                        digest = digestObject.toString();
                        digest = digest.replace("{productName}", productEntity.getProName()).replace("{nickName}", nickName);
                    }
                    share.setShareTitle(title);
                    share.setShareDigest(digest);
                    share.setShareImageUrl("1000/sysImg/BF429A38-3F40-49FF-8A13-00F0132FE482.png");
                    shareMap.put("qrcodeUrl", this.ossService.getImageResoure("1000/sysImg/14897d5784d04a74a53a35599b7b7e3g.jpg"));
                } else {
                    share = this.findByPage(pageUrl, platformId);
                }
            } else {
                share = this.findByPage(pageUrl, platformId);
            }
            shareMap.put("title", StringUtil.isEmpty((String)share.getShareTitle()) ? null : this.getShareProductContent(share.getShareTitle(), nickName, productId, groupType));
            shareMap.put("digest", StringUtil.isEmpty((String)share.getShareDigest()) ? null : this.getShareProductContent(share.getShareDigest(), nickName, productId, groupType));
            if (StringUtils.isEmpty((String)share.getShareUrl())) {
                share.setShareUrl(pageUrl);
            }
            if (StringUtils.isEmpty((String)URLUtil.getQueryMap(share.getShareUrl(), "ncp_bat"))) {
                shareMap.put("url", StringUtil.isEmpty((String)share.getShareUrl()) ? pageUrl + (pageUrl.contains("?") ? "&" : "?") + "ncp_bat=" + inviteCode : share.getShareUrl() + (share.getShareUrl().contains("?") ? "&" : "?") + "ncp_bat=" + inviteCode);
            } else {
                shareMap.put("url", share.getShareUrl());
                inviteCode = URLUtil.getQueryMap(share.getShareUrl(), "ncp_bat");
            }
            shareMap.put("imageUrl", this.getShareProudctPic(share.getShareImageUrl1(), share.getShareImageUrl(), productId, groupType));
            shareMap.put("ncp_bat", inviteCode);
            return BaseJsonVo.success(shareMap);
        }
        return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u5206\u4eab");
    }

    private String getShareProudctPic(String picParam, String picDefault, String productId, Integer groupType) {
        List<String> lst;
        Map<String, Integer> map;
        String defaultpicUrl;
        String string = defaultpicUrl = StringUtil.isEmpty((String)picDefault) ? null : this.ossService.getImageResoure(picDefault);
        if (StringUtils.isNotEmpty((String)productId) && groupType != null && (map = this.getPicIndexByPicParam(picParam, groupType)) != null && (lst = this.mallProductPicInterface.getProductPicUrl(productId = this.getrealId(productId, groupType), map.get("picType"))) != null && lst.size() > 0) {
            String picurl = "";
            if (lst.size() > map.get("index")) {
                picurl = lst.get(map.get("index"));
                if (StringUtils.isEmpty((String)picurl)) {
                    picurl = lst.get(0);
                }
            } else {
                picurl = lst.get(0);
            }
            if (StringUtils.isNotEmpty((String)picurl)) {
                return picurl;
            }
        }
        return defaultpicUrl;
    }

    private String getrealId(String productId, Integer groupType) {
        MallPromotionProductEntity promotionProductEntity;
        if (groupType == 1 && (promotionProductEntity = this.mallPromotionProductInterface.getPromotionProductEntity(productId)) != null) {
            return promotionProductEntity.getPromotionProductId();
        }
        return productId;
    }

    private Map<String, Integer> getPicIndexByPicParam(String picParam, Integer groupType) {
        if (StringUtils.isEmpty((String)picParam)) {
            return null;
        }
        try {
            String[] c = picParam.split("\\[");
            if (c.length == 2) {
                String pic = c[0];
                pic = pic.replace("{", "").trim();
                Integer index = Integer.parseInt(c[1].split("\\]")[0].trim());
                Integer picType = this.getPicType(pic, groupType);
                HashedMap map = new HashedMap();
                map.put("picType", picType);
                map.put("index", index);
                return map;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Integer getPicType(String picParam, Integer groupType) {
        Integer pre = 0;
        if (groupType == 1) {
            pre = 100;
        }
        if (groupType == 2) {
            pre = 50;
        }
        if (groupType == 4) {
            pre = 0;
        }
        if (groupType == 5) {
            pre = 150;
        }
        switch (picParam) {
            case "picBig": {
                return pre + 1;
            }
            case "picList": {
                return pre + 2;
            }
            case "picNutrition": {
                return pre + 3;
            }
            case "picBuy": {
                return pre + 4;
            }
            case "picSmall": {
                return pre + 5;
            }
            case "picDetail": {
                return pre + 6;
            }
            case "picRecommend": {
                return pre + 7;
            }
        }
        return pre + 5;
    }

    private String getShareProductContent(String content, String nickName, String productId, Integer groupType) {
        Serializable productEntity;
        if (StringUtil.isNotEmpty((String)nickName)) {
            content = content.replace("{nickName}", nickName);
        }
        if (groupType == null || productId == null) {
            return this.replaceEmptyTagContent(content);
        }
        if (groupType == 1 && (productEntity = this.promotionInterface.getPromotion(productId)) != null) {
            content = this.replaceContent(content, productEntity);
        }
        if (groupType == 2 && (productEntity = this.groupInterface.getGroup(productId)) != null) {
            content = this.replaceContent(content, productEntity);
        }
        if (groupType == 4 && (productEntity = this.productInterface.getProduct(productId)) != null) {
            content = this.replaceContent(content, productEntity);
        }
        return this.replaceEmptyTagContent(content);
    }

    private <T> String replaceEmptyTagContent(String content) {
        List<String> filters = this.extractMessageByRegular(content);
        for (String b : filters) {
            content = content.replace("{" + b + "}", "");
        }
        return content;
    }

    private <T> String replaceContent(String content, T t) {
        try {
            List<String> filters = this.extractMessageByRegular(content);
            for (String b : filters) {
                Object value = BeanUtils.getFieldValue(t, (String)b);
                if (value == null) continue;
                content = content.replace("{" + b + "}", value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public List<String> extractMessageByRegular(String msg) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("\\{([^}]*)\\}");
        Matcher m = p.matcher(msg);
        while (m.find()) {
            list.add(m.group().substring(1, m.group().length() - 1));
        }
        return list;
    }

    @Override
    public BaseJsonVo getDefaultShare(String pageUrl, String inviteCode, String customerId, String nickName, String productId, Integer groupType) {
        ShareEntity share = this.getDefaultShareEntity();
        HashMap<String, String> shareMap = new HashMap<String, String>();
        shareMap.put("title", StringUtil.isEmpty((String)share.getShareTitle()) ? null : MessageFormat.format(share.getShareTitle(), nickName));
        shareMap.put("digest", StringUtil.isEmpty((String)share.getShareDigest()) ? null : MessageFormat.format(share.getShareDigest(), nickName));
        if (pageUrl != null && pageUrl.contains("inviteId=")) {
            int inviteIndex = pageUrl.indexOf("inviteId=");
            String tempUrl = pageUrl.substring(inviteIndex);
            String otherPara = "";
            boolean hasOther = false;
            if (tempUrl.indexOf("&") > 0) {
                hasOther = true;
                otherPara = tempUrl.substring(tempUrl.substring(1).indexOf("&"));
            } else {
                pageUrl = pageUrl.substring(0, inviteIndex);
            }
            this.logger.info("pageUrl:{}", (Object)(pageUrl.substring(0, inviteIndex - 1) + "&inviteId=" + customerId + otherPara));
            shareMap.put("url", StringUtil.isEmpty((String)share.getShareUrl()) ? (pageUrl == null ? null : pageUrl.substring(0, inviteIndex - 1) + (pageUrl.contains("?") ? "&" : "?") + "ncp_bat=" + inviteCode + "&inviteId=" + customerId + otherPara) : share.getShareUrl() + (share.getShareUrl().contains("?") ? "&" : "?") + "ncp_bat=" + inviteCode + "&inviteId=" + customerId);
        } else {
            shareMap.put("url", StringUtil.isEmpty((String)share.getShareUrl()) ? (pageUrl == null ? null : pageUrl + (pageUrl.contains("?") ? "&" : "?") + "ncp_bat=" + inviteCode + "&inviteId=" + customerId) : share.getShareUrl() + (share.getShareUrl().contains("?") ? "&" : "?") + "ncp_bat=" + inviteCode + "&inviteId=" + customerId);
        }
        shareMap.put("imageUrl", StringUtil.isEmpty((String)share.getShareImageUrl()) ? null : this.ossService.getImageResoure(share.getShareImageUrl()));
        this.logger.info("\u5206\u4eaburl:{}", shareMap.get("url"));
        shareMap.put("ncp_bat", inviteCode);
        return BaseJsonVo.success(shareMap);
    }
}

